/*
 * Decompiled with CFR 0.152.
 */
package jsr166y;

import java.lang.reflect.Field;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.Collection;
import java.util.concurrent.RejectedExecutionException;
import jsr166y.ForkJoinPool;
import jsr166y.ForkJoinTask;
import sun.misc.Unsafe;

public class ForkJoinWorkerThread
extends Thread {
    private static final int INITIAL_QUEUE_CAPACITY = 8192;
    private static final int MAXIMUM_QUEUE_CAPACITY = 0x10000000;
    final ForkJoinPool pool;
    private ForkJoinTask<?>[] queue;
    private volatile int sp;
    private volatile int base;
    private boolean active;
    private volatile int runState;
    private int seed;
    private int stealCount;
    int poolIndex;
    long lastEventCount;
    private boolean locallyFifo;
    private static final int RUNNING = 0;
    private static final int SHUTDOWN = 1;
    private static final int TERMINATING = 2;
    private static final int TERMINATED = 3;
    private static final Unsafe UNSAFE = ForkJoinWorkerThread.getUnsafe();
    private static final long spOffset = ForkJoinWorkerThread.objectFieldOffset("sp", ForkJoinWorkerThread.class);
    private static final long runStateOffset = ForkJoinWorkerThread.objectFieldOffset("runState", ForkJoinWorkerThread.class);
    private static final long qBase = UNSAFE.arrayBaseOffset(ForkJoinTask[].class);
    private static final int qShift;

    protected ForkJoinWorkerThread(ForkJoinPool pool) {
        if (pool == null) {
            throw new NullPointerException();
        }
        this.pool = pool;
    }

    public ForkJoinPool getPool() {
        return this.pool;
    }

    public int getPoolIndex() {
        return this.poolIndex;
    }

    void setAsyncMode(boolean async) {
        this.locallyFifo = async;
    }

    final boolean isShutdown() {
        return this.runState >= 1;
    }

    final boolean isTerminating() {
        return this.runState >= 2;
    }

    final boolean isTerminated() {
        return this.runState == 3;
    }

    final boolean shutdown() {
        return this.transitionRunStateTo(1);
    }

    final boolean shutdownNow() {
        return this.transitionRunStateTo(2);
    }

    private boolean transitionRunStateTo(int state) {
        int s;
        do {
            if ((s = this.runState) < state) continue;
            return false;
        } while (!UNSAFE.compareAndSwapInt(this, runStateOffset, s, state));
        return true;
    }

    private boolean tryActivate() {
        if (!this.active) {
            if (!this.pool.tryIncrementActiveCount()) {
                return false;
            }
            this.active = true;
        }
        return true;
    }

    private boolean tryInactivate() {
        if (this.active) {
            if (!this.pool.tryDecrementActiveCount()) {
                return false;
            }
            this.active = false;
        }
        return true;
    }

    private static int xorShift(int r) {
        r ^= r << 13;
        r ^= r >>> 17;
        return r ^ r << 5;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        Throwable exception = null;
        try {
            this.onStart();
            this.pool.sync(this);
            this.mainLoop();
        }
        catch (Throwable ex) {
            exception = ex;
        }
        finally {
            this.onTermination(exception);
        }
    }

    private void mainLoop() {
        while (!this.isShutdown()) {
            ForkJoinTask<?> t = this.pollTask();
            if (t != null || (t = this.pollSubmission()) != null) {
                t.quietlyExec();
                continue;
            }
            if (!this.tryInactivate()) continue;
            this.pool.sync(this);
        }
    }

    protected void onStart() {
        this.queue = new ForkJoinTask[8192];
        int p = this.poolIndex + 1;
        this.seed = p + (p << 8) + (p << 16) + (p << 24);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void onTermination(Throwable exception) {
        while (exception == null && this.pool.isProcessingTasks() && this.base != this.sp) {
            try {
                ForkJoinTask<?> t = this.popTask();
                if (t == null) continue;
                t.quietlyExec();
            }
            catch (Throwable ex) {
                exception = ex;
            }
        }
        try {
            while (!this.tryInactivate()) {
            }
            this.cancelTasks();
            this.runState = 3;
            this.pool.workerTerminated(this);
        }
        catch (Throwable ex) {
            if (exception == null) {
                exception = ex;
            }
        }
        finally {
            if (exception != null) {
                ForkJoinTask.rethrowException(exception);
            }
        }
    }

    private static long slotOffset(int i) {
        return ((long)i << qShift) + qBase;
    }

    private static void setSlot(ForkJoinTask<?>[] q, int i, ForkJoinTask<?> t) {
        UNSAFE.putOrderedObject(q, ForkJoinWorkerThread.slotOffset(i), t);
    }

    private static boolean casSlotNull(ForkJoinTask<?>[] q, int i, ForkJoinTask<?> t) {
        return UNSAFE.compareAndSwapObject(q, ForkJoinWorkerThread.slotOffset(i), t, null);
    }

    private void storeSp(int s) {
        UNSAFE.putOrderedInt(this, spOffset, s);
    }

    final void pushTask(ForkJoinTask<?> t) {
        ForkJoinTask<?>[] q = this.queue;
        int mask = q.length - 1;
        int s = this.sp;
        ForkJoinWorkerThread.setSlot(q, s & mask, t);
        this.storeSp(++s);
        if ((s -= this.base) == 1) {
            this.pool.signalWork();
        } else if (s >= mask) {
            this.growQueue();
        }
    }

    final ForkJoinTask<?> deqTask() {
        int b = this.base;
        if (this.sp != b) {
            int i;
            ForkJoinTask<?> t;
            ForkJoinTask<?>[] q = this.queue;
            if (this.queue != null && (t = q[i = q.length - 1 & b]) != null && ForkJoinWorkerThread.casSlotNull(q, i, t)) {
                this.base = b + 1;
                return t;
            }
        }
        return null;
    }

    final ForkJoinTask<?> locallyDeqTask() {
        int b;
        while (this.sp != (b = this.base)) {
            int i;
            ForkJoinTask<?>[] q;
            ForkJoinTask<?> t;
            if (!this.tryActivate() || (t = (q = this.queue)[i = q.length - 1 & b]) == null || !ForkJoinWorkerThread.casSlotNull(q, i, t)) continue;
            this.base = b + 1;
            return t;
        }
        return null;
    }

    final ForkJoinTask<?> popTask() {
        int s = this.sp;
        while (s != this.base) {
            if (!this.tryActivate()) continue;
            ForkJoinTask<?>[] q = this.queue;
            int mask = q.length - 1;
            int i = s - 1 & mask;
            ForkJoinTask<?> t = q[i];
            if (t == null || !ForkJoinWorkerThread.casSlotNull(q, i, t)) break;
            this.storeSp(s - 1);
            return t;
        }
        return null;
    }

    final boolean unpushTask(ForkJoinTask<?> t) {
        ForkJoinTask<?>[] q = this.queue;
        int s = this.sp - 1;
        int mask = q.length - 1;
        if (ForkJoinWorkerThread.casSlotNull(q, s & mask, t)) {
            this.storeSp(s);
            return true;
        }
        return false;
    }

    final ForkJoinTask<?> peekTask() {
        ForkJoinTask<?>[] q = this.queue;
        if (q == null) {
            return null;
        }
        int mask = q.length - 1;
        int i = this.locallyFifo ? this.base : this.sp - 1;
        return q[i & mask];
    }

    private void growQueue() {
        ForkJoinTask<?>[] oldQ = this.queue;
        int oldSize = oldQ.length;
        int newSize = oldSize << 1;
        if (newSize > 0x10000000) {
            throw new RejectedExecutionException("Queue capacity exceeded");
        }
        this.queue = new ForkJoinTask[newSize];
        ForkJoinTask[] newQ = this.queue;
        int b = this.base;
        int bf = b + oldSize;
        int oldMask = oldSize - 1;
        int newMask = newSize - 1;
        do {
            int oldIndex;
            ForkJoinTask<?> t;
            if ((t = oldQ[oldIndex = b & oldMask]) != null && !ForkJoinWorkerThread.casSlotNull(oldQ, oldIndex, t)) {
                t = null;
            }
            ForkJoinWorkerThread.setSlot(newQ, b & newMask, t);
        } while (++b != bf);
        this.pool.signalWork();
    }

    private ForkJoinTask<?> scan() {
        ForkJoinTask<?> t = null;
        int r = this.seed;
        block0: do {
            ForkJoinWorkerThread v;
            int mask;
            ForkJoinWorkerThread[] ws = this.pool.workers;
            if (this.pool.workers == null || (mask = ws.length - 1) <= 0) continue;
            int idx = r;
            int probes = ~mask;
            while (true) {
                r = ForkJoinWorkerThread.xorShift(r);
                v = ws[mask & idx];
                if (v != null && v.sp != v.base) break;
                if (probes > mask) continue block0;
                idx = probes++ < 0 ? r : idx + 1;
            }
            if (this.tryActivate() && (t = v.deqTask()) != null) break;
        } while (this.pool.hasNewSyncEvent(this));
        this.seed = r;
        return t;
    }

    final ForkJoinTask<?> pollTask() {
        ForkJoinTask<?> t;
        ForkJoinTask<?> forkJoinTask = t = this.locallyFifo ? this.locallyDeqTask() : this.popTask();
        if (t == null && (t = this.scan()) != null) {
            ++this.stealCount;
        }
        return t;
    }

    final ForkJoinTask<?> pollLocalTask() {
        return this.locallyFifo ? this.locallyDeqTask() : this.popTask();
    }

    private ForkJoinTask<?> pollSubmission() {
        ForkJoinPool p = this.pool;
        while (p.hasQueuedSubmissions()) {
            ForkJoinTask<?> t;
            if (!this.tryActivate() || (t = p.pollSubmission()) == null) continue;
            return t;
        }
        return null;
    }

    final void cancelTasks() {
        ForkJoinTask<?> t;
        while (this.base != this.sp && (t = this.deqTask()) != null) {
            t.cancelIgnoringExceptions();
        }
    }

    final int drainTasksTo(Collection<? super ForkJoinTask<?>> c) {
        ForkJoinTask<?> t;
        int n = 0;
        while (this.base != this.sp && (t = this.deqTask()) != null) {
            c.add(t);
            ++n;
        }
        return n;
    }

    final int getAndClearStealCount() {
        int sc = this.stealCount;
        this.stealCount = 0;
        return sc;
    }

    static boolean hasQueuedTasks(ForkJoinWorkerThread[] ws) {
        if (ws != null) {
            int len = ws.length;
            for (int j = 0; j < 2; ++j) {
                for (int i = 0; i < len; ++i) {
                    ForkJoinWorkerThread w = ws[i];
                    if (w == null || w.sp == w.base) continue;
                    return true;
                }
            }
        }
        return false;
    }

    final int getQueueSize() {
        return Math.max(0, this.sp - this.base);
    }

    final int getEstimatedSurplusTaskCount() {
        return this.sp - this.base - (this.pool.getIdleThreadCount() >>> 1);
    }

    final ForkJoinTask<?> scanWhileJoining(ForkJoinTask<?> joinMe) {
        ForkJoinTask<?> t = this.pollTask();
        if (t != null && joinMe.status < 0 && this.sp == this.base) {
            this.pushTask(t);
            t = null;
        }
        return t;
    }

    final void helpQuiescePool() {
        while (true) {
            ForkJoinTask<?> t;
            if ((t = this.pollTask()) != null) {
                t.quietlyExec();
                continue;
            }
            if (this.tryInactivate() && this.pool.isQuiescent()) break;
        }
        while (!this.tryActivate()) {
        }
    }

    private static long objectFieldOffset(String field, Class<?> klazz) {
        try {
            return UNSAFE.objectFieldOffset(klazz.getDeclaredField(field));
        }
        catch (NoSuchFieldException e) {
            NoSuchFieldError error = new NoSuchFieldError(field);
            error.initCause(e);
            throw error;
        }
    }

    private static Unsafe getUnsafe() {
        try {
            return Unsafe.getUnsafe();
        }
        catch (SecurityException se) {
            try {
                return AccessController.doPrivileged(new PrivilegedExceptionAction<Unsafe>(){

                    @Override
                    public Unsafe run() throws Exception {
                        Field f = Unsafe.class.getDeclaredField("theUnsafe");
                        f.setAccessible(true);
                        return (Unsafe)f.get(null);
                    }
                });
            }
            catch (PrivilegedActionException e) {
                throw new RuntimeException("Could not initialize intrinsics", e.getCause());
            }
        }
    }

    static {
        int s = UNSAFE.arrayIndexScale(ForkJoinTask[].class);
        if ((s & s - 1) != 0) {
            throw new Error("data type scale not a power of two");
        }
        qShift = 31 - Integer.numberOfLeadingZeros(s);
    }
}

