/*
 * Decompiled with CFR 0.152.
 */
package hj.runtime.wsh;

import hj.lang.MultipleExceptions;
import hj.lang.PhaserException;
import hj.lang.Runtime;
import hj.lang.activity;
import hj.lang.phaserRegMode;
import hj.runtime.common.Configuration;
import hj.runtime.wsh.FinishState;
import hj.runtime.wsh.Future_c;
import hj.runtime.wsh.HjRunnable;
import hj.runtime.wsh.InvocationStrategy;
import hj.runtime.wsh.Place;
import hj.runtime.wsh.PoolRunner;
import hj.runtime.wsh.Report;
import hj.runtime.wsh.VMInterface;
import hj.runtime.wsh.WshConfiguration;
import hj.runtime.wsh.abstractmetrics.AbstractMetrics;
import hj.runtime.wsh.abstractmetrics.AbstractMetricsFactory;
import hj.runtime.wsh.ovd.OVDInfo;
import hj.runtime.wsh.phaser.PhaserImpl;
import hj.runtime.wsh.phaser.PhaserManager;
import hj.runtime.wsh.phaser.PhaserManagerFactory;
import hj.runtime.wsh.phaser.SyncVar1;
import hj.runtime.wsh.phaser.SyncVar2;
import hj.runtime.wsh.phaser.accumulator.AccumCell;
import hj.runtime.wsh.phaser.accumulator.Accumulator;
import hj.runtime.wsh.util.DataDrivenFutureList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Random;
import java.util.Stack;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class Activity
extends activity
implements HjRunnable,
AbstractMetrics {
    protected Place place_;
    protected FinishState finishState_ = null;
    protected Stack<FinishState> finishStack_ = null;
    public PhaserManager activityPhaserManager;
    protected FinishState rootNode_;
    protected Future_c future;
    private AbstractMetrics abstractMetricsManager;
    private boolean notFinished = true;
    boolean success = true;
    private InvocationStrategy invocationStrategy = InvocationStrategy.ASYNC;
    private final String name;
    private OVDInfo ovdInfo;
    public DataDrivenFutureList waitList;
    private final HashMap syncVarMap1 = new HashMap();
    private final HashMap syncVarMap2 = new HashMap();
    private SyncVar1 sv1 = null;
    private SyncVar2 sv2 = null;
    private PhaserImpl singlePh = null;
    private int cnt = 0;
    private final HashMap AccumCellMap = new HashMap();
    private AccumCell cell = null;
    private Accumulator acc = null;
    private int cnta = 0;
    public int tmpForDelay;
    public int round;
    public Random rand = null;
    private phaserRegMode prm = null;
    private List<phaserRegMode> phaserRegModes = null;
    public List<PhaserImpl> childPhasers = null;
    private HashMap<Activity, List> childActRegMap = null;
    public boolean hasAcyclicPhaser = false;

    public Activity() {
        this(new Throwable().getStackTrace()[2].toString());
    }

    public Activity(String name) {
        this.name = name;
        if (Configuration.ABSTRACT_EXECUTION_STATS) {
            this.abstractMetricsManager = AbstractMetricsFactory.getAbstractMetricsManager();
        }
        this.initializeActivity();
    }

    public void setDDF(Collection l) {
        assert (this.waitList == null);
        this.waitList = new DataDrivenFutureList(this);
        this.waitList.setList(l);
    }

    public Activity(List<phaserRegMode> phaserRegModes, String name) {
        this.name = name;
        if (Configuration.ABSTRACT_EXECUTION_STATS) {
            this.abstractMetricsManager = AbstractMetricsFactory.getAbstractMetricsManager();
        }
        this.activityPhaserManager = PhaserManagerFactory.getPhaserManager(this, phaserRegModes);
        if (!phaserRegModes.isEmpty()) {
            this.phaserRegModes = phaserRegModes;
            Activity a = (Activity)Runtime.getCurrentActivity();
            if (a.childActRegMap == null) {
                a.childActRegMap = new HashMap();
            }
            a.childActRegMap.put(this, new LinkedList<phaserRegMode>(phaserRegModes));
        }
        this.initializeActivity();
    }

    public Activity(List<phaserRegMode> phaserRegModes) {
        this(phaserRegModes, new Throwable().getStackTrace()[2].toString());
    }

    public Activity(phaserRegMode prm, String name) {
        this.name = name;
        if (Configuration.ABSTRACT_EXECUTION_STATS) {
            this.abstractMetricsManager = AbstractMetricsFactory.getAbstractMetricsManager();
        }
        this.activityPhaserManager = PhaserManagerFactory.getPhaserManager(this, prm);
        this.prm = prm;
        this.initializeActivity();
    }

    public Activity(phaserRegMode prm) {
        this(prm, new Throwable().getStackTrace()[2].toString());
    }

    private void initializeActivity() {
        if (Report.should_report("activity", 5)) {
            Report.report(5, "Activity: initializing " + this);
        }
        this.registerPhasers();
        if (VMInterface.ABSTRACT_EXECUTION_TIMES) {
            this.setResumeTime();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        PoolRunner activityRunner = (PoolRunner)((Object)Thread.currentThread());
        if (Report.should_report("activity", 5)) {
            Report.report(5, activityRunner + " is running " + this);
        }
        activityRunner.setActivity(this);
        activityRunner.setPlace(this.getPlace());
        try {
            this.invocationStrategy.invokeHjTask(this);
        }
        catch (Throwable t) {
            this.success = false;
            if (t instanceof Error) {
                throw (Error)t;
            }
            if (t instanceof RuntimeException) {
                throw (RuntimeException)t;
            }
        }
        finally {
            if (this.waitList != null) {
                this.waitList.clear();
            }
            this.setFinished();
        }
    }

    @Override
    public abstract void runHjTask();

    @Override
    public abstract boolean isHjTaskReady();

    public synchronized void join() throws InterruptedException {
        while (this.notFinished) {
            this.wait();
        }
    }

    private synchronized void setFinished() {
        this.notFinished = false;
        this.notifyAll();
    }

    public void setRootActivityFinishState(FinishState root) {
        this.rootNode_ = root;
    }

    public void setPlace(Place p) {
        this.place_ = p;
    }

    public Place getPlace() {
        return this.place_;
    }

    public void setAsyncReturn(Object asyncResult) {
        this.future.setResult(asyncResult);
    }

    public void startFinish() {
        if (this.finishState_ != null) {
            this.getFinishStack().push(this.finishState_);
        }
        this.finishState_ = new FinishState(this);
        if (Report.should_report("activity", 3)) {
            Report.report(3, this + " starts finish " + this.finishState_);
        }
    }

    public void startFinish(Object accums) {
        if (this.finishState_ != null) {
            this.getFinishStack().push(this.finishState_);
        }
        this.finishState_ = new FinishState(this);
        this.finishState_.initializeFinishAccumulatorManager((List)accums);
        if (Report.should_report("activity", 3)) {
            Report.report(3, this + " starts finish " + this.finishState_);
        }
    }

    public void stopFinish() {
        if (this.hasAcyclicPhaser) {
            this.detectAcyclicPhasersOnCycle();
        }
        PhaserImpl.dropAllPhasers(this.finishState_.getPhaserList(), this);
        if (Report.should_report("activity", 5)) {
            Report.report(5, this + " enters stopfinish ");
        }
        this.finishState_.waitForFinish();
        if (Report.should_report("activity", 5)) {
            Report.report(5, this + " continues stopfinish ");
        }
        this.finishState_.finalizeFinishAccumulatorManager();
        FinishState state = this.finishState_;
        if (this.finishStack_ == null) {
            this.finishState_ = null;
        } else if (!this.finishStack_.isEmpty()) {
            this.finishState_ = this.finishStack_.pop();
        }
        Stack result = state.exceptions();
        if (result != null && !result.empty()) {
            if (result.size() == 1) {
                Throwable t = (Throwable)result.pop();
                if (Report.should_report("activity", 3)) {
                    Report.report(3, this + " throws  " + t);
                }
                if (t instanceof Error) {
                    throw (Error)t;
                }
                if (t instanceof RuntimeException) {
                    throw (RuntimeException)t;
                }
            }
            throw new MultipleExceptions(result);
        }
        if (Report.should_report("activity", 3)) {
            Report.report(3, this + " exits from finish.");
        }
    }

    private Stack<FinishState> getFinishStack() {
        if (this.finishStack_ == null) {
            this.finishStack_ = new Stack();
        }
        return this.finishStack_;
    }

    private boolean inFinish() {
        return this.finishState_ != null;
    }

    public void pushException(Throwable t) {
        if (Report.should_report("activity", 3)) {
            Report.report(3, this + " pushing exception " + t + " onto " + this.finishState_);
        }
        this.finishState_.pushException(t);
    }

    public void addPhaser(phaserRegMode prm) {
        if (this.activityPhaserManager != null) {
            this.activityPhaserManager.addPhaser(prm);
        } else {
            this.activityPhaserManager = PhaserManagerFactory.getPhaserManager(this, prm);
        }
    }

    public void dropPhaser(PhaserImpl ph) {
        if (this.activityPhaserManager != null) {
            this.activityPhaserManager.dropPhaser(ph);
            if (this.activityPhaserManager.getNbRegisteredPhasers() == 0) {
                this.activityPhaserManager = null;
            }
        } else if (Report.should_report("Phaser", 3)) {
            Report.report(3, this + " dropPhaser attempt failed because no phasers are registered in this activity " + ph + ".");
        }
    }

    protected void dropAllPhasers() {
        if (this.activityPhaserManager != null) {
            this.activityPhaserManager.dropAllPhasers();
            this.activityPhaserManager = null;
        } else if (Report.should_report("Phaser", 3)) {
            Report.report(3, "dropAllPhasers attempt failed because no phasers are registered in this activity ");
        }
    }

    public void doNext() {
        if (this.activityPhaserManager != null) {
            this.activityPhaserManager.doNext();
        } else if (Report.should_report("Phaser", 3)) {
            Report.report(3, "doNext attempt failed because no phasers are registered in this activity ");
        }
    }

    public void doSignal() {
        if (this.activityPhaserManager != null) {
            this.activityPhaserManager.doSignal();
        } else if (Report.should_report("Phaser", 3)) {
            Report.report(3, "signal attempt failed because no phasers are registered in this activity ");
        }
    }

    public void doWait() {
        if (this.activityPhaserManager != null) {
            this.activityPhaserManager.doWait();
        } else if (Report.should_report("Phaser", 3)) {
            Report.report(3, "doWait attempt failed because no phasers are registered in this activity ");
        }
    }

    public int doNext1(String loc) {
        int ret = 0;
        if (this.activityPhaserManager != null) {
            ret = this.activityPhaserManager.doNext1(loc);
        } else {
            if (Report.should_report("Phaser", 3)) {
                Report.report(3, "doNext1 attempt failed because no phasers are registered in this activity ");
            }
            assert (false);
        }
        return ret;
    }

    public void doNext2() {
        if (this.activityPhaserManager != null) {
            this.activityPhaserManager.doNext2();
        } else {
            if (Report.should_report("Phaser", 3)) {
                Report.report(3, "doNext2 attempt failed because no phasers are registered in this activity ");
            }
            assert (false);
        }
    }

    public void putSyncVar1(PhaserImpl ph, SyncVar1 s1) {
        if (this.cnt > 1) {
            this.syncVarMap1.put(ph, s1);
        } else if (this.cnt == 1) {
            if (ph == this.singlePh) {
                this.sv1 = s1;
            } else {
                if (this.sv1 != null) {
                    this.syncVarMap1.put(this.singlePh, this.sv1);
                }
                if (this.sv2 != null) {
                    this.syncVarMap2.put(this.singlePh, this.sv2);
                }
                this.syncVarMap1.put(ph, s1);
                this.cnt = 2;
            }
        } else {
            this.singlePh = ph;
            this.sv1 = s1;
            this.cnt = 1;
        }
    }

    public void putSyncVar2(PhaserImpl ph, SyncVar2 s2) {
        if (this.cnt > 1) {
            this.syncVarMap2.put(ph, s2);
        } else if (this.cnt == 1) {
            if (ph == this.singlePh) {
                this.sv2 = s2;
            } else {
                if (this.sv1 != null) {
                    this.syncVarMap1.put(this.singlePh, this.sv1);
                }
                if (this.sv2 != null) {
                    this.syncVarMap2.put(this.singlePh, this.sv2);
                }
                this.syncVarMap2.put(ph, s2);
                this.cnt = 2;
            }
        } else {
            this.singlePh = ph;
            this.sv2 = s2;
            this.cnt = 1;
        }
    }

    public SyncVar1 getSyncVar1(PhaserImpl ph) {
        if (this.cnt == 1 && ph == this.singlePh) {
            return this.sv1;
        }
        if (this.cnt > 1) {
            return (SyncVar1)this.syncVarMap1.get(ph);
        }
        return null;
    }

    public SyncVar2 getSyncVar2(PhaserImpl ph) {
        if (this.cnt == 1 && ph == this.singlePh) {
            return this.sv2;
        }
        if (this.cnt > 1) {
            return (SyncVar2)this.syncVarMap2.get(ph);
        }
        return null;
    }

    public void putAccumCell(Accumulator ac, AccumCell cel) {
        if (this.cnta > 1) {
            this.AccumCellMap.put(ac, cel);
        } else if (this.cnta == 1) {
            assert (ac != this.acc);
            this.AccumCellMap.put(this.acc, this.cell);
            this.AccumCellMap.put(ac, cel);
            this.cnta = 2;
        } else {
            this.acc = ac;
            this.cell = cel;
            this.cnta = 1;
        }
    }

    public AccumCell getAccumCell(Accumulator ac) {
        if (this.cnta == 1 && ac == this.acc) {
            return this.cell;
        }
        if (this.cnta > 1) {
            return (AccumCell)this.AccumCellMap.get(ac);
        }
        return null;
    }

    private void detectAcyclicPhasersOnCycle() {
        int n = this.childPhasers.size() + 1;
        HashMap<PhaserImpl, Integer> phToId = new HashMap<PhaserImpl, Integer>();
        ArrayList<Integer> aphasers = new ArrayList<Integer>();
        LinkedList<Integer> edges = new LinkedList<Integer>();
        int id = 0;
        for (PhaserImpl ph : this.childPhasers) {
            Integer num = new Integer(id);
            phToId.put(ph, num);
            if (ph.isAcyclic) {
                aphasers.add(num);
            }
            ++id;
        }
        if (aphasers.isEmpty()) {
            return;
        }
        if (this.prm != null) {
            PhaserImpl ph = (PhaserImpl)this.prm.getPhaser();
            PhaserImpl.Mode m = this.prm.getMode();
            if (!(ph.isAcyclic || m != PhaserImpl.Mode.SIG_WAIT && m != PhaserImpl.Mode.SIG_WAIT_SINGLE)) {
                phToId.put(ph, new Integer(id));
            }
        } else if (this.phaserRegModes != null) {
            PhaserImpl.Mode modeSum = PhaserImpl.Mode.TRANSMIT;
            for (phaserRegMode pr : this.phaserRegModes) {
                PhaserImpl ph = (PhaserImpl)pr.getPhaser();
                PhaserImpl.Mode m = pr.getMode();
                if (ph.isAcyclic) continue;
                if (modeSum == PhaserImpl.Mode.TRANSMIT) {
                    modeSum = m;
                } else if (modeSum != m) {
                    modeSum = PhaserImpl.Mode.SIG_WAIT;
                }
                if (modeSum != PhaserImpl.Mode.SIG_WAIT && modeSum != PhaserImpl.Mode.SIG_WAIT_SINGLE) continue;
                break;
            }
            if (modeSum == PhaserImpl.Mode.SIG_WAIT || modeSum == PhaserImpl.Mode.SIG_WAIT_SINGLE) {
                Integer num = new Integer(id);
                for (phaserRegMode pr : this.phaserRegModes) {
                    PhaserImpl ph = (PhaserImpl)pr.getPhaser();
                    if (ph.isAcyclic) continue;
                    phToId.put(ph, num);
                }
            }
        }
        if (this.childActRegMap != null) {
            for (Activity a : this.childActRegMap.keySet()) {
                List childActRegModes = this.childActRegMap.get(a);
                LinkedList sigs = new LinkedList();
                LinkedList waits = new LinkedList();
                for (phaserRegMode cpr : childActRegModes) {
                    PhaserImpl ph = (PhaserImpl)cpr.getPhaser();
                    PhaserImpl.Mode m = cpr.getMode();
                    if (m != PhaserImpl.Mode.WAIT) {
                        sigs.add(phToId.get(ph));
                    }
                    if (m == PhaserImpl.Mode.SIG) continue;
                    waits.add(phToId.get(ph));
                }
                for (Integer waitID : waits) {
                    for (Integer sigID : sigs) {
                        if (waitID == sigID) continue;
                        edges.add(waitID);
                        edges.add(sigID);
                    }
                }
            }
        }
        Integer[][] edgeTarget = new Integer[n][n];
        Integer[][] closureSource = new Integer[n][n];
        int[][] refcount = new int[n][n];
        List[] adjacent = new LinkedList[n];
        List[] reaches = new LinkedList[n];
        for (int i = 0; i < n; ++i) {
            adjacent[i] = new LinkedList();
            reaches[i] = new LinkedList();
        }
        int totalAph = aphasers.size();
        Iterator<Object> it = edges.iterator();
        while (it.hasNext()) {
            Integer srcID = (Integer)it.next();
            Integer distID = (Integer)it.next();
            if (refcount[distID][srcID] > 0) {
                int i = 0;
                while (i < totalAph) {
                    Integer aphID = (Integer)aphasers.get(i);
                    if (!(refcount[distID][aphID] <= 0 && distID != aphID || refcount[aphID][srcID] <= 0 && aphID != srcID)) {
                        aphasers.remove(i);
                        --totalAph;
                        continue;
                    }
                    ++i;
                }
                if (aphasers.isEmpty()) break;
            }
            this.insertEdge(srcID, distID, edgeTarget, closureSource, refcount, adjacent, reaches);
        }
        for (PhaserImpl ph : this.childPhasers) {
            if (!ph.isAcyclic) continue;
            if (!aphasers.contains(phToId.get(ph))) {
                ph.isAcyclic = false;
            }
            ph.isDetecting = false;
        }
    }

    private void insertEdge(Integer a, Integer b, Integer[][] edgeTarget, Integer[][] closureSource, int[][] refcount, List[] adjacent, List[] reaches) {
        ArrayList<Integer> worklist = new ArrayList<Integer>();
        if (refcount[a][b] == 0) {
            this.makeClosure(a, b, reaches, closureSource);
            worklist.add(a);
            worklist.add(b);
        }
        this.makeEdge(a, b, adjacent, edgeTarget);
        int[] nArray = refcount[a];
        int n = b;
        nArray[n] = nArray[n] + 1;
        for (Integer x : reaches[a]) {
            if (refcount[x][b] == 0) {
                this.makeClosure(x, b, reaches, closureSource);
                worklist.add(x);
                worklist.add(b);
            }
            int[] nArray2 = refcount[x];
            int n2 = b;
            nArray2[n2] = nArray2[n2] + 1;
        }
        int total = worklist.size();
        for (int i = 0; i < total; i += 2) {
            Integer x = (Integer)worklist.get(i);
            Integer y = (Integer)worklist.get(i + 1);
            for (Integer z : adjacent[y]) {
                if (refcount[x][z] == 0) {
                    this.makeClosure(x, z, reaches, closureSource);
                    worklist.add(x);
                    worklist.add(z);
                    total += 2;
                }
                int[] nArray3 = refcount[x];
                int n3 = z;
                nArray3[n3] = nArray3[n3] + 1;
            }
        }
    }

    private void makeEdge(Integer v, Integer w, List[] adjacent, Integer[][] edgeTarget) {
        adjacent[v].add(w);
        edgeTarget[v.intValue()][w.intValue()] = w;
    }

    private void makeClosure(Integer v, Integer w, List[] reaches, Integer[][] closureSource) {
        reaches[w].add(v);
        closureSource[v.intValue()][w.intValue()] = v;
    }

    public phaserRegMode checkPhaserUse(phaserRegMode prm) {
        PhaserImpl ph = (PhaserImpl)prm.getPhaser();
        if (ph.dropped()) {
            throw new PhaserException("Cannot transmit dropped phaser.");
        }
        if (ph.quiescent()) {
            throw new PhaserException("Cannot transmit sent (resumed) phaser.");
        }
        if (this.inFinish() && !this.finishState_.getPhaserList().contains(ph)) {
            throw new PhaserException("IEF scope rule violation: The innermost finish doesn't include this phaser.");
        }
        return prm;
    }

    public void checkPhaserUse(List<phaserRegMode> phaserModeList) {
        Iterator<phaserRegMode> it = phaserModeList.iterator();
        while (it.hasNext()) {
            this.checkPhaserUse(it.next());
        }
    }

    public List<phaserRegMode> getPhaserRegModeList() {
        if (this.activityPhaserManager != null) {
            return this.activityPhaserManager.getPhaserRegModeList();
        }
        return Collections.EMPTY_LIST;
    }

    public int getNbRegisteredPhasers() {
        if (this.activityPhaserManager == null) {
            return 0;
        }
        return this.activityPhaserManager.getNbRegisteredPhasers();
    }

    public void registerPhasers() {
        if (this.activityPhaserManager != null) {
            this.activityPhaserManager.registerPhasers();
        }
    }

    @Override
    public long getTotalOps() {
        if (Configuration.ABSTRACT_EXECUTION_STATS) {
            return this.abstractMetricsManager.getTotalOps();
        }
        return 0L;
    }

    @Override
    public long getCritPathOps() {
        if (Configuration.ABSTRACT_EXECUTION_STATS) {
            return this.abstractMetricsManager.getCritPathOps();
        }
        return 0L;
    }

    @Override
    public void addLocalOps(long n) {
        if (Configuration.ABSTRACT_EXECUTION_STATS) {
            this.abstractMetricsManager.addLocalOps(n);
        }
    }

    @Override
    public void addCritPathOps(long n) {
        if (Configuration.ABSTRACT_EXECUTION_STATS) {
            this.abstractMetricsManager.addCritPathOps(n);
        }
    }

    @Override
    public void maxCritPathOps(long n) {
        if (Configuration.ABSTRACT_EXECUTION_STATS) {
            this.abstractMetricsManager.maxCritPathOps(n);
        }
    }

    @Override
    public long getTotalUnblockedTime() {
        if (Configuration.ABSTRACT_EXECUTION_STATS) {
            return this.abstractMetricsManager.getTotalUnblockedTime();
        }
        return 0L;
    }

    @Override
    public long getCritPathTime() {
        if (Configuration.ABSTRACT_EXECUTION_STATS) {
            return this.abstractMetricsManager.getCritPathTime();
        }
        return 0L;
    }

    @Override
    public void maxCritPathTime(long t) {
        if (Configuration.ABSTRACT_EXECUTION_STATS) {
            this.abstractMetricsManager.maxCritPathTime(t);
        }
    }

    @Override
    public long getResumeTime() {
        if (Configuration.ABSTRACT_EXECUTION_STATS) {
            return this.abstractMetricsManager.getResumeTime();
        }
        return 0L;
    }

    @Override
    public void setResumeTime() {
        if (Configuration.ABSTRACT_EXECUTION_STATS) {
            this.abstractMetricsManager.setResumeTime();
        }
    }

    @Override
    public void updateIdealTime() {
        if (Configuration.ABSTRACT_EXECUTION_STATS) {
            this.abstractMetricsManager.updateIdealTime();
        }
    }

    @Override
    public long getCurrentTime() {
        if (Configuration.ABSTRACT_EXECUTION_STATS) {
            return this.abstractMetricsManager.getCurrentTime();
        }
        return 0L;
    }

    @Override
    public void addUnblockedTime(long t) {
        if (Configuration.ABSTRACT_EXECUTION_STATS) {
            this.abstractMetricsManager.addUnblockedTime(t);
        }
    }

    @Override
    public void maxOverheads(long n) {
        if (Configuration.ABSTRACT_EXECUTION_STATS) {
            this.abstractMetricsManager.maxOverheads(n);
        }
    }

    @Override
    public long getOverheads() {
        if (Configuration.ABSTRACT_EXECUTION_STATS) {
            return this.abstractMetricsManager.getOverheads();
        }
        return 0L;
    }

    public Activity finalizeActivitySpawn(Activity child) {
        if (Report.should_report("activity", 3)) {
            Report.report(3, this + " spawns " + child);
        }
        FinishState target = this.finishState_ == null ? this.rootNode_ : this.finishState_;
        child.setRootActivityFinishState(target);
        target.notifySubActivitySpawn();
        if (Configuration.ABSTRACT_EXECUTION_STATS) {
            child.maxCritPathOps(this.getCritPathOps());
            child.maxOverheads(this.getOverheads() + WshConfiguration.ABSTRACT_EXECUTION_OVERHEAD);
        }
        if (Configuration.isOVDEnabled()) {
            this.getOVDInfo().prepareSpawn(this, child.getOVDInfo());
        }
        return child;
    }

    public void finalizeTermination() {
        if (Report.should_report("activity", 5)) {
            Report.report(5, this + "terminates.");
        }
        this.finalizeTerminationCleanup();
        if (this.rootNode_ != null) {
            if (this.future != null && this.future.getException() != null) {
                this.rootNode_.registerFailedFuture(this.future);
            }
            this.rootNode_.notifySubActivityTermination();
        }
    }

    public void finalizeTermination(Throwable t) {
        if (Report.should_report("activity", 5)) {
            Report.report(5, Thread.currentThread() + " " + this + " terminates abruptly with " + t);
        }
        if (this.future != null) {
            this.future.setException(t);
            this.finalizeTermination();
        } else {
            this.finalizeTerminationCleanup();
            if (this.rootNode_ != null) {
                this.rootNode_.notifySubActivityTermination(t);
            }
        }
    }

    public void finalizeTerminationCleanup() {
        if (Configuration.ABSTRACT_EXECUTION_STATS) {
            ((Place)Runtime.here()).maxCritPathOps(this.getCritPathOps());
            ((Place)Runtime.here()).addLocalOps(this.getTotalOps());
            ((Place)Runtime.here()).maxOverheads(this.getOverheads());
            if (VMInterface.ABSTRACT_EXECUTION_TIMES) {
                this.updateIdealTime();
                ((Place)Runtime.here()).addUnblockedTime(this.getTotalUnblockedTime());
                ((Place)Runtime.here()).maxCritPathTime(this.getCritPathTime());
            }
        }
        if (this.hasAcyclicPhaser) {
            this.detectAcyclicPhasersOnCycle();
        }
        this.dropAllPhasers();
        if (Report.should_report("activity", 5)) {
            Report.report(5, Thread.currentThread() + " " + this + " drops phasers, has rootNode_ " + this.rootNode_);
        }
    }

    public String myName() {
        return this.name != null ? this.name : "Activity " + Long.toHexString(System.identityHashCode(this));
    }

    public String toString() {
        String rv = "<" + this.myName();
        rv = rv + " " + this.finishState_ + "," + this.rootNode_;
        rv = rv + ">";
        return rv;
    }

    public String shortString() {
        return "<" + this.myName() + ">";
    }

    public void setInvocationStrategy(InvocationStrategy async_in_finish) {
        this.invocationStrategy = async_in_finish;
    }

    public void registerPhaserToIEF(PhaserImpl phaserImpl) {
        if (this.finishState_ != null) {
            this.finishState_.getPhaserList().add(phaserImpl);
        }
    }

    public FinishState getFinishState() {
        return this.finishState_;
    }

    public boolean hasFinishState(FinishState fs) {
        if (this.finishState_ == fs && fs != null) {
            return true;
        }
        if (this.finishStack_ != null) {
            for (int i = this.finishStack_.size() - 1; i >= 0; --i) {
                if (this.finishStack_.get(i) != fs) continue;
                return true;
            }
        }
        return false;
    }

    public boolean isReady() {
        return this.waitList == null || this.waitList.isReady();
    }

    public OVDInfo getOVDInfo() {
        if (this.ovdInfo == null) {
            this.ovdInfo = new OVDInfo();
        }
        return this.ovdInfo;
    }
}

