/*
 * Decompiled with CFR 0.152.
 */
package hj.runtime.wsh;

import hj.lang.BlockedException;
import hj.lang.accumulator;
import hj.runtime.common.Configuration;
import hj.runtime.wsh.Activity;
import hj.runtime.wsh.Future_c;
import hj.runtime.wsh.HjManagedBlocker;
import hj.runtime.wsh.ModCountDownLatch;
import hj.runtime.wsh.PoolRunner;
import hj.runtime.wsh.Report;
import hj.runtime.wsh.VMInterface;
import hj.runtime.wsh.WshRuntime_c;
import hj.runtime.wsh.finishAccumulator.FinishAccumulatorManager;
import hj.runtime.wsh.phaser.PhaserImpl;
import java.util.LinkedList;
import java.util.List;
import java.util.Stack;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FinishState
implements HjManagedBlocker {
    private Stack<Throwable> finish_;
    protected Activity parent;
    protected ModCountDownLatch mcdl = new ModCountDownLatch(0);
    protected List<PhaserImpl> phaserList = new LinkedList<PhaserImpl>();
    protected FinishAccumulatorManager accumManager = null;
    private List<Future_c> futureList;

    public FinishState(Activity activity2) {
        this.parent = activity2;
    }

    public void waitForFinish() {
        if (this.mcdl.getCount() > 0L) {
            PoolRunner activityRunner = (PoolRunner)((Object)Thread.currentThread());
            activityRunner.getPlace().threadBlockedNotification(this);
        }
        if (Configuration.ABSTRACT_EXECUTION_STATS) {
            ((Activity)WshRuntime_c.getCurrentActivity()).maxCritPathOps(this.mcdl.getCritPathOps());
            ((Activity)WshRuntime_c.getCurrentActivity()).maxOverheads(this.mcdl.getOverheads());
            if (VMInterface.ABSTRACT_EXECUTION_TIMES) {
                ((Activity)WshRuntime_c.getCurrentActivity()).maxCritPathTime(this.mcdl.getIdealTime());
                ((Activity)WshRuntime_c.getCurrentActivity()).setResumeTime();
            }
        }
    }

    public void notifySubActivitySpawn() {
        this.mcdl.updateCount();
        if (Report.should_report("activity", 5)) {
            Report.report(5, " updating " + this.toString());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void pushException(Throwable t) {
        if (t instanceof BlockedException) {
            return;
        }
        FinishState finishState = this;
        synchronized (finishState) {
            t.printStackTrace();
            this.getFinishStack().push(t);
        }
    }

    private Stack<Throwable> getFinishStack() {
        if (this.finish_ == null) {
            this.finish_ = new Stack();
        }
        return this.finish_;
    }

    public void notifySubActivityTermination() {
        this.mcdl.countDown();
    }

    public void notifySubActivityTermination(Throwable t) {
        this.pushException(t);
        this.notifySubActivityTermination();
    }

    public Stack exceptions() {
        if (this.futureList != null) {
            for (Future_c promise : this.futureList) {
                Throwable exception;
                if (promise.finished() || (exception = promise.getException()) == null) continue;
                this.getFinishStack().push(exception);
            }
        }
        return this.finish_;
    }

    public synchronized String toString() {
        return "<FinishState " + this.hashCode() + " " + this.mcdl.getCount() + "," + this.parent.shortString() + "," + this.finish_ + ">";
    }

    public List<PhaserImpl> getPhaserList() {
        return this.phaserList;
    }

    public void initializeFinishAccumulatorManager(List<accumulator> accums) {
        this.accumManager = new FinishAccumulatorManager(accums);
        this.accumManager.openFinishAccumulators();
    }

    public void finalizeFinishAccumulatorManager() {
        if (this.accumManager != null) {
            this.accumManager.closeFinishAccumulators();
        }
    }

    public void registerFailedFuture(Future_c future) {
        if (this.futureList == null) {
            this.futureList = new LinkedList<Future_c>();
        }
        this.futureList.add(future);
    }

    public boolean block() throws InterruptedException {
        try {
            this.mcdl.await();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        return true;
    }

    public boolean isReleasable() {
        return this.mcdl.getCount() == 0L;
    }
}

