/*
 * Decompiled with CFR 0.152.
 */
package hj.runtime.wsh;

import hj.lang.Future;
import hj.runtime.common.Configuration;
import hj.runtime.wsh.Activity;
import hj.runtime.wsh.ModCountDownLatch;
import hj.runtime.wsh.PoolRunner;
import hj.runtime.wsh.VMInterface;
import hj.runtime.wsh.WshRuntime_c;
import hj.runtime.wsh.abstractmetrics.AbstractMetrics;

public final class Future_c
extends Future {
    private Throwable exception_;
    private Object result_;
    private boolean completed_;
    private boolean forced_;
    private ModCountDownLatch cdl = new ModCountDownLatch(1);
    private long critPathOps = 0L;
    private long overheads = 0L;
    private long curIdealTime = 0L;

    public void setResult(Object result) {
        this.result_ = result;
        this.completed_ = true;
        if (this.cdl.getCount() > 0L) {
            this.cdl.countDown();
        }
        if (Configuration.ABSTRACT_EXECUTION_STATS) {
            this.maxCritPathOps(((AbstractMetrics)((Object)WshRuntime_c.getCurrentActivity())).getCritPathOps());
            this.maxOverheads(((AbstractMetrics)((Object)WshRuntime_c.getCurrentActivity())).getOverheads());
            if (VMInterface.ABSTRACT_EXECUTION_TIMES) {
                ((AbstractMetrics)((Object)WshRuntime_c.getCurrentActivity())).updateIdealTime();
                this.maxIdealTime(((AbstractMetrics)((Object)WshRuntime_c.getCurrentActivity())).getCritPathTime());
            }
        }
    }

    public void setException(Throwable t) {
        this.exception_ = t;
        this.completed_ = true;
        if (this.cdl.getCount() > 0L) {
            this.cdl.countDown();
        }
        if (Configuration.ABSTRACT_EXECUTION_STATS) {
            this.maxCritPathOps(((AbstractMetrics)((Object)WshRuntime_c.getCurrentActivity())).getCritPathOps());
            this.maxOverheads(((AbstractMetrics)((Object)WshRuntime_c.getCurrentActivity())).getOverheads());
            if (VMInterface.ABSTRACT_EXECUTION_TIMES) {
                ((AbstractMetrics)((Object)WshRuntime_c.getCurrentActivity())).updateIdealTime();
                this.maxIdealTime(((AbstractMetrics)((Object)WshRuntime_c.getCurrentActivity())).getCritPathTime());
            }
        }
    }

    public Throwable getException() {
        return this.exception_;
    }

    public Object get() {
        PoolRunner t = (PoolRunner)((Object)Thread.currentThread());
        if (this.cdl.getCount() > 0L) {
            t.getPlace().threadBlockedNotification();
            try {
                this.cdl.await();
            }
            catch (InterruptedException ie) {
                System.err.println("Future_c::get - unexpected exception e" + ie);
                throw new Error(ie);
            }
            t.getPlace().threadUnblockedNotification();
        }
        if (Configuration.ABSTRACT_EXECUTION_STATS) {
            ((Activity)WshRuntime_c.getCurrentActivity()).maxCritPathOps(this.getCritPathOps());
            ((Activity)WshRuntime_c.getCurrentActivity()).maxOverheads(this.getOverheads());
            if (VMInterface.ABSTRACT_EXECUTION_TIMES) {
                ((Activity)WshRuntime_c.getCurrentActivity()).maxCritPathTime(this.getIdealTime());
                ((Activity)WshRuntime_c.getCurrentActivity()).setResumeTime();
            }
        }
        this.forced_ = true;
        if (this.exception_ != null) {
            if (this.exception_ instanceof Error) {
                throw (Error)this.exception_;
            }
            if (this.exception_ instanceof RuntimeException) {
                throw (RuntimeException)this.exception_;
            }
            assert (false);
        }
        return this.result_;
    }

    protected boolean completed() {
        return this.completed_;
    }

    public boolean finished() {
        return this.forced_;
    }

    public synchronized void maxCritPathOps(long n) {
        this.critPathOps = Math.max(this.critPathOps, n);
    }

    public long getCritPathOps() {
        return this.critPathOps;
    }

    public synchronized void maxOverheads(long n) {
        this.overheads = Math.max(this.overheads, n);
    }

    public long getOverheads() {
        return this.overheads;
    }

    public synchronized void maxIdealTime(long t) {
        this.curIdealTime = Math.max(this.curIdealTime, t);
    }

    public long getIdealTime() {
        return this.curIdealTime;
    }
}

