/*
 * Decompiled with CFR 0.152.
 */
package hj.runtime.wsh.finishAccumulator;

import hj.lang.FinishAccumulatorException;
import hj.lang.Runtime;
import hj.lang.accumulator;
import hj.runtime.wsh.Activity;
import hj.runtime.wsh.finishAccumulator.AtomicDouble;
import java.util.concurrent.atomic.AtomicInteger;

public class FinishAccumulator
extends accumulator {
    private final accumulator.Operator ope;
    private final Class type;
    private final Activity parentTask;
    private boolean isAccessible = false;
    private final boolean isLazy;
    private final Number initVal;
    private final int func;
    private final double delay;
    private final double coef;
    private Number resultVal;
    private Number resultTmp;
    private final AtomicInteger atomI;
    private final AtomicDouble atomD;

    public FinishAccumulator(accumulator.Operator ope, Class type) {
        this(ope, type, false, 1, 50.0, 2.0);
    }

    public FinishAccumulator(accumulator.Operator ope, Class type, boolean isLazy) {
        this(ope, type, isLazy, 1, 50.0, 2.0);
    }

    public FinishAccumulator(accumulator.Operator ope, Class type0, boolean isLazy, int func, double delay, double coef) {
        double initD;
        int initI;
        if (ope != accumulator.Operator.ANY && ope != accumulator.Operator.SUM && ope != accumulator.Operator.PROD && ope != accumulator.Operator.MIN && ope != accumulator.Operator.MAX) {
            throw new FinishAccumulatorException("Not supported operator.");
        }
        Class ty = null;
        if (type0 == Integer.TYPE || type0 == Integer.class) {
            ty = Integer.class;
        } else if (type0 == Double.TYPE || type0 == Double.class) {
            ty = Double.class;
        } else {
            throw new FinishAccumulatorException("Not supported data type " + type0 + ".");
        }
        this.ope = ope;
        this.type = ty;
        this.parentTask = (Activity)Runtime.getCurrentActivity();
        this.isLazy = isLazy;
        this.func = func;
        this.delay = delay;
        this.coef = coef;
        if (ope == accumulator.Operator.SUM || ope == accumulator.Operator.ANY) {
            initI = 0;
            initD = 0.0;
        } else if (ope == accumulator.Operator.PROD) {
            initI = 1;
            initD = 1.0;
        } else if (ope == accumulator.Operator.MIN) {
            initI = Integer.MAX_VALUE;
            initD = Double.MAX_VALUE;
        } else if (ope == accumulator.Operator.MAX) {
            initI = Integer.MIN_VALUE;
            initD = Double.MIN_VALUE;
        } else {
            initI = 0;
            initD = 0.0;
            assert (false);
        }
        if (this.type == Integer.class) {
            this.initVal = new Integer(initI);
        } else if (this.type == Double.class) {
            this.initVal = new Double(initD);
        } else {
            this.initVal = null;
            assert (false);
        }
        this.resultVal = this.initVal;
        if (isLazy) {
            throw new FinishAccumulatorException("Lazy polisy is not yet supported in work-sharing scheduler.");
        }
        this.atomI = this.type == Integer.class ? new AtomicInteger(initI) : null;
        this.atomD = this.type == Double.class ? new AtomicDouble(initD) : null;
    }

    public void setAccessible(boolean isAccessible) {
        if (isAccessible) {
            this.checkOwnership(0);
            if (this.isAccessible) {
                throw new FinishAccumulatorException("Nested (double) registration is not allowed.");
            }
        }
        this.isAccessible = isAccessible;
    }

    public void send(Number val) {
        if (val == null) {
            return;
        }
        Class<?> ty = val.getClass();
        if (ty == Integer.class) {
            this.send(val.intValue());
        } else if (ty == Double.class) {
            this.send(val.doubleValue());
        } else assert (false);
    }

    public void send(int val) {
        if (!this.isAccessible) {
            this.checkOwnership(1);
            if (this.ope == accumulator.Operator.ANY) {
                this.resultVal = new Integer(val);
            } else if (this.ope == accumulator.Operator.SUM) {
                if ((double)val != 0.0) {
                    this.resultVal = new Integer(val + this.resultVal.intValue());
                }
            } else if (this.ope == accumulator.Operator.PROD) {
                if ((double)val != 1.0) {
                    this.resultVal = new Integer(val * this.resultVal.intValue());
                }
            } else if (this.ope == accumulator.Operator.MIN) {
                if (val < this.resultVal.intValue()) {
                    this.resultVal = new Integer(val);
                }
            } else if (this.ope == accumulator.Operator.MAX) {
                if (val > this.resultVal.intValue()) {
                    this.resultVal = new Integer(val);
                }
            } else assert (false);
        } else if (this.ope == accumulator.Operator.ANY) {
            this.resultTmp = new Integer(val);
        } else {
            if (this.isLazy) {
                throw new FinishAccumulatorException("Lazy polisy is not yet supported in work-sharing scheduler.");
            }
            if (this.ope == accumulator.Operator.SUM) {
                this.atomIntAddAndGet(this.atomI, val);
            } else if (this.ope == accumulator.Operator.PROD) {
                this.atomIntMulAndGet(this.atomI, val);
            } else if (this.ope == accumulator.Operator.MIN) {
                this.atomIntMinAndGet(this.atomI, val);
            } else if (this.ope == accumulator.Operator.MAX) {
                this.atomIntMaxAndGet(this.atomI, val);
            } else assert (false);
        }
    }

    public void send(double val) {
        if (!this.isAccessible) {
            this.checkOwnership(1);
            if (this.ope == accumulator.Operator.ANY) {
                this.resultVal = new Double(val);
            } else if (this.ope == accumulator.Operator.SUM) {
                if (val != 0.0) {
                    this.resultVal = new Double(val + this.resultVal.doubleValue());
                }
            } else if (this.ope == accumulator.Operator.PROD) {
                if (val != 1.0) {
                    this.resultVal = new Double(val * this.resultVal.doubleValue());
                }
            } else if (this.ope == accumulator.Operator.MIN) {
                if (val < this.resultVal.doubleValue()) {
                    this.resultVal = new Double(val);
                }
            } else if (this.ope == accumulator.Operator.MAX) {
                if (val > this.resultVal.doubleValue()) {
                    this.resultVal = new Double(val);
                }
            } else assert (false);
        } else if (this.ope == accumulator.Operator.ANY) {
            this.resultTmp = new Double(val);
        } else {
            if (this.isLazy) {
                throw new FinishAccumulatorException("Lazy polisy is not yet supported in work-sharing scheduler.");
            }
            if (this.ope == accumulator.Operator.SUM) {
                this.atomD.addAndGet(val);
            } else if (this.ope == accumulator.Operator.PROD) {
                this.atomD.mulAndGet(val);
            } else if (this.ope == accumulator.Operator.MIN) {
                this.atomD.minAndGet(val);
            } else if (this.ope == accumulator.Operator.MAX) {
                this.atomD.maxAndGet(val);
            } else assert (false);
        }
    }

    public Number result() {
        if (!this.isAccessible) {
            this.checkOwnership(2);
        }
        return this.resultVal;
    }

    public void calculateAccum() {
        if (this.ope == accumulator.Operator.ANY) {
            this.resultVal = this.resultTmp;
            this.resultTmp = null;
        } else {
            if (this.isLazy) {
                throw new FinishAccumulatorException("Lazy polisy is not yet supported in work-sharing scheduler.");
            }
            if (this.type == Integer.class) {
                int val = this.resultVal.intValue();
                if (this.ope == accumulator.Operator.SUM) {
                    val += this.atomI.get();
                } else if (this.ope == accumulator.Operator.PROD) {
                    val *= this.atomI.get();
                } else if (this.ope == accumulator.Operator.MIN) {
                    int v = this.atomI.get();
                    if (v < val) {
                        val = v;
                    }
                } else if (this.ope == accumulator.Operator.MAX) {
                    int v = this.atomI.get();
                    if (v > val) {
                        val = v;
                    }
                } else assert (false);
                this.atomI.set(this.initVal.intValue());
                this.resultVal = new Integer(val);
            } else if (this.type == Double.class) {
                double val = this.resultVal.doubleValue();
                if (this.ope == accumulator.Operator.SUM) {
                    val += this.atomD.get();
                } else if (this.ope == accumulator.Operator.PROD) {
                    val *= this.atomD.get();
                } else if (this.ope == accumulator.Operator.MIN) {
                    double v = this.atomD.get();
                    if (v < val) {
                        val = v;
                    }
                } else if (this.ope == accumulator.Operator.MAX) {
                    double v = this.atomD.get();
                    if (v > val) {
                        val = v;
                    }
                } else assert (false);
                this.atomD.set(this.initVal.doubleValue());
                this.resultVal = new Double(val);
            } else assert (false);
        }
    }

    public Class getType() {
        return this.type;
    }

    public accumulator.Operator getOperator() {
        return this.ope;
    }

    private void checkOwnership(int messageId) {
        String message;
        switch (messageId) {
            case 0: {
                message = "Registration by non-parent task is not allowed.";
                break;
            }
            case 1: {
                message = "Send (put) by non-parent task is not allowed outside registered finish scope.";
                break;
            }
            case 2: {
                message = "Result (get) by non-parent task is not allowed outside registered finish scope.";
                break;
            }
            default: {
                message = "";
                assert (false);
                break;
            }
        }
        Activity task = (Activity)Runtime.getCurrentActivity();
        if (task != this.parentTask) {
            throw new FinishAccumulatorException(message);
        }
    }

    private int atomIntAddAndGet(AtomicInteger aI, int val) {
        int neo;
        int cur;
        if (val == 0) {
            return aI.get();
        }
        while (!aI.compareAndSet(cur = aI.get(), neo = cur + val)) {
        }
        return neo;
    }

    private int atomIntMulAndGet(AtomicInteger aI, int val) {
        int neo;
        int cur;
        if (val == 1) {
            return aI.get();
        }
        while (!aI.compareAndSet(cur = aI.get(), neo = cur * val)) {
        }
        return neo;
    }

    private int atomIntMinAndGet(AtomicInteger aI, int val) {
        int cur;
        do {
            if (val < (cur = aI.get())) continue;
            return cur;
        } while (!aI.compareAndSet(cur, val));
        return val;
    }

    private int atomIntMaxAndGet(AtomicInteger aI, int val) {
        int cur;
        do {
            if (val > (cur = aI.get())) continue;
            return cur;
        } while (!aI.compareAndSet(cur, val));
        return val;
    }

    public void send(Object obj) {
        throw new FinishAccumulatorException("Not yet supported.");
    }

    public void send(int[] arr) {
        throw new FinishAccumulatorException("Not yet supported.");
    }

    public void send(double[] arr) {
        throw new FinishAccumulatorException("Not yet supported.");
    }

    public void send(Object[] arr) {
        throw new FinishAccumulatorException("Not yet supported.");
    }

    public Number result(int offset) {
        throw new FinishAccumulatorException("Not yet supported.");
    }

    public int intResult() {
        throw new FinishAccumulatorException("Not yet supported.");
    }

    public int intResult(int offset) {
        throw new FinishAccumulatorException("Not yet supported.");
    }

    public double doubleResult() {
        throw new FinishAccumulatorException("Not yet supported.");
    }

    public double doubleResult(int offset) {
        throw new FinishAccumulatorException("Not yet supported.");
    }

    public Object objResult() {
        throw new FinishAccumulatorException("Not yet supported.");
    }

    public Object objResult(int offset) {
        throw new FinishAccumulatorException("Not yet supported.");
    }

    public int[] intResultArr() {
        throw new FinishAccumulatorException("Not yet supported.");
    }

    public int[] intResultArr(int offset) {
        throw new FinishAccumulatorException("Not yet supported.");
    }

    public double[] doubleResultArr() {
        throw new FinishAccumulatorException("Not yet supported.");
    }

    public double[] doubleResultArr(int offset) {
        throw new FinishAccumulatorException("Not yet supported.");
    }

    public Object[] objResultArr() {
        throw new FinishAccumulatorException("Not yet supported.");
    }

    public Object[] objResultArr(int offset) {
        throw new FinishAccumulatorException("Not yet supported.");
    }

    public int getRound() {
        throw new FinishAccumulatorException("Not yet supported.");
    }

    public int getArrsize() {
        throw new FinishAccumulatorException("Not yet supported.");
    }

    public void send(Number val, int workerId) {
        throw new FinishAccumulatorException("Not supported send method in work-sharing scheduler.");
    }

    public void send(int val, int workerId) {
        throw new FinishAccumulatorException("Not supported send method in work-sharing scheduler.");
    }

    public void send(double val, int workerId) {
        throw new FinishAccumulatorException("Not supported send method in work-sharing scheduler.");
    }
}

