/*
 * Decompiled with CFR 0.152.
 */
package hj.runtime.wsh.ovd;

import hj.lang.Runtime;
import hj.runtime.wsh.Activity;
import hj.runtime.wsh.ActivityRunner;
import hj.runtime.wsh.TwoLevelLockPlace;
import hj.runtime.wsh.ovd.HjOVDException;
import hj.runtime.wsh.ovd.OVDInfo;
import hj.util.ConcurrentHashMap;
import hj.util.Epoc;

public class WshOVDManager {
    private static ConcurrentHashMap stateTable = new ConcurrentHashMap();
    private static final Object SHARED_READONLY = new Object();

    public static void checkRead(Object obj, int idx) {
        WshOVDManager.internalCheckRead(obj, idx);
    }

    public static void checkWrite(Object obj) {
        WshOVDManager.internalCheckWrite(obj);
    }

    public static void checkRead(ActivityRunner worker, Object obj, int idx) {
        WshOVDManager.internalCheckRead(worker, obj, idx);
    }

    public static void checkWrite(ActivityRunner worker, Object obj, int idx) {
        WshOVDManager.internalCheckWrite(worker, obj, idx);
    }

    protected static void internalCheckRead(Object obj) {
        WshOVDManager.internalCheckRead(Runtime.getCurrentWorker(), obj);
    }

    protected static void internalCheckRead(ActivityRunner ar, Object obj) {
        WshOVDManager.checkRead(ar, obj);
    }

    protected static void internalCheckRead(int objID) {
        WshOVDManager.internalCheckRead(Runtime.getCurrentWorker(), objID);
    }

    protected static void internalCheckRead(ActivityRunner ar, int objID) {
        WshOVDManager.checkRead(ar, objID);
    }

    protected static void internalCheckWrite(Object obj) {
        WshOVDManager.internalCheckWrite(Runtime.getCurrentWorker(), obj);
    }

    protected static void internalCheckWrite(ActivityRunner ar, Object obj) {
        WshOVDManager.checkWrite(ar, obj);
    }

    protected static void internalCheckWrite(int objID) {
        WshOVDManager.internalCheckWrite(Runtime.getCurrentWorker(), objID);
    }

    protected static void internalCheckWrite(ActivityRunner ar, int objID) {
        WshOVDManager.checkWrite(ar, objID);
    }

    protected static void internalCheckWrite(Object obj, int idx) {
        int objID = obj.hashCode() << 32 ^ idx;
        WshOVDManager.internalCheckWrite(Runtime.getCurrentWorker(), objID);
    }

    protected static void internalCheckWrite(ActivityRunner ar, Object obj, int idx) {
        int objID = obj.hashCode() << 32 ^ idx;
        WshOVDManager.internalCheckWrite(ar, objID);
    }

    public static void checkRead(Object obj) {
        WshOVDManager.checkRead(Runtime.getCurrentWorker(), obj);
    }

    protected static void internalCheckRead(Object obj, int idx) {
        int objID = obj.hashCode() << 32 ^ idx;
        WshOVDManager.internalCheckRead(Runtime.getCurrentWorker(), objID);
    }

    protected static void internalCheckRead(ActivityRunner ar, Object obj, int idx) {
        int objID = obj.hashCode() << 32 ^ idx;
        WshOVDManager.internalCheckRead(ar, objID);
    }

    public static void checkRead(ActivityRunner ar, Object obj) {
        Epoc epoc = ar.getEpoc();
        Activity activity2 = ar.getActivity();
        if (ar != null) {
            Object updated = null;
            do {
                Object o;
                if ((o = stateTable.getObj(obj, epoc)) == null) {
                    updated = stateTable.putObj(obj, ar, activity2, activity2.getOVDInfo().getAct_Clock(), false, TwoLevelLockPlace.inLock(ar), null);
                    continue;
                }
                Object origState = epoc.value;
                if (origState != SHARED_READONLY) {
                    boolean hb;
                    if (epoc.isWrite) {
                        if (epoc.value == ar) {
                            return;
                        }
                        hb = WshOVDManager.isHappenBefore(epoc.activity, epoc.act_clock, activity2);
                        if (hb) {
                            return;
                        }
                        if (epoc.inLock && TwoLevelLockPlace.inLock(ar)) {
                            return;
                        }
                        System.out.println("Read After Write Violation in obj ");
                        throw new HjOVDException("Read After Write Violation in obj");
                    }
                    if (epoc.value == ar) {
                        epoc.inLock = epoc.inLock && TwoLevelLockPlace.inLock(ar);
                    } else {
                        hb = WshOVDManager.isHappenBefore(epoc.activity, epoc.act_clock, activity2);
                        if (hb) {
                            epoc.inLock = epoc.inLock && TwoLevelLockPlace.inLock(ar);
                        } else {
                            epoc.value = SHARED_READONLY;
                        }
                    }
                }
                updated = stateTable.putObj(obj, epoc.value, epoc.activity, epoc.act_clock, epoc.isWrite, epoc.inLock, origState);
            } while (updated == null);
        }
    }

    public static void checkRead(ActivityRunner ar, int objID) {
        Epoc epoc = ar.getEpoc();
        Activity activity2 = ar.getActivity();
        if (ar != null) {
            Boolean updated = null;
            do {
                Object o;
                if ((o = stateTable.getInt(objID, epoc)) == null) {
                    updated = stateTable.putInt(objID, ar, activity2, activity2.getOVDInfo().getAct_Clock(), false, TwoLevelLockPlace.inLock(ar), null);
                    continue;
                }
                Object origState = epoc.value;
                if (origState != SHARED_READONLY) {
                    boolean hb;
                    if (epoc.isWrite) {
                        if (epoc.value == ar) {
                            return;
                        }
                        hb = WshOVDManager.isHappenBefore(epoc.activity, epoc.act_clock, activity2);
                        if (hb) {
                            return;
                        }
                        if (epoc.inLock && TwoLevelLockPlace.inLock(ar)) {
                            return;
                        }
                        System.out.println("Read After Write Violation in array");
                        throw new HjOVDException("Read After Write Violation in array");
                    }
                    if (epoc.value == ar) {
                        epoc.inLock = epoc.inLock && TwoLevelLockPlace.inLock(ar);
                    } else {
                        hb = WshOVDManager.isHappenBefore(epoc.activity, epoc.act_clock, activity2);
                        if (hb) {
                            epoc.inLock = epoc.inLock && TwoLevelLockPlace.inLock(ar);
                        } else {
                            epoc.value = SHARED_READONLY;
                        }
                    }
                }
                updated = stateTable.putInt(objID, epoc.value, epoc.activity, epoc.act_clock, epoc.isWrite, epoc.inLock, origState);
            } while (updated == null);
        }
    }

    public static void checkWrite(Object obj, int idx) {
        WshOVDManager.checkWrite(Runtime.getCurrentWorker(), obj);
    }

    /*
     * Enabled aggressive block sorting
     */
    public static void checkWrite(ActivityRunner ar, Object obj) {
        block17: {
            Epoc epoc = ar.getEpoc();
            Activity activity2 = ar.getActivity();
            if (ar == null) break block17;
            Object updated = null;
            do {
                Object origState;
                block16: {
                    boolean hb;
                    block18: {
                        Object o;
                        if ((o = stateTable.getObj(obj, epoc)) == null) {
                            updated = stateTable.putObj(obj, ar, activity2, activity2.getOVDInfo().getAct_Clock(), true, TwoLevelLockPlace.inLock(ar), null);
                            continue;
                        }
                        origState = epoc.value;
                        if (epoc.value == SHARED_READONLY) {
                            System.out.println("Write After Read Violation in obj");
                            throw new HjOVDException("Write After Read Violation in obj");
                        }
                        if (!epoc.isWrite) break block18;
                        if (epoc.value == ar) {
                            if (epoc.activity == activity2 && epoc.act_clock == activity2.getOVDInfo().getAct_Clock()) {
                                epoc.act_clock = activity2.getOVDInfo().getAct_Clock();
                                epoc.inLock = epoc.inLock && TwoLevelLockPlace.inLock(ar);
                                break block16;
                            } else {
                                epoc.activity = activity2;
                                epoc.act_clock = activity2.getOVDInfo().getAct_Clock();
                                epoc.inLock = TwoLevelLockPlace.inLock(ar);
                            }
                            break block16;
                        } else {
                            hb = WshOVDManager.isHappenBefore(epoc.activity, epoc.act_clock, activity2);
                            if (hb) {
                                epoc.value = ar;
                                epoc.activity = activity2;
                                epoc.act_clock = activity2.getOVDInfo().getAct_Clock();
                                epoc.inLock = epoc.inLock && TwoLevelLockPlace.inLock(ar);
                                break block16;
                            } else {
                                if (epoc.inLock && TwoLevelLockPlace.inLock(ar)) {
                                    return;
                                }
                                System.out.println("Write After Write Violation in obj");
                                throw new HjOVDException("Write After Write Violation in obj");
                            }
                        }
                    }
                    if (epoc.value == ar) {
                        epoc.activity = activity2;
                        epoc.act_clock = activity2.getOVDInfo().getAct_Clock();
                        epoc.isWrite = true;
                        epoc.inLock = epoc.inLock && TwoLevelLockPlace.inLock(ar);
                    } else {
                        hb = WshOVDManager.isHappenBefore(epoc.activity, epoc.act_clock, activity2);
                        if (hb) {
                            epoc.activity = activity2;
                            epoc.act_clock = activity2.getOVDInfo().getAct_Clock();
                            epoc.isWrite = true;
                            epoc.inLock = epoc.inLock && TwoLevelLockPlace.inLock(ar);
                        } else if (epoc.inLock && TwoLevelLockPlace.inLock(ar)) {
                            epoc.activity = activity2;
                            epoc.act_clock = activity2.getOVDInfo().getAct_Clock();
                            epoc.isWrite = true;
                            epoc.inLock = epoc.inLock && TwoLevelLockPlace.inLock(ar);
                        } else {
                            System.out.println("Write After Read Violation in obj");
                            throw new HjOVDException("Write After Read Violation in obj");
                        }
                    }
                }
                updated = stateTable.putObj(obj, epoc.value, epoc.activity, epoc.act_clock, epoc.isWrite, epoc.inLock, origState);
            } while (updated == null);
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    public static void checkWrite(ActivityRunner ar, int objID) {
        block15: {
            Epoc epoc = ar.getEpoc();
            Activity activity2 = ar.getActivity();
            if (ar == null) break block15;
            Boolean updated = null;
            do {
                Object origState;
                block14: {
                    boolean hb;
                    block16: {
                        Object o;
                        if ((o = stateTable.getInt(objID, epoc)) == null) {
                            updated = stateTable.putInt(objID, ar, activity2, activity2.getOVDInfo().getAct_Clock(), true, TwoLevelLockPlace.inLock(ar), null);
                            continue;
                        }
                        origState = epoc.value;
                        if (epoc.value == SHARED_READONLY) {
                            System.out.println("Write After Read Violation in array");
                            throw new HjOVDException("Write After Read Violation in array");
                        }
                        if (!epoc.isWrite) break block16;
                        if (epoc.value == ar) {
                            epoc.act_clock = activity2.getOVDInfo().getAct_Clock();
                            epoc.inLock = epoc.inLock && TwoLevelLockPlace.inLock(ar);
                            break block14;
                        } else {
                            hb = WshOVDManager.isHappenBefore(epoc.activity, epoc.act_clock, activity2);
                            if (hb) {
                                epoc.value = ar;
                                epoc.activity = activity2;
                                epoc.act_clock = activity2.getOVDInfo().getAct_Clock();
                                epoc.inLock = epoc.inLock && TwoLevelLockPlace.inLock(ar);
                                break block14;
                            } else {
                                if (epoc.inLock && TwoLevelLockPlace.inLock(ar)) {
                                    return;
                                }
                                System.out.println("Write After Write Violation in array");
                                throw new HjOVDException("Write After Write Violation in array");
                            }
                        }
                    }
                    if (epoc.value == ar) {
                        epoc.activity = activity2;
                        epoc.act_clock = activity2.getOVDInfo().getAct_Clock();
                        epoc.isWrite = true;
                        epoc.inLock = epoc.inLock && TwoLevelLockPlace.inLock(ar);
                    } else {
                        hb = WshOVDManager.isHappenBefore(epoc.activity, epoc.act_clock, activity2);
                        if (hb) {
                            epoc.activity = activity2;
                            epoc.act_clock = activity2.getOVDInfo().getAct_Clock();
                            epoc.isWrite = true;
                            epoc.inLock = epoc.inLock && TwoLevelLockPlace.inLock(ar);
                        } else if (epoc.inLock && TwoLevelLockPlace.inLock(ar)) {
                            epoc.activity = activity2;
                            epoc.act_clock = activity2.getOVDInfo().getAct_Clock();
                            epoc.isWrite = true;
                            epoc.inLock = epoc.inLock && TwoLevelLockPlace.inLock(ar);
                        } else {
                            System.out.println("Write After Read Violation rw in array");
                            throw new HjOVDException("Write After Read Violation rw in array");
                        }
                    }
                }
                updated = stateTable.putInt(objID, epoc.value, epoc.activity, epoc.act_clock, epoc.isWrite, epoc.inLock, origState);
            } while (updated == null);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected static boolean isHappenBefore(Activity oldAct, int oldAct_Clock, Activity curAct) {
        int curSL;
        if (oldAct == null) {
            return false;
        }
        int oldSL = oldAct.getOVDInfo().getSpawnLevel();
        if (oldSL < (curSL = curAct.getOVDInfo().getSpawnLevel())) {
            while (oldSL < curSL - 1) {
                curAct = curAct.getOVDInfo().getParentActivity();
                curSL = curAct.getOVDInfo().getSpawnLevel();
            }
            Activity curParent = curAct.getOVDInfo().getParentActivity();
            if (oldAct != curParent) return WshOVDManager.checkHappenBefore(oldAct, curParent);
            if (oldAct_Clock > curAct.getOVDInfo().getParentAct_Clock()) return false;
            return true;
        }
        if (oldSL <= curSL) return WshOVDManager.checkHappenBefore(oldAct, curAct);
        while (curSL < oldSL - 1) {
            oldAct = oldAct.getOVDInfo().getParentActivity();
            oldSL = oldAct.getOVDInfo().getSpawnLevel();
        }
        Activity oldParent = oldAct.getOVDInfo().getParentActivity();
        if (oldParent != curAct) return WshOVDManager.checkHappenBefore(oldParent, curAct);
        if (curAct.hasFinishState(oldAct.getFinishState())) return false;
        return true;
    }

    protected static boolean checkHappenBefore(Activity oldAct, Activity curAct) {
        Activity oldParent = oldAct;
        Activity curParent = curAct;
        OVDInfo oldParentInfo = oldParent.getOVDInfo();
        OVDInfo curParentInfo = curParent.getOVDInfo();
        do {
            oldAct = oldParent;
            curAct = curParent;
        } while ((oldParent = oldParentInfo.getParentActivity()) != (curParent = curParentInfo.getParentActivity()) && oldParent != null && curParent != null);
        if (oldParent == null || curParent == null) {
            return false;
        }
        if (oldParentInfo.getParentAct_Clock() < curParentInfo.getParentAct_Clock()) {
            return !oldParent.hasFinishState(oldAct.getFinishState());
        }
        return false;
    }
}

