/*
 * Decompiled with CFR 0.152.
 */
package hj.runtime.wsh.phaser;

import hj.lang.PhaserAbst;
import hj.lang.PhaserException;
import hj.lang.Runtime;
import hj.lang.accumulator;
import hj.lang.phaserMode;
import hj.lang.phaserRegMode;
import hj.runtime.common.Configuration;
import hj.runtime.wsh.Activity;
import hj.runtime.wsh.PoolRunner;
import hj.runtime.wsh.VMInterface;
import hj.runtime.wsh.WshRuntime_c;
import hj.runtime.wsh.abstractmetrics.AbstractMetrics;
import hj.runtime.wsh.phaser.SubPhaser;
import hj.runtime.wsh.phaser.SyncVar1;
import hj.runtime.wsh.phaser.SyncVar2;
import hj.runtime.wsh.phaser.accumulator.Accumulator;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;

public class PhaserImpl
extends PhaserAbst {
    private static final AtomicInteger nextId_ = new AtomicInteger(-1);
    private final int id_;
    private final String name_;
    private static final Mode defaultMode = Mode.SIG_WAIT_SINGLE;
    private final int busyWaitCount;
    private static final int busyWaitCountInit = 100000;
    private static final int busyWaitCountForDropInit = 1000000;
    private volatile int mSigPhase = 0;
    private volatile int mSigPhase2 = -1;
    private volatile int mWaitPhase = 0;
    private volatile int mWaitPhase2 = -1;
    private int minSigP = 0;
    private int minWaitP = 0;
    private int mSigCycle = 0;
    private int mWaitCycle = 0;
    private final AtomicInteger sCastID = new AtomicInteger(0);
    private final AtomicInteger wCastID = new AtomicInteger(0);
    private Mode masterMode;
    private final AtomicInteger masterID = new AtomicInteger(0);
    public String loc_of_master;
    private final Activity parent;
    private final ArrayList syncVars1 = new ArrayList();
    private final Object lockForSyncVars1 = new Object();
    private final ArrayList syncVars2 = new ArrayList();
    private final Object lockForSyncVars2 = new Object();
    private final AtomicInteger swCounter = new AtomicInteger(0);
    private final AtomicInteger snglCounter = new AtomicInteger(0);
    private final Object lockForLastDrop = new Object();
    private ArrayList accums = null;
    private final Object lockForAccums = new Object();
    private boolean onlyBoundedANY = true;
    private final int bound;
    private final int upperBound;
    public final Cycle cycle;
    public final int batchSize;
    public final int numTiers;
    public final int numDegree;
    public final SubPhaser[][] subPhaser;
    private final int numLeave;
    private final ArrayList nonAnchoredVars1;
    private final Object lockForNonAnchoredVars1;
    private long gblCP;
    private long gblTime;
    private long gblOvhd;
    private long critPathOps = 0L;
    private long overheads = 0L;
    private long curIdealTime = 0L;

    public static Mode PhaserModeToImplMode(phaserMode m) {
        switch (m) {
            case SIG: {
                return Mode.SIG;
            }
            case WAIT: {
                return Mode.WAIT;
            }
            case SIG_WAIT: {
                return Mode.SIG_WAIT;
            }
            case SIG_WAIT_SINGLE: {
                return Mode.SIG_WAIT_SINGLE;
            }
        }
        throw new RuntimeException("Unhandled phaser mode " + (Object)((Object)m));
    }

    public PhaserImpl() {
        this("", defaultMode, 100000, 0, Cycle.CYCLIC, 0);
    }

    public PhaserImpl(Mode mode) {
        this("", mode, 100000, 0, Cycle.CYCLIC, 0);
    }

    public PhaserImpl(Mode mode, int bound, Cycle cycle, int batchSize) {
        this("", mode, 100000, bound, cycle, batchSize);
    }

    public PhaserImpl(String name, Mode mode, int busyWaitCount) {
        this(name, mode, busyWaitCount, 0, Cycle.CYCLIC, 0);
    }

    public PhaserImpl(String name, Mode mode, int busyWaitCount, int bound, Cycle cycle, int batchSize) {
        this.name_ = name;
        this.id_ = nextId_.addAndGet(1);
        this.busyWaitCount = busyWaitCount;
        if (mode == Mode.TRANSMIT) {
            throw new PhaserException("TRANSMIT mode isn't permitted.");
        }
        Activity a = (Activity)Runtime.getCurrentActivity();
        a.addPhaser(new phaserRegMode(this, mode));
        this.parent = a;
        a.registerPhaserToIEF(this);
        if (mode != Mode.WAIT) {
            SyncVar1 s1 = new SyncVar1(0, 0, mode, batchSize > 0);
            a.putSyncVar1(this, s1);
            this.syncVars1.add(s1);
        }
        if (mode != Mode.SIG) {
            SyncVar2 s2 = new SyncVar2(0, 0, 0, mode);
            a.putSyncVar2(this, s2);
            this.syncVars2.add(s2);
            if (mode == Mode.SIG_WAIT) {
                this.swCounter.addAndGet(1);
            } else if (mode == Mode.SIG_WAIT_SINGLE) {
                this.snglCounter.addAndGet(1);
            }
            this.masterMode = mode;
        }
        if (bound < 0) {
            throw new PhaserException("Bounded size must be greater or equal to 0.");
        }
        this.bound = bound;
        int n = this.upperBound = bound > 0 ? bound * 3 + 1 : 0;
        if (batchSize < 0) {
            throw new PhaserException("Batch size must be greater or equal to 0.");
        }
        if (batchSize > 0 && bound == 0) {
            throw new PhaserException("When batch size > 0, bounded size must be greater than 0.");
        }
        this.cycle = cycle;
        this.batchSize = batchSize;
        if (cycle == Cycle.ACYCLIC) {
            if (!a.hasAcyclicPhaser) {
                a.hasAcyclicPhaser = true;
                a.childPhasers = new LinkedList<PhaserImpl>();
            }
            a.childPhasers.add(this);
            this.isAcyclic = true;
            this.isDetecting = true;
        } else {
            this.isAcyclic = false;
            this.isDetecting = false;
        }
        this.numTiers = -1;
        this.numDegree = -1;
        this.numLeave = -1;
        this.subPhaser = null;
        this.nonAnchoredVars1 = null;
        this.lockForNonAnchoredVars1 = null;
    }

    public PhaserImpl(Mode mode, int numTiers, int numDegree) {
        this("", mode, 100000, numTiers, numDegree);
    }

    public PhaserImpl(String name, Mode mode, int busyWaitCount, int numTiers, int numDegree) {
        this.name_ = name;
        this.id_ = nextId_.addAndGet(1);
        this.busyWaitCount = busyWaitCount;
        if (mode == Mode.TRANSMIT || mode == Mode.SIG || mode == Mode.WAIT) {
            throw new PhaserException("TRANSMIT/SIG/WAIT mode isn't permitted on tree-based phasers.");
        }
        if (numTiers < 2 || numDegree < 2) {
            throw new PhaserException("numTiers and numDegree must be > 1.");
        }
        this.numTiers = numTiers;
        this.numDegree = numDegree;
        this.subPhaser = new SubPhaser[numTiers][];
        int n = 1;
        for (int i = 0; i < numTiers; ++i) {
            this.subPhaser[i] = new SubPhaser[n];
            if (i == 0) {
                this.subPhaser[0][0] = null;
            } else {
                for (int j = 0; j < n; ++j) {
                    this.subPhaser[i][j] = new SubPhaser(i == numTiers - 1);
                }
            }
            if (i >= numTiers - 1) continue;
            n *= numDegree;
        }
        this.numLeave = n;
        Activity a = (Activity)Runtime.getCurrentActivity();
        a.addPhaser(new phaserRegMode(this, mode));
        this.parent = a;
        a.registerPhaserToIEF(this);
        SyncVar1 s1 = new SyncVar1(0, 0, mode, 0, true);
        a.putSyncVar1(this, s1);
        for (int i = numTiers - 1; i > 0; --i) {
            SubPhaser sub = this.subPhaser[i][0];
            sub.nChildren.addAndGet(1);
            sub.isDropped = false;
            if (!sub.isLeaf) continue;
            sub.syncVars1.add(s1);
        }
        SyncVar2 s2 = new SyncVar2(0, 0, 0, mode, 0);
        a.putSyncVar2(this, s2);
        this.syncVars2.add(s2);
        this.masterMode = mode;
        this.bound = 0;
        this.upperBound = 0;
        this.cycle = Cycle.CYCLIC;
        this.batchSize = 0;
        this.isAcyclic = false;
        this.isDetecting = false;
        this.nonAnchoredVars1 = new ArrayList();
        this.lockForNonAnchoredVars1 = new Object();
    }

    public void register(Activity a) {
        this.register(a, defaultMode);
    }

    public void register(Activity a, Mode mode) {
        if (this.subPhaser == null) {
            this.register0(a, mode);
        } else {
            this.registerTree(a, mode);
        }
    }

    public void register0(Activity a, Mode mode) {
        Mode authMode;
        boolean availWait;
        Activity authorizer = (Activity)Runtime.getCurrentActivity();
        if (this.cycle == Cycle.ACYCLIC && authorizer == this.parent && (mode == Mode.SIG_WAIT || mode == Mode.SIG_WAIT_SINGLE) && this.isAcyclic) {
            this.isAcyclic = false;
            this.isDetecting = false;
        }
        SyncVar1 authSync1 = authorizer.getSyncVar1(this);
        SyncVar2 authSync2 = authorizer.getSyncVar2(this);
        boolean availSignal = authSync1 != null && !authSync1.isDropped;
        boolean bl = availWait = authSync2 != null && !authSync2.isDropped;
        if (!availSignal && !availWait) {
            throw new PhaserException("TRANSMIT mode isn't permitted.");
        }
        Mode mode2 = authMode = availSignal ? authSync1.mode : authSync2.mode;
        if (mode != Mode.WAIT && !availSignal || mode != Mode.SIG && !availWait || mode == Mode.SIG_WAIT_SINGLE && authMode != Mode.SIG_WAIT_SINGLE) {
            throw new PhaserException("Capability model violation: Parent mode = " + (Object)((Object)authMode) + ", child mode = " + (Object)((Object)mode) + ".");
        }
        if (this.quiescent(authorizer)) {
            throw new PhaserException(authorizer + "is not active on " + this + "; cannot transmit.");
        }
        if (mode != Mode.WAIT) {
            this.register1(a, authSync1.sigPhase, authSync1.sigCycle, mode);
        }
        if (mode != Mode.SIG) {
            this.register2(a, authSync2.waitPhase, authSync2.waitCycle, authSync2.mID, mode);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void register1(Activity a, int sigPhase, int sigCycle, Mode mode) {
        if (a.getSyncVar1(this) != null) {
            throw new PhaserException("Multiple registration on a phaser.");
        }
        SyncVar1 s1 = new SyncVar1(sigPhase, sigCycle, mode, this.batchSize > 0);
        a.putSyncVar1(this, s1);
        Object object = this.lockForSyncVars1;
        synchronized (object) {
            this.syncVars1.add(s1);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void register2(Activity a, int waitPhase, int waitCycle, int mID, Mode mode) {
        if (a.getSyncVar2(this) != null) {
            throw new PhaserException("Multiple registration on a phaser.");
        }
        SyncVar2 s2 = new SyncVar2(waitPhase, waitCycle, mID, mode);
        a.putSyncVar2(this, s2);
        Object object = this.lockForSyncVars2;
        synchronized (object) {
            this.syncVars2.add(s2);
        }
        if (mode == Mode.SIG_WAIT) {
            this.swCounter.addAndGet(1);
        } else if (mode == Mode.SIG_WAIT_SINGLE) {
            this.snglCounter.addAndGet(1);
        }
    }

    private void activateSubPhaser(int idx, int tier, int mWaitPhase, int sigPhase, int mID) {
        SubPhaser sub = this.subPhaser[tier][idx];
        if (sub.nChildren.addAndGet(1) == 1) {
            while (!sub.isDropped) {
            }
            if (tier > 1) {
                this.activateSubPhaser(idx / this.numDegree, tier - 1, mWaitPhase, sigPhase, mID);
            }
            if (sub.sigPhase < sigPhase) {
                sub.masterID.set(mID);
                sub.mWaitPhase = mWaitPhase;
                sub.sigPhase = sigPhase;
            }
            sub.isDropped = false;
        } else {
            while (sub.isDropped) {
            }
        }
    }

    private int activateSubPhasers(int parentLeafSubIdx, int mWaitPhase, int sigPhase, int mID) {
        int myIdx = parentLeafSubIdx;
        int min = Integer.MAX_VALUE;
        int idx = parentLeafSubIdx;
        for (int i = 0; i < this.numLeave; ++i) {
            int nChildren = this.subPhaser[this.numTiers - 1][idx].nChildren.get();
            if (nChildren < this.numDegree) {
                myIdx = idx;
                break;
            }
            if (nChildren < min) {
                min = nChildren;
                myIdx = idx;
            }
            idx = idx == this.numLeave - 1 ? 0 : idx + 1;
        }
        this.activateSubPhaser(myIdx, this.numTiers - 1, mWaitPhase, sigPhase, mID);
        return myIdx;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerTree(Activity a, Mode mode) {
        Activity authorizer = (Activity)Runtime.getCurrentActivity();
        SyncVar1 authSync1 = authorizer.getSyncVar1(this);
        SyncVar2 authSync2 = authorizer.getSyncVar2(this);
        if (this.masterMode != mode) {
            throw new PhaserException("Current restriction on tree: Mode must be same for all.");
        }
        if (a.getSyncVar1(this) != null || a.getSyncVar2(this) != null) {
            throw new PhaserException("Multiple registration on a phaser.");
        }
        int leafSubIdx = this.activateSubPhasers(authSync1.leafSubIdx, authSync2.waitPhase, authSync1.sigPhase, authSync2.mID);
        boolean anchored = authSync1.anchored && leafSubIdx == authSync1.leafSubIdx;
        SyncVar1 s1 = new SyncVar1(authSync1.sigPhase, authSync1.sigCycle, mode, leafSubIdx, anchored);
        a.putSyncVar1(this, s1);
        Object object = this.lockForSyncVars1;
        synchronized (object) {
            this.subPhaser[this.numTiers - 1][leafSubIdx].syncVars1.add(s1);
        }
        if (!anchored) {
            object = this.lockForNonAnchoredVars1;
            synchronized (object) {
                this.nonAnchoredVars1.add(s1);
            }
        }
        SyncVar2 s2 = new SyncVar2(authSync2.waitPhase, authSync2.waitCycle, authSync2.mID, mode, leafSubIdx);
        a.putSyncVar2(this, s2);
        Object object2 = this.lockForSyncVars2;
        synchronized (object2) {
            this.syncVars2.add(s2);
        }
    }

    public phaserMode getPhaserMode() {
        Activity a = (Activity)Runtime.getCurrentActivity();
        Mode rm = this.getMode(a);
        if (rm == Mode.SIG) {
            return phaserMode.SIG;
        }
        if (rm == Mode.WAIT) {
            return phaserMode.WAIT;
        }
        if (rm == Mode.SIG_WAIT) {
            return phaserMode.SIG_WAIT;
        }
        if (rm == Mode.SIG_WAIT_SINGLE) {
            return phaserMode.SIG_WAIT_SINGLE;
        }
        if (rm == Mode.TRANSMIT) {
            throw new PhaserException("TRANSMIT mode isn't permitted.");
        }
        return phaserMode.SIG_WAIT_SINGLE;
    }

    public Mode getMode() {
        Activity a = (Activity)Runtime.getCurrentActivity();
        return this.getMode(a);
    }

    public Mode getMode(Activity a) {
        SyncVar1 s1 = a.getSyncVar1(this);
        if (s1 != null && !s1.isDropped) {
            return s1.mode;
        }
        SyncVar2 s2 = a.getSyncVar2(this);
        if (s2 == null || s2.isDropped) {
            throw new PhaserException("Dropped/non-registered activity cannot call getMode.");
        }
        return s2.mode;
    }

    public int getLeafSubIdx() {
        Activity a = (Activity)Runtime.getCurrentActivity();
        SyncVar1 s1 = a.getSyncVar1(this);
        if (s1 != null) {
            return s1.leafSubIdx;
        }
        return -1;
    }

    public int getNumChildrenOfSubPhaser(int idx) {
        if (this.subPhaser != null && 0 <= idx && idx < this.numLeave) {
            return this.subPhaser[this.numTiers - 1][idx].nChildren.get();
        }
        return 0;
    }

    public int getBound() {
        return this.bound;
    }

    public boolean registered() {
        Activity a = (Activity)Runtime.getCurrentActivity();
        SyncVar1 s1 = a.getSyncVar1(this);
        if (s1 != null && !s1.isDropped) {
            return true;
        }
        SyncVar2 s2 = a.getSyncVar2(this);
        return s2 != null && !s2.isDropped;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addAccum(Accumulator accum, accumulator.Operator ope) {
        if (this.onlyBoundedANY && (ope != accumulator.Operator.ANY || this.bound == 0)) {
            this.onlyBoundedANY = false;
        }
        Object object = this.lockForAccums;
        synchronized (object) {
            if (this.accums == null) {
                this.accums = new ArrayList();
            }
            this.accums.add(accum);
        }
    }

    public void drop() {
        this.drop((Activity)Runtime.getCurrentActivity());
    }

    public void drop(Activity a) {
        if (this.subPhaser == null) {
            this.drop0(a);
        } else {
            this.dropTree(a);
        }
    }

    public void drop0(Activity a) {
        this.drop1(a);
        this.drop2(a, true, -1);
        a.dropPhaser(this);
    }

    public void drop1(Activity a) {
        SyncVar1 s1 = a.getSyncVar1(this);
        if (s1 != null && !s1.isDropped) {
            if (this.isAcyclic && !s1.lastArrayMap.isEmpty()) {
                s1.sendArrayToAccum();
            }
            s1.isDropped = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Mode setMasterMode(SyncVar2 s2, AtomicInteger c) {
        Mode selected = Mode.TRANSMIT;
        if (c.addAndGet(-1) == 0) {
            Object object = this.lockForLastDrop;
            synchronized (object) {
                if (c.get() == 0 && s2.mode == this.masterMode) {
                    ArrayList lSyncVars2;
                    Object object2 = this.lockForSyncVars2;
                    synchronized (object2) {
                        lSyncVars2 = (ArrayList)this.syncVars2.clone();
                    }
                    int size = lSyncVars2.size();
                    for (int i = 0; i < size; ++i) {
                        SyncVar2 workS2 = (SyncVar2)lSyncVars2.get(i);
                        if (workS2 == s2 || workS2.isDropped || workS2.mode.compareTo(selected) <= 0 || workS2.mode.compareTo(s2.mode) >= 0) continue;
                        selected = workS2.mode;
                    }
                    if (selected.compareTo(Mode.TRANSMIT) > 0) {
                        this.masterMode = selected;
                    }
                    lSyncVars2 = null;
                }
            }
        }
        return selected;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean passedWithoutMasterCheck(SyncVar2 s2) {
        SyncVar2 workS2;
        int i;
        ArrayList lSyncVars2;
        Object object = this.lockForSyncVars2;
        synchronized (object) {
            lSyncVars2 = (ArrayList)this.syncVars2.clone();
        }
        int size = lSyncVars2.size();
        for (i = 0; i < size && ((workS2 = (SyncVar2)lSyncVars2.get(i)) == s2 || workS2.isDropped || workS2.mID != s2.mID + 1); ++i) {
        }
        lSyncVars2 = null;
        return i < size;
    }

    public boolean drop2(Activity a, boolean isFirstTime, int busyWaitCountForDrop) {
        SyncVar2 s2 = a.getSyncVar2(this);
        if (s2 != null && !s2.isDropped) {
            boolean isMaster = false;
            if (isFirstTime) {
                AtomicInteger c = null;
                if (s2.mode == Mode.SIG_WAIT) {
                    c = this.swCounter;
                } else if (s2.mode == Mode.SIG_WAIT_SINGLE) {
                    c = this.snglCounter;
                }
                Mode selected = c != null ? this.setMasterMode(s2, c) : Mode.TRANSMIT;
                isMaster = selected.compareTo(Mode.TRANSMIT) > 0 && this.passedWithoutMasterCheck(s2) && this.masterID.compareAndSet(s2.mID, s2.mID + 1);
            } else {
                isMaster = true;
            }
            if (isMaster) {
                if (busyWaitCountForDrop == -1) {
                    this.waitForWorkerSignals();
                } else {
                    boolean done = this.waitForWorkerSignals(busyWaitCountForDrop);
                    if (!done) {
                        return false;
                    }
                }
                if (!this.onlyBoundedANY) {
                    this.calculateAccums(a, 1, s2.mode);
                }
                ++this.mWaitPhase;
                if (this.bound > 0) {
                    this.mWaitCycle = this.mWaitCycle == this.upperBound ? 0 : this.mWaitCycle + 1;
                    boolean isFirst = this.wCastID.compareAndSet(this.mWaitPhase - 1, this.mWaitPhase);
                    this.mWaitPhase2 = this.mWaitPhase;
                    if (!isFirst) {
                        this.notifyAllWorkersOnS1(a.getSyncVar1(this));
                    }
                    if (this.mSigPhase >= this.minWaitP + this.bound) {
                        this.waitForWorkersInBound();
                    }
                }
                ++this.mSigPhase;
                if (this.bound > 0) {
                    this.mSigCycle = this.mSigCycle == this.upperBound ? 0 : this.mSigCycle + 1;
                }
                boolean isFirst = this.sCastID.compareAndSet(this.mSigPhase - 1, this.mSigPhase);
                this.mSigPhase2 = this.mSigPhase;
                if (!isFirst) {
                    this.notifyAllWorkersOnS2(s2);
                }
            }
            s2.isDropped = true;
        }
        return true;
    }

    private void dropSubPhaser(int leafSubIdx) {
        int idx = leafSubIdx;
        for (int i = this.numTiers - 1; i > 0; --i) {
            SubPhaser sub = this.subPhaser[i][idx];
            if (sub.nChildren.addAndGet(-1) != 0) break;
            if (!this.onlyBoundedANY) {
                this.calculateSubAccums(i, idx);
            }
            sub.isDropped = true;
            idx /= this.numDegree;
        }
    }

    public void dropTree(Activity a) {
        SyncVar1 s1 = a.getSyncVar1(this);
        SyncVar2 s2 = a.getSyncVar2(this);
        if (s1 != null && !s1.isDropped) {
            this.dropSubPhaser(s1.leafSubIdx);
            s1.isDropped = true;
        }
        if (s2 != null && !s2.isDropped) {
            s2.isDropped = true;
        }
        a.dropPhaser(this);
    }

    public static void dropAllPhasers(List phList, Activity a) {
        PhaserImpl[] phArray = phList.toArray(new PhaserImpl[0]);
        PhaserImpl.dropAllPhasers(phArray, a);
    }

    public static void dropAllPhasers(PhaserImpl[] phArray, Activity a) {
        boolean[] s2IsDropped = new boolean[phArray.length];
        PhaserImpl.dropAllPhasersTree(phArray, a, s2IsDropped);
        PhaserImpl.dropAllPhasers0(phArray, a, s2IsDropped);
    }

    public static void dropAllPhasers0(PhaserImpl[] phArray, Activity a, boolean[] s2IsDropped) {
        PhaserImpl ph;
        int i;
        for (int i2 = 0; i2 < phArray.length; ++i2) {
            PhaserImpl ph2 = phArray[i2];
            if (ph2.subPhaser != null) continue;
            ph2.drop1(a);
        }
        boolean isRemained = true;
        boolean isFirst = true;
        while (isRemained) {
            isRemained = false;
            for (i = 0; i < phArray.length; ++i) {
                ph = phArray[i];
                if (s2IsDropped[i]) continue;
                boolean isDropped = ph.drop2(a, isFirst, 1000000);
                if (isDropped) {
                    s2IsDropped[i] = true;
                    continue;
                }
                isRemained = true;
            }
            if (!isFirst) continue;
            isFirst = false;
        }
        for (i = 0; i < phArray.length; ++i) {
            ph = phArray[i];
            if (ph.subPhaser != null) continue;
            a.dropPhaser(ph);
        }
    }

    public static void dropAllPhasersTree(PhaserImpl[] phArray, Activity a, boolean[] s2IsDropped) {
        for (int i = 0; i < phArray.length; ++i) {
            PhaserImpl ph = phArray[i];
            if (ph.subPhaser == null) continue;
            ph.dropTree(a);
            s2IsDropped[i] = true;
        }
    }

    public boolean dropped() {
        return !this.registered();
    }

    public void resume() {
        Activity a = (Activity)Runtime.getCurrentActivity();
        this.resume(a, a.getSyncVar1(this), a.getSyncVar2(this));
    }

    public void resume(Activity a, SyncVar1 s1, SyncVar2 s2) {
        if (s1 == null || s2 == null) {
            Mode mode = this.getMode(a);
            throw new PhaserException("Activity in " + (Object)((Object)mode) + " cannot resume.");
        }
        if (s1.isDropped || s2.isDropped) {
            throw new PhaserException("Dropped activity cannot resume.");
        }
        this.signal(a, s1, s2);
    }

    public void signal() {
        Activity a = (Activity)Runtime.getCurrentActivity();
        this.signal(a, a.getSyncVar1(this), a.getSyncVar2(this));
    }

    public void signal(Activity a, SyncVar1 s1, SyncVar2 s2) {
        if (s1 == null) {
            return;
        }
        if (s2 != null && s1.isResumed) {
            return;
        }
        if (this.cycle == Cycle.ACYCLIC && a == this.parent && s1.mode != Mode.SIG && this.isAcyclic) {
            this.isAcyclic = false;
            this.isDetecting = false;
        }
        if (s1.isDropped) {
            throw new PhaserException("Dropped activity cannot signal.");
        }
        if (Configuration.ABSTRACT_EXECUTION_STATS) {
            this.metricsUpdateGlobal();
        }
        ++s1.sigPhase;
        s1.isResumed = true;
        if (this.bound > 0) {
            int n = s1.sigCycle = s1.sigCycle == this.upperBound ? 0 : s1.sigCycle + 1;
            if (s2 == null && s1.prevMWP + this.bound <= s1.sigPhase) {
                this.waitForMasterInBound(s1);
            }
        }
    }

    public void signalWithLastArray(accumulator acc, int[] array) {
        Activity a = (Activity)Runtime.getCurrentActivity();
        SyncVar1 s1 = a.getSyncVar1(this);
        SyncVar2 s2 = a.getSyncVar2(this);
        this.signal(a, s1, s2);
        if (s1 != null && acc != null && array != null) {
            s1.lastArrayMap.put(acc, array);
        }
    }

    public void signalWithLastArray(accumulator acc, double[] array) {
        Activity a = (Activity)Runtime.getCurrentActivity();
        SyncVar1 s1 = a.getSyncVar1(this);
        SyncVar2 s2 = a.getSyncVar2(this);
        this.signal(a, s1, s2);
        if (s1 != null && acc != null && array != null) {
            s1.lastArrayMap.put(acc, array);
        }
    }

    public void signalWithLastArray(accumulator acc, Object[] array) {
        Activity a = (Activity)Runtime.getCurrentActivity();
        SyncVar1 s1 = a.getSyncVar1(this);
        SyncVar2 s2 = a.getSyncVar2(this);
        this.signal(a, s1, s2);
        if (s1 != null && acc != null && array != null) {
            s1.lastArrayMap.put(acc, array);
        }
    }

    public void setLastArray(accumulator acc, int[] array) {
        Activity a = (Activity)Runtime.getCurrentActivity();
        SyncVar1 s1 = a.getSyncVar1(this);
        if (s1 != null && acc != null && array != null) {
            s1.lastArrayMap.put(acc, array);
        }
    }

    public void setLastArray(accumulator acc, double[] array) {
        Activity a = (Activity)Runtime.getCurrentActivity();
        SyncVar1 s1 = a.getSyncVar1(this);
        if (s1 != null && acc != null && array != null) {
            s1.lastArrayMap.put(acc, array);
        }
    }

    public void setLastArray(accumulator acc, Object[] array) {
        Activity a = (Activity)Runtime.getCurrentActivity();
        SyncVar1 s1 = a.getSyncVar1(this);
        if (s1 != null && acc != null && array != null) {
            s1.lastArrayMap.put(acc, array);
        }
    }

    public boolean quiescent() {
        Activity a = (Activity)Runtime.getCurrentActivity();
        return this.quiescent(a);
    }

    public boolean quiescent(Activity a) {
        SyncVar1 s1 = a.getSyncVar1(this);
        return s1 != null && !s1.isDropped && s1.isResumed && (s1.mode == Mode.SIG_WAIT || s1.mode == Mode.SIG_WAIT_SINGLE);
    }

    public void doNext() {
        Activity a = (Activity)Runtime.getCurrentActivity();
        this.doNext(a, a.getSyncVar1(this), a.getSyncVar2(this));
    }

    public void doNext(Activity a, SyncVar1 s1, SyncVar2 s2) {
        if (s1 == null || s2 == null) {
            Mode mode = this.getMode(a);
            throw new PhaserException("Activity in " + (Object)((Object)mode) + " cannot do next.");
        }
        if (s1.isDropped || s2.isDropped) {
            throw new PhaserException("Dropped activity cannot do next.");
        }
        this.doWait(a, s1, s2);
    }

    public void doWait() {
        Activity a = (Activity)Runtime.getCurrentActivity();
        this.doWait(a, a.getSyncVar1(this), a.getSyncVar2(this));
    }

    public void doWait(Activity a, SyncVar1 s1, SyncVar2 s2) {
        if (this.subPhaser == null) {
            this.doWait0(a, s1, s2);
        } else {
            this.doWaitTree(a, s1, s2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifyAllWorkersOnS1(SyncVar1 s1) {
        ArrayList lSyncVars1;
        Object object = this.lockForSyncVars1;
        synchronized (object) {
            lSyncVars1 = (ArrayList)this.syncVars1.clone();
        }
        int size = lSyncVars1.size();
        for (int i = 0; i < size; ++i) {
            SyncVar1 workS1 = (SyncVar1)lSyncVars1.get(i);
            if (workS1 == s1 || workS1.isDropped) continue;
            Object object2 = workS1.lockForSSync1;
            synchronized (object2) {
                workS1.lockForSSync1.notifyAll();
                continue;
            }
        }
        lSyncVars1 = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifyAllWorkersOnS2(SyncVar2 s2) {
        ArrayList lSyncVars2;
        Object object = this.lockForSyncVars2;
        synchronized (object) {
            lSyncVars2 = (ArrayList)this.syncVars2.clone();
        }
        int size = lSyncVars2.size();
        for (int i = 0; i < size; ++i) {
            SyncVar2 workS2 = (SyncVar2)lSyncVars2.get(i);
            if (workS2 == s2 || workS2.isDropped) continue;
            Object object2 = workS2.lockForSSync2;
            synchronized (object2) {
                workS2.lockForSSync2.notifyAll();
                continue;
            }
        }
        lSyncVars2 = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean waitForMasterNotifyOnS1(SyncVar1 s1) {
        Thread t = Thread.currentThread();
        ((PoolRunner)((Object)t)).getPlace().threadBlockedNotification();
        if (this.mWaitPhase + this.bound <= s1.sigPhase) {
            Object object = s1.lockForSSync1;
            synchronized (object) {
                if (this.mWaitPhase + this.bound <= s1.sigPhase) {
                    try {
                        s1.lockForSSync1.wait();
                    }
                    catch (InterruptedException ie) {
                        ((PoolRunner)((Object)t)).getPlace().threadUnblockedNotification();
                        throw new Error(ie);
                    }
                }
            }
        }
        ((PoolRunner)((Object)t)).getPlace().threadUnblockedNotification();
        return this.mWaitPhase + this.bound > s1.sigPhase;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean waitForMasterNotifyOnS2(SyncVar2 s2) {
        Thread t = Thread.currentThread();
        ((PoolRunner)((Object)t)).getPlace().threadBlockedNotification();
        if (this.mSigPhase <= s2.waitPhase) {
            Object object = s2.lockForSSync2;
            synchronized (object) {
                if (this.mSigPhase <= s2.waitPhase) {
                    try {
                        s2.lockForSSync2.wait();
                    }
                    catch (InterruptedException ie) {
                        ((PoolRunner)((Object)t)).getPlace().threadUnblockedNotification();
                        throw new Error(ie);
                    }
                }
            }
        }
        ((PoolRunner)((Object)t)).getPlace().threadUnblockedNotification();
        return this.mSigPhase > s2.waitPhase;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void waitForWorkerSignals() {
        int size = 0;
        int min = Integer.MAX_VALUE;
        while (true) {
            ArrayList lSyncVars1;
            Object object = this.lockForSyncVars1;
            synchronized (object) {
                int sz = this.syncVars1.size();
                if (sz == size) {
                    break;
                }
                lSyncVars1 = (ArrayList)this.syncVars1.clone();
                int first = size;
                size = sz;
            }
            Thread t = Thread.currentThread();
            ((PoolRunner)((Object)t)).getPlace().threadBlockedNotification();
            for (int i = first; i < size; ++i) {
                int s1SigP;
                SyncVar1 s1 = (SyncVar1)lSyncVars1.get(i);
                while (!s1.isDropped && s1.sigPhase <= this.mWaitPhase) {
                }
                if (s1.isDropped || (s1SigP = s1.sigPhase) >= min) continue;
                min = s1SigP;
            }
            ((PoolRunner)((Object)t)).getPlace().threadUnblockedNotification();
            lSyncVars1 = null;
        }
        this.minSigP = min;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean waitForWorkerSignals(int busyWaitCountForDrop) {
        assert (busyWaitCountForDrop > 0);
        int size = 0;
        int min = Integer.MAX_VALUE;
        while (true) {
            ArrayList lSyncVars1;
            Object object = this.lockForSyncVars1;
            synchronized (object) {
                int sz = this.syncVars1.size();
                if (sz == size) {
                    break;
                }
                lSyncVars1 = (ArrayList)this.syncVars1.clone();
                int first = size;
                size = sz;
            }
            Thread t = Thread.currentThread();
            ((PoolRunner)((Object)t)).getPlace().threadBlockedNotification();
            for (int i = first; i < size; ++i) {
                int s1SigP;
                int j;
                SyncVar1 s1 = (SyncVar1)lSyncVars1.get(i);
                for (j = 0; j < busyWaitCountForDrop && !s1.isDropped && s1.sigPhase <= this.mWaitPhase; ++j) {
                }
                if (j == busyWaitCountForDrop) {
                    ((PoolRunner)((Object)t)).getPlace().threadUnblockedNotification();
                    lSyncVars1 = null;
                    return false;
                }
                if (s1.isDropped || (s1SigP = s1.sigPhase) >= min) continue;
                min = s1SigP;
            }
            ((PoolRunner)((Object)t)).getPlace().threadUnblockedNotification();
            lSyncVars1 = null;
        }
        this.minSigP = min;
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void waitForWorkersInBound() {
        int size = 0;
        int min = Integer.MAX_VALUE;
        while (true) {
            ArrayList lSyncVars2;
            Object object = this.lockForSyncVars2;
            synchronized (object) {
                int sz = this.syncVars2.size();
                if (sz == size) {
                    break;
                }
                lSyncVars2 = (ArrayList)this.syncVars2.clone();
                int first = size;
                size = sz;
            }
            Thread t = Thread.currentThread();
            ((PoolRunner)((Object)t)).getPlace().threadBlockedNotification();
            for (int i = first; i < size; ++i) {
                int s2WaitP;
                SyncVar2 s2 = (SyncVar2)lSyncVars2.get(i);
                while (!s2.isDropped && s2.waitPhase + this.bound <= this.mSigPhase) {
                }
                if (s2.isDropped || (s2WaitP = s2.waitPhase) >= min) continue;
                min = s2WaitP;
            }
            ((PoolRunner)((Object)t)).getPlace().threadUnblockedNotification();
            lSyncVars2 = null;
        }
        this.minWaitP = min;
    }

    private void waitForMasterInBound(SyncVar1 s1) {
        boolean done = false;
        while (!done) {
            for (int j = 0; j < this.busyWaitCount; ++j) {
                if (this.mWaitPhase + this.bound <= s1.sigPhase) continue;
                done = true;
                s1.prevMWP = this.mWaitPhase;
                break;
            }
            if (done) continue;
            this.wCastID.compareAndSet(s1.sigPhase - this.bound, s1.sigPhase - this.bound + 1);
            if (!this.waitForMasterNotifyOnS1(s1)) continue;
            done = true;
            s1.prevMWP = this.mWaitPhase;
        }
        while (this.mWaitPhase > this.mWaitPhase2) {
        }
    }

    private void waitForMasterSignal(SyncVar2 s2) {
        boolean done = false;
        while (!done) {
            for (int j = 0; j < this.busyWaitCount; ++j) {
                if (this.mSigPhase <= s2.waitPhase) continue;
                done = true;
                s2.prevMSP = this.mSigPhase;
                break;
            }
            if (done) continue;
            this.sCastID.compareAndSet(s2.waitPhase, s2.waitPhase + 1);
            if (!this.waitForMasterNotifyOnS2(s2)) continue;
            done = true;
            s2.prevMSP = this.mSigPhase;
        }
        while (this.mSigPhase > this.mSigPhase2) {
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void calculateAccums(Activity a, int delta, Mode mode) {
        Accumulator acc;
        Iterator it;
        if (this.bound == 0 && mode == Mode.WAIT) {
            throw new PhaserException("Accumulator: SIG-ONLY/WAIT-ONLY needs bounded phaser.");
        }
        Object object = this.lockForAccums;
        synchronized (object) {
            it = this.accums.iterator();
        }
        if (this.bound == 0 || delta == 1) {
            while (it.hasNext()) {
                acc = (Accumulator)it.next();
                acc.calculateAccum(this.isAcyclic, this.mWaitPhase, this.mWaitCycle, this.mSigCycle);
            }
        } else {
            while (it.hasNext()) {
                acc = (Accumulator)it.next();
                acc.calculateAccumMulti(this.isAcyclic, this.mWaitPhase, this.mWaitCycle, this.mSigCycle, delta, this.upperBound);
            }
        }
    }

    public void doWait0(Activity a, SyncVar1 s1, SyncVar2 s2) {
        if (s2 == null) {
            return;
        }
        if (s2.isDropped) {
            throw new PhaserException("Dropped activity cannot wait.");
        }
        if (s1 != null && !s1.isResumed) {
            throw new PhaserException("Signal is necessary before wait.");
        }
        if (this.cycle == Cycle.ACYCLIC && a == this.parent && s2.mode != Mode.WAIT && this.isAcyclic) {
            this.isAcyclic = false;
            this.isDetecting = false;
        }
        ++s2.mID;
        boolean bl = s2.isMaster = s2.prevMSP <= s2.waitPhase && this.mSigPhase <= s2.waitPhase && s2.mode == this.masterMode && this.masterID.compareAndSet(s2.mID - 1, s2.mID);
        if (s2.mode == Mode.SIG_WAIT_SINGLE) {
            s2.loc = null;
        }
        if (s1 != null) {
            s1.isResumed = false;
        }
        if (s2.isMaster) {
            if (s1 != null) {
                boolean isFirst;
                this.waitForWorkerSignals();
                if (!this.onlyBoundedANY) {
                    this.calculateAccums(a, 1, s2.mode);
                }
                ++this.mWaitPhase;
                if (this.bound > 0) {
                    this.mWaitCycle = this.mWaitCycle == this.upperBound ? 0 : this.mWaitCycle + 1;
                    isFirst = this.wCastID.compareAndSet(this.mWaitPhase - 1, this.mWaitPhase);
                    this.mWaitPhase2 = this.mWaitPhase;
                    if (!isFirst) {
                        this.notifyAllWorkersOnS1(s1);
                    }
                    if (this.mSigPhase >= this.minWaitP + this.bound) {
                        this.waitForWorkersInBound();
                    }
                }
                if (Configuration.ABSTRACT_EXECUTION_STATS) {
                    this.metricsGetGlobal();
                }
                if (s2.mode == Mode.SIG_WAIT_SINGLE) {
                    this.loc_of_master = s2.loc;
                }
                ++this.mSigPhase;
                if (this.bound > 0) {
                    this.mSigCycle = this.mSigCycle == this.upperBound ? 0 : this.mSigCycle + 1;
                }
                isFirst = this.sCastID.compareAndSet(this.mSigPhase - 1, this.mSigPhase);
                s2.prevMSP = this.mSigPhase;
                this.mSigPhase2 = this.mSigPhase;
                if (!isFirst) {
                    this.notifyAllWorkersOnS2(s2);
                }
            } else {
                boolean isFirst;
                int delta;
                this.waitForWorkerSignals();
                int t = Integer.MAX_VALUE;
                if (this.bound > 0) {
                    this.waitForWorkersInBound();
                    t = this.minWaitP + this.bound;
                }
                int n = delta = this.minSigP < t ? this.minSigP - this.mWaitPhase : t - this.mWaitPhase;
                if (!this.onlyBoundedANY) {
                    this.calculateAccums(a, delta, s2.mode);
                }
                if (delta > 1) {
                    boolean flg = this.masterID.compareAndSet(s2.mID, s2.mID + delta - 1);
                    assert (flg);
                }
                this.mWaitPhase += delta;
                if (this.bound > 0) {
                    int t2 = this.mWaitCycle + delta;
                    this.mWaitCycle = t2 > this.upperBound ? t2 - this.upperBound - 1 : t2;
                    boolean isFirst2 = this.wCastID.compareAndSet(this.mWaitPhase - delta, this.mWaitPhase);
                    if (!isFirst2 && delta > 1) {
                        boolean flg = this.wCastID.compareAndSet(this.mWaitPhase - delta + 1, this.mWaitPhase);
                        assert (flg);
                    }
                    this.mWaitPhase2 = this.mWaitPhase;
                    if (!isFirst2) {
                        this.notifyAllWorkersOnS1(s1);
                    }
                }
                if (Configuration.ABSTRACT_EXECUTION_STATS) {
                    this.metricsGetGlobal();
                }
                this.mSigPhase += delta;
                if (this.bound > 0) {
                    int t3 = this.mSigCycle + delta;
                    int n2 = this.mSigCycle = t3 > this.upperBound ? t3 - this.upperBound - 1 : t3;
                }
                if (!(isFirst = this.sCastID.compareAndSet(this.mSigPhase - delta, this.mSigPhase)) && delta > 1) {
                    boolean flg = this.sCastID.compareAndSet(this.mSigPhase - delta + 1, this.mSigPhase);
                    assert (flg);
                }
                s2.prevMSP = this.mSigPhase;
                this.mSigPhase2 = this.mSigPhase;
                if (!isFirst) {
                    this.notifyAllWorkersOnS2(s2);
                }
            }
        } else {
            if (s1 != null || s2.prevMSP <= s2.waitPhase) {
                this.waitForMasterSignal(s2);
            }
            if (s2.mode == Mode.SIG_WAIT_SINGLE && this.loc_of_master != null) {
                throw new PhaserException("Location of single statement doesn't match.");
            }
        }
        ++s2.waitPhase;
        if (this.bound > 0) {
            int n = s2.waitCycle = s2.waitCycle == this.upperBound ? 0 : s2.waitCycle + 1;
        }
        if (Configuration.ABSTRACT_EXECUTION_STATS) {
            this.metricsUpdateLocal();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean handleSyncForSubMasters(SyncVar2 s2) {
        int idx = s2.leafSubIdx;
        int mID = s2.mID;
        for (int i = this.numTiers - 1; i > 0; --i) {
            SubPhaser sub = this.subPhaser[i][idx];
            if (sub.masterID.compareAndSet(mID - 1, mID)) {
                block14: {
                    if (i == this.numTiers - 1) {
                        int size = 0;
                        while (true) {
                            ArrayList lSyncVars1;
                            Object object = sub.lockForSyncVars1;
                            synchronized (object) {
                                int sz = sub.syncVars1.size();
                                if (sz == size) {
                                    break block14;
                                }
                                lSyncVars1 = (ArrayList)sub.syncVars1.clone();
                                int first = size;
                                size = sz;
                            }
                            Thread t = Thread.currentThread();
                            ((PoolRunner)((Object)t)).getPlace().threadBlockedNotification();
                            for (int j = first; j < size; ++j) {
                                SyncVar1 s1 = (SyncVar1)lSyncVars1.get(j);
                                if (!s1.anchored) continue;
                                while (!s1.isDropped && s1.sigPhase <= sub.mWaitPhase) {
                                }
                            }
                            ((PoolRunner)((Object)t)).getPlace().threadUnblockedNotification();
                            lSyncVars1 = null;
                        }
                    }
                    Thread t = Thread.currentThread();
                    ((PoolRunner)((Object)t)).getPlace().threadBlockedNotification();
                    for (int j = idx * this.numDegree; j < (idx + 1) * this.numDegree; ++j) {
                        SubPhaser child = this.subPhaser[i + 1][j];
                        while (!child.isDropped && child.sigPhase <= sub.mWaitPhase) {
                        }
                    }
                    ((PoolRunner)((Object)t)).getPlace().threadUnblockedNotification();
                }
                ++sub.mWaitPhase;
                if (!this.onlyBoundedANY) {
                    this.calculateSubAccums(i, idx);
                }
                ++sub.sigPhase;
            } else {
                return false;
            }
            idx /= this.numDegree;
        }
        return this.masterID.compareAndSet(mID - 1, mID);
    }

    private void waitFor1stTierSubPhasers() {
        Thread t = Thread.currentThread();
        ((PoolRunner)((Object)t)).getPlace().threadBlockedNotification();
        for (int j = 0; j < this.numDegree; ++j) {
            SubPhaser child = this.subPhaser[1][j];
            while (!child.isDropped && child.sigPhase <= this.mWaitPhase) {
            }
        }
        ((PoolRunner)((Object)t)).getPlace().threadUnblockedNotification();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void calculateSubAccums(int i, int idx) {
        Iterator it;
        Object object = this.lockForAccums;
        synchronized (object) {
            it = this.accums.iterator();
        }
        while (it.hasNext()) {
            Accumulator acc = (Accumulator)it.next();
            acc.calculateSubAccum(i, idx);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void waitForNonAnchoredVars(boolean allAnchored) {
        int size = 0;
        while (true) {
            ArrayList lNonAnchoredVars1;
            Object object = this.lockForNonAnchoredVars1;
            synchronized (object) {
                int sz = this.nonAnchoredVars1.size();
                if (sz == size) {
                    break;
                }
                lNonAnchoredVars1 = (ArrayList)this.nonAnchoredVars1.clone();
                int first = size;
                size = sz;
            }
            Thread t = Thread.currentThread();
            ((PoolRunner)((Object)t)).getPlace().threadBlockedNotification();
            for (int j = first; j < size; ++j) {
                SyncVar1 s1 = (SyncVar1)lNonAnchoredVars1.get(j);
                if (allAnchored) {
                    while (!s1.isDropped && !s1.anchored) {
                    }
                    continue;
                }
                while (!s1.isDropped && s1.sigPhase <= this.mWaitPhase) {
                }
            }
            ((PoolRunner)((Object)t)).getPlace().threadUnblockedNotification();
            lNonAnchoredVars1 = null;
        }
        if (allAnchored) {
            this.nonAnchoredVars1.clear();
        }
    }

    public void doWaitTree(Activity a, SyncVar1 s1, SyncVar2 s2) {
        if (s2 == null || s2.mode != this.masterMode) assert (false);
        if (s2.isDropped) {
            throw new PhaserException("Dropped activity cannot wait.");
        }
        if (s1 != null && !s1.isResumed) {
            throw new PhaserException("Signal is necessary before wait.");
        }
        ++s2.mID;
        s2.isMaster = this.handleSyncForSubMasters(s2);
        if (s2.mode == Mode.SIG_WAIT_SINGLE) {
            s2.loc = null;
        }
        if (s1 != null) {
            s1.isResumed = false;
        }
        if (s2.isMaster) {
            this.waitFor1stTierSubPhasers();
            this.waitForNonAnchoredVars(false);
            if (!this.onlyBoundedANY) {
                this.calculateAccums(a, 1, s2.mode);
            }
            ++this.mWaitPhase;
            if (Configuration.ABSTRACT_EXECUTION_STATS) {
                this.metricsGetGlobal();
            }
            if (s2.mode == Mode.SIG_WAIT_SINGLE) {
                this.loc_of_master = s2.loc;
            }
            if (!s1.anchored) {
                s1.anchored = true;
            }
            this.waitForNonAnchoredVars(true);
            ++this.mSigPhase;
            boolean isFirst = this.sCastID.compareAndSet(this.mSigPhase - 1, this.mSigPhase);
            this.mSigPhase2 = this.mSigPhase;
            if (!isFirst) {
                this.notifyAllWorkersOnS2(s2);
            }
        } else {
            if (!s1.anchored) {
                s1.anchored = true;
            }
            this.waitForMasterSignal(s2);
            if (s2.mode == Mode.SIG_WAIT_SINGLE && this.loc_of_master != null) {
                throw new PhaserException("Location of single statement doesn't match.");
            }
        }
        ++s2.waitPhase;
        if (Configuration.ABSTRACT_EXECUTION_STATS) {
            this.metricsUpdateLocal();
        }
    }

    public boolean doWaitSingle1() {
        Activity a = (Activity)Runtime.getCurrentActivity();
        return this.doWaitSingle1(a, a.getSyncVar1(this), a.getSyncVar2(this), "foo");
    }

    public boolean doWaitSingle1(String loc) {
        Activity a = (Activity)Runtime.getCurrentActivity();
        return this.doWaitSingle1(a, a.getSyncVar1(this), a.getSyncVar2(this), loc);
    }

    public boolean doWaitSingle1(Activity a, SyncVar1 s1, SyncVar2 s2, String loc) {
        if (this.subPhaser == null) {
            return this.doWaitSingle1_0(a, s1, s2, loc);
        }
        return this.doWaitSingle1Tree(a, s1, s2, loc);
    }

    public boolean doWaitSingle1_0(Activity a, SyncVar1 s1, SyncVar2 s2, String loc) {
        if (s1 == null || s1.mode != Mode.SIG_WAIT_SINGLE || s2 == null || s2.mode != Mode.SIG_WAIT_SINGLE) {
            Mode mode = this.getMode(a);
            throw new PhaserException("Single statement isn't permitted for activity in " + (Object)((Object)mode) + ".");
        }
        if (s1.isDropped || s2.isDropped) {
            throw new PhaserException("Dropped activity cannot wait.");
        }
        if (!s1.isResumed) {
            throw new PhaserException("Signal is necessary before wait.");
        }
        if (this.cycle == Cycle.ACYCLIC && a == this.parent && this.isAcyclic) {
            this.isAcyclic = false;
            this.isDetecting = false;
        }
        ++s2.mID;
        s2.isMaster = this.mSigPhase <= s2.waitPhase && s2.mode == this.masterMode && this.masterID.compareAndSet(s2.mID - 1, s2.mID);
        s2.loc = loc;
        if (s1 != null) {
            s1.isResumed = false;
        }
        if (s2.isMaster) {
            this.waitForWorkerSignals();
            if (!this.onlyBoundedANY) {
                this.calculateAccums(a, 1, s2.mode);
            }
            ++this.mWaitPhase;
            if (this.bound > 0) {
                this.mWaitCycle = this.mWaitCycle == this.upperBound ? 0 : this.mWaitCycle + 1;
                boolean isFirst = this.wCastID.compareAndSet(this.mWaitPhase - 1, this.mWaitPhase);
                this.mWaitPhase2 = this.mWaitPhase;
                if (!isFirst) {
                    this.notifyAllWorkersOnS1(s1);
                }
                if (this.mSigPhase >= this.minWaitP + this.bound) {
                    this.waitForWorkersInBound();
                }
            }
            if (Configuration.ABSTRACT_EXECUTION_STATS) {
                this.metricsGetGlobal();
                this.metricsUpdateLocal();
            }
        }
        return s2.isMaster;
    }

    public boolean doWaitSingle1Tree(Activity a, SyncVar1 s1, SyncVar2 s2, String loc) {
        if (s2 == null || s2.mode != this.masterMode || s2.mode != Mode.SIG_WAIT_SINGLE) assert (false);
        if (s1.isDropped || s2.isDropped) {
            throw new PhaserException("Dropped activity cannot wait.");
        }
        if (!s1.isResumed) {
            throw new PhaserException("Signal is necessary before wait.");
        }
        ++s2.mID;
        s2.isMaster = this.handleSyncForSubMasters(s2);
        s2.loc = loc;
        if (s1 != null) {
            s1.isResumed = false;
        }
        if (s2.isMaster) {
            this.waitFor1stTierSubPhasers();
            this.waitForNonAnchoredVars(false);
            if (!this.onlyBoundedANY) {
                this.calculateAccums(a, 1, s2.mode);
            }
            ++this.mWaitPhase;
            if (Configuration.ABSTRACT_EXECUTION_STATS) {
                this.metricsGetGlobal();
                this.metricsUpdateLocal();
            }
        }
        return s2.isMaster;
    }

    public void doWaitSingle2() {
        Activity a = (Activity)Runtime.getCurrentActivity();
        this.doWaitSingle2(a, a.getSyncVar2(this));
    }

    public void doWaitSingle2(Activity a, SyncVar2 s2) {
        if (s2 == null || s2.mode != Mode.SIG_WAIT_SINGLE) {
            Mode mode = this.getMode(a);
            throw new PhaserException("Single statement isn't permitted for activity in " + (Object)((Object)mode) + ".");
        }
        if (s2.isDropped) {
            throw new PhaserException("Dropped activity cannot wait.");
        }
        if (s2.isMaster) {
            if (Configuration.ABSTRACT_EXECUTION_STATS) {
                this.metricsUpdateGlobal();
                this.metricsGetGlobal();
            }
            this.loc_of_master = s2.loc;
            if (this.subPhaser != null) {
                SyncVar1 s1 = a.getSyncVar1(this);
                if (!s1.anchored) {
                    s1.anchored = true;
                }
                this.waitForNonAnchoredVars(true);
            }
            ++this.mSigPhase;
            if (this.bound > 0) {
                this.mSigCycle = this.mSigCycle == this.upperBound ? 0 : this.mSigCycle + 1;
            }
            boolean isFirst = this.sCastID.compareAndSet(this.mSigPhase - 1, this.mSigPhase);
            this.mSigPhase2 = this.mSigPhase;
            if (!isFirst) {
                this.notifyAllWorkersOnS2(s2);
            }
        } else {
            if (this.subPhaser != null) {
                SyncVar1 s1 = a.getSyncVar1(this);
                if (!s1.anchored) {
                    s1.anchored = true;
                }
            }
            this.waitForMasterSignal(s2);
            if (!s2.loc.equals(this.loc_of_master)) {
                throw new PhaserException("Location of single statement doesn't match.");
            }
        }
        ++s2.waitPhase;
        if (this.bound > 0) {
            int n = s2.waitCycle = s2.waitCycle == this.upperBound ? 0 : s2.waitCycle + 1;
        }
        if (Configuration.ABSTRACT_EXECUTION_STATS) {
            this.metricsUpdateLocal();
        }
    }

    public int getSigPhase() {
        Activity a = (Activity)Runtime.getCurrentActivity();
        return this.getSigPhase(a);
    }

    public int getSigPhase(Activity a) {
        SyncVar1 s1 = a.getSyncVar1(this);
        SyncVar2 s2 = a.getSyncVar2(this);
        if (this.mSigPhase != this.mWaitPhase && s2 != null && !s2.isDropped && s2.isMaster) {
            return this.mSigPhase;
        }
        if (s1 == null || s1.isDropped) {
            return Integer.MAX_VALUE;
        }
        return s1.sigPhase;
    }

    public int getWaitPhase() {
        Activity a = (Activity)Runtime.getCurrentActivity();
        return this.getWaitPhase(a);
    }

    public int getWaitPhase(Activity a) {
        SyncVar2 s2 = a.getSyncVar2(this);
        if (s2 == null || s2.isDropped) {
            return 0;
        }
        if (this.mSigPhase != this.mWaitPhase && s2.isMaster) {
            return this.mWaitPhase;
        }
        return s2.waitPhase;
    }

    public int getSigCycle() {
        Activity a = (Activity)Runtime.getCurrentActivity();
        return this.getSigCycle(a);
    }

    public int getSigCycle(Activity a) {
        SyncVar1 s1 = a.getSyncVar1(this);
        SyncVar2 s2 = a.getSyncVar2(this);
        if (this.bound == 0) {
            return 0;
        }
        if (this.mSigPhase != this.mWaitPhase && s2 != null && !s2.isDropped && s2.isMaster) {
            return this.mSigCycle;
        }
        if (s1 == null || s1.isDropped) {
            return 0;
        }
        return s1.sigCycle;
    }

    public int getWaitCycle() {
        Activity a = (Activity)Runtime.getCurrentActivity();
        return this.getWaitCycle(a);
    }

    public int getWaitCycle(Activity a) {
        SyncVar2 s2 = a.getSyncVar2(this);
        if (this.bound == 0 || s2 == null || s2.isDropped) {
            return 0;
        }
        if (this.mSigPhase != this.mWaitPhase && s2.isMaster) {
            return this.mWaitCycle;
        }
        return s2.waitCycle;
    }

    public boolean masterInSingle(Activity a) {
        SyncVar2 s2 = a.getSyncVar2(this);
        return this.masterInSingle(s2);
    }

    public boolean masterInSingle(SyncVar2 s2) {
        return s2 != null && !s2.isDropped && this.mSigPhase != this.mWaitPhase && s2.isMaster;
    }

    public String toString() {
        return "Phaser" + this.id_ + this.name_ + ")";
    }

    synchronized boolean tryMoveToSplit_() {
        assert (false);
        return true;
    }

    private void metricsUpdateGlobal() {
        this.maxCritPathOps(((AbstractMetrics)((Object)WshRuntime_c.getCurrentActivity())).getCritPathOps());
        this.maxOverheads(((AbstractMetrics)((Object)WshRuntime_c.getCurrentActivity())).getOverheads());
        if (VMInterface.ABSTRACT_EXECUTION_TIMES) {
            ((AbstractMetrics)((Object)WshRuntime_c.getCurrentActivity())).updateIdealTime();
            this.maxIdealTime(((AbstractMetrics)((Object)WshRuntime_c.getCurrentActivity())).getCritPathTime());
        }
    }

    private void metricsGetGlobal() {
        this.gblCP = this.getCritPathOps();
        this.gblOvhd = this.getOverheads();
        if (VMInterface.ABSTRACT_EXECUTION_TIMES) {
            this.gblTime = this.getIdealTime();
        }
    }

    private void metricsUpdateLocal() {
        ((Activity)WshRuntime_c.getCurrentActivity()).maxCritPathOps(this.gblCP);
        ((Activity)WshRuntime_c.getCurrentActivity()).maxOverheads(this.gblOvhd);
        if (VMInterface.ABSTRACT_EXECUTION_TIMES) {
            ((Activity)WshRuntime_c.getCurrentActivity()).maxCritPathTime(this.gblTime);
            ((Activity)WshRuntime_c.getCurrentActivity()).setResumeTime();
        }
    }

    public synchronized void maxCritPathOps(long n) {
        this.critPathOps = Math.max(this.critPathOps, n);
    }

    public long getCritPathOps() {
        return this.critPathOps;
    }

    public synchronized void maxOverheads(long n) {
        this.overheads = Math.max(this.overheads, n);
    }

    public long getOverheads() {
        return this.overheads;
    }

    public synchronized void maxIdealTime(long t) {
        this.curIdealTime = Math.max(this.curIdealTime, t);
    }

    public long getIdealTime() {
        return this.curIdealTime;
    }

    public static interface AdvanceListener {
        public void notifyAdvance();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Cycle {
        CYCLIC,
        ACYCLIC;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Mode {
        TRANSMIT,
        SIG,
        WAIT,
        SIG_WAIT,
        SIG_WAIT_SINGLE;

    }
}

