/*
 * Decompiled with CFR 0.152.
 */
package hj.runtime.wsh.phaser;

import hj.lang.Runtime;
import hj.lang.phaserRegMode;
import hj.runtime.wsh.Activity;
import hj.runtime.wsh.Report;
import hj.runtime.wsh.phaser.PhaserImpl;
import hj.runtime.wsh.phaser.PhaserManager;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PhaserManagerImpl
implements PhaserManager {
    protected Activity activity;
    private phaserRegMode singlePhaserRegMode;
    private List<phaserRegMode> phaserRegModeList;

    public PhaserManagerImpl(Activity activity2) {
        this.activity = activity2;
    }

    public PhaserManagerImpl(Activity activity2, List<phaserRegMode> phaserRegModes) {
        this(activity2);
        if (Report.should_report("activity", 3)) {
            Report.report(3, "adding phaserRegModes " + phaserRegModes + " to " + activity2);
        }
        this.phaserRegModeList = phaserRegModes;
    }

    public PhaserManagerImpl(Activity activity2, phaserRegMode pr) {
        this(activity2);
        if (Report.should_report("activity", 3)) {
            Report.report(3, "adding phaserRegMode " + pr + " to " + activity2);
        }
        this.singlePhaserRegMode = pr;
    }

    private void switchFromSingleToListStrategy() {
        this.phaserRegModeList = new LinkedList<phaserRegMode>();
        this.phaserRegModeList.add(this.singlePhaserRegMode);
        this.singlePhaserRegMode = null;
    }

    @Override
    public List<phaserRegMode> clonePhasers() {
        LinkedList<phaserRegMode> l = new LinkedList<phaserRegMode>();
        Activity current = (Activity)Runtime.getCurrentActivity();
        for (phaserRegMode o : this.phaserRegModeList) {
            phaserRegMode pr = current.checkPhaserUse(o);
            phaserRegMode ppr = new phaserRegMode((PhaserImpl)pr.getPhaser(), pr.getMode());
            l.add(ppr);
        }
        return l;
    }

    @Override
    public void addPhaser(phaserRegMode pr) {
        if (Report.should_report("Phaser", 3)) {
            Report.report(3, "" + this.activity + " adds " + pr + ".");
        }
        if (this.singlePhaserRegMode != null) {
            this.switchFromSingleToListStrategy();
        }
        this.phaserRegModeList.add(pr);
    }

    @Override
    public void dropPhaser(PhaserImpl ph) {
        if (Report.should_report("Phaser", 3)) {
            Report.report(3, "" + this.activity + " drops " + ph + ".");
        }
        if (this.singlePhaserRegMode != null) {
            PhaserImpl singlePh = (PhaserImpl)this.singlePhaserRegMode.getPhaser();
            if (singlePh.equals(ph)) {
                this.singlePhaserRegMode = null;
            } else if (Report.should_report("Phaser", 3)) {
                Report.report(3, "" + this.activity + " dropPhaser attempt failed because phaser to drop is not known by the activity " + ph + ".");
            }
        } else {
            phaserRegMode pr = null;
            for (phaserRegMode tpr : this.phaserRegModeList) {
                PhaserImpl ph2 = (PhaserImpl)tpr.getPhaser();
                if (!ph2.equals(ph)) continue;
                pr = tpr;
                break;
            }
            if (pr != null) {
                this.phaserRegModeList.remove(pr);
            }
        }
    }

    @Override
    public void dropAllPhasers() {
        if (this.singlePhaserRegMode != null) {
            PhaserImpl singlePh = (PhaserImpl)this.singlePhaserRegMode.getPhaser();
            singlePh.drop(this.activity);
            this.singlePhaserRegMode = null;
        } else {
            int i = 0;
            PhaserImpl[] arr = new PhaserImpl[this.phaserRegModeList.size()];
            for (phaserRegMode pr : this.phaserRegModeList) {
                arr[i] = (PhaserImpl)pr.getPhaser();
                ++i;
            }
            PhaserImpl.dropAllPhasers(arr, this.activity);
            arr = null;
            this.phaserRegModeList = null;
        }
        if (Report.should_report("Phaser", 3)) {
            Report.report(3, "" + this.activity + " drops all phasers.");
        }
    }

    @Override
    public void doSignal() {
        if (this.singlePhaserRegMode != null) {
            PhaserImpl.Mode mode;
            PhaserImpl singlePh = (PhaserImpl)this.singlePhaserRegMode.getPhaser();
            if (Report.should_report("activity", 3)) {
                Report.report(3, "" + this.activity + ".signal() on " + singlePh);
            }
            if ((mode = this.singlePhaserRegMode.getMode()) == PhaserImpl.Mode.SIG || (mode == PhaserImpl.Mode.SIG_WAIT || mode == PhaserImpl.Mode.SIG_WAIT_SINGLE) && !singlePh.quiescent()) {
                singlePh.signal();
            }
        } else {
            if (Report.should_report("activity", 3)) {
                Report.report(3, "" + this.activity + ".signal() on " + this.phaserRegModeList);
            }
            for (phaserRegMode pr : this.phaserRegModeList) {
                PhaserImpl ph = (PhaserImpl)pr.getPhaser();
                PhaserImpl.Mode mode = pr.getMode();
                if (mode != PhaserImpl.Mode.SIG && (mode != PhaserImpl.Mode.SIG_WAIT && mode != PhaserImpl.Mode.SIG_WAIT_SINGLE || ph.quiescent())) continue;
                ph.signal();
            }
        }
    }

    @Override
    public void doWait() {
        if (this.singlePhaserRegMode != null) {
            PhaserImpl.Mode mode;
            PhaserImpl singlePh = (PhaserImpl)this.singlePhaserRegMode.getPhaser();
            if (Report.should_report("activity", 3)) {
                Report.report(3, "" + this.activity + ".doWait() on " + singlePh);
            }
            if ((mode = this.singlePhaserRegMode.getMode()) == PhaserImpl.Mode.WAIT || (mode == PhaserImpl.Mode.SIG_WAIT || mode == PhaserImpl.Mode.SIG_WAIT_SINGLE) && singlePh.quiescent()) {
                singlePh.doWait();
            }
        } else {
            if (Report.should_report("activity", 3)) {
                Report.report(3, "" + this.activity + ".doWait() on " + this.phaserRegModeList);
            }
            for (phaserRegMode pr : this.phaserRegModeList) {
                PhaserImpl ph = (PhaserImpl)pr.getPhaser();
                PhaserImpl.Mode mode = pr.getMode();
                if (mode != PhaserImpl.Mode.WAIT && (mode != PhaserImpl.Mode.SIG_WAIT && mode != PhaserImpl.Mode.SIG_WAIT_SINGLE || !ph.quiescent())) continue;
                ph.doWait();
            }
        }
    }

    @Override
    public void doNext() {
        if (this.singlePhaserRegMode != null) {
            PhaserImpl.Mode mode;
            PhaserImpl singlePh = (PhaserImpl)this.singlePhaserRegMode.getPhaser();
            if (Report.should_report("activity", 3)) {
                Report.report(3, "" + this.activity + ".doNext() on " + singlePh);
            }
            if ((mode = this.singlePhaserRegMode.getMode()) == PhaserImpl.Mode.SIG || (mode == PhaserImpl.Mode.SIG_WAIT || mode == PhaserImpl.Mode.SIG_WAIT_SINGLE) && !singlePh.quiescent()) {
                singlePh.signal();
            }
            if (mode != PhaserImpl.Mode.SIG) {
                singlePh.doWait();
            }
        } else {
            if (Report.should_report("activity", 3)) {
                Report.report(3, "" + this.activity + ".doNext() on " + this.phaserRegModeList);
            }
            for (phaserRegMode pr : this.phaserRegModeList) {
                PhaserImpl ph = (PhaserImpl)pr.getPhaser();
                PhaserImpl.Mode mode = pr.getMode();
                if (mode != PhaserImpl.Mode.SIG && (mode != PhaserImpl.Mode.SIG_WAIT && mode != PhaserImpl.Mode.SIG_WAIT_SINGLE || ph.quiescent())) continue;
                ph.signal();
            }
            for (phaserRegMode pr : this.phaserRegModeList) {
                PhaserImpl ph = (PhaserImpl)pr.getPhaser();
                PhaserImpl.Mode mode = pr.getMode();
                if (mode == PhaserImpl.Mode.SIG) continue;
                ph.doWait();
            }
        }
    }

    @Override
    public int doNext1(String loc) {
        int ret = 0;
        if (this.singlePhaserRegMode != null) {
            PhaserImpl singlePh = (PhaserImpl)this.singlePhaserRegMode.getPhaser();
            if (Report.should_report("activity", 3)) {
                Report.report(3, "" + this.activity + ".doNext1() on " + singlePh);
            }
            if (!singlePh.quiescent()) {
                singlePh.signal();
            }
            if (singlePh.doWaitSingle1(loc)) {
                ++ret;
            }
        } else {
            if (Report.should_report("activity", 3)) {
                Report.report(3, "" + this.activity + ".doNext1() on " + this.phaserRegModeList);
            }
            for (phaserRegMode pr : this.phaserRegModeList) {
                PhaserImpl ph = (PhaserImpl)pr.getPhaser();
                if (ph.quiescent()) continue;
                ph.signal();
            }
            for (phaserRegMode pr : this.phaserRegModeList) {
                PhaserImpl ph = (PhaserImpl)pr.getPhaser();
                if (!ph.doWaitSingle1(loc)) continue;
                ++ret;
            }
        }
        return ret;
    }

    @Override
    public void doNext2() {
        if (this.singlePhaserRegMode != null) {
            PhaserImpl singlePh = (PhaserImpl)this.singlePhaserRegMode.getPhaser();
            if (Report.should_report("activity", 3)) {
                Report.report(3, "" + this.activity + ".doNext2() on " + singlePh);
            }
            singlePh.doWaitSingle2();
        } else {
            if (Report.should_report("activity", 3)) {
                Report.report(3, "" + this.activity + ".doNext2() on " + this.phaserRegModeList);
            }
            for (phaserRegMode pr : this.phaserRegModeList) {
                PhaserImpl ph = (PhaserImpl)pr.getPhaser();
                ph.doWaitSingle2();
            }
        }
    }

    @Override
    public void registerPhasers() {
        if (this.singlePhaserRegMode != null) {
            this.registerPhaser(this.singlePhaserRegMode);
        } else {
            for (phaserRegMode pr : this.phaserRegModeList) {
                this.registerPhaser(pr);
            }
        }
    }

    private void registerPhaser(phaserRegMode pr) {
        PhaserImpl ph = (PhaserImpl)pr.getPhaser();
        PhaserImpl.Mode mode = pr.getMode();
        ph.register(this.activity, mode);
    }

    @Override
    public PhaserImpl checkPhaserUse(PhaserImpl ph) {
        assert (false);
        return null;
    }

    @Override
    public int getNbRegisteredPhasers() {
        if (this.singlePhaserRegMode != null) {
            return 1;
        }
        if (this.phaserRegModeList != null) {
            return this.phaserRegModeList.size();
        }
        return 0;
    }

    @Override
    public List<phaserRegMode> getPhaserRegModeList() {
        if (this.singlePhaserRegMode != null) {
            ArrayList<phaserRegMode> l = new ArrayList<phaserRegMode>();
            l.add(this.singlePhaserRegMode);
            return l;
        }
        return this.phaserRegModeList;
    }
}

