/*
 * Decompiled with CFR 0.152.
 */
package hj.runtime.wsh.phaser.accumulator;

import hj.lang.PhaserException;
import hj.lang.Runtime;
import hj.lang.accumulator;
import hj.lang.phaser;
import hj.runtime.wsh.Activity;
import hj.runtime.wsh.phaser.PhaserImpl;
import hj.runtime.wsh.phaser.SyncVar1;
import hj.runtime.wsh.phaser.accumulator.AccumCell;
import hj.runtime.wsh.phaser.accumulator.AccumCellD;
import hj.runtime.wsh.phaser.accumulator.AccumCellI;
import hj.runtime.wsh.phaser.accumulator.AtomicDouble;
import hj.runtime.wsh.phaser.accumulator.SubAccum;
import java.util.ArrayList;
import java.util.Random;
import java.util.concurrent.atomic.AtomicInteger;

public class Accumulator
extends accumulator {
    private final accumulator.Operator ope;
    private final Class type;
    private final phaser ph;
    private final PhaserImpl phi;
    public final Number initVal;
    public final boolean isLazy;
    public final int arrsize;
    public final DataKind dataKind;
    private final int buffsize;
    private Number resultVal;
    private Number resultTmp;
    private Object resultObj;
    private Object resultObjTmp;
    private int[] intResultArray;
    private int[] intResultArrTmp;
    private double[] doubleResultArray;
    private double[] doubleResultArrTmp;
    private Object[] objectResultArray;
    private Object[] objectResultArrTmp;
    private final Number[] resultBuff;
    private final Object[] resultObjBuff;
    private final int[][] intResultArrBuff;
    private final double[][] doubleResultArrBuff;
    private final Object[][] objectResultArrBuff;
    public final AtomicInteger atomI;
    public final AtomicDouble atomD;
    public final AtomicInteger[] atomIarr;
    public final AtomicDouble[] atomDarr;
    public final AtomicInteger[] atomIbuff;
    public final AtomicDouble[] atomDbuff;
    public final AtomicInteger[][] atomIarrBuff;
    public final AtomicDouble[][] atomDarrBuff;
    private final int func;
    private final double delay;
    private final double coef;
    public final ArrayList accumCells;
    private final Object lockForAccumCells;
    public final SubAccum[][] subAccum;

    public Accumulator(accumulator.Operator ope, Class type, phaser ph) {
        this(ope, type, ph, false, 0, 1, 50.0, 2.0);
    }

    public Accumulator(accumulator.Operator ope, Class type, phaser ph, boolean isLazy) {
        this(ope, type, ph, isLazy, 0, 1, 50.0, 2.0);
    }

    public Accumulator(accumulator.Operator ope, Class type, phaser ph, boolean isLazy, int arrsize) {
        this(ope, type, ph, isLazy, arrsize, 1, 50.0, 2.0);
    }

    public Accumulator(accumulator.Operator ope, Class type0, phaser ph, boolean isLazy, int arrsize0, int func, double delay, double coef) {
        int j;
        int i;
        double initD;
        int initI;
        if (ope != accumulator.Operator.ANY && ope != accumulator.Operator.SUM && ope != accumulator.Operator.PROD && ope != accumulator.Operator.MIN && ope != accumulator.Operator.MAX) {
            throw new PhaserException("Accumulator: Not supported operator.");
        }
        Class ty = null;
        if (type0 == Integer.TYPE || type0 == Integer.class) {
            ty = Integer.class;
        } else if (type0 == Double.TYPE || type0 == Double.class) {
            ty = Double.class;
        } else if (type0 == Object.class) {
            ty = Object.class;
        } else {
            throw new PhaserException("Accumulator: Not supported data type " + type0 + ".");
        }
        Activity a = (Activity)Runtime.getCurrentActivity();
        PhaserImpl phiTmp = (PhaserImpl)ph.getPhaser();
        PhaserImpl.Mode mode = phiTmp.getMode(a);
        assert (mode != PhaserImpl.Mode.TRANSMIT);
        int bound = phiTmp.getBound();
        if (bound == 0 && (mode == PhaserImpl.Mode.SIG || mode == PhaserImpl.Mode.WAIT)) {
            throw new PhaserException("Accumulator: SIG-ONLY/WAIT-ONLY needs bounded phaser.");
        }
        if (arrsize0 < 0) {
            throw new PhaserException("Accumulator: Array size must be greater or equal to 0.");
        }
        if (phiTmp.batchSize > 0 && arrsize0 > 0) {
            throw new PhaserException("Accumulator: Array size must not be specified for batch-opt.");
        }
        if (func < 0 || func > 5) {
            throw new PhaserException("Accumulator: func must be 0 to 5.");
        }
        if (delay <= 0.0) {
            throw new PhaserException("Accumulator: delay must be > 0.");
        }
        if (coef <= 0.0) {
            throw new PhaserException("Accumulator: coef  must be > 0.");
        }
        if (phiTmp.subPhaser != null) {
            if (isLazy) {
                throw new PhaserException("Accumulator: Current restriction on tree: Lazy isn't supported.");
            }
            if (arrsize0 > 0) {
                throw new PhaserException("Accumulator: Current restriction on tree: Array reduction isn't supported.");
            }
        }
        if (ty == Object.class) {
            if (ope != accumulator.Operator.ANY) {
                throw new PhaserException("Accumulator: Current restriction on type: Only Operator.ANY is allowed for Object type.");
            }
            if (phiTmp.subPhaser != null) {
                throw new PhaserException("Accumulator: Current restriction on type: Tree isn't supported.");
            }
        }
        this.ope = ope;
        this.type = ty;
        this.ph = ph;
        this.isLazy = isLazy;
        this.phi = phiTmp;
        int n = this.buffsize = bound > 0 ? bound * 3 + 2 : 0;
        if (ope == accumulator.Operator.SUM || ope == accumulator.Operator.ANY) {
            initI = 0;
            initD = 0.0;
        } else if (ope == accumulator.Operator.PROD) {
            initI = 1;
            initD = 1.0;
        } else if (ope == accumulator.Operator.MIN) {
            initI = Integer.MAX_VALUE;
            initD = Double.MAX_VALUE;
        } else if (ope == accumulator.Operator.MAX) {
            initI = Integer.MIN_VALUE;
            initD = Double.MIN_VALUE;
        } else {
            initI = 0;
            initD = 0.0;
            assert (false);
        }
        if (phiTmp.batchSize > 0) {
            assert (this.buffsize > 0);
            this.arrsize = phiTmp.batchSize;
            this.dataKind = DataKind.HYBRID;
        } else {
            this.arrsize = arrsize0;
            DataKind dataKind = this.dataKind = this.arrsize > 0 ? DataKind.ARRAY : DataKind.SCALAR;
        }
        if (this.type == Integer.class) {
            this.initVal = new Integer(initI);
        } else if (this.type == Double.class) {
            this.initVal = new Double(initD);
        } else if (this.type == Object.class) {
            this.initVal = null;
        } else {
            this.initVal = null;
            assert (false);
        }
        if (this.buffsize == 0) {
            if (this.dataKind == DataKind.SCALAR) {
                this.resultVal = this.initVal;
                this.resultObj = null;
                this.intResultArray = null;
                this.doubleResultArray = null;
                this.objectResultArray = null;
            } else {
                this.resultVal = null;
                this.resultObj = null;
                if (this.type == Integer.class) {
                    this.intResultArray = new int[this.arrsize];
                    this.doubleResultArray = null;
                    this.objectResultArray = null;
                    for (i = 0; i < this.arrsize; ++i) {
                        this.intResultArray[i] = initI;
                    }
                } else if (this.type == Double.class) {
                    this.intResultArray = null;
                    this.doubleResultArray = new double[this.arrsize];
                    this.objectResultArray = null;
                    for (i = 0; i < this.arrsize; ++i) {
                        this.doubleResultArray[i] = initD;
                    }
                } else if (this.type == Object.class) {
                    this.intResultArray = null;
                    this.doubleResultArray = null;
                    this.objectResultArray = new Object[this.arrsize];
                } else {
                    this.intResultArray = null;
                    this.doubleResultArray = null;
                    this.objectResultArray = null;
                    assert (false);
                }
            }
            this.resultBuff = null;
            this.resultObjBuff = null;
            this.intResultArrBuff = null;
            this.doubleResultArrBuff = null;
            this.objectResultArrBuff = null;
        } else {
            this.resultVal = null;
            this.resultObj = null;
            this.intResultArray = null;
            this.doubleResultArray = null;
            this.objectResultArray = null;
            if (this.dataKind != DataKind.ARRAY) {
                if (this.type != Object.class) {
                    this.resultBuff = new Number[this.buffsize];
                    this.resultObjBuff = null;
                    if (this.type == Integer.class) {
                        for (i = 0; i < this.buffsize; ++i) {
                            this.resultBuff[i] = new Integer(initI);
                        }
                    } else if (this.type == Double.class) {
                        for (i = 0; i < this.buffsize; ++i) {
                            this.resultBuff[i] = new Double(initD);
                        }
                    } else assert (false);
                } else {
                    this.resultBuff = null;
                    this.resultObjBuff = new Object[this.buffsize];
                }
            } else {
                this.resultBuff = null;
                this.resultObjBuff = null;
            }
            if (this.dataKind != DataKind.SCALAR) {
                if (this.type == Integer.class) {
                    this.intResultArrBuff = new int[this.buffsize][this.arrsize];
                    this.doubleResultArrBuff = null;
                    this.objectResultArrBuff = null;
                    for (i = 0; i < this.buffsize; ++i) {
                        for (j = 0; j < this.arrsize; ++j) {
                            this.intResultArrBuff[i][j] = initI;
                        }
                    }
                } else if (this.type == Double.class) {
                    this.intResultArrBuff = null;
                    this.doubleResultArrBuff = new double[this.buffsize][this.arrsize];
                    this.objectResultArrBuff = null;
                    for (i = 0; i < this.buffsize; ++i) {
                        for (j = 0; j < this.arrsize; ++j) {
                            this.doubleResultArrBuff[i][j] = initD;
                        }
                    }
                } else if (this.type == Object.class) {
                    this.intResultArrBuff = null;
                    this.doubleResultArrBuff = null;
                    this.objectResultArrBuff = new Object[this.buffsize][this.arrsize];
                } else {
                    this.intResultArrBuff = null;
                    this.doubleResultArrBuff = null;
                    this.objectResultArrBuff = null;
                    assert (false);
                }
            } else {
                this.intResultArrBuff = null;
                this.doubleResultArrBuff = null;
                this.objectResultArrBuff = null;
            }
        }
        if (!isLazy && ope != accumulator.Operator.ANY) {
            if (this.buffsize == 0) {
                if (this.dataKind != DataKind.ARRAY) {
                    this.atomI = this.type == Integer.class ? new AtomicInteger(initI) : null;
                    this.atomD = this.type == Double.class ? new AtomicDouble(initD, func, delay, coef) : null;
                } else {
                    this.atomI = null;
                    this.atomD = null;
                }
                if (this.dataKind != DataKind.SCALAR) {
                    if (this.type == Integer.class) {
                        this.atomIarr = new AtomicInteger[this.arrsize];
                        this.atomDarr = null;
                        for (i = 0; i < this.arrsize; ++i) {
                            this.atomIarr[i] = new AtomicInteger(initI);
                        }
                    } else if (this.type == Double.class) {
                        this.atomIarr = null;
                        this.atomDarr = new AtomicDouble[this.arrsize];
                        for (i = 0; i < this.arrsize; ++i) {
                            this.atomDarr[i] = new AtomicDouble(initD, func, delay, coef);
                        }
                    } else {
                        this.atomIarr = null;
                        this.atomDarr = null;
                        assert (false);
                    }
                } else {
                    this.atomIarr = null;
                    this.atomDarr = null;
                }
                this.atomIbuff = null;
                this.atomDbuff = null;
                this.atomIarrBuff = null;
                this.atomDarrBuff = null;
            } else {
                this.atomI = null;
                this.atomD = null;
                this.atomIarr = null;
                this.atomDarr = null;
                if (this.dataKind != DataKind.ARRAY) {
                    if (this.type == Integer.class) {
                        this.atomIbuff = new AtomicInteger[this.buffsize];
                        this.atomDbuff = null;
                        for (i = 0; i < this.buffsize; ++i) {
                            this.atomIbuff[i] = new AtomicInteger(initI);
                        }
                    } else if (this.type == Double.class) {
                        this.atomIbuff = null;
                        this.atomDbuff = new AtomicDouble[this.buffsize];
                        for (i = 0; i < this.buffsize; ++i) {
                            this.atomDbuff[i] = new AtomicDouble(initD, func, delay, coef);
                        }
                    } else {
                        this.atomIbuff = null;
                        this.atomDbuff = null;
                        assert (false);
                    }
                } else {
                    this.atomIbuff = null;
                    this.atomDbuff = null;
                }
                if (this.dataKind != DataKind.SCALAR) {
                    if (this.type == Integer.class) {
                        this.atomIarrBuff = new AtomicInteger[this.buffsize][this.arrsize];
                        this.atomDarrBuff = null;
                        for (i = 0; i < this.buffsize; ++i) {
                            for (j = 0; j < this.arrsize; ++j) {
                                this.atomIarrBuff[i][j] = new AtomicInteger(initI);
                            }
                        }
                    } else if (this.type == Double.class) {
                        this.atomIarrBuff = null;
                        this.atomDarrBuff = new AtomicDouble[this.buffsize][this.arrsize];
                        for (i = 0; i < this.buffsize; ++i) {
                            for (j = 0; j < this.arrsize; ++j) {
                                this.atomDarrBuff[i][j] = new AtomicDouble(initD, func, delay, coef);
                            }
                        }
                    } else {
                        this.atomIarrBuff = null;
                        this.atomDarrBuff = null;
                        assert (false);
                    }
                } else {
                    this.atomIarrBuff = null;
                    this.atomDarrBuff = null;
                }
            }
        } else {
            this.atomI = null;
            this.atomD = null;
            this.atomIarr = null;
            this.atomDarr = null;
            this.atomIbuff = null;
            this.atomDbuff = null;
            this.atomIarrBuff = null;
            this.atomDarrBuff = null;
        }
        this.func = func;
        this.delay = delay;
        this.coef = coef;
        if (isLazy && ope != accumulator.Operator.ANY) {
            this.accumCells = new ArrayList();
            this.lockForAccumCells = new Object();
            if (mode != PhaserImpl.Mode.WAIT) {
                AccumCell cell = null;
                if (this.type == Integer.class) {
                    cell = new AccumCellI(this.buffsize);
                } else if (this.type == Double.class) {
                    cell = new AccumCellD(this.buffsize);
                } else assert (false);
                a.putAccumCell(this, cell);
                this.accumCells.add(cell);
            }
        } else {
            this.accumCells = null;
            this.lockForAccumCells = null;
            if (mode != PhaserImpl.Mode.WAIT && a.rand == null) {
                a.rand = new Random();
            }
        }
        if (this.phi.subPhaser == null) {
            this.subAccum = null;
        } else {
            this.subAccum = new SubAccum[this.phi.numTiers][];
            int n2 = 1;
            for (int i2 = 0; i2 < this.phi.numTiers; ++i2) {
                this.subAccum[i2] = new SubAccum[n2];
                if (i2 == 0) {
                    this.subAccum[0][0] = null;
                } else {
                    for (int j2 = 0; j2 < n2; ++j2) {
                        this.subAccum[i2][j2] = new SubAccum(this.type, this.initVal);
                    }
                }
                if (i2 >= this.phi.numTiers - 1) continue;
                n2 *= this.phi.numDegree;
            }
        }
        this.phi.addAccum(this, ope);
    }

    public accumulator.Operator getOperator() {
        return this.ope;
    }

    public Class getType() {
        return this.type;
    }

    public int getBuffsize() {
        return this.buffsize;
    }

    public int getArrsize() {
        return this.arrsize;
    }

    public int getRound() {
        Activity a = (Activity)Runtime.getCurrentActivity();
        return a.round;
    }

    public void send(Number val) {
        if (val == null) {
            return;
        }
        Class<?> ty = val.getClass();
        if (ty == Integer.class) {
            this.send(val.intValue());
        } else if (ty == Double.class) {
            this.send(val.doubleValue());
        } else assert (false);
    }

    public void send(int val) {
        if (this.subAccum == null) {
            this.send0(val);
        } else {
            this.sendTree(val);
        }
    }

    public void send(double val) {
        if (this.subAccum == null) {
            this.send0(val);
        } else {
            this.sendTree(val);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void send0(int val) {
        int sigC;
        Activity a = (Activity)Runtime.getCurrentActivity();
        if (!this.isValidSend(a, Integer.class, DataKind.SCALAR, -1)) {
            return;
        }
        int n = sigC = this.buffsize > 0 ? this.phi.getSigCycle(a) : -1;
        if (this.ope == accumulator.Operator.ANY) {
            if (this.buffsize == 0) {
                this.resultTmp = new Integer(val);
            } else {
                this.resultBuff[sigC] = new Integer(val);
            }
        } else if (!this.isLazy) {
            AtomicInteger aI;
            AtomicInteger atomicInteger = aI = this.buffsize == 0 ? this.atomI : this.atomIbuff[sigC];
            if (this.ope == accumulator.Operator.SUM) {
                this.atomIntAddAndGet(aI, val, a);
            } else if (this.ope == accumulator.Operator.PROD) {
                this.atomIntMulAndGet(aI, val, a);
            } else if (this.ope == accumulator.Operator.MIN) {
                this.atomIntMinAndGet(aI, val, a);
            } else if (this.ope == accumulator.Operator.MAX) {
                this.atomIntMaxAndGet(aI, val, a);
            } else assert (false);
        } else {
            int sigP = this.phi.getSigPhase(a);
            AccumCellI cell = (AccumCellI)a.getAccumCell(this);
            if (cell == null) {
                cell = new AccumCellI(this.buffsize);
                a.putAccumCell(this, cell);
                Object object = this.lockForAccumCells;
                synchronized (object) {
                    this.accumCells.add(cell);
                }
            }
            if (this.buffsize == 0) {
                cell.val = val;
                cell.sigPhase = sigP;
            } else {
                cell.buff[sigC] = val;
                cell.sigPhaseBuff[sigC] = sigP;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void send0(double val) {
        int sigC;
        Activity a = (Activity)Runtime.getCurrentActivity();
        if (!this.isValidSend(a, Double.class, DataKind.SCALAR, -1)) {
            return;
        }
        int n = sigC = this.buffsize > 0 ? this.phi.getSigCycle(a) : -1;
        if (this.ope == accumulator.Operator.ANY) {
            if (this.buffsize == 0) {
                this.resultTmp = new Double(val);
            } else {
                this.resultBuff[sigC] = new Double(val);
            }
        } else if (!this.isLazy) {
            AtomicDouble aD;
            AtomicDouble atomicDouble = aD = this.buffsize == 0 ? this.atomD : this.atomDbuff[sigC];
            if (this.ope == accumulator.Operator.SUM) {
                aD.addAndGet(val);
            } else if (this.ope == accumulator.Operator.PROD) {
                aD.mulAndGet(val);
            } else if (this.ope == accumulator.Operator.MIN) {
                aD.minAndGet(val);
            } else if (this.ope == accumulator.Operator.MAX) {
                aD.maxAndGet(val);
            } else assert (false);
        } else {
            int sigP = this.phi.getSigPhase(a);
            AccumCellD cell = (AccumCellD)a.getAccumCell(this);
            if (cell == null) {
                cell = new AccumCellD(this.buffsize);
                a.putAccumCell(this, cell);
                Object object = this.lockForAccumCells;
                synchronized (object) {
                    this.accumCells.add(cell);
                }
            }
            if (this.buffsize == 0) {
                cell.val = val;
                cell.sigPhase = sigP;
            } else {
                cell.buff[sigC] = val;
                cell.sigPhaseBuff[sigC] = sigP;
            }
        }
    }

    public void send(Object obj) {
        int sigC;
        Activity a = (Activity)Runtime.getCurrentActivity();
        if (!this.isValidSend(a, Object.class, DataKind.SCALAR, -1)) {
            return;
        }
        int n = sigC = this.buffsize > 0 ? this.phi.getSigCycle(a) : -1;
        if (this.ope == accumulator.Operator.ANY) {
            if (this.buffsize == 0) {
                this.resultObjTmp = obj;
            } else {
                this.resultObjBuff[sigC] = obj;
            }
        } else assert (false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void send(int[] arr) {
        int sigC;
        Activity a = (Activity)Runtime.getCurrentActivity();
        if (!this.isValidSend(a, Integer.class, DataKind.ARRAY, arr.length)) {
            return;
        }
        int n = sigC = this.buffsize > 0 ? this.phi.getSigCycle(a) : -1;
        if (this.ope == accumulator.Operator.ANY) {
            if (this.buffsize == 0) {
                this.intResultArrTmp = arr;
            } else {
                this.intResultArrBuff[sigC] = arr;
            }
        } else if (!this.isLazy) {
            AtomicInteger[] aIarr;
            AtomicInteger[] atomicIntegerArray = aIarr = this.buffsize == 0 ? this.atomIarr : this.atomIarrBuff[sigC];
            if (this.ope == accumulator.Operator.SUM) {
                for (int i = 0; i < this.arrsize; ++i) {
                    this.atomIntAddAndGet(aIarr[i], arr[i], a);
                }
            } else if (this.ope == accumulator.Operator.PROD) {
                for (int i = 0; i < this.arrsize; ++i) {
                    this.atomIntMulAndGet(aIarr[i], arr[i], a);
                }
            } else if (this.ope == accumulator.Operator.MIN) {
                for (int i = 0; i < this.arrsize; ++i) {
                    this.atomIntMinAndGet(aIarr[i], arr[i], a);
                }
            } else if (this.ope == accumulator.Operator.MAX) {
                for (int i = 0; i < this.arrsize; ++i) {
                    this.atomIntMaxAndGet(aIarr[i], arr[i], a);
                }
            } else assert (false);
        } else {
            int sigP = this.phi.getSigPhase(a);
            AccumCellI cell = (AccumCellI)a.getAccumCell(this);
            if (cell == null) {
                cell = new AccumCellI(this.buffsize);
                a.putAccumCell(this, cell);
                Object object = this.lockForAccumCells;
                synchronized (object) {
                    this.accumCells.add(cell);
                }
            }
            if (this.buffsize == 0) {
                cell.arr = arr;
                cell.sigPhase = sigP;
            } else {
                cell.arrBuff[sigC] = arr;
                cell.sigPhaseBuff[sigC] = sigP;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void send(double[] arr) {
        int sigC;
        Activity a = (Activity)Runtime.getCurrentActivity();
        if (!this.isValidSend(a, Double.class, DataKind.ARRAY, arr.length)) {
            return;
        }
        int n = sigC = this.buffsize > 0 ? this.phi.getSigCycle(a) : -1;
        if (this.ope == accumulator.Operator.ANY) {
            if (this.buffsize == 0) {
                this.doubleResultArrTmp = arr;
            } else {
                this.doubleResultArrBuff[sigC] = arr;
            }
        } else if (!this.isLazy) {
            AtomicDouble[] aDarr;
            AtomicDouble[] atomicDoubleArray = aDarr = this.buffsize == 0 ? this.atomDarr : this.atomDarrBuff[sigC];
            if (this.ope == accumulator.Operator.SUM) {
                for (int i = 0; i < this.arrsize; ++i) {
                    aDarr[i].addAndGet(arr[i]);
                }
            } else if (this.ope == accumulator.Operator.PROD) {
                for (int i = 0; i < this.arrsize; ++i) {
                    aDarr[i].mulAndGet(arr[i]);
                }
            } else if (this.ope == accumulator.Operator.MIN) {
                for (int i = 0; i < this.arrsize; ++i) {
                    aDarr[i].minAndGet(arr[i]);
                }
            } else if (this.ope == accumulator.Operator.MAX) {
                for (int i = 0; i < this.arrsize; ++i) {
                    aDarr[i].maxAndGet(arr[i]);
                }
            } else assert (false);
        } else {
            int sigP = this.phi.getSigPhase(a);
            AccumCellD cell = (AccumCellD)a.getAccumCell(this);
            if (cell == null) {
                cell = new AccumCellD(this.buffsize);
                a.putAccumCell(this, cell);
                Object object = this.lockForAccumCells;
                synchronized (object) {
                    this.accumCells.add(cell);
                }
            }
            if (this.buffsize == 0) {
                cell.arr = arr;
                cell.sigPhase = sigP;
            } else {
                cell.arrBuff[sigC] = arr;
                cell.sigPhaseBuff[sigC] = sigP;
            }
        }
    }

    public void send(Object[] arr) {
        int sigC;
        Activity a = (Activity)Runtime.getCurrentActivity();
        if (!this.isValidSend(a, Object.class, DataKind.ARRAY, arr.length)) {
            return;
        }
        int n = sigC = this.buffsize > 0 ? this.phi.getSigCycle(a) : -1;
        if (this.ope == accumulator.Operator.ANY) {
            if (this.buffsize == 0) {
                this.objectResultArrTmp = arr;
            } else {
                this.objectResultArrBuff[sigC] = arr;
            }
        } else assert (false);
    }

    private boolean isValidSend(Activity a, Class validType, DataKind validDataKind, int arrLength) {
        PhaserImpl.Mode mode = this.phi.getMode(a);
        if ((mode == PhaserImpl.Mode.SIG_WAIT || mode == PhaserImpl.Mode.SIG_WAIT_SINGLE) && this.phi.quiescent(a)) {
            throw new PhaserException("Accumulator: SIG_WAIT can't perform send after signal.");
        }
        if (this.buffsize == 0 && (mode == PhaserImpl.Mode.SIG || mode == PhaserImpl.Mode.WAIT)) {
            throw new PhaserException("Accumulator: SIG-ONLY/WAIT-ONLY needs bounded phaser.");
        }
        if (mode == PhaserImpl.Mode.WAIT) {
            return false;
        }
        if (this.type != validType) {
            throw new PhaserException("Accumulator: " + validType + " type send method on " + this.type + " type accumulator isn't permitted.");
        }
        if (this.dataKind != validDataKind && this.dataKind != DataKind.HYBRID) {
            throw new PhaserException("Accumulator: " + (Object)((Object)validDataKind) + " kind send cannot be called for " + (Object)((Object)this.dataKind) + " kind accumulation.");
        }
        if (arrLength != -1 && this.arrsize != arrLength) {
            throw new PhaserException("Accumulator: arr.length must be equal to array size.");
        }
        return true;
    }

    public void sendTree(int val) {
        AtomicInteger aI;
        Activity a = (Activity)Runtime.getCurrentActivity();
        PhaserImpl.Mode mode = this.phi.getMode(a);
        if ((mode == PhaserImpl.Mode.SIG_WAIT || mode == PhaserImpl.Mode.SIG_WAIT_SINGLE) && this.phi.quiescent(a)) {
            throw new PhaserException("Accumulator: SIG_WAIT can't perform send after signal.");
        }
        if (this.type != Integer.class) {
            throw new PhaserException("Accumulator: Integer type send method on " + this.type + " type accumulator isn't permitted.");
        }
        SyncVar1 s1 = a.getSyncVar1(this.phi);
        int idx = s1.leafSubIdx == -1 ? 0 : s1.leafSubIdx;
        AtomicInteger atomicInteger = aI = s1.anchored ? this.subAccum[this.phi.numTiers - 1][idx].atomI : this.atomI;
        if (this.ope == accumulator.Operator.ANY) {
            if (s1.anchored) {
                this.subAccum[this.phi.numTiers - 1][idx].resultTmp = new Integer(val);
            } else {
                this.resultTmp = new Integer(val);
            }
        } else if (this.ope == accumulator.Operator.SUM) {
            this.atomIntAddAndGet(aI, val, a);
        } else if (this.ope == accumulator.Operator.PROD) {
            this.atomIntMulAndGet(aI, val, a);
        } else if (this.ope == accumulator.Operator.MIN) {
            this.atomIntMinAndGet(aI, val, a);
        } else if (this.ope == accumulator.Operator.MAX) {
            this.atomIntMaxAndGet(aI, val, a);
        } else assert (false);
    }

    public void sendTree(double val) {
        AtomicDouble aD;
        Activity a = (Activity)Runtime.getCurrentActivity();
        PhaserImpl.Mode mode = this.phi.getMode(a);
        if ((mode == PhaserImpl.Mode.SIG_WAIT || mode == PhaserImpl.Mode.SIG_WAIT_SINGLE) && this.phi.quiescent(a)) {
            throw new PhaserException("Accumulator: SIG_WAIT can't perform send after signal.");
        }
        if (this.type != Double.class) {
            throw new PhaserException("Accumulator: Double type send method on " + this.type + " type accumulator isn't permitted.");
        }
        SyncVar1 s1 = a.getSyncVar1(this.phi);
        int idx = s1.leafSubIdx == -1 ? 0 : s1.leafSubIdx;
        AtomicDouble atomicDouble = aD = s1.anchored ? this.subAccum[this.phi.numTiers - 1][idx].atomD : this.atomD;
        if (this.ope == accumulator.Operator.ANY) {
            if (s1.anchored) {
                this.subAccum[this.phi.numTiers - 1][idx].resultTmp = new Double(val);
            } else {
                this.resultTmp = new Double(val);
            }
        } else if (this.ope == accumulator.Operator.SUM) {
            aD.addAndGet(val);
        } else if (this.ope == accumulator.Operator.PROD) {
            aD.mulAndGet(val);
        } else if (this.ope == accumulator.Operator.MIN) {
            aD.minAndGet(val);
        } else if (this.ope == accumulator.Operator.MAX) {
            aD.maxAndGet(val);
        } else assert (false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ArrayList cloneAccumCells(int size) {
        Object object = this.lockForAccumCells;
        synchronized (object) {
            int sz = this.accumCells.size();
            if (sz == size) {
                return null;
            }
            return (ArrayList)this.accumCells.clone();
        }
    }

    public void calculateAccum(boolean isArrRed, int mWaitPhase, int mWaitCycle, int mSigCycle) {
        assert (mWaitCycle == mSigCycle);
        if (this.ope == accumulator.Operator.ANY) {
            if (this.buffsize == 0) {
                if (this.type != Object.class) {
                    this.resultVal = this.resultTmp;
                    this.resultTmp = null;
                } else {
                    this.resultObj = this.resultObjTmp;
                    this.resultObjTmp = null;
                }
            }
            return;
        }
        if (!this.isLazy) {
            if (this.dataKind == DataKind.SCALAR || this.dataKind == DataKind.HYBRID && !isArrRed) {
                if (this.type == Integer.class) {
                    AtomicInteger aI = this.buffsize == 0 ? this.atomI : this.atomIbuff[mWaitCycle];
                    Integer v = new Integer(aI.get());
                    if (this.buffsize == 0) {
                        this.resultVal = v;
                    } else {
                        this.resultBuff[mSigCycle] = v;
                    }
                    aI.set(this.initVal.intValue());
                } else if (this.type == Double.class) {
                    AtomicDouble aD = this.buffsize == 0 ? this.atomD : this.atomDbuff[mWaitCycle];
                    Double v = new Double(aD.get());
                    if (this.buffsize == 0) {
                        this.resultVal = v;
                    } else {
                        this.resultBuff[mSigCycle] = v;
                    }
                    aD.set(this.initVal.doubleValue());
                } else assert (false);
            } else if (this.type == Integer.class) {
                AtomicInteger[] aIarr = this.buffsize == 0 ? this.atomIarr : this.atomIarrBuff[mWaitCycle];
                int[] arr = new int[this.arrsize];
                for (int i = 0; i < this.arrsize; ++i) {
                    AtomicInteger aI = aIarr[i];
                    arr[i] = aI.get();
                    aI.set(this.initVal.intValue());
                }
                if (this.buffsize == 0) {
                    this.intResultArray = arr;
                } else {
                    this.intResultArrBuff[mSigCycle] = arr;
                }
            } else if (this.type == Double.class) {
                AtomicDouble[] aDarr = this.buffsize == 0 ? this.atomDarr : this.atomDarrBuff[mWaitCycle];
                double[] arr = new double[this.arrsize];
                for (int i = 0; i < this.arrsize; ++i) {
                    AtomicDouble aD = aDarr[i];
                    arr[i] = aD.get();
                    aD.set(this.initVal.doubleValue());
                }
                if (this.buffsize == 0) {
                    this.doubleResultArray = arr;
                } else {
                    this.doubleResultArrBuff[mSigCycle] = arr;
                }
            } else assert (false);
        } else if (this.dataKind == DataKind.SCALAR || this.dataKind == DataKind.HYBRID && !isArrRed) {
            if (this.type == Integer.class) {
                ArrayList lAccumCells;
                int val = this.initVal.intValue();
                int size = 0;
                while ((lAccumCells = this.cloneAccumCells(size)) != null) {
                    int first = size;
                    size = lAccumCells.size();
                    for (int i = first; i < size; ++i) {
                        int lval;
                        AccumCellI cell = (AccumCellI)lAccumCells.get(i);
                        if (this.buffsize == 0 && cell.sigPhase < mWaitPhase || this.buffsize > 0 && cell.sigPhaseBuff[mWaitCycle] < mWaitPhase) continue;
                        int n = lval = this.buffsize == 0 ? cell.val : cell.buff[mWaitCycle];
                        if (this.ope == accumulator.Operator.SUM) {
                            val += lval;
                            continue;
                        }
                        if (this.ope == accumulator.Operator.PROD) {
                            val *= lval;
                            continue;
                        }
                        if (this.ope == accumulator.Operator.MIN) {
                            if (lval >= val) continue;
                            val = lval;
                            continue;
                        }
                        if (this.ope == accumulator.Operator.MAX) {
                            if (lval <= val) continue;
                            val = lval;
                            continue;
                        }
                        assert (false);
                    }
                }
                Integer v = new Integer(val);
                if (this.buffsize == 0) {
                    this.resultVal = v;
                } else {
                    this.resultBuff[mSigCycle] = v;
                }
            } else if (this.type == Double.class) {
                ArrayList lAccumCells;
                double val = this.initVal.doubleValue();
                int size = 0;
                while ((lAccumCells = this.cloneAccumCells(size)) != null) {
                    int first = size;
                    size = lAccumCells.size();
                    for (int i = first; i < size; ++i) {
                        double lval;
                        AccumCellD cell = (AccumCellD)lAccumCells.get(i);
                        if (this.buffsize == 0 && cell.sigPhase < mWaitPhase || this.buffsize > 0 && cell.sigPhaseBuff[mWaitCycle] < mWaitPhase) continue;
                        double d = lval = this.buffsize == 0 ? cell.val : cell.buff[mWaitCycle];
                        if (this.ope == accumulator.Operator.SUM) {
                            val += lval;
                            continue;
                        }
                        if (this.ope == accumulator.Operator.PROD) {
                            val *= lval;
                            continue;
                        }
                        if (this.ope == accumulator.Operator.MIN) {
                            if (!(lval < val)) continue;
                            val = lval;
                            continue;
                        }
                        if (this.ope == accumulator.Operator.MAX) {
                            if (!(lval > val)) continue;
                            val = lval;
                            continue;
                        }
                        assert (false);
                    }
                }
                Double v = new Double(val);
                if (this.buffsize == 0) {
                    this.resultVal = v;
                } else {
                    this.resultBuff[mSigCycle] = v;
                }
            } else assert (false);
        } else if (this.type == Integer.class) {
            ArrayList lAccumCells;
            int[] arr = new int[this.arrsize];
            for (int i = 0; i < this.arrsize; ++i) {
                arr[i] = this.initVal.intValue();
            }
            int size = 0;
            while ((lAccumCells = this.cloneAccumCells(size)) != null) {
                int first = size;
                size = lAccumCells.size();
                for (int i = first; i < size; ++i) {
                    int j;
                    int[] larr;
                    AccumCellI cell = (AccumCellI)lAccumCells.get(i);
                    if (this.buffsize == 0 && cell.sigPhase < mWaitPhase || this.buffsize > 0 && cell.sigPhaseBuff[mWaitCycle] < mWaitPhase) continue;
                    int[] nArray = larr = this.buffsize == 0 ? cell.arr : cell.arrBuff[mWaitCycle];
                    assert (larr != null);
                    if (this.ope == accumulator.Operator.SUM) {
                        for (j = 0; j < this.arrsize; ++j) {
                            int n = j;
                            arr[n] = arr[n] + larr[j];
                        }
                        continue;
                    }
                    if (this.ope == accumulator.Operator.PROD) {
                        for (j = 0; j < this.arrsize; ++j) {
                            int n = j;
                            arr[n] = arr[n] * larr[j];
                        }
                        continue;
                    }
                    if (this.ope == accumulator.Operator.MIN) {
                        for (j = 0; j < this.arrsize; ++j) {
                            if (larr[j] >= arr[j]) continue;
                            arr[j] = larr[j];
                        }
                        continue;
                    }
                    if (this.ope == accumulator.Operator.MAX) {
                        for (j = 0; j < this.arrsize; ++j) {
                            if (larr[j] <= arr[j]) continue;
                            arr[j] = larr[j];
                        }
                        continue;
                    }
                    assert (false);
                }
            }
            if (this.buffsize == 0) {
                this.intResultArray = arr;
            } else {
                this.intResultArrBuff[mSigCycle] = arr;
            }
        } else if (this.type == Double.class) {
            ArrayList lAccumCells;
            double[] arr = new double[this.arrsize];
            for (int i = 0; i < this.arrsize; ++i) {
                arr[i] = this.initVal.doubleValue();
            }
            int size = 0;
            while ((lAccumCells = this.cloneAccumCells(size)) != null) {
                int first = size;
                size = lAccumCells.size();
                for (int i = first; i < size; ++i) {
                    int j;
                    double[] larr;
                    AccumCellD cell = (AccumCellD)lAccumCells.get(i);
                    if (this.buffsize == 0 && cell.sigPhase < mWaitPhase || this.buffsize > 0 && cell.sigPhaseBuff[mWaitCycle] < mWaitPhase) continue;
                    double[] dArray = larr = this.buffsize == 0 ? cell.arr : cell.arrBuff[mWaitCycle];
                    assert (larr != null);
                    if (this.ope == accumulator.Operator.SUM) {
                        for (j = 0; j < this.arrsize; ++j) {
                            int n = j;
                            arr[n] = arr[n] + larr[j];
                        }
                        continue;
                    }
                    if (this.ope == accumulator.Operator.PROD) {
                        for (j = 0; j < this.arrsize; ++j) {
                            int n = j;
                            arr[n] = arr[n] * larr[j];
                        }
                        continue;
                    }
                    if (this.ope == accumulator.Operator.MIN) {
                        for (j = 0; j < this.arrsize; ++j) {
                            if (!(larr[j] < arr[j])) continue;
                            arr[j] = larr[j];
                        }
                        continue;
                    }
                    if (this.ope == accumulator.Operator.MAX) {
                        for (j = 0; j < this.arrsize; ++j) {
                            if (!(larr[j] > arr[j])) continue;
                            arr[j] = larr[j];
                        }
                        continue;
                    }
                    assert (false);
                }
            }
            if (this.buffsize == 0) {
                this.doubleResultArray = arr;
            } else {
                this.doubleResultArrBuff[mSigCycle] = arr;
            }
        } else assert (false);
    }

    public void calculateAccumMulti(boolean isArrRed, int mWaitPhase, int mWaitCycle, int mSigCycle, int delta, int upperBound) {
        boolean flg;
        boolean bl = flg = mWaitCycle == mSigCycle && this.buffsize > 0;
        assert (flg);
        if (this.ope == accumulator.Operator.ANY) {
            return;
        }
        if (!this.isLazy) {
            if (this.dataKind == DataKind.SCALAR || this.dataKind == DataKind.HYBRID && !isArrRed) {
                if (this.type == Integer.class) {
                    int cyc = mWaitCycle;
                    for (int i = 0; i < delta; ++i) {
                        AtomicInteger aI = this.atomIbuff[cyc];
                        Integer v = new Integer(aI.get());
                        this.resultBuff[cyc] = v;
                        aI.set(this.initVal.intValue());
                        cyc = cyc == upperBound ? 0 : cyc + 1;
                    }
                } else if (this.type == Double.class) {
                    int cyc = mWaitCycle;
                    for (int i = 0; i < delta; ++i) {
                        AtomicDouble aD = this.atomDbuff[cyc];
                        Double v = new Double(aD.get());
                        this.resultBuff[cyc] = v;
                        aD.set(this.initVal.doubleValue());
                        cyc = cyc == upperBound ? 0 : cyc + 1;
                    }
                } else assert (false);
            } else if (this.type == Integer.class) {
                int cyc = mWaitCycle;
                for (int i = 0; i < delta; ++i) {
                    AtomicInteger[] aIarr = this.atomIarrBuff[cyc];
                    int[] arr = new int[this.arrsize];
                    for (int j = 0; j < this.arrsize; ++j) {
                        AtomicInteger aI = aIarr[j];
                        arr[j] = aI.get();
                        aI.set(this.initVal.intValue());
                    }
                    this.intResultArrBuff[cyc] = arr;
                    cyc = cyc == upperBound ? 0 : cyc + 1;
                }
            } else if (this.type == Double.class) {
                int cyc = mWaitCycle;
                for (int i = 0; i < delta; ++i) {
                    AtomicDouble[] aDarr = this.atomDarrBuff[cyc];
                    double[] arr = new double[this.arrsize];
                    for (int j = 0; j < this.arrsize; ++j) {
                        AtomicDouble aD = aDarr[j];
                        arr[j] = aD.get();
                        aD.set(this.initVal.doubleValue());
                    }
                    this.doubleResultArrBuff[cyc] = arr;
                    cyc = cyc == upperBound ? 0 : cyc + 1;
                }
            } else assert (false);
        } else if (this.dataKind == DataKind.SCALAR || this.dataKind == DataKind.HYBRID && !isArrRed) {
            if (this.type == Integer.class) {
                ArrayList lAccumCells;
                int[] buff = new int[delta];
                for (int i = 0; i < delta; ++i) {
                    buff[i] = this.initVal.intValue();
                }
                int size = 0;
                while ((lAccumCells = this.cloneAccumCells(size)) != null) {
                    int first = size;
                    size = lAccumCells.size();
                    for (int i = first; i < size; ++i) {
                        AccumCellI cell = (AccumCellI)lAccumCells.get(i);
                        int cyc = mWaitCycle;
                        for (int j = 0; j < delta; ++j) {
                            if (cell.sigPhaseBuff[cyc] == mWaitPhase + j) {
                                int lval = cell.buff[cyc];
                                if (this.ope == accumulator.Operator.SUM) {
                                    int n = j;
                                    buff[n] = buff[n] + lval;
                                } else if (this.ope == accumulator.Operator.PROD) {
                                    int n = j;
                                    buff[n] = buff[n] * lval;
                                } else if (this.ope == accumulator.Operator.MIN) {
                                    if (lval < buff[j]) {
                                        buff[j] = lval;
                                    }
                                } else if (this.ope == accumulator.Operator.MAX) {
                                    if (lval > buff[j]) {
                                        buff[j] = lval;
                                    }
                                } else assert (false);
                            }
                            cyc = cyc == upperBound ? 0 : cyc + 1;
                        }
                    }
                }
                int cyc = mWaitCycle;
                for (int j = 0; j < delta; ++j) {
                    Integer v = new Integer(buff[j]);
                    this.resultBuff[cyc] = v;
                    cyc = cyc == upperBound ? 0 : cyc + 1;
                }
            } else if (this.type == Double.class) {
                ArrayList lAccumCells;
                double[] buff = new double[delta];
                for (int i = 0; i < delta; ++i) {
                    buff[i] = this.initVal.doubleValue();
                }
                int size = 0;
                while ((lAccumCells = this.cloneAccumCells(size)) != null) {
                    int first = size;
                    size = lAccumCells.size();
                    for (int i = first; i < size; ++i) {
                        AccumCellD cell = (AccumCellD)lAccumCells.get(i);
                        int cyc = mWaitCycle;
                        for (int j = 0; j < delta; ++j) {
                            if (cell.sigPhaseBuff[cyc] == mWaitPhase + j) {
                                double lval = cell.buff[cyc];
                                if (this.ope == accumulator.Operator.SUM) {
                                    int n = j;
                                    buff[n] = buff[n] + lval;
                                } else if (this.ope == accumulator.Operator.PROD) {
                                    int n = j;
                                    buff[n] = buff[n] * lval;
                                } else if (this.ope == accumulator.Operator.MIN) {
                                    if (lval < buff[j]) {
                                        buff[j] = lval;
                                    }
                                } else if (this.ope == accumulator.Operator.MAX) {
                                    if (lval > buff[j]) {
                                        buff[j] = lval;
                                    }
                                } else assert (false);
                            }
                            cyc = cyc == upperBound ? 0 : cyc + 1;
                        }
                    }
                }
                int cyc = mWaitCycle;
                for (int j = 0; j < delta; ++j) {
                    Double v = new Double(buff[j]);
                    this.resultBuff[cyc] = v;
                    cyc = cyc == upperBound ? 0 : cyc + 1;
                }
            } else assert (false);
        } else if (this.type == Integer.class) {
            ArrayList lAccumCells;
            int[][] arrBuff = new int[delta][this.arrsize];
            for (int i = 0; i < delta; ++i) {
                for (int j = 0; j < this.arrsize; ++j) {
                    arrBuff[i][j] = this.initVal.intValue();
                }
            }
            int size = 0;
            while ((lAccumCells = this.cloneAccumCells(size)) != null) {
                int first = size;
                size = lAccumCells.size();
                for (int i = first; i < size; ++i) {
                    AccumCellI cell = (AccumCellI)lAccumCells.get(i);
                    int cyc = mWaitCycle;
                    for (int j = 0; j < delta; ++j) {
                        if (cell.sigPhaseBuff[cyc] == mWaitPhase + j) {
                            int k;
                            int[] larr = cell.arrBuff[cyc];
                            assert (larr != null);
                            int[] arr = arrBuff[j];
                            if (this.ope == accumulator.Operator.SUM) {
                                for (k = 0; k < this.arrsize; ++k) {
                                    int n = k;
                                    arr[n] = arr[n] + larr[k];
                                }
                            } else if (this.ope == accumulator.Operator.PROD) {
                                for (k = 0; k < this.arrsize; ++k) {
                                    int n = k;
                                    arr[n] = arr[n] * larr[k];
                                }
                            } else if (this.ope == accumulator.Operator.MIN) {
                                for (k = 0; k < this.arrsize; ++k) {
                                    if (larr[k] >= arr[k]) continue;
                                    arr[k] = larr[k];
                                }
                            } else if (this.ope == accumulator.Operator.MAX) {
                                for (k = 0; k < this.arrsize; ++k) {
                                    if (larr[k] <= arr[k]) continue;
                                    arr[k] = larr[k];
                                }
                            } else assert (false);
                        }
                        cyc = cyc == upperBound ? 0 : cyc + 1;
                    }
                }
            }
            int cyc = mWaitCycle;
            for (int j = 0; j < delta; ++j) {
                this.intResultArrBuff[cyc] = arrBuff[j];
                cyc = cyc == upperBound ? 0 : cyc + 1;
            }
        } else if (this.type == Double.class) {
            ArrayList lAccumCells;
            double[][] arrBuff = new double[delta][this.arrsize];
            for (int i = 0; i < delta; ++i) {
                for (int j = 0; j < this.arrsize; ++j) {
                    arrBuff[i][j] = this.initVal.doubleValue();
                }
            }
            int size = 0;
            while ((lAccumCells = this.cloneAccumCells(size)) != null) {
                int first = size;
                size = lAccumCells.size();
                for (int i = first; i < size; ++i) {
                    AccumCellD cell = (AccumCellD)lAccumCells.get(i);
                    int cyc = mWaitCycle;
                    for (int j = 0; j < delta; ++j) {
                        if (cell.sigPhaseBuff[cyc] == mWaitPhase + j) {
                            int k;
                            double[] larr = cell.arrBuff[cyc];
                            assert (larr != null);
                            double[] arr = arrBuff[j];
                            if (this.ope == accumulator.Operator.SUM) {
                                for (k = 0; k < this.arrsize; ++k) {
                                    int n = k;
                                    arr[n] = arr[n] + larr[k];
                                }
                            } else if (this.ope == accumulator.Operator.PROD) {
                                for (k = 0; k < this.arrsize; ++k) {
                                    int n = k;
                                    arr[n] = arr[n] * larr[k];
                                }
                            } else if (this.ope == accumulator.Operator.MIN) {
                                for (k = 0; k < this.arrsize; ++k) {
                                    if (!(larr[k] < arr[k])) continue;
                                    arr[k] = larr[k];
                                }
                            } else if (this.ope == accumulator.Operator.MAX) {
                                for (k = 0; k < this.arrsize; ++k) {
                                    if (!(larr[k] > arr[k])) continue;
                                    arr[k] = larr[k];
                                }
                            } else assert (false);
                        }
                        cyc = cyc == upperBound ? 0 : cyc + 1;
                    }
                }
            }
            int cyc = mWaitCycle;
            for (int j = 0; j < delta; ++j) {
                this.doubleResultArrBuff[cyc] = arrBuff[j];
                cyc = cyc == upperBound ? 0 : cyc + 1;
            }
        } else assert (false);
    }

    public void calculateSubAccum(int i, int idx) {
        Activity a = (Activity)Runtime.getCurrentActivity();
        SubAccum subAcc = this.subAccum[i][idx];
        SubAccum pSubAcc = this.subAccum[i - 1][idx / this.phi.numDegree];
        if (this.ope != accumulator.Operator.ANY) {
            if (this.type == Integer.class) {
                AtomicInteger pI;
                AtomicInteger aI = subAcc.atomI;
                int val = aI.get();
                AtomicInteger atomicInteger = pI = i > 1 ? pSubAcc.atomI : this.atomI;
                if (this.ope == accumulator.Operator.SUM) {
                    this.atomIntAddAndGet(pI, val, a);
                } else if (this.ope == accumulator.Operator.PROD) {
                    this.atomIntMulAndGet(pI, val, a);
                } else if (this.ope == accumulator.Operator.MIN) {
                    this.atomIntMinAndGet(pI, val, a);
                } else if (this.ope == accumulator.Operator.MAX) {
                    this.atomIntMaxAndGet(pI, val, a);
                } else assert (false);
                aI.set(this.initVal.intValue());
            } else if (this.type == Double.class) {
                AtomicDouble pD;
                AtomicDouble aD = subAcc.atomD;
                double val = aD.get();
                AtomicDouble atomicDouble = pD = i > 1 ? pSubAcc.atomD : this.atomD;
                if (this.ope == accumulator.Operator.SUM) {
                    pD.addAndGet(val);
                } else if (this.ope == accumulator.Operator.PROD) {
                    pD.mulAndGet(val);
                } else if (this.ope == accumulator.Operator.MIN) {
                    pD.minAndGet(val);
                } else if (this.ope == accumulator.Operator.MAX) {
                    pD.maxAndGet(val);
                } else assert (false);
                aD.set(this.initVal.doubleValue());
            } else assert (false);
        } else {
            if (i > 1) {
                pSubAcc.resultTmp = subAcc.resultTmp;
            } else {
                this.resultTmp = subAcc.resultTmp;
            }
            subAcc.resultTmp = 0;
        }
    }

    public Number result() {
        return this.result(0);
    }

    public Number result(int offset) {
        Activity a = (Activity)Runtime.getCurrentActivity();
        PhaserImpl.Mode mode = this.phi.getMode(a);
        if (this.buffsize == 0 && (mode == PhaserImpl.Mode.SIG || mode == PhaserImpl.Mode.WAIT)) {
            throw new PhaserException("Accumulator: SIG-ONLY/WAIT-ONLY needs bounded phaser.");
        }
        if (mode == PhaserImpl.Mode.SIG) {
            return this.initVal;
        }
        if (this.buffsize == 0) {
            return this.resultVal;
        }
        if (offset < -this.buffsize || offset > 0) {
            throw new PhaserException("Accumulator: offset for result method must be " + -this.buffsize + " <= offset <= 0");
        }
        int tmp = this.phi.getWaitCycle(a) + offset - 1;
        int cyc = tmp >= 0 ? tmp : tmp + this.buffsize;
        return this.resultBuff[cyc];
    }

    public int intResult() {
        return this.result(0).intValue();
    }

    public int intResult(int offset) {
        return this.result(offset).intValue();
    }

    public double doubleResult() {
        return this.result(0).doubleValue();
    }

    public double doubleResult(int offset) {
        return this.result(offset).doubleValue();
    }

    public Object objResult() {
        return this.objResult(0);
    }

    public Object objResult(int offset) {
        Activity a = (Activity)Runtime.getCurrentActivity();
        PhaserImpl.Mode mode = this.phi.getMode(a);
        if (this.buffsize == 0 && (mode == PhaserImpl.Mode.SIG || mode == PhaserImpl.Mode.WAIT)) {
            throw new PhaserException("Accumulator: SIG-ONLY/WAIT-ONLY needs bounded phaser.");
        }
        if (mode == PhaserImpl.Mode.SIG) {
            return null;
        }
        if (this.buffsize == 0) {
            return this.resultObj;
        }
        if (offset < -this.buffsize || offset > 0) {
            throw new PhaserException("Accumulator: offset for result method must be " + -this.buffsize + " <= offset <= 0");
        }
        int tmp = this.phi.getWaitCycle(a) + offset - 1;
        int cyc = tmp >= 0 ? tmp : tmp + this.buffsize;
        return this.resultObjBuff[cyc];
    }

    public int[] intResultArr() {
        return this.intResultArr(0);
    }

    public int[] intResultArr(int offset) {
        Activity a = (Activity)Runtime.getCurrentActivity();
        PhaserImpl.Mode mode = this.phi.getMode(a);
        if (this.buffsize == 0 && (mode == PhaserImpl.Mode.SIG || mode == PhaserImpl.Mode.WAIT)) {
            throw new PhaserException("Accumulator: SIG-ONLY/WAIT-ONLY needs bounded phaser.");
        }
        if (mode == PhaserImpl.Mode.SIG) {
            return null;
        }
        if (this.buffsize == 0) {
            return this.intResultArray;
        }
        if (offset < -this.buffsize || offset > 0) {
            throw new PhaserException("Accumulator: offset for result method must be " + -this.buffsize + " <= offset <= 0");
        }
        int tmp = this.phi.getWaitCycle(a) + offset - 1;
        int cyc = tmp >= 0 ? tmp : this.buffsize + tmp;
        return this.intResultArrBuff[cyc];
    }

    public double[] doubleResultArr() {
        return this.doubleResultArr(0);
    }

    public double[] doubleResultArr(int offset) {
        Activity a = (Activity)Runtime.getCurrentActivity();
        PhaserImpl.Mode mode = this.phi.getMode(a);
        if (this.buffsize == 0 && (mode == PhaserImpl.Mode.SIG || mode == PhaserImpl.Mode.WAIT)) {
            throw new PhaserException("Accumulator: SIG-ONLY/WAIT-ONLY needs bounded phaser.");
        }
        if (mode == PhaserImpl.Mode.SIG) {
            return null;
        }
        if (this.buffsize == 0) {
            return this.doubleResultArray;
        }
        if (offset < -this.buffsize || offset > 0) {
            throw new PhaserException("Accumulator: offset for result method must be " + -this.buffsize + " <= offset <= 0");
        }
        int tmp = this.phi.getWaitCycle(a) + offset - 1;
        int cyc = tmp >= 0 ? tmp : this.buffsize + tmp;
        return this.doubleResultArrBuff[cyc];
    }

    public Object[] objResultArr() {
        return this.objResultArr(0);
    }

    public Object[] objResultArr(int offset) {
        Activity a = (Activity)Runtime.getCurrentActivity();
        PhaserImpl.Mode mode = this.phi.getMode(a);
        if (this.buffsize == 0 && (mode == PhaserImpl.Mode.SIG || mode == PhaserImpl.Mode.WAIT)) {
            throw new PhaserException("Accumulator: SIG-ONLY/WAIT-ONLY needs bounded phaser.");
        }
        if (mode == PhaserImpl.Mode.SIG) {
            return null;
        }
        if (this.buffsize == 0) {
            return this.objectResultArray;
        }
        if (offset < -this.buffsize || offset > 0) {
            throw new PhaserException("Accumulator: offset for result method must be " + -this.buffsize + " <= offset <= 0");
        }
        int tmp = this.phi.getWaitCycle(a) + offset - 1;
        int cyc = tmp >= 0 ? tmp : this.buffsize + tmp;
        return this.objectResultArrBuff[cyc];
    }

    private int localSpin(double round, double exp, Activity a) {
        int n = 0;
        int length = (int)this.delay;
        switch (this.func) {
            case 1: {
                length = (int)(this.delay * (1.0 + this.coef * a.rand.nextDouble()));
                break;
            }
            case 2: {
                length = (int)(this.delay * (1.0 + this.coef * (round - 1.0)));
                break;
            }
            case 3: {
                length = (int)(this.delay * (1.0 + this.coef * round * a.rand.nextDouble()));
                break;
            }
            case 4: {
                length = (int)Math.min(exp * this.coef, this.delay);
                break;
            }
            case 5: {
                length = (int)(Math.min(exp * this.coef, this.delay) * a.rand.nextDouble());
            }
        }
        for (int i = 0; i < length; ++i) {
            n += i;
        }
        return n;
    }

    private int atomIntAddAndGet(AtomicInteger aI, int val, Activity a) {
        if (val == 0) {
            return aI.get();
        }
        if (a.rand == null) {
            a.rand = new Random();
        }
        double round = 1.0;
        double exp = 2.0;
        while (true) {
            int neo;
            int cur;
            if (aI.compareAndSet(cur = aI.get(), neo = cur + val)) {
                a.round = (int)round;
                return neo;
            }
            a.tmpForDelay = this.localSpin(round, exp, a);
            round += 1.0;
            exp *= 2.0;
        }
    }

    private int atomIntMulAndGet(AtomicInteger aI, int val, Activity a) {
        if (val == 1) {
            return aI.get();
        }
        if (a.rand == null) {
            a.rand = new Random();
        }
        double round = 1.0;
        double exp = 2.0;
        while (true) {
            int neo;
            int cur;
            if (aI.compareAndSet(cur = aI.get(), neo = cur * val)) {
                a.round = (int)round;
                return neo;
            }
            a.tmpForDelay = this.localSpin(round, exp, a);
            round += 1.0;
            exp *= 2.0;
        }
    }

    private int atomIntMinAndGet(AtomicInteger aI, int val, Activity a) {
        if (a.rand == null) {
            a.rand = new Random();
        }
        double round = 1.0;
        double exp = 2.0;
        while (true) {
            int cur;
            if (val >= (cur = aI.get())) {
                a.round = (int)round;
                return cur;
            }
            if (aI.compareAndSet(cur, val)) {
                a.round = (int)round;
                return val;
            }
            a.tmpForDelay = this.localSpin(round, exp, a);
            round += 1.0;
            exp *= 2.0;
        }
    }

    private int atomIntMaxAndGet(AtomicInteger aI, int val, Activity a) {
        if (a.rand == null) {
            a.rand = new Random();
        }
        double round = 1.0;
        double exp = 2.0;
        while (true) {
            int cur;
            if (val <= (cur = aI.get())) {
                a.round = (int)round;
                return cur;
            }
            if (aI.compareAndSet(cur, val)) {
                a.round = (int)round;
                return val;
            }
            a.tmpForDelay = this.localSpin(round, exp, a);
            round += 1.0;
            exp *= 2.0;
        }
    }

    public void send(Number val, int workerId) {
        throw new PhaserException("Accumulator: Not supported send method in phaser accumulator");
    }

    public void send(int val, int workerId) {
        throw new PhaserException("Accumulator: Not supported send method in phaser accumulator");
    }

    public void send(double val, int workerId) {
        throw new PhaserException("Accumulator: Not supported send method in phaser accumulator");
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum DataKind {
        SCALAR,
        ARRAY,
        HYBRID;

    }
}

