/*
 * Decompiled with CFR 0.152.
 */
package hj.runtime.wst.adaptive;

import hj.lang.accumulator;
import hj.runtime.common.Configuration;
import hj.runtime.wsh.finishAccumulator.FinishAccumulatorManager;
import hj.runtime.wst.Trace;
import hj.runtime.wst.WstConfiguration;
import hj.runtime.wst.adaptive.ContinuationFrame;
import hj.runtime.wst.adaptive.DelayedAsync;
import hj.runtime.wst.adaptive.Runtime;
import hj.runtime.wst.adaptive.Worker;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FinishTreeNode {
    public static FinishTreeNode mainFinishScope = null;
    public static final BlockingQueue<FinishTreeNode> FinishWithDelayedAsyncs = new LinkedBlockingQueue<FinishTreeNode>();
    public boolean fast = true;
    private int id;
    public final FinishTreeNode parent;
    private final AtomicInteger _numActiveWorkers;
    private int _gcVersion;
    public ContinuationFrame suspendedContinuation = null;
    private final Worker _creator;
    private int _creatorLocalCounter;
    private final AtomicReference<int[]> _localCounter = new AtomicReference();
    private final AtomicReference<AtomicInteger[]> _stealCounter = new AtomicReference<Object>(null);
    private final AtomicReference<BlockingQueue<DelayedAsync>> _delayedAsyncs = new AtomicReference<Object>(null);
    protected FinishAccumulatorManager accumManager = null;

    public FinishTreeNode(FinishTreeNode parent, Worker creator) {
        this.parent = parent;
        this._numActiveWorkers = new AtomicInteger(1);
        this._creator = creator;
        this._creatorLocalCounter = 0;
    }

    public boolean completeForContinuation() {
        return this._numActiveWorkers.compareAndSet(0, -1);
    }

    public final void checkIn(Worker worker) {
        if (this._numActiveWorkers.getAndIncrement() == 0) {
            ++this._gcVersion;
        }
        if (WstConfiguration.REPORTING) {
            Trace.line(0, worker + " checks into finish " + this);
        }
    }

    public final int checkOut(Worker worker) {
        if (WstConfiguration.REPORTING) {
            Trace.line(0, worker + " checks out of finish " + this);
        }
        return this._numActiveWorkers.decrementAndGet();
    }

    private int[] getOrCreateLocalCounters() {
        int[] lc = this._localCounter.get();
        if (lc == null && !this._localCounter.compareAndSet(null, lc = new int[Runtime.getNumWorkers() * 16])) {
            lc = this._localCounter.get();
        }
        return lc;
    }

    private AtomicInteger[] getOrCreateStealCounters() {
        AtomicInteger[] sc = this._stealCounter.get();
        if (sc == null) {
            sc = new AtomicInteger[Runtime.getNumWorkers() * 16];
            for (int i = 0; i < Runtime.getNumWorkers(); ++i) {
                sc[Runtime.getWorker((int)i).index] = new AtomicInteger(0);
            }
            if (!this._stealCounter.compareAndSet(null, sc)) {
                sc = this._stealCounter.get();
            }
        }
        return sc;
    }

    public void incLocalCounter(Worker worker) {
        if (worker == this._creator) {
            ++this._creatorLocalCounter;
        } else {
            int[] lc = this.getOrCreateLocalCounters();
            int n = worker.index;
            lc[n] = lc[n] + 1;
        }
    }

    public void decLocalCounter(Worker worker) {
        if (worker == this._creator) {
            --this._creatorLocalCounter;
        } else {
            int[] lc = this.getOrCreateLocalCounters();
            int n = worker.index;
            lc[n] = lc[n] - 1;
        }
    }

    public void incStealCounter(Worker victim) {
        AtomicInteger[] sc = this.getOrCreateStealCounters();
        sc[victim.index].incrementAndGet();
    }

    public final boolean verifyComplete() {
        int v = this._gcVersion;
        if (this._numActiveWorkers.get() != 0) {
            return false;
        }
        AtomicInteger[] _sc = this._stealCounter.get();
        if (_sc == null) {
            if (this._creatorLocalCounter != 0) {
                return false;
            }
        } else {
            if (_sc[this._creator.index].get() != this._creatorLocalCounter) {
                return false;
            }
            int[] _lc = this._localCounter.get();
            if (_lc != null) {
                for (int i = 0; i < Configuration.INIT_THREADS_PER_PLACE; ++i) {
                    Worker worker = Runtime.getWorker(i);
                    if (worker == this._creator || _sc[worker.index].get() == _lc[worker.index]) continue;
                    return false;
                }
            }
        }
        return this._gcVersion == v;
    }

    public String toString() {
        String s = this == mainFinishScope ? "MainFinish" : "Finish#" + this.id;
        s = s + "(active:" + this._numActiveWorkers + ", local:[";
        AtomicInteger[] _sc = this._stealCounter.get();
        int[] _lc = this._localCounter.get();
        for (int i = 0; i < Configuration.INIT_THREADS_PER_PLACE; ++i) {
            Worker worker = Runtime.getWorker(i);
            if (i > 0) {
                s = s + ",";
            }
            s = s + "(";
            s = _sc == null ? s + "null" : s + _sc[worker.index].get();
            s = s + ",";
            s = worker == this._creator ? s + this._creatorLocalCounter : (_lc != null ? s + _lc[worker.index] : s + null);
            s = s + ")";
        }
        s = s + "])";
        return s;
    }

    public void addDelayedAsync(DelayedAsync frame) {
        BlockingQueue<DelayedAsync> _list;
        if (WstConfiguration.REPORTING) {
            Trace.line(20, "Add " + frame + " to delayed async queue under " + this);
        }
        if ((_list = this._delayedAsyncs.get()) == null) {
            _list = new LinkedBlockingQueue<DelayedAsync>();
            if (!this._delayedAsyncs.compareAndSet(null, _list)) {
                _list = this._delayedAsyncs.get();
            } else {
                FinishWithDelayedAsyncs.add(this);
            }
        }
        _list.add(frame);
    }

    public DelayedAsync evaluateDelayedAsyncs(Worker caller) {
        BlockingQueue<DelayedAsync> _list = this._delayedAsyncs.get();
        if (_list == null) {
            return null;
        }
        if (WstConfiguration.REPORTING) {
            Trace.line(20, caller + " evaluting all delayed asyncs under " + this);
        }
        Iterator iterator = _list.iterator();
        DelayedAsync last = null;
        while (iterator.hasNext()) {
            DelayedAsync f = (DelayedAsync)iterator.next();
            if (f == null || !f.isHjTaskReady() || !f.taken.compareAndSet(false, true)) continue;
            if (WstConfiguration.REPORTING) {
                Trace.line(20, f + " is ready and taken by " + caller);
            }
            if (last == null) {
                this.checkIn(caller);
            }
            iterator.remove();
            if (last != null) {
                caller.pushBfAsync(last);
            }
            last = f;
        }
        return last;
    }

    public boolean hasDelayedAsyncs() {
        BlockingQueue<DelayedAsync> _list = this._delayedAsyncs.get();
        return _list != null && _list.size() > 0;
    }

    public void confirmDelayedAsyncsComplete() throws RuntimeException {
        BlockingQueue<DelayedAsync> _list = this._delayedAsyncs.get();
        if (_list == null) {
            return;
        }
        if (_list.size() > 0) {
            throw new RuntimeException("Dead delayed asyncs");
        }
        FinishWithDelayedAsyncs.remove(this);
    }

    public void initializeFinishAccumulatorManager(List<accumulator> accums) {
        this.accumManager = new FinishAccumulatorManager(accums);
        this.accumManager.openFinishAccumulators();
    }

    public void finalizeFinishAccumulatorManager() {
        if (this.accumManager != null) {
            this.accumManager.closeFinishAccumulators();
        }
    }
}

