/*
 * Decompiled with CFR 0.152.
 */
package hj.runtime.wst.finishAccumulator;

import hj.lang.FinishAccumulatorException;
import hj.lang.accumulator;
import hj.runtime.wst.adaptive.Runtime;
import hj.runtime.wst.adaptive.TaskProperty;
import hj.runtime.wst.adaptive.Worker;
import hj.runtime.wst.adaptive.WorkerExecutable;
import hj.runtime.wst.finishAccumulator.AtomicDouble;
import hj.runtime.wst.finishAccumulator.FinishAccumulatorProperty;
import java.util.concurrent.atomic.AtomicInteger;

public class FinishAccumulator
extends accumulator {
    private final accumulator.Operator ope;
    private final Class type;
    private boolean isAccessible = false;
    private final boolean isLazy;
    private final Number initVal;
    private final int func;
    private final double delay;
    private final double coef;
    private Number resultVal;
    private Number resultTmp;
    private final AtomicInteger atomI;
    private final AtomicDouble atomD;
    private final int[] accumArrayI;
    private final double[] accumArrayD;
    private final int strideI;
    private final int strideD;
    private final int sizeI;
    private final int sizeD;

    public FinishAccumulator(accumulator.Operator ope, Class type) {
        this(ope, type, false, 1, 50.0, 2.0);
    }

    public FinishAccumulator(accumulator.Operator ope, Class type, boolean isLazy) {
        this(ope, type, isLazy, 1, 50.0, 2.0);
    }

    public FinishAccumulator(accumulator.Operator ope, Class type0, boolean isLazy, int func, double delay, double coef) {
        double initD;
        int initI;
        FinishAccumulatorProperty fap;
        if (ope != accumulator.Operator.ANY && ope != accumulator.Operator.SUM && ope != accumulator.Operator.PROD && ope != accumulator.Operator.MIN && ope != accumulator.Operator.MAX) {
            throw new FinishAccumulatorException("Not supported operator.");
        }
        Class ty = null;
        if (type0 == Integer.TYPE || type0 == Integer.class) {
            ty = Integer.class;
        } else if (type0 == Double.TYPE || type0 == Double.class) {
            ty = Double.class;
        } else {
            throw new FinishAccumulatorException("Not supported data type " + type0 + ".");
        }
        this.ope = ope;
        this.type = ty;
        this.isLazy = isLazy;
        this.func = func;
        this.delay = delay;
        this.coef = coef;
        WorkerExecutable exec = Runtime.getCurrentExecutable();
        TaskProperty property = TaskProperty.extract(exec);
        if (property == null) {
            property = new TaskProperty();
            TaskProperty.store(exec, property);
        }
        if ((fap = property.finishAccumulatorProperty) == null) {
            property.finishAccumulatorProperty = fap = new FinishAccumulatorProperty();
        }
        fap.addOwnedAccum(this);
        if (ope == accumulator.Operator.SUM || ope == accumulator.Operator.ANY) {
            initI = 0;
            initD = 0.0;
        } else if (ope == accumulator.Operator.PROD) {
            initI = 1;
            initD = 1.0;
        } else if (ope == accumulator.Operator.MIN) {
            initI = Integer.MAX_VALUE;
            initD = Double.MAX_VALUE;
        } else if (ope == accumulator.Operator.MAX) {
            initI = Integer.MIN_VALUE;
            initD = Double.MIN_VALUE;
        } else {
            initI = 0;
            initD = 0.0;
            assert (false);
        }
        if (this.type == Integer.class) {
            this.initVal = new Integer(initI);
        } else if (this.type == Double.class) {
            this.initVal = new Double(initD);
        } else {
            this.initVal = null;
            assert (false);
        }
        this.resultVal = this.initVal;
        int n = Runtime.getNumWorkers();
        this.strideI = 16;
        this.strideD = 8;
        this.sizeI = n * this.strideI;
        this.sizeD = n * this.strideD;
        if (isLazy) {
            if (this.type == Integer.class) {
                this.accumArrayI = new int[this.sizeI];
                for (int i = 0; i < this.sizeI; i += this.strideI) {
                    this.accumArrayI[i] = initI;
                }
                this.accumArrayD = null;
            } else if (this.type == Double.class) {
                this.accumArrayI = null;
                this.accumArrayD = new double[this.sizeD];
                for (int i = 0; i < this.sizeD; i += this.strideD) {
                    this.accumArrayD[i] = initD;
                }
            } else {
                this.accumArrayI = null;
                this.accumArrayD = null;
                assert (false);
            }
            this.atomI = null;
            this.atomD = null;
        } else {
            this.accumArrayI = null;
            this.accumArrayD = null;
            this.atomI = this.type == Integer.class ? new AtomicInteger(initI) : null;
            this.atomD = this.type == Double.class ? new AtomicDouble(initD) : null;
        }
    }

    public void setAccessible(boolean isAccessible) {
        if (isAccessible) {
            this.checkOwnership(0);
            if (this.isAccessible) {
                throw new FinishAccumulatorException("Nested (double) registration is not allowed.");
            }
        }
        this.isAccessible = isAccessible;
    }

    public void send(Number val) {
        if (this.isLazy) {
            Worker worker = Runtime.getCurrentWSTWorker();
            this.send(val, worker.id);
        } else {
            this.send(val, -1);
        }
    }

    public void send(Number val, int workerId) {
        if (val == null) {
            return;
        }
        Class<?> ty = val.getClass();
        if (ty == Integer.class) {
            this.send(val.intValue(), workerId);
        } else if (ty == Double.class) {
            this.send(val.doubleValue(), workerId);
        } else assert (false);
    }

    public void send(int val) {
        if (this.isLazy) {
            Worker worker = Runtime.getCurrentWSTWorker();
            this.send(val, worker.id);
        } else {
            this.send(val, -1);
        }
    }

    public void send(int val, int workerId) {
        if (!this.isAccessible) {
            this.checkOwnership(1);
            if (this.ope == accumulator.Operator.ANY) {
                this.resultVal = new Integer(val);
            } else if (this.ope == accumulator.Operator.SUM) {
                if ((double)val != 0.0) {
                    this.resultVal = new Integer(val + this.resultVal.intValue());
                }
            } else if (this.ope == accumulator.Operator.PROD) {
                if ((double)val != 1.0) {
                    this.resultVal = new Integer(val * this.resultVal.intValue());
                }
            } else if (this.ope == accumulator.Operator.MIN) {
                if (val < this.resultVal.intValue()) {
                    this.resultVal = new Integer(val);
                }
            } else if (this.ope == accumulator.Operator.MAX) {
                if (val > this.resultVal.intValue()) {
                    this.resultVal = new Integer(val);
                }
            } else assert (false);
        } else if (this.ope == accumulator.Operator.ANY) {
            this.resultTmp = new Integer(val);
        } else if (this.isLazy) {
            if (this.ope == accumulator.Operator.SUM) {
                int n = workerId * this.strideI;
                this.accumArrayI[n] = this.accumArrayI[n] + val;
            } else if (this.ope == accumulator.Operator.PROD) {
                int n = workerId * this.strideI;
                this.accumArrayI[n] = this.accumArrayI[n] * val;
            } else if (this.ope == accumulator.Operator.MIN) {
                if (val < this.accumArrayI[workerId * this.strideI]) {
                    this.accumArrayI[workerId * this.strideI] = val;
                }
            } else if (this.ope == accumulator.Operator.MAX) {
                if (val > this.accumArrayI[workerId * this.strideI]) {
                    this.accumArrayI[workerId * this.strideI] = val;
                }
            } else assert (false);
        } else if (this.ope == accumulator.Operator.SUM) {
            this.atomIntAddAndGet(this.atomI, val);
        } else if (this.ope == accumulator.Operator.PROD) {
            this.atomIntMulAndGet(this.atomI, val);
        } else if (this.ope == accumulator.Operator.MIN) {
            this.atomIntMinAndGet(this.atomI, val);
        } else if (this.ope == accumulator.Operator.MAX) {
            this.atomIntMaxAndGet(this.atomI, val);
        } else assert (false);
    }

    public void send(double val) {
        if (this.isLazy) {
            Worker worker = Runtime.getCurrentWSTWorker();
            this.send(val, worker.id);
        } else {
            this.send(val, -1);
        }
    }

    public void send(double val, int workerId) {
        if (!this.isAccessible) {
            this.checkOwnership(1);
            if (this.ope == accumulator.Operator.ANY) {
                this.resultVal = new Double(val);
            } else if (this.ope == accumulator.Operator.SUM) {
                if (val != 0.0) {
                    this.resultVal = new Double(val + this.resultVal.doubleValue());
                }
            } else if (this.ope == accumulator.Operator.PROD) {
                if (val != 1.0) {
                    this.resultVal = new Double(val * this.resultVal.doubleValue());
                }
            } else if (this.ope == accumulator.Operator.MIN) {
                if (val < this.resultVal.doubleValue()) {
                    this.resultVal = new Double(val);
                }
            } else if (this.ope == accumulator.Operator.MAX) {
                if (val > this.resultVal.doubleValue()) {
                    this.resultVal = new Double(val);
                }
            } else assert (false);
        } else if (this.ope == accumulator.Operator.ANY) {
            this.resultTmp = new Double(val);
        } else if (this.isLazy) {
            if (this.ope == accumulator.Operator.SUM) {
                int n = workerId * this.strideD;
                this.accumArrayD[n] = this.accumArrayD[n] + val;
            } else if (this.ope == accumulator.Operator.PROD) {
                int n = workerId * this.strideD;
                this.accumArrayD[n] = this.accumArrayD[n] * val;
            } else if (this.ope == accumulator.Operator.MIN) {
                if (val < this.accumArrayD[workerId * this.strideD]) {
                    this.accumArrayD[workerId * this.strideD] = val;
                }
            } else if (this.ope == accumulator.Operator.MAX) {
                if (val > this.accumArrayD[workerId * this.strideD]) {
                    this.accumArrayD[workerId * this.strideD] = val;
                }
            } else assert (false);
        } else if (this.ope == accumulator.Operator.SUM) {
            this.atomD.addAndGet(val);
        } else if (this.ope == accumulator.Operator.PROD) {
            this.atomD.mulAndGet(val);
        } else if (this.ope == accumulator.Operator.MIN) {
            this.atomD.minAndGet(val);
        } else if (this.ope == accumulator.Operator.MAX) {
            this.atomD.maxAndGet(val);
        } else assert (false);
    }

    public Number result() {
        if (!this.isAccessible) {
            this.checkOwnership(2);
        }
        return this.resultVal;
    }

    public void calculateAccum() {
        if (this.ope == accumulator.Operator.ANY) {
            this.resultVal = this.resultTmp;
            this.resultTmp = null;
        } else if (this.isLazy) {
            if (this.type == Integer.class) {
                int val = this.resultVal.intValue();
                if (this.ope == accumulator.Operator.SUM) {
                    for (int i = 0; i < this.sizeI; i += this.strideI) {
                        val += this.accumArrayI[i];
                        this.accumArrayI[i] = this.initVal.intValue();
                    }
                } else if (this.ope == accumulator.Operator.PROD) {
                    for (int i = 0; i < this.sizeI; i += this.strideI) {
                        val *= this.accumArrayI[i];
                        this.accumArrayI[i] = this.initVal.intValue();
                    }
                } else if (this.ope == accumulator.Operator.MIN) {
                    for (int i = 0; i < this.sizeI; i += this.strideI) {
                        if (this.accumArrayI[i] < val) {
                            val = this.accumArrayI[i];
                        }
                        this.accumArrayI[i] = this.initVal.intValue();
                    }
                } else if (this.ope == accumulator.Operator.MAX) {
                    for (int i = 0; i < this.sizeI; i += this.strideI) {
                        if (this.accumArrayI[i] > val) {
                            val = this.accumArrayI[i];
                        }
                        this.accumArrayI[i] = this.initVal.intValue();
                    }
                } else assert (false);
                this.resultVal = new Integer(val);
            } else if (this.type == Double.class) {
                double val = this.resultVal.doubleValue();
                if (this.ope == accumulator.Operator.SUM) {
                    for (int i = 0; i < this.sizeD; i += this.strideD) {
                        val += this.accumArrayD[i];
                        this.accumArrayD[i] = this.initVal.doubleValue();
                    }
                } else if (this.ope == accumulator.Operator.PROD) {
                    for (int i = 0; i < this.sizeD; i += this.strideD) {
                        val *= this.accumArrayD[i];
                        this.accumArrayD[i] = this.initVal.doubleValue();
                    }
                } else if (this.ope == accumulator.Operator.MIN) {
                    for (int i = 0; i < this.sizeD; i += this.strideD) {
                        if (this.accumArrayD[i] < val) {
                            val = this.accumArrayD[i];
                        }
                        this.accumArrayD[i] = this.initVal.doubleValue();
                    }
                } else if (this.ope == accumulator.Operator.MAX) {
                    for (int i = 0; i < this.sizeD; i += this.strideD) {
                        if (this.accumArrayD[i] > val) {
                            val = this.accumArrayD[i];
                        }
                        this.accumArrayD[i] = this.initVal.doubleValue();
                    }
                } else assert (false);
                this.resultVal = new Double(val);
            } else assert (false);
        } else if (this.type == Integer.class) {
            int val = this.resultVal.intValue();
            if (this.ope == accumulator.Operator.SUM) {
                val += this.atomI.get();
            } else if (this.ope == accumulator.Operator.PROD) {
                val *= this.atomI.get();
            } else if (this.ope == accumulator.Operator.MIN) {
                int v = this.atomI.get();
                if (v < val) {
                    val = v;
                }
            } else if (this.ope == accumulator.Operator.MAX) {
                int v = this.atomI.get();
                if (v > val) {
                    val = v;
                }
            } else assert (false);
            this.atomI.set(this.initVal.intValue());
            this.resultVal = new Integer(val);
        } else if (this.type == Double.class) {
            double val = this.resultVal.doubleValue();
            if (this.ope == accumulator.Operator.SUM) {
                val += this.atomD.get();
            } else if (this.ope == accumulator.Operator.PROD) {
                val *= this.atomD.get();
            } else if (this.ope == accumulator.Operator.MIN) {
                double v = this.atomD.get();
                if (v < val) {
                    val = v;
                }
            } else if (this.ope == accumulator.Operator.MAX) {
                double v = this.atomD.get();
                if (v > val) {
                    val = v;
                }
            } else assert (false);
            this.atomD.set(this.initVal.doubleValue());
            this.resultVal = new Double(val);
        } else assert (false);
    }

    public Class getType() {
        return this.type;
    }

    public accumulator.Operator getOperator() {
        return this.ope;
    }

    private void checkOwnership(int messageId) {
        String message;
        switch (messageId) {
            case 0: {
                message = "Registration by non-parent task is not allowed.";
                break;
            }
            case 1: {
                message = "Send (put) by non-parent task is not allowed outside registered finish scope.";
                break;
            }
            case 2: {
                message = "Result (get) by non-parent task is not allowed outside registered finish scope.";
                break;
            }
            default: {
                message = "";
                assert (false);
                break;
            }
        }
        WorkerExecutable exec = Runtime.getCurrentExecutable();
        TaskProperty property = TaskProperty.extract(exec);
        if (property == null || property.finishAccumulatorProperty == null || !property.finishAccumulatorProperty.isOwnedAccum(this)) {
            throw new FinishAccumulatorException(message);
        }
    }

    private int atomIntAddAndGet(AtomicInteger aI, int val) {
        int neo;
        int cur;
        if (val == 0) {
            return aI.get();
        }
        while (!aI.compareAndSet(cur = aI.get(), neo = cur + val)) {
        }
        return neo;
    }

    private int atomIntMulAndGet(AtomicInteger aI, int val) {
        int neo;
        int cur;
        if (val == 1) {
            return aI.get();
        }
        while (!aI.compareAndSet(cur = aI.get(), neo = cur * val)) {
        }
        return neo;
    }

    private int atomIntMinAndGet(AtomicInteger aI, int val) {
        int cur;
        do {
            if (val < (cur = aI.get())) continue;
            return cur;
        } while (!aI.compareAndSet(cur, val));
        return val;
    }

    private int atomIntMaxAndGet(AtomicInteger aI, int val) {
        int cur;
        do {
            if (val > (cur = aI.get())) continue;
            return cur;
        } while (!aI.compareAndSet(cur, val));
        return val;
    }

    public void send(Object obj) {
        throw new FinishAccumulatorException("Not yet supported.");
    }

    public void send(int[] arr) {
        throw new FinishAccumulatorException("Not yet supported.");
    }

    public void send(double[] arr) {
        throw new FinishAccumulatorException("Not yet supported.");
    }

    public void send(Object[] arr) {
        throw new FinishAccumulatorException("Not yet supported.");
    }

    public Number result(int offset) {
        throw new FinishAccumulatorException("Not yet supported.");
    }

    public int intResult() {
        throw new FinishAccumulatorException("Not yet supported.");
    }

    public int intResult(int offset) {
        throw new FinishAccumulatorException("Not yet supported.");
    }

    public double doubleResult() {
        throw new FinishAccumulatorException("Not yet supported.");
    }

    public double doubleResult(int offset) {
        throw new FinishAccumulatorException("Not yet supported.");
    }

    public Object objResult() {
        throw new FinishAccumulatorException("Not yet supported.");
    }

    public Object objResult(int offset) {
        throw new FinishAccumulatorException("Not yet supported.");
    }

    public int[] intResultArr() {
        throw new FinishAccumulatorException("Not yet supported.");
    }

    public int[] intResultArr(int offset) {
        throw new FinishAccumulatorException("Not yet supported.");
    }

    public double[] doubleResultArr() {
        throw new FinishAccumulatorException("Not yet supported.");
    }

    public double[] doubleResultArr(int offset) {
        throw new FinishAccumulatorException("Not yet supported.");
    }

    public Object[] objResultArr() {
        throw new FinishAccumulatorException("Not yet supported.");
    }

    public Object[] objResultArr(int offset) {
        throw new FinishAccumulatorException("Not yet supported.");
    }

    public int getRound() {
        throw new FinishAccumulatorException("Not yet supported.");
    }

    public int getArrsize() {
        throw new FinishAccumulatorException("Not yet supported.");
    }
}

