/*
 * Decompiled with CFR 0.152.
 */
package soot.HjToJimple;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import polyglot.ast.ClassDecl;
import polyglot.ast.ConstructorCall;
import polyglot.ast.FieldDecl;
import polyglot.ast.Initializer;
import polyglot.ast.LocalClassDecl;
import polyglot.ast.New;
import polyglot.ast.Node;
import polyglot.ast.ProcedureDecl;
import polyglot.ast.SourceFile;
import polyglot.frontend.Compiler;
import polyglot.frontend.ExtensionInfo;
import polyglot.frontend.Globals;
import polyglot.types.ClassDef;
import polyglot.types.ClassType;
import polyglot.types.ConstructorInstance;
import polyglot.types.LocalInstance;
import polyglot.types.Type;
import polyglot.util.IdentityKey;
import polyglot.visit.NodeVisitor;
import soot.ClassMember;
import soot.FastHierarchy;
import soot.G;
import soot.HjToJimple.ClassResolver;
import soot.HjToJimple.HjToJimple;
import soot.HjToJimple.JimpleBodyBuilderFactory;
import soot.HjToJimple.Util;
import soot.RefType;
import soot.Singletons;
import soot.SootClass;
import soot.SootField;
import soot.SootMethod;
import soot.javaToJimple.AbstractJBBFactory;
import soot.javaToJimple.AnonLocalClassInfo;
import soot.javaToJimple.BiMap;
import soot.javaToJimple.ClassDeclFinder;
import soot.javaToJimple.IInitialResolver;
import soot.javaToJimple.InnerClassInfo;
import soot.javaToJimple.InnerClassInfoFinder;
import soot.javaToJimple.MethodFinalsChecker;
import soot.options.Options;
import soot.tagkit.InnerClassTag;
import soot.tagkit.Tag;
import soot.util.StringTools;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InitialResolver
implements IInitialResolver {
    private Node astNode;
    private Compiler compiler;
    private BiMap anonClassMap;
    private HashMap<IdentityKey, String> anonTypeOuterCounterMap;
    private HashMap<IdentityKey, String> anonTypeMapping;
    private BiMap localClassMap;
    private HashMap<IdentityKey, String> localTypeMap;
    private int privateAccessCounter = 0;
    private HashMap<IdentityKey, AnonLocalClassInfo> finalLocalInfo;
    private HashMap<String, Node> sootNameToAST = null;
    private ArrayList hasOuterRefInInit;
    private HashMap<String, String> classToSourceMap;
    private HashMap<SootClass, SootClass> specialAnonMap;
    private HashMap<IdentityKey, SootMethod> privateMethodGetAccessMap;
    private HashMap<IdentityKey, SootMethod> sootFieldGetAccessMap;
    private HashMap<IdentityKey, SootMethod> sootFieldSetAccessMap;
    private ArrayList<String> interfacesList;
    private ArrayList<Node> cCallList;
    private HashMap<New, ConstructorInstance> anonConstructorMap;
    private FastHierarchy hierarchy;
    private AbstractJBBFactory jbbFactory = new JimpleBodyBuilderFactory();
    private static final int NO_MATCH = 0;
    private HashMap<SootClass, InnerClassInfo> innerClassInfoMap;

    public void addToAnonConstructorMap(New anonNew, ConstructorInstance ci) {
        if (this.anonConstructorMap == null) {
            this.anonConstructorMap = new HashMap();
        }
        this.anonConstructorMap.put(anonNew, ci);
    }

    public ConstructorInstance getConstructorForAnon(New anonNew) {
        if (this.anonConstructorMap == null) {
            return null;
        }
        return this.anonConstructorMap.get(anonNew);
    }

    public void setJBBFactory(AbstractJBBFactory jbbFactory) {
        this.jbbFactory = jbbFactory;
    }

    public AbstractJBBFactory getJBBFactory() {
        return this.jbbFactory;
    }

    public boolean hasASTForSootName(String name) {
        if (this.sootNameToAST == null) {
            return false;
        }
        return this.sootNameToAST.containsKey(name);
    }

    public void setASTForSootName(String name) {
        if (!this.hasASTForSootName(name)) {
            throw new RuntimeException("Can only set AST for name if it exists. You should probably not be calling this method unless you know what you're doing!");
        }
        if (Options.v().hjVerbose()) {
            G.v().out.println("SOOT NAME: " + name);
        }
        this.setAst(this.sootNameToAST.get(name));
    }

    public InitialResolver(Singletons.Global g) {
    }

    public static InitialResolver v() {
        return G.v().soot_HjToJimple_InitialResolver();
    }

    @Override
    public void formAst(String fullPath, List<String> locations, String className) {
        HjToJimple jtj = new HjToJimple();
        ExtensionInfo extInfo = jtj.initExtInfo(fullPath, locations);
        if (this.compiler == null) {
            this.compiler = new Compiler(extInfo);
            Globals.initialize((Compiler)this.compiler);
        }
        this.astNode = jtj.compile(this.compiler, className, fullPath, extInfo);
        this.resolveAST();
    }

    public void setAst(Node ast) {
        this.astNode = ast;
    }

    public Node getAst() {
        return this.astNode;
    }

    private void makeASTMap() {
        ClassDeclFinder finder = new ClassDeclFinder();
        this.astNode.visit((NodeVisitor)finder);
        for (ClassDecl decl : finder.declsFound()) {
            ClassType type = decl.classDef().asType();
            if (type.flags().isInterface()) {
                if (this.interfacesList == null) {
                    this.interfacesList = new ArrayList();
                }
                this.interfacesList.add(Util.getSootType((Type)type).toString());
            }
            this.addNameToAST(Util.getSootType((Type)type).toString());
        }
    }

    protected void addNameToAST(String name) {
        if (this.sootNameToAST == null) {
            this.sootNameToAST = new HashMap();
        }
        this.sootNameToAST.put(name, this.astNode);
        Options.v().classes().addLast(name);
    }

    public void resolveAST() {
        this.buildInnerClassInfo();
        if (this.astNode instanceof SourceFile) {
            this.createClassToSourceMap((SourceFile)this.astNode);
        }
    }

    @Override
    public IInitialResolver.Dependencies resolveFromJavaFile(SootClass sc) {
        IInitialResolver.Dependencies dependencies = new IInitialResolver.Dependencies();
        ClassResolver cr = new ClassResolver(sc, dependencies.typesToSignature);
        if (this.astNode instanceof SourceFile) {
            String packageName = "";
            if (((SourceFile)this.astNode).package_() != null) {
                packageName = ((SourceFile)this.astNode).package_().toString();
            }
            if (!packageName.equals("") && sc.getType().toString().indexOf(packageName) != 0) {
                sc.setRefType(RefType.v(packageName + "." + sc.getType().toString()));
            }
            cr.createSource((SourceFile)this.astNode);
        } else if (Options.v().hjVerbose()) {
            G.v().out.println("AST NODE IS NOT CLASS FILE: " + this.astNode);
        }
        cr.addSourceFileTag(sc);
        this.makeASTMap();
        return dependencies;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void createClassToSourceMap(SourceFile src) {
        String srcName = src.source().path();
        String srcFileName = null;
        if (src.package_() != null) {
            String slashedPkg = StringTools.replaceAll(src.package_().package_().toString(), ".", System.getProperty("file.separator"));
            int lastIndexOf = srcName.lastIndexOf(slashedPkg);
            if (lastIndexOf == -1) throw new RuntimeException("Package definition " + slashedPkg.replaceAll(System.getProperty("file.separator"), ".") + " doesn't match source file path " + srcName);
            srcFileName = srcName.substring(srcName.lastIndexOf(slashedPkg));
        } else {
            srcFileName = srcName.substring(srcName.lastIndexOf(System.getProperty("file.separator")) + 1);
        }
        for (ClassDecl nextDecl : src.decls()) {
            this.addToClassToSourceMap(Util.getSootType((Type)nextDecl.classDef().asType()).toString(), srcFileName);
        }
    }

    private void createLocalAndAnonClassNames(ArrayList<Node> anonBodyList, ArrayList<Node> localClassDeclList) {
        Iterator<Node> anonBodyIt = anonBodyList.iterator();
        while (anonBodyIt.hasNext()) {
            this.createAnonClassName((New)anonBodyIt.next());
        }
        Iterator<Node> localClassDeclIt = localClassDeclList.iterator();
        while (localClassDeclIt.hasNext()) {
            this.createLocalClassName((LocalClassDecl)localClassDeclIt.next());
        }
    }

    protected int getNextAnonNum() {
        if (this.anonTypeOuterCounterMap == null) {
            return 1;
        }
        return this.anonTypeOuterCounterMap.size() + 1;
    }

    private void createAnonClassName(New nextNew) {
        if (this.anonClassMap == null) {
            this.anonClassMap = new BiMap();
        }
        if (this.anonTypeOuterCounterMap == null) {
            this.anonTypeOuterCounterMap = new HashMap();
        }
        if (this.anonTypeMapping == null) {
            this.anonTypeMapping = new HashMap();
        }
        if (!this.anonClassMap.containsKey(nextNew)) {
            int nextAvailNum = 1;
            ClassType outerToMatch = nextNew.anonType().asType().outer();
            while (outerToMatch.isNested()) {
                outerToMatch = outerToMatch.outer();
            }
            if (!this.anonTypeOuterCounterMap.isEmpty()) {
                Iterator<IdentityKey> matchIt = this.anonTypeOuterCounterMap.keySet().iterator();
                while (matchIt.hasNext()) {
                    int numFound;
                    ClassType outerMatch = (ClassType)matchIt.next().object();
                    if (!outerMatch.typeEquals((Type)outerToMatch, null) || (numFound = this.getAnonClassNum(this.anonTypeOuterCounterMap.get(new IdentityKey((Object)outerMatch)))) < nextAvailNum) continue;
                    nextAvailNum = numFound + 1;
                }
            }
            String realName = outerToMatch.fullName() + "$" + nextAvailNum;
            this.anonClassMap.put(nextNew, realName);
            this.anonTypeOuterCounterMap.put(new IdentityKey((Object)outerToMatch), realName);
            this.anonTypeMapping.put(new IdentityKey((Object)nextNew.anonType().asType().def()), realName);
            this.addNameToAST(realName);
        }
    }

    private void createLocalClassName(LocalClassDecl lcd) {
        if (Options.v().hjVerbose()) {
            G.v().out.println("LOCAL CLASS NAME: " + lcd);
        }
        if (this.localClassMap == null) {
            this.localClassMap = new BiMap();
        }
        if (this.localTypeMap == null) {
            this.localTypeMap = new HashMap();
        }
        if (!this.localClassMap.containsKey(lcd)) {
            int nextAvailNum = 1;
            ClassType outerToMatch = lcd.decl().classDef().asType().outer();
            while (outerToMatch.isNested()) {
                outerToMatch = outerToMatch.outer();
            }
            if (!this.localTypeMap.isEmpty()) {
                Iterator<IdentityKey> matchIt = this.localTypeMap.keySet().iterator();
                while (matchIt.hasNext()) {
                    int numFound;
                    ClassType pType = (ClassType)matchIt.next().object();
                    ClassType outerMatch = pType.outer();
                    while (outerMatch.isNested()) {
                        outerMatch = outerMatch.outer();
                    }
                    if (!outerMatch.typeEquals((Type)outerToMatch, null) || (numFound = this.getLocalClassNum(this.localTypeMap.get(new IdentityKey((Object)pType)), lcd.decl().name().toString())) < nextAvailNum) continue;
                    nextAvailNum = numFound + 1;
                }
            }
            String realName = outerToMatch.fullName() + "$" + nextAvailNum + lcd.decl().name();
            this.localClassMap.put(lcd, realName);
            this.localTypeMap.put(new IdentityKey((Object)lcd.decl().classDef().asType()), realName);
            System.out.print("LOCAL CLASS --> ");
            this.addNameToAST(realName);
        }
    }

    private int getLocalClassNum(String realName, String simpleName) {
        int dIndex = realName.indexOf("$");
        int nIndex = realName.indexOf(simpleName, dIndex);
        if (nIndex == -1) {
            return 0;
        }
        if (dIndex == -1) {
            throw new RuntimeException("Matching an incorrectly named local inner class: " + realName);
        }
        String numString = realName.substring(dIndex + 1, nIndex);
        for (int i = 0; i < numString.length(); ++i) {
            if (Character.isDigit(numString.charAt(i))) continue;
            return 0;
        }
        return new Integer(numString);
    }

    private int getAnonClassNum(String realName) {
        int dIndex = realName.indexOf("$");
        if (dIndex == -1) {
            throw new RuntimeException("Matching an incorrectly named anon inner class: " + realName);
        }
        return new Integer(realName.substring(dIndex + 1));
    }

    private void addToClassToSourceMap(String className, String sourceName) {
        if (this.classToSourceMap == null) {
            this.classToSourceMap = new HashMap();
        }
        this.classToSourceMap.put(className, sourceName);
    }

    public boolean hasClassInnerTag(SootClass sc, String innerName) {
        for (Tag t : sc.getTags()) {
            InnerClassTag tag;
            if (!(t instanceof InnerClassTag) || !(tag = (InnerClassTag)t).getInnerClassName().equals(innerName)) continue;
            return true;
        }
        return false;
    }

    private void buildInnerClassInfo() {
        InnerClassInfoFinder icif = new InnerClassInfoFinder();
        this.astNode.visit((NodeVisitor)icif);
        this.createLocalAndAnonClassNames(icif.anonBodyList(), icif.localClassDeclList());
        this.buildFinalLocalMap(icif.memberList());
    }

    private void buildFinalLocalMap(ArrayList<Node> memberList) {
        Iterator<Node> it = memberList.iterator();
        while (it.hasNext()) {
            this.handleFinalLocals((polyglot.ast.ClassMember)it.next());
        }
    }

    private void handleFinalLocals(polyglot.ast.ClassMember member) {
        MethodFinalsChecker mfc = new MethodFinalsChecker();
        member.visit((NodeVisitor)mfc);
        if (this.cCallList == null) {
            this.cCallList = new ArrayList();
        }
        this.cCallList.addAll(mfc.ccallList());
        AnonLocalClassInfo alci = new AnonLocalClassInfo();
        if (member instanceof ProcedureDecl) {
            ProcedureDecl procedure = (ProcedureDecl)member;
            alci.finalLocalsAvail(mfc.finalLocals());
            if (procedure.flags().flags().isStatic()) {
                alci.inStaticMethod(true);
            }
        } else if (member instanceof FieldDecl) {
            alci.finalLocalsAvail(new ArrayList<IdentityKey>());
            if (((FieldDecl)member).flags().flags().isStatic()) {
                alci.inStaticMethod(true);
            }
        } else if (member instanceof Initializer) {
            alci.finalLocalsAvail(mfc.finalLocals());
            if (((Initializer)member).flags().flags().isStatic()) {
                alci.inStaticMethod(true);
            }
        }
        if (this.finalLocalInfo == null) {
            this.finalLocalInfo = new HashMap();
        }
        Iterator<IdentityKey> it = mfc.inners().iterator();
        while (it.hasNext()) {
            ClassDef cType = (ClassDef)it.next().object();
            HashMap<IdentityKey, ArrayList<IdentityKey>> typeToLocalUsed = mfc.typeToLocalsUsed();
            ArrayList<IdentityKey> localsUsed = new ArrayList<IdentityKey>();
            if (typeToLocalUsed.containsKey(new IdentityKey((Object)cType))) {
                ArrayList<IdentityKey> localsNeeded = typeToLocalUsed.get(new IdentityKey((Object)cType));
                Iterator<IdentityKey> usesIt = localsNeeded.iterator();
                while (usesIt.hasNext()) {
                    LocalInstance li = (LocalInstance)usesIt.next().object();
                    if (!alci.finalLocalsAvail().contains(new IdentityKey((Object)li))) continue;
                    localsUsed.add(new IdentityKey((Object)li));
                }
            }
            AnonLocalClassInfo info = new AnonLocalClassInfo();
            info.inStaticMethod(alci.inStaticMethod());
            info.finalLocalsAvail(localsUsed);
            if (this.finalLocalInfo.containsKey(new IdentityKey((Object)cType))) continue;
            this.finalLocalInfo.put(new IdentityKey((Object)cType), info);
        }
    }

    public boolean isAnonInCCall(ClassType anonType) {
        for (ConstructorCall constructorCall : this.cCallList) {
            for (Object next : constructorCall.arguments()) {
                if (!(next instanceof New) || ((New)next).anonType() == null || !((New)next).anonType().asType().typeEquals((Type)anonType, null)) continue;
                return true;
            }
        }
        return false;
    }

    public BiMap getAnonClassMap() {
        return this.anonClassMap;
    }

    public BiMap getLocalClassMap() {
        return this.localClassMap;
    }

    public HashMap<IdentityKey, String> getAnonTypeMap() {
        return this.anonTypeMapping;
    }

    public HashMap<IdentityKey, String> getLocalTypeMap() {
        return this.localTypeMap;
    }

    public HashMap<IdentityKey, AnonLocalClassInfo> finalLocalInfo() {
        return this.finalLocalInfo;
    }

    public int getNextPrivateAccessCounter() {
        int res = this.privateAccessCounter++;
        return res;
    }

    public ArrayList getHasOuterRefInInit() {
        return this.hasOuterRefInInit;
    }

    public void setHasOuterRefInInit(ArrayList list) {
        this.hasOuterRefInInit = list;
    }

    public HashMap<SootClass, SootClass> specialAnonMap() {
        return this.specialAnonMap;
    }

    public void setSpecialAnonMap(HashMap<SootClass, SootClass> map) {
        this.specialAnonMap = map;
    }

    public void hierarchy(FastHierarchy fh) {
        this.hierarchy = fh;
    }

    public FastHierarchy hierarchy() {
        return this.hierarchy;
    }

    public HashMap<SootClass, InnerClassInfo> getInnerClassInfoMap() {
        return this.innerClassInfoMap;
    }

    public void setInnerClassInfoMap(HashMap<SootClass, InnerClassInfo> map) {
        this.innerClassInfoMap = map;
    }

    protected HashMap<String, String> classToSourceMap() {
        return this.classToSourceMap;
    }

    public void addToSootFieldGetAccessMap(SootField sm, SootMethod meth) {
        IdentityKey key = new IdentityKey((Object)sm);
        this.getSootFieldGetAccessMap().put(key, meth);
    }

    public SootMethod getSootFieldGetAccessMap(ClassMember sm) {
        return this.getSootFieldGetAccessMap().get(new IdentityKey((Object)sm));
    }

    private HashMap<IdentityKey, SootMethod> getSootFieldGetAccessMap() {
        if (this.sootFieldGetAccessMap == null) {
            this.sootFieldGetAccessMap = new HashMap();
        }
        return this.sootFieldGetAccessMap;
    }

    public void addToSootFieldSetAccessMap(SootField sm, SootMethod meth) {
        IdentityKey key = new IdentityKey((Object)sm);
        this.getSootFieldSetAccessMap().put(key, meth);
    }

    public SootMethod getSootFieldSetAccessMap(ClassMember sm) {
        return this.getSootFieldSetAccessMap().get(new IdentityKey((Object)sm));
    }

    private HashMap<IdentityKey, SootMethod> getSootFieldSetAccessMap() {
        if (this.sootFieldSetAccessMap == null) {
            this.sootFieldSetAccessMap = new HashMap();
        }
        return this.sootFieldSetAccessMap;
    }

    public void addToPrivateMethodGetAccessMap(SootMethod sm, SootMethod meth) {
        IdentityKey key = new IdentityKey((Object)sm);
        this.getPrivateMethodGetAccessMap().put(key, meth);
    }

    public SootMethod getPrivateMethodGetAccessMap(ClassMember sm) {
        return this.getPrivateMethodGetAccessMap().get(new IdentityKey((Object)sm));
    }

    private HashMap<IdentityKey, SootMethod> getPrivateMethodGetAccessMap() {
        if (this.privateMethodGetAccessMap == null) {
            this.privateMethodGetAccessMap = new HashMap();
        }
        return this.privateMethodGetAccessMap;
    }

    public ArrayList<String> getInterfacesList() {
        return this.interfacesList;
    }
}

