/*
 * Decompiled with CFR 0.152.
 */
package soot.HjToJimple;

import soot.Body;
import soot.BooleanType;
import soot.ByteType;
import soot.CharType;
import soot.DoubleType;
import soot.FloatType;
import soot.HjToJimple.jimple.ext.complex.ComplexUtils;
import soot.IntType;
import soot.Local;
import soot.LongType;
import soot.RefLikeType;
import soot.ShortType;
import soot.Type;
import soot.VoidType;
import soot.jimple.Jimple;

public class LocalGenerator {
    private Body body;
    private int tempInt = -1;
    private int tempVoid = -1;
    private int tempBoolean = -1;
    private int tempLong = -1;
    private int tempDouble = -1;
    private int tempFloat = -1;
    private int tempRefLikeType = -1;
    private int tempByte = -1;
    private int tempShort = -1;
    private int tempChar = -1;
    private int tempComplexD = -1;
    private int tempComplexF = -1;

    public LocalGenerator(Body b) {
        this.body = b;
    }

    public void setBody(Body b) {
        this.body = b;
    }

    private String generateLocalNewName(Type type) {
        String name = "v";
        if (type instanceof IntType) {
            name = this.nextLocalIntName();
        } else if (type instanceof ByteType) {
            name = this.nextLocalByteName();
        } else if (type instanceof ShortType) {
            name = this.nextLocalShortName();
        } else if (type instanceof BooleanType) {
            name = this.nextLocalBooleanName();
        } else if (type instanceof VoidType) {
            name = this.nextLocalVoidName();
        } else if (type instanceof CharType) {
            name = this.nextLocalCharName();
        } else if (type instanceof DoubleType) {
            name = this.nextLocalDoubleName();
        } else if (type instanceof FloatType) {
            name = this.nextLocalFloatName();
        } else if (type instanceof LongType) {
            name = this.nextLocalLongName();
        } else if (type instanceof RefLikeType) {
            name = this.nextLocalRefLikeTypeName();
        } else if (ComplexUtils.isComplex(type)) {
            name = this.nextLocalComplexName(type);
        } else {
            throw new RuntimeException("Unhandled Type of Local variable to Generate - Not Implemented: " + type + " --> " + type.getClass().getName());
        }
        return name;
    }

    private String generateNewName(Type type) {
        String name = "v";
        if (type instanceof IntType) {
            name = this.nextIntName();
        } else if (type instanceof ByteType) {
            name = this.nextByteName();
        } else if (type instanceof ShortType) {
            name = this.nextShortName();
        } else if (type instanceof BooleanType) {
            name = this.nextBooleanName();
        } else if (type instanceof VoidType) {
            name = this.nextVoidName();
        } else if (type instanceof CharType) {
            name = this.nextCharName();
        } else if (type instanceof DoubleType) {
            name = this.nextDoubleName();
        } else if (type instanceof FloatType) {
            name = this.nextFloatName();
        } else if (type instanceof LongType) {
            name = this.nextLongName();
        } else if (type instanceof RefLikeType) {
            name = this.nextRefLikeTypeName();
        } else if (ComplexUtils.isComplex(type)) {
            name = this.nextComplexName(type);
        } else {
            throw new RuntimeException("Unhandled Type of Local variable to Generate - Not Implemented: " + type + " --> " + type.getClass().getName());
        }
        return name;
    }

    public Local generateLocal(Type type) {
        String name = this.generateLocalNewName(type);
        return this.createLocal(name, type);
    }

    public Local generateLocal(String name, Type type) {
        String suffix = this.generateNewName(type);
        return this.createLocal(name + suffix, type);
    }

    private String nextIntName() {
        ++this.tempInt;
        return "i" + this.tempInt;
    }

    private String nextCharName() {
        ++this.tempChar;
        return "c" + this.tempChar;
    }

    private String nextVoidName() {
        ++this.tempVoid;
        return "v" + this.tempVoid;
    }

    private String nextByteName() {
        ++this.tempByte;
        return "b" + this.tempByte;
    }

    private String nextShortName() {
        ++this.tempShort;
        return "s" + this.tempShort;
    }

    private String nextBooleanName() {
        ++this.tempBoolean;
        return "z" + this.tempBoolean;
    }

    private String nextDoubleName() {
        ++this.tempDouble;
        return "d" + this.tempDouble;
    }

    private String nextFloatName() {
        ++this.tempFloat;
        return "f" + this.tempFloat;
    }

    private String nextLongName() {
        ++this.tempLong;
        return "l" + this.tempLong;
    }

    private String nextRefLikeTypeName() {
        ++this.tempRefLikeType;
        return "r" + this.tempRefLikeType;
    }

    private String nextComplexName(Type complexType) {
        if (ComplexUtils.isComplex64Type(complexType)) {
            ++this.tempComplexD;
            return "cd" + this.tempComplexD;
        }
        ++this.tempComplexF;
        return "cf" + this.tempComplexF;
    }

    private String nextLocalIntName() {
        ++this.tempInt;
        return "$i" + this.tempInt;
    }

    private String nextLocalCharName() {
        ++this.tempChar;
        return "$c" + this.tempChar;
    }

    private String nextLocalVoidName() {
        ++this.tempVoid;
        return "$v" + this.tempVoid;
    }

    private String nextLocalByteName() {
        ++this.tempByte;
        return "$b" + this.tempByte;
    }

    private String nextLocalShortName() {
        ++this.tempShort;
        return "$s" + this.tempShort;
    }

    private String nextLocalBooleanName() {
        ++this.tempBoolean;
        return "$z" + this.tempBoolean;
    }

    private String nextLocalDoubleName() {
        ++this.tempDouble;
        return "$d" + this.tempDouble;
    }

    private String nextLocalFloatName() {
        ++this.tempFloat;
        return "$f" + this.tempFloat;
    }

    private String nextLocalLongName() {
        ++this.tempLong;
        return "$l" + this.tempLong;
    }

    private String nextLocalRefLikeTypeName() {
        ++this.tempRefLikeType;
        return "$r" + this.tempRefLikeType;
    }

    private String nextLocalComplexName(Type complexType) {
        if (ComplexUtils.isComplex64Type(complexType)) {
            ++this.tempComplexD;
            return "$cd" + this.tempComplexD;
        }
        ++this.tempComplexF;
        return "$cf" + this.tempComplexF;
    }

    private Local createLocal(String name, Type sootType) {
        Local sootLocal = Jimple.v().newLocal(name, sootType);
        this.body.getLocals().add(sootLocal);
        return sootLocal;
    }
}

