/*
 * Decompiled with CFR 0.152.
 */
package soot.HjToJimple.jimple;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import soot.G;
import soot.HjToJimple.jimple.AsyncInvokeExpr;
import soot.SootMethodRef;
import soot.Unit;
import soot.UnitPrinter;
import soot.Value;
import soot.ValueBox;
import soot.baf.AsyncInvokeInst;
import soot.baf.Baf;
import soot.jimple.ConvertToBaf;
import soot.jimple.Jimple;
import soot.jimple.JimpleToBafContext;
import soot.jimple.internal.AbstractInvokeExpr;
import soot.options.Options;
import soot.tagkit.Tag;
import soot.util.Switch;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractAsyncInvokeExpr
extends AbstractInvokeExpr
implements AsyncInvokeExpr,
ConvertToBaf {
    AbstractAsyncInvokeExpr(SootMethodRef methodRef, List args) {
        this(methodRef, new ValueBox[args.size()]);
        for (int i = 0; i < args.size(); ++i) {
            this.argBoxes[i] = Jimple.v().newImmediateBox((Value)args.get(i));
        }
    }

    @Override
    public boolean equivTo(Object o) {
        if (o instanceof AbstractAsyncInvokeExpr) {
            AbstractAsyncInvokeExpr ie = (AbstractAsyncInvokeExpr)o;
            if (!this.getMethod().equals(ie.getMethod()) || this.argBoxes.length != ie.argBoxes.length) {
                return false;
            }
            for (ValueBox element : this.argBoxes) {
                if (element.getValue().equivTo(element.getValue())) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    @Override
    public int equivHashCode() {
        return this.getMethod().equivHashCode();
    }

    @Override
    public abstract Object clone();

    protected AbstractAsyncInvokeExpr(SootMethodRef methodRef, ValueBox[] argBoxes) {
        this.methodRef = methodRef;
        this.argBoxes = argBoxes;
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("asyncinvoke " + this.methodRef.getSignature() + "(");
        for (int i = 0; i < this.argBoxes.length; ++i) {
            if (i != 0) {
                buffer.append(", ");
            }
            buffer.append(this.argBoxes[i].getValue().toString());
        }
        buffer.append(")");
        return buffer.toString();
    }

    @Override
    public void toString(UnitPrinter up) {
        up.literal("asyncinvoke");
        up.literal(" ");
        up.methodRef(this.methodRef);
        up.literal("(");
        for (int i = 0; i < this.argBoxes.length; ++i) {
            if (i != 0) {
                up.literal(", ");
            }
            this.argBoxes[i].toString(up);
        }
        up.literal(")");
    }

    @Override
    public List getUseBoxes() {
        ArrayList<ValueBox> list = new ArrayList<ValueBox>();
        for (ValueBox element : this.argBoxes) {
            list.addAll(element.getValue().getUseBoxes());
            list.add(element);
        }
        return list;
    }

    @Override
    public void apply(Switch sw) {
    }

    @Override
    public void convertToBaf(JimpleToBafContext context, List<Unit> out) {
        if (Options.v().hjVerbose()) {
            G.v().out.println("Convert to BAF!!");
        }
        for (ValueBox element : this.argBoxes) {
            ((ConvertToBaf)((Object)element.getValue())).convertToBaf(context, out);
        }
        AsyncInvokeInst u = Baf.v().newAsyncInvokeInst(this.methodRef);
        out.add(u);
        Unit currentUnit = context.getCurrentUnit();
        Iterator<Tag> it = currentUnit.getTags().iterator();
        while (it.hasNext()) {
            u.addTag(it.next());
        }
    }
}

