/*
 * Decompiled with CFR 0.152.
 */
package soot.HjToJimple.jimple;

import java.util.ArrayList;
import java.util.List;
import polyglot.ast.Call;
import polyglot.ast.Field;
import polyglot.ast.ProcedureCall;
import polyglot.types.LocalInstance;
import soot.HjToJimple.InitialResolver;
import soot.HjToJimple.Util;
import soot.MethodSource;
import soot.RefType;
import soot.SootClass;
import soot.SootField;
import soot.SootMethod;
import soot.Type;
import soot.javaToJimple.PrivateFieldAccMethodSource;
import soot.javaToJimple.PrivateFieldSetMethodSource;
import soot.javaToJimple.PrivateMethodAccMethodSource;
import soot.tagkit.SyntheticTag;

public class AccessMethodsGenerator {
    public static SootMethod addGetFieldAccessMeth(SootClass conClass, Field field) {
        SootField sf = conClass.getField(field.name().toString(), Util.getSootType(field.fieldInstance().type()));
        SootMethod meth = AccessMethodsGenerator.addGetFieldAccessMeth(sf);
        return meth;
    }

    public static SootMethod addSetFieldAccessMeth(SootClass conClass, Field field) {
        SootField sf = conClass.getFieldFromCH(field.name().toString(), Util.getSootType(field.fieldInstance().type()));
        SootMethod meth = AccessMethodsGenerator.addSetFieldAccessMeth(sf);
        return meth;
    }

    public static SootMethod addSetFieldAccessMeth(SootField field) {
        SootMethod meth = InitialResolver.v().getSootFieldSetAccessMap(field);
        if (meth != null) {
            return meth;
        }
        meth = AccessMethodsGenerator.addFieldAccessMethImpl(field, true);
        InitialResolver.v().addToSootFieldSetAccessMap(field, meth);
        return meth;
    }

    public static SootMethod addGetFieldAccessMeth(SootField field) {
        SootMethod meth = InitialResolver.v().getSootFieldGetAccessMap(field);
        if (meth != null) {
            return meth;
        }
        meth = AccessMethodsGenerator.addFieldAccessMethImpl(field, false);
        InitialResolver.v().addToSootFieldGetAccessMap(field, meth);
        return meth;
    }

    private static SootMethod addFieldAccessMethImpl(SootField field, boolean isSetter) {
        SootClass targetClass = field.getDeclaringClass();
        Type fieldType = field.getType();
        ArrayList<Type> paramTypes = new ArrayList<Type>(2);
        if (!field.isStatic()) {
            paramTypes.add(targetClass.getType());
        }
        if (isSetter) {
            paramTypes.add(fieldType);
        }
        Type returnType = fieldType;
        SootMethod meth = AccessMethodsGenerator.createMethodAccessor(paramTypes, returnType);
        MethodSource accessorMth = null;
        accessorMth = isSetter ? new PrivateFieldSetMethodSource(fieldType, field.getName(), field.isStatic()) : new PrivateFieldAccMethodSource(fieldType, field.getName(), field.isStatic());
        targetClass.addMethod(meth);
        meth.setActiveBody(accessorMth.getBody(meth, null));
        return meth;
    }

    public static SootMethod addMethodAccessMeth(SootClass conClass, Call call) {
        SootMethod sm = conClass.getMethod(call.name().toString(), Util.getSootParamsTypes((ProcedureCall)call), Util.getSootType(call.methodInstance().returnType()));
        return AccessMethodsGenerator.addMethodAccessMeth(sm);
    }

    public static SootMethod addMethodAccessMeth(SootMethod sm) {
        SootClass targetClass = sm.getDeclaringClass();
        SootMethod meth = InitialResolver.v().getPrivateMethodGetAccessMap(sm);
        if (meth != null) {
            return meth;
        }
        ArrayList<RefType> paramTypes = new ArrayList<RefType>();
        if (!sm.isStatic()) {
            paramTypes.add(targetClass.getType());
        }
        paramTypes.addAll(sm.getParameterTypes());
        meth = AccessMethodsGenerator.createMethodAccessor(paramTypes, sm.getReturnType());
        PrivateMethodAccMethodSource pmams = new PrivateMethodAccMethodSource(targetClass, sm.getName(), sm.isStatic());
        targetClass.addMethod(meth);
        meth.setActiveBody(pmams.getBody(meth, null));
        InitialResolver.v().addToPrivateMethodGetAccessMap(sm, meth);
        return meth;
    }

    public static String getNextAccessorName() {
        String name = "access$" + InitialResolver.v().getNextPrivateAccessCounter() + "00";
        return name;
    }

    public static SootMethod createMethodAccessor(List paramTypes, Type returnType) {
        String name = AccessMethodsGenerator.getNextAccessorName();
        SootMethod meth = new SootMethod(name, paramTypes, returnType, 8);
        meth.addTag(new SyntheticTag());
        return meth;
    }

    public static MethodSource createMethodSource(Type fieldType, String fieldName, boolean isStatic, SootClass classToInvoke) {
        PrivateFieldAccMethodSource src = new PrivateFieldAccMethodSource(fieldType, fieldName, isStatic);
        return src;
    }

    public static SootMethod makeSuperAccessMethod(SootClass classToInvoke, Object memberToAccess) {
        SootMethod meth;
        ArrayList<RefType> paramTypes = new ArrayList<RefType>();
        paramTypes.add(classToInvoke.getType());
        if (memberToAccess instanceof Field) {
            Field fieldToAccess = (Field)memberToAccess;
            SootClass targetSootClass = ((RefType)Util.getSootType(fieldToAccess.target().type())).getSootClass();
            meth = AccessMethodsGenerator.addGetFieldAccessMeth(targetSootClass, fieldToAccess);
        } else if (memberToAccess instanceof Call) {
            Call methToAccess = (Call)memberToAccess;
            SootClass targetSootClass = ((RefType)Util.getSootType((polyglot.types.Type)methToAccess.methodInstance().container())).getSootClass();
            meth = AccessMethodsGenerator.addMethodAccessMeth(targetSootClass, methToAccess);
        } else {
            throw new RuntimeException("trying to access unhandled member type: " + memberToAccess);
        }
        return meth;
    }

    public static SootMethod makeLiFieldAccessMethod(SootClass classToInvoke, LocalInstance li) {
        String name = AccessMethodsGenerator.getNextAccessorName();
        ArrayList<RefType> paramTypes = new ArrayList<RefType>();
        paramTypes.add(classToInvoke.getType());
        SootMethod meth = AccessMethodsGenerator.createMethodAccessor(paramTypes, Util.getSootType(li.type()));
        classToInvoke.addMethod(meth);
        PrivateFieldAccMethodSource src = new PrivateFieldAccMethodSource(Util.getSootType(li.type()), "val$" + li.name(), false);
        meth.setActiveBody(src.getBody(meth, null));
        return meth;
    }
}

