/*
 * Decompiled with CFR 0.152.
 */
package soot.HjToJimple.jimple;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import soot.Body;
import soot.G;
import soot.HjToJimple.jimple.RegionStmt;
import soot.HjToJimple.util.CFGNode;
import soot.HjToJimple.util.CFGNode_c;
import soot.HjToJimple.util.RSTNode;
import soot.Singletons;
import soot.SootMethod;
import soot.jimple.Stmt;
import soot.toolkits.graph.BriefUnitGraph;
import soot.toolkits.graph.InverseGraph;
import soot.toolkits.graph.MHGPostDominatorsFinder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HjRCFGBuilder {
    private int level = 0;

    public HjRCFGBuilder(Singletons.Global g) {
    }

    public static HjRCFGBuilder v() {
        return G.v().soot_HjToJimple_jimple_HjRCFGBuilder();
    }

    public void buildRCFG(RSTNode rstNode, Body body, MHGPostDominatorsFinder mhgDominator) {
        this.buildRCFG(rstNode, null);
    }

    public void buildRCFG(RSTNode rstNode, HashMap<Stmt, CFGNode> stmtCFGMap) {
        if (rstNode.getSubNodes().size() == 0) {
            return;
        }
        if (stmtCFGMap == null) {
            stmtCFGMap = new HashMap();
        }
        if (!rstNode.isMethodNode()) {
            throw new RuntimeException("This buildRCFG method must be applied to method RST node");
        }
        SootMethod method = rstNode.getNodeMethod();
        Body body = method.retrieveActiveBody();
        MHGPostDominatorsFinder mhgDominator = new MHGPostDominatorsFinder(new BriefUnitGraph(body));
        this.buildRCFG(rstNode, body, mhgDominator, stmtCFGMap, true);
        this.checkAll(rstNode.getRCFG());
    }

    public void buildRCFG(RSTNode rstNode, Body body, MHGPostDominatorsFinder dominator, HashMap<Stmt, CFGNode> stmtCFGMap, boolean handleMethod) {
        CFGNode rcfgNode;
        if (rstNode.getSubNodes().size() == 0) {
            return;
        }
        if (stmtCFGMap == null) {
            stmtCFGMap = new HashMap();
        } else {
            stmtCFGMap.clear();
        }
        if (rstNode.isMethodNode()) {
            rcfgNode = this.buildRCFGInternal(null, (Stmt)body.getUnits().getFirst(), (Stmt)body.getUnits().getLast(), body, dominator, (InverseGraph)dominator.getGraph(), stmtCFGMap);
        } else if (rstNode.isForLoopNode()) {
            RegionStmt startStmt = rstNode.getRegionStmt();
            Stmt endStmt = startStmt.getConnect();
            rcfgNode = this.buildRCFGInternal(null, startStmt, endStmt, body, dominator, (InverseGraph)dominator.getGraph(), stmtCFGMap);
        } else {
            rcfgNode = this.buildRCFGInternal(null, rstNode.getRegionStmt(), rstNode.getRegionStmt().getConnect(), body, dominator, (InverseGraph)dominator.getGraph(), stmtCFGMap);
        }
        rcfgNode = this.cleanUpRCFG(rcfgNode);
        rstNode.setRCFG(rcfgNode);
        for (RSTNode node : rstNode.getSubNodes()) {
            if (node.isMethodNode()) {
                if (!handleMethod) continue;
                this.buildRCFG(node, stmtCFGMap);
                continue;
            }
            this.buildRCFG(node, body, dominator, stmtCFGMap, handleMethod);
        }
    }

    protected CFGNode cleanUpRCFG(CFGNode currentNode) {
        if (currentNode.getOuts() == null) {
            return currentNode;
        }
        List<Object> nodeList = new ArrayList<CFGNode>();
        nodeList.addAll(currentNode.getOuts());
        for (CFGNode cFGNode : nodeList) {
            CFGNode cleanNode;
            if (cFGNode == (cleanNode = this.cleanUpRCFG(cFGNode))) continue;
            currentNode.removeOut(cFGNode);
            currentNode.addOut(cleanNode);
        }
        nodeList = currentNode.getOuts();
        if (nodeList.size() == 2 && nodeList.get(0) == nodeList.get(1)) {
            assert (((CFGNode)nodeList.get(0)).getNodeStmt() == ((CFGNode)nodeList.get(1)).getNodeStmt());
            assert (!(currentNode.getNodeStmt() instanceof RegionStmt));
            CFGNode cFGNode = (CFGNode)nodeList.get(0);
            cFGNode.getIns().clear();
            cFGNode.getIns().addAll(currentNode.getIns());
            for (CFGNode inNode : currentNode.getIns()) {
                while (inNode.getOuts().remove(currentNode)) {
                }
            }
        }
        return currentNode;
    }

    protected CFGNode buildRCFGInternal(CFGNode currentNode, Stmt startStmt, Stmt endStmt, Body body, MHGPostDominatorsFinder dominator, InverseGraph graph, HashMap<Stmt, CFGNode> stmtCFGMap) {
        CFGNode_c node;
        CFGNode returnNode = currentNode;
        if (currentNode == null) {
            returnNode = currentNode = new CFGNode_c(startStmt);
            startStmt = (Stmt)body.getUnits().getSuccOf(startStmt);
        }
        stmtCFGMap.put(startStmt, null);
        List<Stmt> predList = graph.getSuccsOf(startStmt);
        if (predList.size() > 1 && currentNode != null) {
            node = new CFGNode_c(startStmt);
            currentNode.addOut(node);
            node.addIn(currentNode);
            currentNode = node;
            stmtCFGMap.put(startStmt, node);
        }
        if (startStmt == endStmt) {
            return returnNode;
        }
        if (startStmt instanceof RegionStmt) {
            Stmt connectStmt;
            if (stmtCFGMap.get(startStmt) == null) {
                node = new CFGNode_c(startStmt);
                currentNode.addOut(node);
                node.addIn(currentNode);
                currentNode = node;
                stmtCFGMap.put(startStmt, node);
            }
            if (!stmtCFGMap.containsKey(startStmt = (connectStmt = ((RegionStmt)startStmt).getConnect()) != null ? (Stmt)body.getUnits().getSuccOf(connectStmt) : (Stmt)body.getUnits().getSuccOf(startStmt))) {
                this.buildRCFGInternal(currentNode, startStmt, endStmt, body, dominator, graph, stmtCFGMap);
            }
            return returnNode;
        }
        if (startStmt == endStmt) {
            return returnNode;
        }
        List<Stmt> succList = graph.getPredsOf(startStmt);
        if (succList.size() > 1) {
            if (stmtCFGMap.get(startStmt) == null) {
                CFGNode_c node2 = new CFGNode_c(startStmt);
                currentNode.addOut(node2);
                node2.addIn(currentNode);
                currentNode = node2;
                stmtCFGMap.put(startStmt, node2);
            }
            for (int i = 0; i < succList.size(); ++i) {
                Stmt succStmt = succList.get(i);
                if (stmtCFGMap.containsKey(succStmt)) {
                    CFGNode cfgNode = stmtCFGMap.get(succStmt);
                    if (cfgNode == null) continue;
                    try {
                        currentNode.addOut(cfgNode);
                        cfgNode.addIn(currentNode);
                    }
                    catch (Exception e) {}
                    continue;
                }
                this.buildRCFGInternal(currentNode, succStmt, endStmt, body, dominator, graph, stmtCFGMap);
            }
        } else {
            Stmt succStmt;
            if (succList.size() < 1) {
                return returnNode;
            }
            while (!stmtCFGMap.containsKey(startStmt)) {
                List<Stmt> nodeList;
                if (startStmt == endStmt) {
                    return returnNode;
                }
                if (startStmt instanceof RegionStmt || graph.getPredsOf(startStmt).size() > 0 || (nodeList = graph.getPredsOf(startStmt)).size() > 0) break;
                startStmt = nodeList.get(0);
            }
            if (!stmtCFGMap.containsKey(succStmt = succList.get(0))) {
                this.buildRCFGInternal(currentNode, succStmt, endStmt, body, dominator, graph, stmtCFGMap);
            }
        }
        return returnNode;
    }

    private void checkAll(CFGNode rcfgNode) {
        if (rcfgNode == null) {
            return;
        }
        if (rcfgNode.getOuts() != null) {
            for (CFGNode subNode : rcfgNode.getOuts()) {
                this.checkAll(subNode);
            }
        } else {
            this.checkAll(rcfgNode.getOut());
        }
    }
}

