/*
 * Decompiled with CFR 0.152.
 */
package soot.HjToJimple.jimple;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import soot.ArrayType;
import soot.Body;
import soot.BodyTransformer;
import soot.BooleanType;
import soot.G;
import soot.HjToJimple.LocalGenerator;
import soot.HjToJimple.Util;
import soot.HjToJimple.jimple.ActivityClassBuilder;
import soot.HjToJimple.jimple.AsyncRegionExpr;
import soot.HjToJimple.jimple.AsyncRegionStmt;
import soot.HjToJimple.jimple.FinishRegionExpr;
import soot.HjToJimple.jimple.HjAsyncRegionStmt;
import soot.HjToJimple.jimple.HjFutureReturn;
import soot.HjToJimple.jimple.HjRegionStmt;
import soot.HjToJimple.jimple.IsolatedRegionExpr;
import soot.HjToJimple.jimple.LoopRegionExpr;
import soot.HjToJimple.jimple.Region;
import soot.HjToJimple.jimple.Region1TStmt;
import soot.HjToJimple.jimple.RegionExit;
import soot.HjToJimple.jimple.RegionStmt;
import soot.HjToJimple.jimple.TargetedHjRuntime;
import soot.HjToJimple.jimple.factory.HjClassFactory;
import soot.HjToJimple.jimple.factory.HjStmtFactory;
import soot.HjToJimple.util.HjObject;
import soot.HjToJimple.util.Phaser;
import soot.IntType;
import soot.Local;
import soot.PatchingChain;
import soot.RefType;
import soot.Scene;
import soot.Singletons;
import soot.SootClass;
import soot.SootField;
import soot.SootMethod;
import soot.SootMethodRef;
import soot.Trap;
import soot.Type;
import soot.Unit;
import soot.Value;
import soot.ValueBox;
import soot.VoidType;
import soot.jimple.AssignStmt;
import soot.jimple.DefinitionStmt;
import soot.jimple.ExitMonitorStmt;
import soot.jimple.GotoStmt;
import soot.jimple.IdentityStmt;
import soot.jimple.IfStmt;
import soot.jimple.InstanceFieldRef;
import soot.jimple.IntConstant;
import soot.jimple.InvokeStmt;
import soot.jimple.Jimple;
import soot.jimple.JimpleBody;
import soot.jimple.LookupSwitchStmt;
import soot.jimple.NewExpr;
import soot.jimple.NopStmt;
import soot.jimple.ParameterRef;
import soot.jimple.ReturnStmt;
import soot.jimple.ReturnVoidStmt;
import soot.jimple.SpecialInvokeExpr;
import soot.jimple.StaticInvokeExpr;
import soot.jimple.Stmt;
import soot.jimple.StmtBody;
import soot.jimple.TableSwitchStmt;
import soot.jimple.ThrowStmt;
import soot.jimple.VirtualInvokeExpr;
import soot.options.Options;
import soot.tagkit.EnclosingTag;
import soot.tagkit.IntegerConstantValueTag;
import soot.tagkit.SyntheticTag;
import soot.util.Chain;
import soot.util.HashChain;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HjRuntimeTranslator
extends BodyTransformer {
    protected ArrayList<SootClass> extraClasses = new ArrayList();
    protected Body origBody;
    protected Local origThisLocal;
    protected int innerClassCounter = 0;
    public static final String JAVALANGOBJECT_CLASSNAME = "java.lang.Object";
    public static final String JAVALANGNOTIFYALL_METHODNAME = "notifyAll";

    public HjRuntimeTranslator(Singletons.Global g) {
    }

    public static HjRuntimeTranslator v() {
        return G.v().soot_HjToJimple_jimple_HjRuntimeTranslator();
    }

    protected static void createHjRuntimeTargetField(SootClass c) {
        SootField runtimeField = new SootField("HJ_RUNTIME_FLAG__", IntType.v(), 25);
        c.addField(runtimeField);
        int rtConstant = 0;
        if (TargetedHjRuntime.isRuntimeWorkSharing()) {
            rtConstant = 1;
        }
        if (TargetedHjRuntime.isRuntimeWorkStealingHelpFirst()) {
            rtConstant = 2;
        }
        if (TargetedHjRuntime.isRuntimeWorkStealingWorkFirst()) {
            rtConstant = 3;
        }
        if (TargetedHjRuntime.isRuntimeWorkStealingAdaptive()) {
            rtConstant = 4;
        }
        assert (rtConstant != 0);
        runtimeField.addTag(new IntegerConstantValueTag(rtConstant));
    }

    protected static void createRaceDetField(SootClass c) {
        SootField raceDetField = new SootField("HJ_RACE_DET_FLAG__", IntType.v(), 25);
        c.addField(raceDetField);
        raceDetField.addTag(new IntegerConstantValueTag(Options.v().racedet() ? 1 : 0));
    }

    protected static void createOVDField(SootClass c) {
        SootField raceDetField = new SootField("HJ_OVD_FLAG__", IntType.v(), 25);
        c.addField(raceDetField);
        raceDetField.addTag(new IntegerConstantValueTag(Options.v().ovd() ? 1 : 0));
    }

    @Override
    protected void internalTransform(Body body, String phaseName, Map opts) {
        SootMethod method = body.getMethod();
        this.extraClasses.clear();
        if (Options.v().hjVerbose()) {
            G.v().out.println("MPIR: " + body);
        }
        if (Util.isMainMethod(method) && TargetedHjRuntime.isRuntimeWorkSharing()) {
            SootClass c = body.getMethod().getDeclaringClass();
            this.createWshMainClass(body);
            HjRuntimeTranslator.createHjRuntimeTargetField(c);
            HjRuntimeTranslator.createRaceDetField(c);
            HjRuntimeTranslator.createOVDField(c);
        }
        this.origBody = body;
        if (!body.getMethod().isStatic()) {
            this.origThisLocal = body.getThisLocal();
        }
        this.hjRuntimeTransform(body, phaseName, opts, null);
        this.nopElimination(this.extraClasses.iterator());
        Scene.v().extraClasses.addAll(this.extraClasses);
    }

    protected void nopElimination(Iterator<SootClass> classIter) {
        ArrayList<Stmt> nopsList = new ArrayList<Stmt>();
        while (classIter.hasNext()) {
            Iterator<SootMethod> methodIter = classIter.next().methodIterator();
            while (methodIter.hasNext()) {
                Body methodBody = methodIter.next().retrieveActiveBody();
                StmtBody stmtBody = (StmtBody)methodBody;
                PatchingChain<Unit> units = stmtBody.getUnits();
                HashMap rtStmtMap = new HashMap();
                ArrayList removeStmts = new ArrayList();
                ArrayList rtTraps = new ArrayList();
                for (Stmt stmt : units) {
                    if (!(stmt instanceof NopStmt)) continue;
                    nopsList.add(stmt);
                }
                Iterator iterator = nopsList.iterator();
                while (iterator.hasNext()) {
                    methodBody.getUnits().remove(iterator.next());
                }
                nopsList.clear();
            }
        }
    }

    protected void checkAll(Iterator<SootClass> classIter) {
        ArrayList nopsList = new ArrayList();
        while (classIter.hasNext()) {
            Iterator<SootMethod> methodIter = classIter.next().methodIterator();
            while (methodIter.hasNext()) {
                if (!Options.v().hjVerbose()) continue;
                G.v().out.println("Method Body: " + methodIter.next().retrieveActiveBody());
            }
        }
    }

    protected SootClass createWshMainClass(Body body) {
        SootClass bodyClass = body.getMethod().getDeclaringClass();
        SootClass mainClass = new SootClass(bodyClass.getName() + "$Main", 9);
        mainClass.setOuterClass(bodyClass);
        mainClass.setSuperclass(Scene.v().getSootClass("hj.runtime.wsh.Activity"));
        HashMap<Local, SootField> classParams = new HashMap<Local, SootField>();
        Iterator typeIter = body.getMethod().getParameterTypes().iterator();
        Type formFieldType = (Type)typeIter.next();
        SootField formField = new SootField("form", formFieldType, 18);
        formField.addTag(new SyntheticTag());
        mainClass.addField(formField);
        JimpleBody methodBody = Jimple.v().newBody();
        SootMethod taskMethod = new SootMethod("runHjTask", Collections.EMPTY_LIST, VoidType.v(), 1);
        methodBody.setMethod(taskMethod);
        taskMethod.setActiveBody(methodBody);
        taskMethod.setDeclaringClass(mainClass);
        mainClass.addMethod(taskMethod);
        Local thisLocal = Jimple.v().newLocal("tl", mainClass.getType());
        methodBody.getLocals().add(thisLocal);
        methodBody.getUnits().add(Jimple.v().newIdentityStmt(thisLocal, Jimple.v().newThisRef(mainClass.getType())));
        Local formLocal = Jimple.v().newLocal("form", formField.getType());
        methodBody.getLocals().add(formLocal);
        InstanceFieldRef fieldRef = Jimple.v().newInstanceFieldRef(thisLocal, formField.makeRef());
        AssignStmt assignStmt = Jimple.v().newAssignStmt(formLocal, fieldRef);
        methodBody.getUnits().add(assignStmt);
        ArrayList<Local> mainParams = new ArrayList<Local>();
        mainParams.add(formLocal);
        StaticInvokeExpr staticInvoke = Jimple.v().newStaticInvokeExpr(body.getMethod().makeRef(), mainParams);
        InvokeStmt invokeStmt = Jimple.v().newInvokeStmt(staticInvoke);
        methodBody.getUnits().add(invokeStmt);
        methodBody.getUnits().add(Jimple.v().newReturnVoidStmt());
        this.createDefaultIsHjTaskReadyMethod(mainClass);
        classParams.put(formLocal, formField);
        this.createInitMethod(mainClass, classParams);
        this.extraClasses.add(mainClass);
        return mainClass;
    }

    protected void hjRuntimeTransform(Body body, String phaseName, Map opts, ArrayList outerBranchItems) {
        StmtBody stmtBody = (StmtBody)body;
        PatchingChain<Unit> units = stmtBody.getUnits();
        HashMap<Stmt, ArrayList<Stmt>> rtStmtMap = new HashMap<Stmt, ArrayList<Stmt>>();
        ArrayList<Stmt> removeStmts = new ArrayList<Stmt>();
        ArrayList<Trap> rtTraps = new ArrayList<Trap>();
        ArrayList branchItems = outerBranchItems != null ? outerBranchItems : new ArrayList();
        Iterator stmtIt = units.iterator();
        while (stmtIt.hasNext()) {
            Stmt stmt = (Stmt)stmtIt.next();
            if (!(stmt instanceof RegionStmt)) continue;
            Region regionExpr = ((RegionStmt)stmt).getRegionExpr();
            if (regionExpr instanceof AsyncRegionExpr) {
                this.handleAsyncRegion((RegionStmt)stmt, body, stmtIt, rtStmtMap, removeStmts, branchItems);
                continue;
            }
            if (regionExpr instanceof FinishRegionExpr) {
                if (TargetedHjRuntime.isRuntimeWorkStealingHelpFirst()) {
                    this.handleHabFinishRegion((RegionStmt)stmt, body, stmtIt, rtStmtMap, removeStmts, rtTraps, branchItems);
                    continue;
                }
                this.handleFinishRegion((RegionStmt)stmt, body, stmtIt, rtStmtMap, removeStmts, rtTraps, branchItems);
                continue;
            }
            if (regionExpr instanceof IsolatedRegionExpr) {
                this.handleIsolatedRegion((RegionStmt)stmt, body, stmtIt, rtStmtMap, removeStmts, rtTraps, branchItems);
                continue;
            }
            if (!(regionExpr instanceof LoopRegionExpr)) continue;
            this.handleLoopRegion((RegionStmt)stmt, removeStmts);
        }
        for (Stmt stmt : rtStmtMap.keySet()) {
            ArrayList rtStmts = (ArrayList)rtStmtMap.get(stmt);
            for (Stmt rtStmt : rtStmts) {
                body.getUnits().insertBefore(rtStmt, (Unit)stmt);
            }
        }
        Iterator trapIter = rtTraps.iterator();
        while (trapIter.hasNext()) {
            this.sortAndAddTrap(body, (Trap)trapIter.next());
        }
        Iterator stmtIter = removeStmts.iterator();
        while (stmtIter.hasNext()) {
            body.getUnits().remove(stmtIter.next());
        }
        if (outerBranchItems == null) {
            Iterator branchItemIter = branchItems.iterator();
            while (branchItemIter.hasNext()) {
                Object branchItem = branchItemIter.next();
                if (!(branchItem instanceof Trap)) continue;
                Trap trap = (Trap)branchItem;
                trap.setBeginUnit((Unit)branchItemIter.next());
                trap.setEndUnit((Unit)branchItemIter.next());
                trap.setHandlerUnit((Unit)branchItemIter.next());
            }
        }
    }

    protected void sortAndAddTrap(Body body, Trap trap) {
        Iterator<Trap> trapIter = body.getTraps().snapshotIterator();
        while (trapIter.hasNext()) {
            Trap currTrap = trapIter.next();
            Unit begUnit = currTrap.getBeginUnit();
            Unit endUnit = currTrap.getEndUnit();
            Unit newBegUnit = trap.getBeginUnit();
            Unit newEndUnit = trap.getEndUnit();
            if (begUnit != newBegUnit && !body.getUnits().follows(newBegUnit, begUnit) || endUnit != newEndUnit && !body.getUnits().follows(endUnit, newEndUnit)) continue;
            body.getTraps().insertBefore(trap, currTrap);
            return;
        }
        body.getTraps().add(trap);
    }

    protected void checkUses(Stmt s, HashChain<Local> outerMethodLocals, HashChain<Local> methodLocals, HashMap<Local, SootField> classParams) {
        Object[] uses = s.getUseBoxes().toArray();
        for (int i = 0; i < uses.length; ++i) {
            Value v = ((ValueBox)uses[i]).getValue();
            if (methodLocals.contains(v) || !outerMethodLocals.contains(v)) continue;
            methodLocals.add((Local)v);
            classParams.put((Local)v, this.createField((Local)v));
        }
    }

    protected void checkDefs(Stmt s, HashChain<Local> outerMethodLocals, HashChain<Local> methodLocals, HashMap<Local, SootField> classParams) {
        Object[] defs = s.getDefBoxes().toArray();
        for (int i = 0; i < defs.length; ++i) {
            Value v = ((ValueBox)defs[i]).getValue();
            if (methodLocals.contains(v) || !outerMethodLocals.contains(v)) continue;
            methodLocals.add((Local)v);
            outerMethodLocals.remove(v);
        }
    }

    protected void handleAsyncRegion(RegionStmt asyncRegionStmt, Body body, Iterator stmtIt, HashMap<Stmt, ArrayList<Stmt>> rtStmtMap, ArrayList<Stmt> removeStmts, ArrayList branchItems) {
        Body taskMethodBody;
        if (Options.v().hjVerbose()) {
            G.v().out.println("HjToJimple handle async region");
        }
        AsyncRegionExpr asyncRegion = (AsyncRegionExpr)asyncRegionStmt.getRegionExpr();
        ArrayList<Stmt> runtimeStmts = new ArrayList<Stmt>();
        Local retLocal = null;
        if (asyncRegionStmt instanceof AsyncRegionStmt) {
            retLocal = (Local)((AsyncRegionStmt)asyncRegionStmt).getLeftOp();
        }
        SootClass bodyClass = body.getMethod().getDeclaringClass();
        SootClass activityClass = new SootClass(bodyClass.getName() + "GenAsync$" + this.innerClassCounter++);
        activityClass.setOuterClass(bodyClass);
        activityClass.setSuperclass(Scene.v().getSootClass("hj.runtime.wsh.Activity"));
        HashMap<Local, SootField> classParams = new HashMap<Local, SootField>();
        if (asyncRegionStmt instanceof Region1TStmt && ((Region1TStmt)asyncRegionStmt).getLabel() != null) {
            RegionStmt statusLabel = ((Region1TStmt)asyncRegionStmt).getLabel();
            ActivityClassBuilder.v().createCondIsHjTaskReadyMethod(activityClass, asyncRegionStmt, statusLabel, body, stmtIt, classParams, removeStmts, this.origThisLocal);
            taskMethodBody = this.createRunHjTaskMethod(activityClass, asyncRegionStmt, body, stmtIt, classParams, removeStmts, branchItems);
        } else {
            taskMethodBody = this.createRunHjTaskMethod(activityClass, asyncRegionStmt, body, stmtIt, classParams, removeStmts, branchItems);
            this.createDefaultIsHjTaskReadyMethod(activityClass);
        }
        Local outerThisLocal = body.getMethod().isStatic() ? null : body.getThisLocal();
        ArrayList<Value> phaserListClassParams = new ArrayList<Value>();
        SootClass phaserListClass = null;
        if (asyncRegion.isPhased()) {
            if (asyncRegion.hasDynamicPhaserList()) {
                phaserListClass = Scene.v().getSootClass("java.util.List");
                Phaser ph = asyncRegion.getPhasers().get(0);
                phaserListClassParams.add(ph.getLocalValue());
            } else {
                phaserListClass = ActivityClassBuilder.v().handlePhasers(asyncRegion.getPhasers(), body, runtimeStmts, outerThisLocal, phaserListClassParams, this.innerClassCounter);
                this.extraClasses.add(phaserListClass);
            }
            assert (phaserListClass != null);
        }
        ActivityClassBuilder.v().createInitMethod(activityClass, classParams, phaserListClass);
        this.extraClasses.add(activityClass);
        ActivityClassBuilder.v().createRuntimeStmts(asyncRegion, activityClass, phaserListClass, phaserListClassParams, body, classParams, asyncRegion.getPlace(), asyncRegion.getDDFs(), retLocal, runtimeStmts);
        rtStmtMap.put(asyncRegionStmt, runtimeStmts);
        removeStmts.add(asyncRegionStmt);
        this.hjRuntimeTransform(taskMethodBody, null, null, branchItems);
    }

    protected void checkTraps(Body body, Body methodBody, Chain<Trap> traps, Stmt regionEntryStmt, Stmt regionExitStmt, HashMap<Stmt, Stmt> branchMap, ArrayList branchItems) {
        for (Trap trap : traps) {
            Stmt beginStmt = (Stmt)trap.getBeginUnit();
            if (body.getUnits().contains(beginStmt) && (!body.getUnits().follows(beginStmt, regionEntryStmt) || !body.getUnits().follows(regionExitStmt, beginStmt))) continue;
            methodBody.getTraps().add(trap);
            branchItems.add(trap);
            Unit unit = trap.getBeginUnit();
            if (branchMap.containsKey((Stmt)unit)) {
                unit = branchMap.get((Stmt)unit);
            }
            branchItems.add(unit);
            unit = trap.getEndUnit();
            if (branchMap.containsKey((Stmt)unit)) {
                unit = branchMap.get((Stmt)unit);
            }
            branchItems.add(unit);
            branchItems.add(trap.getHandlerUnit());
        }
        Iterator<Trap> trapIter = methodBody.getTraps().iterator();
        while (trapIter.hasNext()) {
            body.getTraps().remove(trapIter.next());
        }
    }

    protected Body createRunHjTaskMethod(SootClass activityClass, RegionStmt asyncRegionStmt, Body body, Iterator stmtIt, HashMap<Local, SootField> classParams, ArrayList<Stmt> removeStmts, ArrayList branchItems) {
        SootField field;
        JimpleBody methodBody = Jimple.v().newBody();
        SootMethod taskMethod = new SootMethod("runHjTask", Collections.EMPTY_LIST, VoidType.v(), 1);
        methodBody.setMethod(taskMethod);
        taskMethod.setActiveBody(methodBody);
        taskMethod.setDeclaringClass(activityClass);
        activityClass.addMethod(taskMethod);
        LocalGenerator lg = new LocalGenerator(body);
        Local thisLocal = Jimple.v().newLocal("tl", activityClass.getType());
        methodBody.getLocals().add(thisLocal);
        Local outerThisLocal = null;
        if (!body.getMethod().isStatic()) {
            outerThisLocal = body.getThisLocal();
        }
        Local newThisLocal = null;
        if (this.origThisLocal != null) {
            newThisLocal = Jimple.v().newLocal("tl", activityClass.getType());
            methodBody.getLocals().add(newThisLocal);
        }
        RegionExit regionExitExpr = ((AsyncRegionExpr)asyncRegionStmt.getRegionExpr()).getExit();
        HashChain outerMethodLocals = (HashChain)body.getLocals();
        HashChain methodLocals = (HashChain)methodBody.getLocals();
        Stmt exitStmt = null;
        HashMap<Stmt, Stmt> branchMap = new HashMap<Stmt, Stmt>();
        int inAsync = 0;
        while (stmtIt.hasNext()) {
            NopStmt nopLabel;
            Stmt target;
            ArrayList<Unit> targetList;
            Iterator targetIter;
            NopStmt nopLabel2;
            Stmt target2;
            Stmt stmt = (Stmt)stmtIt.next();
            Object newStmt = null;
            if (stmt instanceof HjAsyncRegionStmt) {
                ++inAsync;
            }
            if (stmt instanceof HjRegionStmt) {
                HjRegionStmt regionStmt = (HjRegionStmt)stmt;
                String toStringVal = regionStmt.regionExprBox.getValue().toString();
                if (toStringVal.equals("AsyncRegion Exit")) {
                    --inAsync;
                }
            }
            if (branchMap.containsKey(stmt)) {
                methodBody.getUnits().add((Unit)branchMap.get(stmt));
            }
            if (stmt instanceof RegionStmt) {
                if (((RegionStmt)stmt).getRegionExpr() == regionExitExpr) {
                    exitStmt = stmt;
                    removeStmts.add(stmt);
                    break;
                }
                NopStmt nopLabel3 = Jimple.v().newNopStmt();
                methodBody.getUnits().add(nopLabel3);
                branchMap.put(stmt, nopLabel3);
            } else if (stmt instanceof GotoStmt) {
                target2 = (Stmt)((GotoStmt)stmt).getTarget();
                if (branchMap.containsKey(target2)) {
                    ((GotoStmt)stmt).setTargetBox((Unit)branchMap.get(target2));
                } else if (methodBody.getUnits().contains(target2)) {
                    nopLabel2 = Jimple.v().newNopStmt();
                    ((GotoStmt)stmt).setTarget(nopLabel2);
                    methodBody.getUnits().insertBefore(nopLabel2, (Unit)target2);
                    branchMap.put(target2, nopLabel2);
                } else {
                    nopLabel2 = Jimple.v().newNopStmt();
                    ((GotoStmt)stmt).setTarget(nopLabel2);
                    branchMap.put(target2, nopLabel2);
                }
            } else if (stmt instanceof IfStmt) {
                target2 = ((IfStmt)stmt).getTarget();
                if (branchMap.containsKey(target2)) {
                    ((IfStmt)stmt).setTarget(branchMap.get(target2));
                } else if (methodBody.getUnits().contains(target2)) {
                    nopLabel2 = Jimple.v().newNopStmt();
                    ((IfStmt)stmt).setTarget(nopLabel2);
                    methodBody.getUnits().insertBefore(nopLabel2, (Unit)target2);
                    branchMap.put(target2, nopLabel2);
                } else {
                    nopLabel2 = Jimple.v().newNopStmt();
                    ((IfStmt)stmt).setTarget(nopLabel2);
                    branchMap.put(target2, nopLabel2);
                }
            } else if (stmt instanceof TableSwitchStmt) {
                targetIter = ((TableSwitchStmt)stmt).getTargets().iterator();
                targetList = new ArrayList<Unit>();
                while (targetIter.hasNext()) {
                    target = (Stmt)targetIter.next();
                    if (branchMap.containsKey(target)) {
                        targetList.add(branchMap.get(target));
                        continue;
                    }
                    if (methodBody.getUnits().contains(target)) {
                        nopLabel = Jimple.v().newNopStmt();
                        targetList.add(nopLabel);
                        methodBody.getUnits().insertBefore(nopLabel, (Unit)target);
                        branchMap.put(target, nopLabel);
                        continue;
                    }
                    nopLabel = Jimple.v().newNopStmt();
                    targetList.add(nopLabel);
                    branchMap.put(target, nopLabel);
                }
                ((TableSwitchStmt)stmt).setTargets(targetList);
                target = (Stmt)((TableSwitchStmt)stmt).getDefaultTarget();
                if (branchMap.containsKey(target)) {
                    ((TableSwitchStmt)stmt).setDefaultTarget(branchMap.get(target));
                } else if (methodBody.getUnits().contains(target)) {
                    nopLabel = Jimple.v().newNopStmt();
                    ((TableSwitchStmt)stmt).setDefaultTarget(nopLabel);
                    methodBody.getUnits().insertBefore(nopLabel, (Unit)target);
                    branchMap.put(target, nopLabel);
                } else {
                    nopLabel = Jimple.v().newNopStmt();
                    ((TableSwitchStmt)stmt).setDefaultTarget(nopLabel);
                    branchMap.put(target, nopLabel);
                }
            } else if (stmt instanceof LookupSwitchStmt) {
                targetIter = ((LookupSwitchStmt)stmt).getTargets().iterator();
                targetList = new ArrayList();
                while (targetIter.hasNext()) {
                    target = (Stmt)targetIter.next();
                    if (branchMap.containsKey(target)) {
                        targetList.add(branchMap.get(target));
                        continue;
                    }
                    if (methodBody.getUnits().contains(target)) {
                        nopLabel = Jimple.v().newNopStmt();
                        targetList.add(nopLabel);
                        methodBody.getUnits().insertBefore(nopLabel, (Unit)target);
                        branchMap.put(target, nopLabel);
                        continue;
                    }
                    nopLabel = Jimple.v().newNopStmt();
                    targetList.add(nopLabel);
                    branchMap.put(target, nopLabel);
                }
                ((LookupSwitchStmt)stmt).setTargets((Unit[])targetList.toArray());
                target = (Stmt)((LookupSwitchStmt)stmt).getDefaultTarget();
                if (branchMap.containsKey(target)) {
                    ((LookupSwitchStmt)stmt).setDefaultTarget(branchMap.get(target));
                } else if (methodBody.getUnits().contains(target)) {
                    nopLabel = Jimple.v().newNopStmt();
                    ((LookupSwitchStmt)stmt).setDefaultTarget(nopLabel);
                    methodBody.getUnits().insertBefore(nopLabel, (Unit)target);
                    branchMap.put(target, nopLabel);
                } else {
                    nopLabel = Jimple.v().newNopStmt();
                    ((LookupSwitchStmt)stmt).setDefaultTarget(nopLabel);
                    branchMap.put(target, nopLabel);
                }
            } else if (stmt instanceof HjFutureReturn && inAsync == 0) {
                ActivityClassBuilder.v().addSetValueStmts(activityClass, methodBody, ((HjFutureReturn)((Object)stmt)).getOp(), thisLocal);
                this.checkUses(stmt, outerMethodLocals, methodLocals, classParams);
                this.checkDefs(stmt, outerMethodLocals, methodLocals, classParams);
                removeStmts.add(stmt);
                continue;
            }
            methodBody.getUnits().add(stmt);
            this.checkUses(stmt, outerMethodLocals, methodLocals, classParams);
            this.checkDefs(stmt, outerMethodLocals, methodLocals, classParams);
            removeStmts.add(stmt);
        }
        this.createFields(activityClass, classParams);
        for (Local local : classParams.keySet()) {
            field = classParams.get(local);
            if (!methodBody.getLocals().contains(local)) continue;
            InstanceFieldRef fieldRef = Jimple.v().newInstanceFieldRef(thisLocal, field.makeRef());
            AssignStmt assignStmt = Jimple.v().newAssignStmt(local, fieldRef);
            methodBody.getUnits().addFirst(assignStmt);
        }
        methodBody.getUnits().addFirst(Jimple.v().newIdentityStmt(thisLocal, Jimple.v().newThisRef(activityClass.getType())));
        methodBody.getUnits().addLast(Jimple.v().newReturnVoidStmt());
        this.checkTraps(body, methodBody, body.getTraps(), asyncRegionStmt, exitStmt, branchMap, branchItems);
        SootMethod bodyMethod = body.getMethod();
        if (!bodyMethod.isStatic() && !classParams.containsKey(outerThisLocal)) {
            field = this.createField(outerThisLocal);
            classParams.put(outerThisLocal, field);
            activityClass.addField(field);
        }
        return methodBody;
    }

    protected ArrayList<Stmt> createRuntimeStmts(SootClass activityClass, Body body, HashMap<Local, SootField> classParams, ArrayList<Stmt> runtimeStmts) {
        LocalGenerator lg = new LocalGenerator(body);
        SootClass hjLPlaceClass = Scene.v().getSootClass("hj.lang.place");
        Local herePlaceLocal = lg.generateLocal(hjLPlaceClass.getType());
        Local realPlaceLocal = lg.generateLocal(hjLPlaceClass.getType());
        Stmt assignStmt = HjStmtFactory.here(herePlaceLocal);
        runtimeStmts.add(assignStmt);
        assignStmt = HjStmtFactory.asPlace(realPlaceLocal, herePlaceLocal);
        runtimeStmts.add(assignStmt);
        Local activityLocal = lg.generateLocal(activityClass.getType());
        NewExpr newExpr = Jimple.v().newNewExpr(activityClass.getType());
        assignStmt = Jimple.v().newAssignStmt(activityLocal, newExpr);
        runtimeStmts.add(assignStmt);
        ArrayList<Type> activityTypeList = new ArrayList<Type>();
        ArrayList<Local> activityParamList = new ArrayList<Local>();
        for (Local local : classParams.keySet()) {
            activityTypeList.add(local.getType());
            activityParamList.add(local);
        }
        SootMethodRef initInvoke = Scene.v().makeMethodRef(activityClass, "<init>", activityTypeList, VoidType.v(), false);
        SpecialInvokeExpr specInvokeExpr = Jimple.v().newSpecialInvokeExpr(activityLocal, initInvoke, activityParamList);
        InvokeStmt invokeStmt = Jimple.v().newInvokeStmt(specInvokeExpr);
        runtimeStmts.add(invokeStmt);
        ArrayList<RefType> runAsyncTypeList = new ArrayList<RefType>();
        ArrayList<Local> runAsyncParamList = new ArrayList<Local>();
        runAsyncTypeList.add(Scene.v().getSootClass("hj.runtime.wsh.Activity").getType());
        runAsyncParamList.add(activityLocal);
        SootMethod runAsyncMethod = hjLPlaceClass.getMethod("runAsync", runAsyncTypeList, VoidType.v());
        VirtualInvokeExpr runAsyncInvoke = Jimple.v().newVirtualInvokeExpr(realPlaceLocal, runAsyncMethod.makeRef(), runAsyncParamList);
        invokeStmt = Jimple.v().newInvokeStmt(runAsyncInvoke);
        runtimeStmts.add(invokeStmt);
        return runtimeStmts;
    }

    protected void createFieldInit(SootClass activityClass, JimpleBody methodBody, SootField field, LocalGenerator lg, Local thisLocal, int paramCounter) {
        ParameterRef paramRef = Jimple.v().newParameterRef(field.getType(), paramCounter);
        Local tmpLocal = lg.generateLocal(field.getType());
        DefinitionStmt assignStmt = Jimple.v().newIdentityStmt(tmpLocal, paramRef);
        assignStmt.addTag(new EnclosingTag());
        methodBody.getUnits().addFirst(assignStmt);
        InstanceFieldRef fieldRef = Jimple.v().newInstanceFieldRef(thisLocal, field.makeRef());
        assignStmt = Jimple.v().newAssignStmt(fieldRef, tmpLocal);
        methodBody.getUnits().addLast(assignStmt);
    }

    protected void createInitMethod(SootClass activityClass, HashMap<Local, SootField> classParams) {
        JimpleBody methodBody = Jimple.v().newBody();
        LocalGenerator lg = new LocalGenerator(methodBody);
        Local thisLocal = lg.generateLocal(activityClass.getType());
        ArrayList<Type> typeList = new ArrayList<Type>();
        Iterator<Local> params = classParams.keySet().iterator();
        int paramCounter = 0;
        while (params.hasNext()) {
            Local local = params.next();
            Type paramType = local.getType();
            typeList.add(paramType);
            this.createFieldInit(activityClass, methodBody, classParams.get(local), lg, thisLocal, paramCounter++);
        }
        methodBody.getUnits().addFirst(Jimple.v().newIdentityStmt(thisLocal, Jimple.v().newThisRef(activityClass.getType())));
        SootMethod initMethod = new SootMethod("<init>", typeList, VoidType.v(), 1);
        methodBody.setMethod(initMethod);
        initMethod.setActiveBody(methodBody);
        initMethod.setDeclaringClass(activityClass);
        activityClass.addMethod(initMethod);
        SootMethodRef initInvoke = Scene.v().makeMethodRef(Scene.v().getSootClass("hj.runtime.wsh.Activity"), "<init>", Collections.EMPTY_LIST, VoidType.v(), false);
        SpecialInvokeExpr invokeExpr = Jimple.v().newSpecialInvokeExpr(thisLocal, initInvoke, Collections.EMPTY_LIST);
        InvokeStmt invokeStmt = Jimple.v().newInvokeStmt(invokeExpr);
        methodBody.getUnits().add(invokeStmt);
        methodBody.getUnits().add(Jimple.v().newReturnVoidStmt());
    }

    protected SootField createField(Local l) {
        SootField field = new SootField("val$" + l.getName(), l.getType(), 18);
        field.addTag(new SyntheticTag());
        return field;
    }

    protected void createFields_(SootClass activityClass, HashMap<Local, SootField> classParams) {
        Iterator<SootField> fields = classParams.values().iterator();
        while (fields.hasNext()) {
            activityClass.addField(fields.next());
        }
    }

    protected void createFields(SootClass activityClass, HashMap<Local, SootField> classParams) {
        Object[] locals = classParams.keySet().toArray();
        for (int i = 0; i < locals.length; ++i) {
            SootField field = classParams.get((Local)locals[i]);
            try {
                SootField oldField = activityClass.getField(field.getName(), field.getType());
                classParams.put((Local)locals[i], oldField);
                continue;
            }
            catch (Exception e) {
                activityClass.addField(field);
            }
        }
    }

    protected void createDefaultIsHjTaskReadyMethod(SootClass activityClass) {
        JimpleBody statusMethodBody = Jimple.v().newBody();
        SootMethod statusMethod = new SootMethod("isHjTaskReady", Collections.EMPTY_LIST, BooleanType.v(), 1);
        statusMethodBody.setMethod(statusMethod);
        statusMethod.setActiveBody(statusMethodBody);
        statusMethod.setDeclaringClass(activityClass);
        activityClass.addMethod(statusMethod);
        statusMethodBody.getUnits().add(Jimple.v().newReturnStmt(IntConstant.v(1)));
    }

    protected void handleFinishRegion(RegionStmt finishRegionStmt, Body body, Iterator stmtIt, HashMap<Stmt, ArrayList<Stmt>> rtStmtMap, ArrayList<Stmt> removeStmts, ArrayList<Trap> rtTraps, ArrayList branchItems) {
        FinishRegionExpr finishRegion = (FinishRegionExpr)finishRegionStmt.getRegionExpr();
        ArrayList<Stmt> prevRTStmts = new ArrayList<Stmt>();
        ArrayList<Stmt> succRTStmts = new ArrayList<Stmt>();
        LocalGenerator lg = new LocalGenerator(body);
        RegionExit regionExitExpr = finishRegion.getExit();
        Stmt regionExitStmt = null;
        Stmt stmt = null;
        do {
            if ((stmt = (Stmt)stmtIt.next()) instanceof RegionStmt) {
                Region regionExpr = ((RegionStmt)stmt).getRegionExpr();
                if (regionExpr instanceof AsyncRegionExpr) {
                    this.handleAsyncRegion((RegionStmt)stmt, body, stmtIt, rtStmtMap, removeStmts, branchItems);
                    continue;
                }
                if (regionExpr instanceof FinishRegionExpr) {
                    this.handleFinishRegion((RegionStmt)stmt, body, stmtIt, rtStmtMap, removeStmts, rtTraps, branchItems);
                    continue;
                }
                if (regionExpr instanceof IsolatedRegionExpr) {
                    this.handleIsolatedRegion((RegionStmt)stmt, body, stmtIt, rtStmtMap, removeStmts, rtTraps, branchItems);
                    continue;
                }
                if (!(regionExpr instanceof LoopRegionExpr)) continue;
                this.handleLoopRegion((RegionStmt)stmt, removeStmts);
                continue;
            }
            if (!(stmt instanceof ReturnStmt) && !(stmt instanceof ReturnVoidStmt)) continue;
            ArrayList<Stmt> stopFinishStmts = new ArrayList<Stmt>();
            Local activityLocal = lg.generateLocal(ActivityClassBuilder.v().hjActivityClass.getType());
            stopFinishStmts.add(HjStmtFactory.getCurrentActivity_HjWshActivity(activityLocal));
            stopFinishStmts.add(ActivityClassBuilder.v().callStopFinish(activityLocal));
            rtStmtMap.put(stmt, stopFinishStmts);
        } while (!(stmt instanceof RegionStmt) || ((RegionStmt)stmt).getRegionExpr() != regionExitExpr);
        regionExitStmt = stmt;
        ActivityClassBuilder.v().createFinishRTStmts(prevRTStmts, succRTStmts, finishRegion.getAccumulators(), rtTraps, lg);
        rtStmtMap.put(finishRegionStmt, prevRTStmts);
        rtStmtMap.put(regionExitStmt, succRTStmts);
        removeStmts.add(finishRegionStmt);
        removeStmts.add(regionExitStmt);
    }

    protected void handleHabFinishRegion(RegionStmt finishRegionStmt, Body body, Iterator stmtIt, HashMap<Stmt, ArrayList<Stmt>> rtStmtMap, ArrayList<Stmt> removeStmts, ArrayList<Trap> rtTraps, ArrayList branchItems) {
        FinishRegionExpr finishRegion = (FinishRegionExpr)finishRegionStmt.getRegionExpr();
        ArrayList<Stmt> prevRTStmts = new ArrayList<Stmt>();
        ArrayList<Stmt> succRTStmts = new ArrayList<Stmt>();
        LocalGenerator lg = new LocalGenerator(body);
        SootClass hjRTClass = Scene.v().getSootClass("hj.lang.Runtime");
        SootClass hjActivityClass = Scene.v().getSootClass("hj.runtime.wsh.Activity");
        SootMethod getCurrentActivityMethod = hjRTClass.getMethod("getCurrentActivity", Collections.EMPTY_LIST, hjActivityClass.getType());
        SootMethod startFinishMethod = hjActivityClass.getMethod("startFinish", Collections.EMPTY_LIST, VoidType.v());
        SootMethod stopFinishMethod = hjActivityClass.getMethod("stopFinish", Collections.EMPTY_LIST, VoidType.v());
        ArrayList<RefType> pushExceptionTypeList = new ArrayList<RefType>();
        SootClass throwableClass = Scene.v().getSootClass("java.lang.Throwable");
        pushExceptionTypeList.add(throwableClass.getType());
        SootMethod pushExceptionMethod = hjActivityClass.getMethod("pushException", pushExceptionTypeList, VoidType.v());
        RegionExit regionExitExpr = finishRegion.getExit();
        Stmt regionExitStmt = null;
        Stmt stmt = null;
        do {
            if (!((stmt = (Stmt)stmtIt.next()) instanceof RegionStmt)) continue;
            Region regionExpr = ((RegionStmt)stmt).getRegionExpr();
            if (regionExpr instanceof AsyncRegionExpr) {
                this.handleAsyncRegion((RegionStmt)stmt, body, stmtIt, rtStmtMap, removeStmts, branchItems);
                continue;
            }
            if (regionExpr instanceof FinishRegionExpr) {
                this.handleHabFinishRegion((RegionStmt)stmt, body, stmtIt, rtStmtMap, removeStmts, rtTraps, branchItems);
                continue;
            }
            if (regionExpr instanceof IsolatedRegionExpr) {
                this.handleIsolatedRegion((RegionStmt)stmt, body, stmtIt, rtStmtMap, removeStmts, rtTraps, branchItems);
                continue;
            }
            if (!(regionExpr instanceof LoopRegionExpr)) continue;
            this.handleLoopRegion((RegionStmt)stmt, removeStmts);
        } while (!(stmt instanceof RegionStmt) || ((RegionStmt)stmt).getRegionExpr() != regionExitExpr);
        regionExitStmt = stmt;
        Local langActivityLocal = lg.generateLocal(HjClassFactory.hjLangActivity().getType());
        Local activityLocal = lg.generateLocal(hjActivityClass.getType());
        Stmt langAssignStmt = HjStmtFactory.getCurrentActivity_HjLangActivity(langActivityLocal);
        prevRTStmts.add(langAssignStmt);
        Stmt assignStmt = HjStmtFactory.assignLangActivityToActivityWsh(activityLocal, langActivityLocal);
        prevRTStmts.add(assignStmt);
        VirtualInvokeExpr virtualInvoke = Jimple.v().newVirtualInvokeExpr(activityLocal, startFinishMethod.makeRef(), Collections.EMPTY_LIST);
        InvokeStmt invokeStmt = Jimple.v().newInvokeStmt(virtualInvoke);
        prevRTStmts.add(invokeStmt);
        langActivityLocal = lg.generateLocal(HjClassFactory.hjLangActivity().getType());
        activityLocal = lg.generateLocal(hjActivityClass.getType());
        langAssignStmt = HjStmtFactory.getCurrentActivity_HjLangActivity(langActivityLocal);
        succRTStmts.add(langAssignStmt);
        assignStmt = HjStmtFactory.assignLangActivityToActivityWsh(activityLocal, langActivityLocal);
        succRTStmts.add(assignStmt);
        virtualInvoke = Jimple.v().newVirtualInvokeExpr(activityLocal, stopFinishMethod.makeRef(), Collections.EMPTY_LIST);
        invokeStmt = Jimple.v().newInvokeStmt(virtualInvoke);
        succRTStmts.add(invokeStmt);
        rtStmtMap.put(finishRegionStmt, prevRTStmts);
        rtStmtMap.put(regionExitStmt, succRTStmts);
        removeStmts.add(finishRegionStmt);
        removeStmts.add(regionExitStmt);
    }

    protected ArrayList<Stmt> createRetStmts(Stmt startStmt, Stmt returnStmt, Local placeLocal, Stmt handler0Stmt, Stmt handler1Stmt, LocalGenerator lg, SootClass hjRTPlaceClass, SootClass throwableClass, SootMethod hereMethod, SootMethod notifyAllMethod, ArrayList<Trap> rtTraps) {
        ArrayList<Stmt> retStmts = new ArrayList<Stmt>();
        NopStmt startNopLabel = Jimple.v().newNopStmt();
        retStmts.add(startNopLabel);
        Local notifyPlcLocal = lg.generateLocal(hjRTPlaceClass.getType());
        StaticInvokeExpr staticInvoke = Jimple.v().newStaticInvokeExpr(hereMethod.makeRef(), Collections.EMPTY_LIST);
        AssignStmt assignStmt = Jimple.v().newAssignStmt(notifyPlcLocal, staticInvoke);
        retStmts.add(assignStmt);
        AssignStmt retNopLabel1 = assignStmt;
        VirtualInvokeExpr virtualInvoke = Jimple.v().newVirtualInvokeExpr(notifyPlcLocal, notifyAllMethod.makeRef(), Collections.EMPTY_LIST);
        InvokeStmt invokeStmt = Jimple.v().newInvokeStmt(virtualInvoke);
        retStmts.add(invokeStmt);
        ExitMonitorStmt exitMonStmt = Jimple.v().newExitMonitorStmt(placeLocal);
        retStmts.add(exitMonStmt);
        NopStmt retNopLabel2 = Jimple.v().newNopStmt();
        retStmts.add(retNopLabel2);
        if (returnStmt != null) {
            retStmts.add(Jimple.v().newGotoStmt(returnStmt));
        }
        rtTraps.add(Jimple.v().newTrap(throwableClass, startNopLabel, retNopLabel1, handler0Stmt));
        rtTraps.add(Jimple.v().newTrap(throwableClass, startNopLabel, retNopLabel2, handler1Stmt));
        return retStmts;
    }

    protected void handleIsolatedRegion(RegionStmt isolatedRegionStmt, Body body, Iterator stmtIt, HashMap<Stmt, ArrayList<Stmt>> rtStmtMap, ArrayList<Stmt> removeStmts, ArrayList<Trap> rtTraps, ArrayList branchItems) {
        AssignStmt assignStmt;
        SootMethod startIsolationMethod;
        ArrayList<Value> paramList;
        ArrayList<RefType> typeList;
        LocalGenerator lg = new LocalGenerator(body);
        SootClass hjRTClass = Scene.v().getSootClass("hj.lang.Runtime");
        SootClass hjObjectClass = Scene.v().getSootClass("hj.lang.Object");
        SootClass throwableClass = Scene.v().getSootClass("java.lang.Throwable");
        ArrayList<Stmt> predStmts = new ArrayList<Stmt>();
        ArrayList<Stmt> succStmts = new ArrayList<Stmt>();
        IsolatedRegionExpr isolatedRegionExpr = (IsolatedRegionExpr)isolatedRegionStmt.getRegionExpr();
        List objectList = isolatedRegionExpr.getObjects();
        ArrayType intArrayType = ArrayType.v(IntType.v(), 1);
        Local placeID = null;
        Local placeIDs = null;
        if (objectList == null || objectList.size() == 0) {
            SootMethod startIsolationMethod2 = hjRTClass.getMethod("startIsolation", Collections.EMPTY_LIST, VoidType.v());
            InvokeStmt invokeStmt = Jimple.v().newInvokeStmt(Jimple.v().newStaticInvokeExpr(startIsolationMethod2.makeRef(), Collections.EMPTY_LIST));
            predStmts.add(invokeStmt);
        } else if (objectList.size() == 1) {
            typeList = new ArrayList<RefType>();
            paramList = new ArrayList<Value>();
            typeList.add(hjObjectClass.getType());
            paramList.add(((HjObject)objectList.get(0)).getLocalValue());
            startIsolationMethod = hjRTClass.getMethod("startIsolation", typeList, IntType.v());
            placeID = lg.generateLocal(IntType.v());
            assignStmt = Jimple.v().newAssignStmt(placeID, Jimple.v().newStaticInvokeExpr(startIsolationMethod.makeRef(), paramList));
            predStmts.add(assignStmt);
        } else if (objectList.size() == 2) {
            typeList = new ArrayList();
            paramList = new ArrayList();
            typeList.add(hjObjectClass.getType());
            typeList.add(hjObjectClass.getType());
            paramList.add(((HjObject)objectList.get(0)).getLocalValue());
            paramList.add(((HjObject)objectList.get(1)).getLocalValue());
            startIsolationMethod = hjRTClass.getMethod("startIsolation", typeList, intArrayType);
            placeIDs = lg.generateLocal(intArrayType);
            assignStmt = Jimple.v().newAssignStmt(placeIDs, Jimple.v().newStaticInvokeExpr(startIsolationMethod.makeRef(), paramList));
            predStmts.add(assignStmt);
        } else {
            ArrayType hjObjsType = ArrayType.v(hjObjectClass.getType(), 1);
            Local objsLocal = lg.generateLocal(hjObjsType);
            AssignStmt assignStmt2 = Jimple.v().newAssignStmt(objsLocal, Jimple.v().newNewArrayExpr(hjObjectClass.getType(), IntConstant.v(objectList.size())));
            predStmts.add(assignStmt2);
            for (int i = 0; i < objectList.size(); ++i) {
                HjObject hjObj = (HjObject)objectList.get(i);
                Value objValue = hjObj.getLocalValue();
                AssignStmt arrayStmt = Jimple.v().newAssignStmt(Jimple.v().newArrayRef(objsLocal, IntConstant.v(i)), objValue);
            }
            ArrayList<ArrayType> typeList2 = new ArrayList<ArrayType>();
            ArrayList<Local> paramList2 = new ArrayList<Local>();
            typeList2.add(hjObjsType);
            paramList2.add(objsLocal);
            SootMethod startIsolationMethod3 = hjRTClass.getMethod("startIsolation", typeList2, intArrayType);
            assignStmt2 = Jimple.v().newAssignStmt(placeIDs, Jimple.v().newStaticInvokeExpr(startIsolationMethod3.makeRef(), paramList2));
            predStmts.add(assignStmt2);
        }
        Stmt regionExitStmt = isolatedRegionStmt.getConnect();
        Stmt startStmt = null;
        while (stmtIt.hasNext()) {
            Stmt stmt = (Stmt)stmtIt.next();
            if (startStmt == null) {
                startStmt = stmt;
            }
            if (stmt == regionExitStmt) break;
            if (stmt instanceof RegionStmt) {
                Region regionExpr = ((RegionStmt)stmt).getRegionExpr();
                if (regionExpr instanceof AsyncRegionExpr) {
                    this.handleAsyncRegion((RegionStmt)stmt, body, stmtIt, rtStmtMap, removeStmts, branchItems);
                    continue;
                }
                if (regionExpr instanceof FinishRegionExpr) {
                    if (TargetedHjRuntime.isRuntimeWorkStealingHelpFirst()) {
                        this.handleHabFinishRegion((RegionStmt)stmt, body, stmtIt, rtStmtMap, removeStmts, rtTraps, branchItems);
                        continue;
                    }
                    this.handleFinishRegion((RegionStmt)stmt, body, stmtIt, rtStmtMap, removeStmts, rtTraps, branchItems);
                    continue;
                }
                if (regionExpr instanceof IsolatedRegionExpr) {
                    this.handleIsolatedRegion((RegionStmt)stmt, body, stmtIt, rtStmtMap, removeStmts, rtTraps, branchItems);
                    continue;
                }
                if (!(regionExpr instanceof LoopRegionExpr)) continue;
                this.handleLoopRegion((RegionStmt)stmt, removeStmts);
                continue;
            }
            if (!(stmt instanceof ReturnStmt) && !(stmt instanceof ReturnVoidStmt)) continue;
        }
        NopStmt endStmt = Jimple.v().newNopStmt();
        Stmt label0 = (Stmt)body.getUnits().getPredOf(isolatedRegionStmt);
        Stmt label1 = ActivityClassBuilder.v().createStopIsolation(placeID, placeIDs, hjRTClass);
        succStmts.add(label1);
        succStmts.add(Jimple.v().newGotoStmt(endStmt));
        Local excpLocal = lg.generateLocal(throwableClass.getType());
        IdentityStmt label2 = Jimple.v().newIdentityStmt(excpLocal, Jimple.v().newCaughtExceptionRef());
        succStmts.add(label2);
        Stmt label3 = ActivityClassBuilder.v().createStopIsolation(placeID, placeIDs, hjRTClass);
        succStmts.add(label3);
        ThrowStmt label4 = Jimple.v().newThrowStmt(excpLocal);
        succStmts.add(label4);
        succStmts.add(endStmt);
        rtTraps.add(Jimple.v().newTrap(throwableClass, label0, label1, label2));
        rtTraps.add(Jimple.v().newTrap(throwableClass, label3, label4, label2));
        rtStmtMap.put(isolatedRegionStmt, predStmts);
        rtStmtMap.put(regionExitStmt, succStmts);
        removeStmts.add(isolatedRegionStmt);
        removeStmts.add(regionExitStmt);
    }

    protected void handleLoopRegion(RegionStmt loopRegionStmt, ArrayList<Stmt> removeStmts) {
        removeStmts.add(loopRegionStmt);
        RegionStmt regionExitStmt = (RegionStmt)loopRegionStmt.getConnect();
        if (!(regionExitStmt.getRegionExpr() instanceof RegionExit)) {
            throw new Error("Can not find the exit of loop region");
        }
        removeStmts.add(regionExitStmt);
    }
}

