/*
 * Decompiled with CFR 0.152.
 */
package soot.HjToJimple.jimple.ext.complex;

import soot.ArrayType;
import soot.Complex32Type;
import soot.Complex64Type;
import soot.DoubleType;
import soot.FloatType;
import soot.HjToJimple.jimple.HjArrayViewConstructor;
import soot.HjToJimple.jimple.utils.ArrayViewUtils;
import soot.Type;
import soot.Value;
import soot.jimple.Complex32Constant;
import soot.jimple.Complex64Constant;

public class ComplexUtils {
    public static boolean isComplex(Type type) {
        return ComplexUtils.isComplex32Type(type) || ComplexUtils.isComplex64Type(type);
    }

    public static boolean isComplex64Type(Type type) {
        return type instanceof Complex64Type;
    }

    public static boolean isComplex32Type(Type type) {
        return type instanceof Complex32Type;
    }

    public static boolean isComplexConstant(Value v) {
        return ComplexUtils.isComplex32Constant(v) || ComplexUtils.isComplex64Constant(v);
    }

    public static boolean isComplex32Constant(Value v) {
        return v instanceof Complex32Constant;
    }

    public static boolean isComplex64Constant(Value v) {
        return v instanceof Complex64Constant;
    }

    public static boolean isComplex(Value value) {
        Type type = value.getType();
        return ComplexUtils.isComplex(type);
    }

    public static boolean isComplex(ArrayType arrayType) {
        return ComplexUtils.isComplex(arrayType.baseType);
    }

    public static boolean isComplexArrayView(HjArrayViewConstructor arrayType) {
        return ComplexUtils.isComplexArrayView(arrayType.getType());
    }

    public static boolean isComplexArrayView(Type type) {
        return ArrayViewUtils.isComplexArrayView(type);
    }

    public static Type getComplexBaseType(Type complexType) {
        if (ComplexUtils.isComplex32Type(complexType)) {
            return FloatType.v();
        }
        if (ComplexUtils.isComplex64Type(complexType)) {
            return DoubleType.v();
        }
        throw new RuntimeException("Trying to get complex base type from non complex type: " + complexType);
    }

    public static Type getComplexBaseType(Value value) {
        return ComplexUtils.getComplexBaseType(value.getType());
    }

    public static Type getComplexBaseType(ArrayType complexType) {
        return ComplexUtils.getComplexBaseType(complexType.baseType);
    }
}

