/*
 * Decompiled with CFR 0.152.
 */
package soot.HjToJimple.jimple.utils;

import java.util.List;
import soot.BooleanType;
import soot.ByteType;
import soot.CharType;
import soot.Complex32Type;
import soot.Complex64Type;
import soot.DoubleType;
import soot.FloatType;
import soot.HjToJimple.Util;
import soot.IntType;
import soot.LongType;
import soot.RefType;
import soot.Scene;
import soot.ShortType;
import soot.SootClass;
import soot.SootMethod;
import soot.Type;

public class ArrayViewUtils {
    public static Type getHjArrayViewRuntimeBaseType(Type arrayType) {
        SootClass sootClass = ((RefType)arrayType).getSootClass();
        if (ArrayViewUtils.isShortArrayView(sootClass)) {
            return ShortType.v();
        }
        if (ArrayViewUtils.isIntArrayView(sootClass)) {
            return IntType.v();
        }
        if (ArrayViewUtils.isLongArrayView(sootClass)) {
            return LongType.v();
        }
        if (ArrayViewUtils.isDoubleArrayView(sootClass)) {
            return DoubleType.v();
        }
        if (ArrayViewUtils.isFloatArrayView(sootClass)) {
            return FloatType.v();
        }
        if (ArrayViewUtils.isComplex64ArrayView(sootClass)) {
            return DoubleType.v();
        }
        if (ArrayViewUtils.isComplex32ArrayView(sootClass)) {
            return FloatType.v();
        }
        if (ArrayViewUtils.isBooleanArrayView(sootClass)) {
            return BooleanType.v();
        }
        if (ArrayViewUtils.isCharArrayView(sootClass)) {
            return CharType.v();
        }
        if (ArrayViewUtils.isByteArrayView(sootClass)) {
            return ByteType.v();
        }
        if (ArrayViewUtils.isObjectArrayView(sootClass)) {
            return RefType.v("java.lang.Object");
        }
        throw new RuntimeException("Unsupported HjArray type: " + arrayType + " -->" + arrayType.getClass().getName());
    }

    public static Type getHjArrayViewPrimitiveType(Type arrayType) {
        SootClass sootClass = ((RefType)arrayType).getSootClass();
        if (ArrayViewUtils.isShortArrayView(sootClass)) {
            return ShortType.v();
        }
        if (ArrayViewUtils.isIntArrayView(sootClass)) {
            return IntType.v();
        }
        if (ArrayViewUtils.isLongArrayView(sootClass)) {
            return LongType.v();
        }
        if (ArrayViewUtils.isDoubleArrayView(sootClass)) {
            return DoubleType.v();
        }
        if (ArrayViewUtils.isFloatArrayView(sootClass)) {
            return FloatType.v();
        }
        if (ArrayViewUtils.isComplex64ArrayView(sootClass)) {
            return Complex64Type.v();
        }
        if (ArrayViewUtils.isComplex32ArrayView(sootClass)) {
            return Complex32Type.v();
        }
        if (ArrayViewUtils.isBooleanArrayView(sootClass)) {
            return BooleanType.v();
        }
        if (ArrayViewUtils.isCharArrayView(sootClass)) {
            return CharType.v();
        }
        if (ArrayViewUtils.isByteArrayView(sootClass)) {
            return ByteType.v();
        }
        if (ArrayViewUtils.isObjectArrayView(sootClass)) {
            return RefType.v("java.lang.Object");
        }
        throw new RuntimeException("Unsupported HjArray type: " + arrayType + " -->" + arrayType.getClass().getName());
    }

    public static Type getHjArrayViewType(Type baseType) {
        String name = null;
        if (baseType instanceof CharType) {
            name = "hj.array.view.CharArrayView";
        } else if (baseType instanceof IntType) {
            name = "hj.array.view.IntArrayView";
        } else if (baseType instanceof DoubleType) {
            name = "hj.array.view.DoubleArrayView";
        } else if (baseType instanceof FloatType) {
            name = "hj.array.view.FloatArrayView";
        } else if (baseType instanceof BooleanType) {
            name = "hj.array.view.BooleanArrayView";
        } else if (baseType instanceof LongType) {
            name = "hj.array.view.LongArrayView";
        } else if (baseType instanceof ShortType) {
            name = "hj.array.view.ShortArrayView";
        } else if (baseType instanceof ByteType) {
            name = "hj.array.view.ByteArrayView";
        } else if (baseType instanceof Complex64Type) {
            name = "hj.array.view.Complex64ArrayView";
        } else if (baseType instanceof Complex32Type) {
            name = "hj.array.view.Complex32ArrayView";
        } else if (baseType instanceof RefType) {
            name = "hj.array.view.ObjectArrayView";
        } else {
            throw new RuntimeException("Unsupported base type: " + baseType + " -->" + baseType.getClass().getName());
        }
        return RefType.v(name);
    }

    public static SootClass getHjArrayViewRuntimeClass(Type baseType) {
        if (baseType instanceof IntType) {
            return ArrayViewUtils.getIntArrayViewClass();
        }
        if (baseType instanceof DoubleType) {
            return ArrayViewUtils.getDoubleArrayViewClass();
        }
        if (baseType instanceof FloatType) {
            return ArrayViewUtils.getFloatArrayViewClass();
        }
        if (baseType instanceof BooleanType) {
            return ArrayViewUtils.getBooleanArrayViewClass();
        }
        if (baseType instanceof LongType) {
            return ArrayViewUtils.getLongArrayViewClass();
        }
        if (baseType instanceof ShortType) {
            return ArrayViewUtils.getShortArrayViewClass();
        }
        if (baseType instanceof ByteType) {
            return ArrayViewUtils.getByteArrayViewClass();
        }
        if (baseType instanceof CharType) {
            return ArrayViewUtils.getCharArrayViewClass();
        }
        if (baseType instanceof Complex64Type) {
            return ArrayViewUtils.getComplex64ArrayViewClass();
        }
        if (baseType instanceof Complex32Type) {
            return ArrayViewUtils.getComplex32ArrayViewClass();
        }
        if (baseType instanceof RefType) {
            return ArrayViewUtils.getObjectArrayViewClass();
        }
        throw new RuntimeException("Unsupported base type: " + baseType + " -->" + baseType.getClass().getName());
    }

    public static SootClass getShortArrayViewClass() {
        return Scene.v().getSootClass("hj.array.view.ShortArrayView");
    }

    public static boolean isShortArrayView(SootClass arrayViewClass) {
        return Util.isInstance(arrayViewClass, ArrayViewUtils.getShortArrayViewClass());
    }

    public static SootClass getIntArrayViewClass() {
        return Scene.v().getSootClass("hj.array.view.IntArrayView");
    }

    public static boolean isIntArrayView(SootClass arrayViewClass) {
        return Util.isInstance(arrayViewClass, ArrayViewUtils.getIntArrayViewClass());
    }

    public static SootClass getLongArrayViewClass() {
        return Scene.v().getSootClass("hj.array.view.LongArrayView");
    }

    public static boolean isLongArrayView(SootClass arrayViewClass) {
        return Util.isInstance(arrayViewClass, ArrayViewUtils.getLongArrayViewClass());
    }

    public static SootClass getDoubleArrayViewClass() {
        return Scene.v().getSootClass("hj.array.view.DoubleArrayView");
    }

    public static boolean isDoubleArrayView(SootClass arrayViewClass) {
        return Util.isInstance(arrayViewClass, ArrayViewUtils.getDoubleArrayViewClass());
    }

    public static SootClass getFloatArrayViewClass() {
        return Scene.v().getSootClass("hj.array.view.FloatArrayView");
    }

    public static boolean isFloatArrayView(SootClass arrayViewClass) {
        return Util.isInstance(arrayViewClass, ArrayViewUtils.getFloatArrayViewClass());
    }

    public static SootClass getBooleanArrayViewClass() {
        return Scene.v().getSootClass("hj.array.view.BooleanArrayView");
    }

    public static boolean isBooleanArrayView(SootClass arrayViewClass) {
        return Util.isInstance(arrayViewClass, ArrayViewUtils.getBooleanArrayViewClass());
    }

    public static SootClass getCharArrayViewClass() {
        return Scene.v().getSootClass("hj.array.view.CharArrayView");
    }

    public static boolean isCharArrayView(SootClass arrayViewClass) {
        return Util.isInstance(arrayViewClass, ArrayViewUtils.getCharArrayViewClass());
    }

    public static SootClass getByteArrayViewClass() {
        return Scene.v().getSootClass("hj.array.view.ByteArrayView");
    }

    public static boolean isByteArrayView(SootClass arrayViewClass) {
        return Util.isInstance(arrayViewClass, ArrayViewUtils.getByteArrayViewClass());
    }

    public static SootClass getComplex64ArrayViewClass() {
        return Scene.v().getSootClass("hj.array.view.Complex64ArrayView");
    }

    public static boolean isComplexArrayView(SootClass arrayViewClass) {
        return ArrayViewUtils.isComplex64ArrayView(arrayViewClass) || ArrayViewUtils.isComplex32ArrayView(arrayViewClass);
    }

    public static boolean isComplex64ArrayView(SootClass arrayViewClass) {
        return Util.isInstance(arrayViewClass, ArrayViewUtils.getComplex64ArrayViewClass());
    }

    public static SootClass getComplex32ArrayViewClass() {
        return Scene.v().getSootClass("hj.array.view.Complex32ArrayView");
    }

    public static boolean isComplex32ArrayView(SootClass arrayViewClass) {
        return Util.isInstance(arrayViewClass, ArrayViewUtils.getComplex32ArrayViewClass());
    }

    public static boolean isObjectArrayView(SootClass arrayViewClass) {
        return Util.isInstance(arrayViewClass, ArrayViewUtils.getObjectArrayViewClass());
    }

    public static SootClass getObjectArrayViewClass() {
        return Scene.v().getSootClass("hj.array.view.ObjectArrayView");
    }

    public static SootMethod getArrayMethod(SootClass factoryClass, List typeList, Type retType) {
        SootClass retClass = ((RefType)retType).getSootClass();
        RefType runtimeArrayViewType = retClass.getType();
        if (ArrayViewUtils.isShortArrayView(retClass)) {
            return factoryClass.getMethodFromCH("newShortArrayView", typeList, runtimeArrayViewType);
        }
        if (ArrayViewUtils.isIntArrayView(retClass)) {
            return factoryClass.getMethodFromCH("newIntArrayView", typeList, runtimeArrayViewType);
        }
        if (ArrayViewUtils.isLongArrayView(retClass)) {
            return factoryClass.getMethodFromCH("newLongArrayView", typeList, runtimeArrayViewType);
        }
        if (ArrayViewUtils.isDoubleArrayView(retClass)) {
            return factoryClass.getMethodFromCH("newDoubleArrayView", typeList, runtimeArrayViewType);
        }
        if (ArrayViewUtils.isFloatArrayView(retClass)) {
            return factoryClass.getMethodFromCH("newFloatArrayView", typeList, runtimeArrayViewType);
        }
        if (ArrayViewUtils.isBooleanArrayView(retClass)) {
            return factoryClass.getMethodFromCH("newBooleanArrayView", typeList, runtimeArrayViewType);
        }
        if (ArrayViewUtils.isCharArrayView(retClass)) {
            return factoryClass.getMethodFromCH("newCharArrayView", typeList, runtimeArrayViewType);
        }
        if (ArrayViewUtils.isByteArrayView(retClass)) {
            return factoryClass.getMethodFromCH("newByteArrayView", typeList, runtimeArrayViewType);
        }
        throw new RuntimeException("No supported return array type " + retType);
    }

    public static boolean isComplexArrayView(Type type) {
        SootClass sootClass = ((RefType)type).getSootClass();
        return ArrayViewUtils.isComplexArrayView(sootClass);
    }
}

