/*
 * Decompiled with CFR 0.152.
 */
package soot.HjToJimple.racedet;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import soot.G;
import soot.HjToJimple.LocalGenerator;
import soot.HjToJimple.jimple.HjRSTTranslator;
import soot.HjToJimple.jimple.RegionStmt;
import soot.HjToJimple.racedet.PropertiesTag;
import soot.HjToJimple.racedet.SuperClassReplacer;
import soot.HjToJimple.util.RSTNode;
import soot.IntType;
import soot.Local;
import soot.RefType;
import soot.Scene;
import soot.SceneTransformer;
import soot.Singletons;
import soot.SootClass;
import soot.SootField;
import soot.SootMethod;
import soot.Type;
import soot.Unit;
import soot.Value;
import soot.ValueBox;
import soot.VoidType;
import soot.jimple.ArrayRef;
import soot.jimple.AssignStmt;
import soot.jimple.FieldRef;
import soot.jimple.InstanceFieldRef;
import soot.jimple.IntConstant;
import soot.jimple.InterfaceInvokeExpr;
import soot.jimple.InvokeExpr;
import soot.jimple.InvokeStmt;
import soot.jimple.Jimple;
import soot.jimple.JimpleBody;
import soot.jimple.NewExpr;
import soot.jimple.NullConstant;
import soot.jimple.SpecialInvokeExpr;
import soot.jimple.StaticFieldRef;
import soot.jimple.StaticInvokeExpr;
import soot.jimple.Stmt;
import soot.jimple.StringConstant;
import soot.jimple.VirtualInvokeExpr;
import soot.tagkit.SourceLnNamePosTag;
import soot.tagkit.SourceLnPosTag;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RaceDetInstrumentor
extends SceneTransformer {
    public static boolean debug2 = false;
    public static boolean debug = false;
    private SootClass staticObjectClass;
    private SootMethod staticObjectConstructor;
    private static String SPbagsPackage = "hj.runtime.wst.racedet.";
    private static String currPackage;
    private static String RaceDetMainClassName;
    private static String TaskObjectClassName;
    private static String FinishObjectClassName;
    private static String AsyncObjectClassName;
    private static String BaseObjectClassName;
    private static String HJLangObjectClassName;
    private static String ArrayViewClassName;
    private static String JavaLangObjectClassName;
    private static String MarkReadMethodName;
    private static String MarkReadViewMethodName;
    private static String MarkReadArrayMethodName;
    private static String MarkWriteMethodName;
    private static String MarkWriteViewMethodName;
    private static String MarkWriteArrayMethodName;
    private static String MarkAtomicReadMethodName;
    private static String MarkAtomicReadViewMethodName;
    private static String MarkAtomicReadArrayMethodName;
    private static String MarkAtomicWriteMethodName;
    private static String MarkAtomicWriteViewMethodName;
    private static String MarkAtomicWriteArrayMethodName;
    private static String InitMethodName;
    private static String StartFinishMethodName;
    private static String EndFinishMethodName;
    private static String StartAsyncMethodName;
    private static String EndAsyncMethodName;
    private static String AllocateMethodName;
    protected Set<SootMethod> applicationMethods;
    protected Set<SootMethod> applicationClones;
    protected Set<SootMethod> constructors;
    protected Set<SootMethod> abstractMethods;
    protected Set<SootMethod> methodsNeedingPartialInstrumentation;
    protected Set<SootMethod> methodsNeedingFullInstrumentation;
    protected Map<SootField, Integer> fieldNumbers;
    protected Map<SootClass, Integer> staticFieldsOfClasses;
    protected Map<SootClass, Integer> instanceFieldsOfClasses;
    protected SootMethod mainMethod;
    protected Map<SootMethod, SootMethod> cloneMethods;
    protected Map<SootMethod, SootMethod> originalMethods;
    protected Map<SootMethod, Value> cloneTaskLocals;
    protected Map<SootClass, SootField> staticObjectFields;
    protected Set<SootClass> extendsLibraryClass;
    protected SootClass RaceDetMainClass;
    protected SootClass TaskObjectClass;
    protected SootClass FinishObjectClass;
    protected SootClass AsyncObjectClass;
    protected SootClass BaseObjectClass;
    protected SootClass HJLangObjectClass;
    protected SootClass ArrayViewClass;
    protected SootClass JavaLangObjectClass;
    protected SootMethod markReadMethod;
    protected SootMethod markReadViewMethod;
    protected SootMethod markReadArrayMethod;
    protected SootMethod markWriteMethod;
    protected SootMethod markReadWriteMethod;
    protected SootMethod markWriteViewMethod;
    protected SootMethod markReadWriteViewMethod;
    protected SootMethod markWriteArrayMethod;
    protected SootMethod markAtomicReadMethod;
    protected SootMethod markAtomicReadViewMethod;
    protected SootMethod markAtomicReadArrayMethod;
    protected SootMethod markAtomicWriteMethod;
    protected SootMethod markAtomicReadWriteMethod;
    protected SootMethod markAtomicWriteViewMethod;
    protected SootMethod markAtomicReadWriteViewMethod;
    protected SootMethod markAtomicWriteArrayMethod;
    protected SootMethod initMethod;
    protected SootMethod startFinishMethod;
    protected SootMethod endFinishMethod;
    protected SootMethod startAsyncMethod;
    protected SootMethod endAsyncMethod;
    protected SootMethod objectConstructor;
    protected InvokeStmt initSt;
    protected SootMethod objectAllocateMethod;
    public boolean insideIsolatedSection;

    public RaceDetInstrumentor(Singletons.Global g) {
    }

    public static RaceDetInstrumentor v() {
        return G.v().soot_HjToJimple_racedet_RaceDetInstrumentor();
    }

    @Override
    protected void internalTransform(String phase, Map opts) {
        JimpleBody body;
        System.out.println("Instrumenting the program for data race detection");
        this.applicationMethods = new HashSet<SootMethod>();
        this.applicationClones = new HashSet<SootMethod>();
        this.constructors = new HashSet<SootMethod>();
        this.abstractMethods = new HashSet<SootMethod>();
        this.methodsNeedingPartialInstrumentation = new HashSet<SootMethod>();
        this.methodsNeedingFullInstrumentation = new HashSet<SootMethod>();
        this.fieldNumbers = new HashMap<SootField, Integer>();
        this.staticFieldsOfClasses = new HashMap<SootClass, Integer>();
        this.instanceFieldsOfClasses = new HashMap<SootClass, Integer>();
        this.cloneMethods = new HashMap<SootMethod, SootMethod>();
        this.originalMethods = new HashMap<SootMethod, SootMethod>();
        this.cloneTaskLocals = new HashMap<SootMethod, Value>();
        this.staticObjectFields = new HashMap<SootClass, SootField>();
        this.extendsLibraryClass = new HashSet<SootClass>();
        this.insideIsolatedSection = false;
        this.staticObjectClass = null;
        this.staticObjectConstructor = null;
        currPackage = SPbagsPackage;
        this.initReferences();
        this.collectApplicationMethods();
        for (SootMethod sMethod : this.applicationMethods) {
            SootMethod cloneMethod;
            if (sMethod.getName().equals("main")) {
                this.mainMethod = sMethod;
                cloneMethod = sMethod;
            } else {
                cloneMethod = this.createClone(sMethod);
            }
            this.applicationClones.add(cloneMethod);
            this.cloneMethods.put(sMethod, cloneMethod);
            this.originalMethods.put(cloneMethod, sMethod);
            HjRSTTranslator.v().rebuildRST(cloneMethod.getActiveBody(), phase, null);
            this.collectProperties((JimpleBody)cloneMethod.getActiveBody(), cloneMethod.getRSTNode());
        }
        this.collectFieldsData();
        this.collectMethodsNeedingInstrumentation();
        Stmt firstSt = ((JimpleBody)this.mainMethod.getActiveBody()).getFirstNonIdentityStmt();
        this.mainMethod.getActiveBody().getUnits().insertBefore((Stmt)this.initSt.clone(), (Unit)firstSt);
        LocalGenerator lg = new LocalGenerator(this.mainMethod.getActiveBody());
        Local local = lg.generateLocal("_task_", this.TaskObjectClass.getType());
        this.mainMethod.getActiveBody().getUnits().insertBefore(Jimple.v().newAssignStmt(local, Jimple.v().newStaticInvokeExpr(this.startFinishMethod.makeRef(), NullConstant.v())), (Unit)firstSt);
        this.cloneTaskLocals.put(this.mainMethod, local);
        for (SootMethod sMethod : this.abstractMethods) {
            this.cloneAbstractMethod(sMethod);
        }
        for (SootMethod cloneMethod : this.methodsNeedingFullInstrumentation) {
            body = (JimpleBody)cloneMethod.getActiveBody();
            Value value = this.cloneTaskLocals.get(cloneMethod);
            this.instrumentParallelRegions(body, cloneMethod.getRSTNode(), (Stmt)body.getUnits().getFirst(), (Stmt)body.getUnits().getLast(), value);
        }
        for (SootMethod cloneMethod : this.methodsNeedingPartialInstrumentation) {
            body = (JimpleBody)cloneMethod.getActiveBody();
            Value value = this.cloneTaskLocals.get(cloneMethod);
            Iterator<Unit> iterator = body.getUnits().snapshotIterator();
            while (iterator.hasNext()) {
                Stmt st = (Stmt)iterator.next();
                if (st instanceof RegionStmt) {
                    RegionStmt rst = (RegionStmt)st;
                    if (rst.isFinishRegion()) {
                        this.instrumentParallelRegions(body, rst.getRSTNode(), value);
                        Stmt end = rst.getConnect();
                        while (iterator.hasNext() && iterator.next() != end) {
                        }
                        continue;
                    }
                    if (!rst.isAsyncRegion() && !rst.isForEachRegion()) continue;
                    System.out.println("Region stmt: " + rst);
                    throw new RuntimeException("Async/Foreach outside all Finishes");
                }
                if (!st.containsInvokeExpr()) continue;
                this.updateMethodCall(st, value);
            }
        }
        for (SootMethod cloneMethod : this.applicationClones) {
            if (this.methodsNeedingPartialInstrumentation.contains(cloneMethod) || this.methodsNeedingFullInstrumentation.contains(cloneMethod)) continue;
            Value taskLocal2 = this.cloneTaskLocals.get(cloneMethod);
            for (Stmt stmt : cloneMethod.getActiveBody().getUnits()) {
                if (!stmt.containsInvokeExpr()) continue;
                this.updateMethodCall(stmt, taskLocal2);
            }
        }
        for (SootMethod sMethod : this.constructors) {
            for (Stmt stmt : sMethod.getActiveBody().getUnits()) {
                if (!stmt.containsInvokeExpr()) continue;
                this.updateMethodCall(stmt, NullConstant.v());
            }
        }
        for (SootMethod sMethod : this.applicationMethods) {
            if (sMethod == this.mainMethod) continue;
            sMethod.getDeclaringClass().removeMethod(sMethod);
        }
        for (SootMethod sMethod : this.abstractMethods) {
            sMethod.getDeclaringClass().removeMethod(sMethod);
        }
        new SuperClassReplacer(this.JavaLangObjectClass, this.HJLangObjectClass, this.BaseObjectClass);
        for (SootMethod sMethod : this.applicationClones) {
            this.addAllocateCall(sMethod);
        }
        for (SootMethod sMethod : this.constructors) {
            this.addAllocateCall(sMethod);
        }
        for (SootMethod sMethod : this.constructors) {
            this.addDefaultAllocateCallForConstructor(sMethod);
        }
        for (SootClass sc : this.extendsLibraryClass) {
            System.out.println("Objects of type \"" + sc + "\" will not be monitored for data races because it descends from a library class");
        }
    }

    public void initReferences() {
        this.RaceDetMainClass = Scene.v().getSootClass(currPackage + RaceDetMainClassName);
        this.TaskObjectClass = Scene.v().getSootClass(currPackage + TaskObjectClassName);
        this.FinishObjectClass = Scene.v().getSootClass(currPackage + FinishObjectClassName);
        this.AsyncObjectClass = Scene.v().getSootClass(currPackage + AsyncObjectClassName);
        this.BaseObjectClass = Scene.v().getSootClass(BaseObjectClassName);
        this.HJLangObjectClass = Scene.v().getSootClass(HJLangObjectClassName);
        this.JavaLangObjectClass = Scene.v().getSootClass(JavaLangObjectClassName);
        this.ArrayViewClass = null;
        this.initMethod = this.RaceDetMainClass.getMethodByName(InitMethodName);
        this.startFinishMethod = this.RaceDetMainClass.getMethodByName(StartFinishMethodName);
        this.endFinishMethod = this.RaceDetMainClass.getMethodByName(EndFinishMethodName);
        this.startAsyncMethod = this.RaceDetMainClass.getMethodByName(StartAsyncMethodName);
        this.endAsyncMethod = this.RaceDetMainClass.getMethodByName(EndAsyncMethodName);
        this.markReadMethod = this.RaceDetMainClass.getMethodByName(MarkReadMethodName);
        this.markReadViewMethod = this.RaceDetMainClass.getMethodByName(MarkReadViewMethodName);
        this.markReadArrayMethod = this.RaceDetMainClass.getMethodByName(MarkReadArrayMethodName);
        this.markWriteMethod = this.RaceDetMainClass.getMethodByName(MarkWriteMethodName);
        this.markWriteViewMethod = this.RaceDetMainClass.getMethodByName(MarkWriteViewMethodName);
        this.markWriteArrayMethod = this.RaceDetMainClass.getMethodByName(MarkWriteArrayMethodName);
        this.markAtomicReadMethod = this.RaceDetMainClass.getMethodByName(MarkAtomicReadMethodName);
        this.markAtomicReadViewMethod = this.RaceDetMainClass.getMethodByName(MarkAtomicReadViewMethodName);
        this.markAtomicReadArrayMethod = this.RaceDetMainClass.getMethodByName(MarkAtomicReadArrayMethodName);
        this.markAtomicWriteMethod = this.RaceDetMainClass.getMethodByName(MarkAtomicWriteMethodName);
        this.markAtomicWriteViewMethod = this.RaceDetMainClass.getMethodByName(MarkAtomicWriteViewMethodName);
        this.markAtomicWriteArrayMethod = this.RaceDetMainClass.getMethodByName(MarkAtomicWriteArrayMethodName);
        this.objectConstructor = this.BaseObjectClass.getMethod("void <init>()");
        this.objectAllocateMethod = this.BaseObjectClass.getMethod(AllocateMethodName);
        this.initSt = Jimple.v().newInvokeStmt(Jimple.v().newStaticInvokeExpr(this.initMethod.makeRef()));
        this.markReadWriteMethod = this.markWriteMethod;
        this.markReadWriteViewMethod = this.RaceDetMainClass.getMethodByName(MarkWriteViewMethodName + "_");
        this.markAtomicReadWriteMethod = this.markAtomicWriteMethod;
        this.markAtomicReadWriteViewMethod = this.markAtomicWriteViewMethod;
    }

    public void collectApplicationMethods() {
        for (SootClass sClass : Scene.v().getApplicationClasses()) {
            if (this.doesExtendLibraryClass(sClass)) {
                this.extendsLibraryClass.add(sClass);
            }
            Iterator<SootMethod> methodsIt = sClass.methodIterator();
            while (methodsIt.hasNext()) {
                SootMethod sMethod = methodsIt.next();
                if (!this.needToBeTranslated(sMethod)) continue;
                this.applicationMethods.add(sMethod);
            }
        }
    }

    private boolean needToBeTranslated(SootMethod sMethod) {
        if (sMethod.getName().equals("<init>")) {
            this.constructors.add(sMethod);
            return false;
        }
        if (sMethod.getName().equals("<cinit>")) {
            this.constructors.add(sMethod);
            return false;
        }
        if (sMethod.getName().equals("<clinit>")) {
            this.constructors.add(sMethod);
            return false;
        }
        if (sMethod.isAbstract()) {
            this.abstractMethods.add(sMethod);
            return false;
        }
        return true;
    }

    private void collectProperties(JimpleBody body, RSTNode node) {
        PropertiesTag pTag;
        if (node.isFinishNode()) {
            pTag = this.addPropertiesTag(body.getMethod());
            pTag.containsFinish = true;
        } else if (node.isAsyncNode()) {
            pTag = this.addPropertiesTag(body.getMethod());
            pTag.containsAsync = true;
        } else if (node.isForEachNode()) {
            pTag = this.addPropertiesTag(body.getMethod());
            pTag.containsForeach = true;
        } else if (node.isIsolatedNode()) {
            pTag = this.addPropertiesTag(body.getMethod());
            pTag.containsIsolated = true;
        }
        Iterator<RSTNode> subnodesIt = node.getSubNodes().iterator();
        while (subnodesIt.hasNext()) {
            this.collectProperties(body, subnodesIt.next());
        }
    }

    private PropertiesTag addPropertiesTag(SootMethod sMethod) {
        if (sMethod.hasTag(PropertiesTag.NAME)) {
            return (PropertiesTag)sMethod.getTag(PropertiesTag.NAME);
        }
        PropertiesTag pTag = new PropertiesTag();
        sMethod.addTag(pTag);
        return pTag;
    }

    private boolean containsFinish(SootMethod sMethod) {
        if (sMethod.hasTag(PropertiesTag.NAME)) {
            return ((PropertiesTag)sMethod.getTag((String)PropertiesTag.NAME)).containsFinish;
        }
        return false;
    }

    private boolean containsAsync(SootMethod sMethod) {
        if (sMethod.hasTag(PropertiesTag.NAME)) {
            return ((PropertiesTag)sMethod.getTag((String)PropertiesTag.NAME)).containsAsync;
        }
        return false;
    }

    private boolean containsForeach(SootMethod sMethod) {
        if (sMethod.hasTag(PropertiesTag.NAME)) {
            return ((PropertiesTag)sMethod.getTag((String)PropertiesTag.NAME)).containsForeach;
        }
        return false;
    }

    private boolean containsIsolated(SootMethod sMethod) {
        if (sMethod.hasTag(PropertiesTag.NAME)) {
            return ((PropertiesTag)sMethod.getTag((String)PropertiesTag.NAME)).containsIsolated;
        }
        return false;
    }

    public void collectFieldsData() {
        this.collectStaticFieldsData();
        this.collectInstanceFieldsData();
    }

    public void collectStaticFieldsData() {
        for (SootClass sClass : Scene.v().getApplicationClasses()) {
            Iterator<SootField> fieldsIt = sClass.getFields().iterator();
            int count = 0;
            while (fieldsIt.hasNext()) {
                SootField sField = fieldsIt.next();
                if (!sField.isStatic() || sField.isFinal()) continue;
                assert (!this.fieldNumbers.containsKey(sField));
                this.fieldNumbers.put(sField, count);
                ++count;
                if (!debug2) continue;
                System.out.println("\tAdding soot field : " + sField);
            }
            assert (!this.staticFieldsOfClasses.containsKey(sClass));
            this.staticFieldsOfClasses.put(sClass, count);
            if (!debug2) continue;
            System.out.println("Adding class : " + sClass);
        }
    }

    private void collectInstanceFieldsData() {
        HashSet<SootClass> toBeProcessed = new HashSet<SootClass>();
        for (SootClass sClass : Scene.v().getApplicationClasses()) {
            toBeProcessed.add(sClass);
        }
        this.collectInstanceFieldsData(toBeProcessed);
        for (SootClass sClass : Scene.v().getApplicationClasses()) {
            if (!sClass.getSuperclass().isApplicationClass()) continue;
            this.setInstanceFieldsOfSuperClasses(sClass.getSuperclass(), this.instanceFieldsOfClasses.get(sClass));
        }
    }

    private void collectInstanceFieldsData(HashSet<SootClass> toBeProcessed) {
        Iterator<SootClass> classesIt = toBeProcessed.iterator();
        HashSet<SootClass> superClasses = new HashSet<SootClass>();
        while (classesIt.hasNext()) {
            SootClass sClass = classesIt.next();
            if (!toBeProcessed.contains(sClass.getSuperclass())) continue;
            superClasses.add(sClass.getSuperclass());
        }
        if (!superClasses.isEmpty()) {
            this.collectInstanceFieldsData(superClasses);
        }
        for (SootClass sClass : toBeProcessed) {
            if (superClasses.contains(sClass)) continue;
            int count = 0;
            if (superClasses.contains(sClass.getSuperclass())) {
                assert (this.instanceFieldsOfClasses.containsKey(sClass.getSuperclass()));
                count = this.instanceFieldsOfClasses.get(sClass.getSuperclass());
            }
            for (SootField sField : sClass.getFields()) {
                if (sField.isStatic() || sField.isFinal()) continue;
                assert (!this.fieldNumbers.containsKey(sField));
                this.fieldNumbers.put(sField, count);
                ++count;
            }
            assert (!this.instanceFieldsOfClasses.containsKey(sClass));
            this.instanceFieldsOfClasses.put(sClass, count);
        }
    }

    private void setInstanceFieldsOfSuperClasses(SootClass sClass, int count) {
        int origCount = this.instanceFieldsOfClasses.get(sClass);
        if (origCount < count) {
            this.instanceFieldsOfClasses.put(sClass, count);
            if (sClass.getSuperclass().isApplicationClass()) {
                this.setInstanceFieldsOfSuperClasses(sClass.getSuperclass(), count);
            }
        }
    }

    private void collectMethodsNeedingInstrumentation() {
        for (SootMethod sMethod : this.applicationClones) {
            if (!this.containsFinish(sMethod)) continue;
            this.methodsNeedingPartialInstrumentation.add(sMethod);
        }
        for (SootMethod sMethod : this.methodsNeedingPartialInstrumentation) {
            JimpleBody body = (JimpleBody)sMethod.getActiveBody();
            this.collectMethodsNeedingInstrumentation(body, sMethod.getRSTNode());
        }
        HashSet<SootMethod> moreMethods = new HashSet<SootMethod>();
        while (true) {
            moreMethods.clear();
            for (SootMethod sM : this.methodsNeedingFullInstrumentation) {
                for (Stmt stmt : sM.getActiveBody().getUnits()) {
                    SootMethod cM;
                    SootMethod callMethod;
                    if (!stmt.containsInvokeExpr() || (callMethod = stmt.getInvokeExpr().getMethod()) == null || !this.cloneMethods.containsKey(callMethod) || this.methodsNeedingFullInstrumentation.contains(cM = this.cloneMethods.get(callMethod))) continue;
                    moreMethods.add(cM);
                }
            }
            if (moreMethods.size() == 0) break;
            this.methodsNeedingFullInstrumentation.addAll(moreMethods);
        }
        for (SootMethod sMethod : this.methodsNeedingFullInstrumentation) {
            this.methodsNeedingPartialInstrumentation.remove(sMethod);
        }
        if (debug) {
            System.out.println("Methods Needing Partial Instrumentation");
            Iterator<SootMethod> methodsIt = this.methodsNeedingPartialInstrumentation.iterator();
            while (methodsIt.hasNext()) {
                System.out.println("\t" + methodsIt.next());
            }
            System.out.println("Methods Needing Full Instrumentation");
            methodsIt = this.methodsNeedingFullInstrumentation.iterator();
            while (methodsIt.hasNext()) {
                System.out.println("\t\t" + methodsIt.next());
            }
        }
    }

    private void collectMethodsNeedingInstrumentation(JimpleBody body, RSTNode node) {
        if (node.isFinishNode()) {
            this.collectMethodsNeedingInstrumentation(body, node.getNodeStmt(), ((RegionStmt)node.getNodeStmt()).getConnect());
        } else {
            Iterator<RSTNode> subnodesIt = node.getSubNodes().iterator();
            while (subnodesIt.hasNext()) {
                this.collectMethodsNeedingInstrumentation(body, subnodesIt.next());
            }
        }
    }

    private void collectMethodsNeedingInstrumentation(JimpleBody body, Stmt st, Stmt end) {
        Iterator<Unit> unitsIt = body.getUnits().iterator(st, end);
        while (unitsIt.hasNext()) {
            SootMethod callMethod;
            Stmt s = (Stmt)unitsIt.next();
            if (!s.containsInvokeExpr() || (callMethod = s.getInvokeExpr().getMethod()) == null || !this.cloneMethods.containsKey(callMethod)) continue;
            this.methodsNeedingFullInstrumentation.add(this.cloneMethods.get(callMethod));
        }
    }

    private boolean isALibraryClass(SootClass sClass) {
        if (Scene.v().getApplicationClasses().contains(sClass)) {
            return false;
        }
        return sClass != this.HJLangObjectClass;
    }

    private boolean doesExtendLibraryClass(SootClass sClass) {
        for (SootClass superClass = sClass.getSuperclass(); superClass != this.JavaLangObjectClass; superClass = superClass.getSuperclass()) {
            if (superClass != this.HJLangObjectClass) continue;
            return false;
        }
        return true;
    }

    public SootMethod createClone(SootMethod sMethod) {
        ArrayList<RefType> params = new ArrayList<RefType>();
        params.addAll(sMethod.getParameterTypes());
        params.add(this.TaskObjectClass.getType());
        SootMethod clone = new SootMethod(sMethod.getName(), params, sMethod.getReturnType(), sMethod.getModifiers(), sMethod.getExceptions());
        sMethod.getDeclaringClass().addMethod(clone);
        JimpleBody body = (JimpleBody)sMethod.getActiveBody();
        sMethod.releaseActiveBody();
        clone.setActiveBody(body);
        LocalGenerator lg = new LocalGenerator(body);
        Local taskLocal = lg.generateLocal("_task_", this.TaskObjectClass.getType());
        this.cloneTaskLocals.put(clone, taskLocal);
        body.getUnits().insertBefore(Jimple.v().newIdentityStmt(taskLocal, Jimple.v().newParameterRef(this.TaskObjectClass.getType(), params.indexOf(this.TaskObjectClass.getType()))), (Unit)body.getFirstNonIdentityStmt());
        return clone;
    }

    public SootMethod cloneAbstractMethod(SootMethod sMethod) {
        ArrayList<RefType> params = new ArrayList<RefType>();
        params.addAll(sMethod.getParameterTypes());
        params.add(this.TaskObjectClass.getType());
        SootMethod clone = new SootMethod(sMethod.getName(), params, sMethod.getReturnType(), sMethod.getModifiers(), sMethod.getExceptions());
        this.cloneMethods.put(sMethod, clone);
        sMethod.getDeclaringClass().addMethod(clone);
        return clone;
    }

    protected void instrumentParallelRegions(JimpleBody body, RSTNode node, Value taskLocal) {
        Stmt end;
        Stmt start;
        LocalGenerator lg = new LocalGenerator(body);
        if (debug2) {
            System.out.println("Examining Node : " + node);
        }
        if (node.isFinishNode()) {
            start = node.getNodeStmt();
            end = ((RegionStmt)node.getNodeStmt()).getConnect();
            Local finishLocal = lg.generateLocal("_finish_", this.FinishObjectClass.getType());
            body.getUnits().insertAfter(Jimple.v().newAssignStmt(finishLocal, Jimple.v().newStaticInvokeExpr(this.startFinishMethod.makeRef(), taskLocal)), (Unit)start);
            body.getUnits().insertBefore(Jimple.v().newInvokeStmt(Jimple.v().newStaticInvokeExpr(this.endFinishMethod.makeRef(), finishLocal)), (Unit)end);
            this.instrumentParallelRegions(body, node, start, end, finishLocal);
        }
        if (node.isAsyncNode()) {
            if (debug2) {
                System.out.println(" An Async Node : " + node);
            }
            start = node.getNodeStmt();
            end = ((RegionStmt)node.getNodeStmt()).getConnect();
            Local asyncLocal = lg.generateLocal("_async_", this.AsyncObjectClass.getType());
            body.getUnits().insertAfter(Jimple.v().newAssignStmt(asyncLocal, Jimple.v().newStaticInvokeExpr(this.startAsyncMethod.makeRef(), taskLocal)), (Unit)start);
            body.getUnits().insertBefore(Jimple.v().newInvokeStmt(Jimple.v().newStaticInvokeExpr(this.endAsyncMethod.makeRef(), asyncLocal)), (Unit)end);
            this.instrumentParallelRegions(body, node, start, end, asyncLocal);
        }
        if (node.isForEachNode()) {
            if (debug2) {
                System.out.println(" A Foreach Node : ");
            }
            start = node.getNodeStmt();
            end = ((RegionStmt)node.getNodeStmt()).getConnect();
            Local foreachLocal = lg.generateLocal("_async_", this.AsyncObjectClass.getType());
            body.getUnits().insertAfter(Jimple.v().newAssignStmt(foreachLocal, Jimple.v().newStaticInvokeExpr(this.startAsyncMethod.makeRef(), taskLocal)), (Unit)start);
            body.getUnits().insertBefore(Jimple.v().newInvokeStmt(Jimple.v().newStaticInvokeExpr(this.endAsyncMethod.makeRef(), foreachLocal)), (Unit)end);
            this.instrumentParallelRegions(body, node, start, end, foreachLocal);
        }
        if (node.isIsolatedNode()) {
            this.insideIsolatedSection = true;
            start = node.getNodeStmt();
            end = ((RegionStmt)node.getNodeStmt()).getConnect();
            this.instrumentParallelRegions(body, node, start, end, taskLocal);
            this.insideIsolatedSection = false;
        }
        if (node.isForLoopNode()) {
            start = node.getRegionStmt();
            end = start.getConnect();
            this.instrumentParallelRegions(body, node, start, end, taskLocal);
        }
    }

    protected void instrumentParallelRegions(JimpleBody body, RSTNode node, Stmt start, Stmt end, Value taskLocal) {
        Stmt st;
        Iterator<Unit> unitsIt = body.getUnits().snapshotIterator();
        while (unitsIt.hasNext() && (st = (Stmt)unitsIt.next()) != start) {
        }
        this.instrumentStmt(body, start, taskLocal);
        while (unitsIt.hasNext()) {
            st = (Stmt)unitsIt.next();
            if (st instanceof RegionStmt) {
                RegionStmt rst = (RegionStmt)st;
                if (rst.isFinishRegion() || rst.isAsyncRegion() || rst.isForEachRegion() || rst.isForLoopRegion()) {
                    Stmt s;
                    Stmt rstEnd = rst.getConnect();
                    while (unitsIt.hasNext() && (s = (Stmt)unitsIt.next()) != rstEnd) {
                    }
                    st = rstEnd;
                }
            } else {
                this.instrumentStmt(body, st, taskLocal);
            }
            if (st != end) continue;
            break;
        }
        Iterator<RSTNode> subnodesIt = node.getSubNodes().iterator();
        while (subnodesIt.hasNext()) {
            this.instrumentParallelRegions(body, subnodesIt.next(), taskLocal);
        }
    }

    protected void instrumentStmt(JimpleBody body, Stmt st, Value taskLocal) {
        if (st.containsInvokeExpr()) {
            this.updateMethodCall(st, taskLocal);
        }
        if (st instanceof AssignStmt) {
            AssignStmt assignSt = (AssignStmt)st;
            Value leftOp = assignSt.getLeftOp();
            Value rightOp = assignSt.getRightOp();
            if (this.insideIsolatedSection) {
                if (rightOp instanceof FieldRef) {
                    this.addCodeForFieldRef((FieldRef)rightOp, body, st, taskLocal, this.markAtomicReadMethod);
                } else if (rightOp instanceof ArrayRef) {
                    this.addCodeForArrayRef((ArrayRef)rightOp, body, st, taskLocal, this.markAtomicReadArrayMethod);
                }
                if (leftOp instanceof FieldRef) {
                    this.addCodeForFieldRef((FieldRef)leftOp, body, st, taskLocal, this.markAtomicWriteMethod);
                } else if (leftOp instanceof ArrayRef) {
                    this.addCodeForArrayRef((ArrayRef)leftOp, body, st, taskLocal, this.markAtomicWriteArrayMethod);
                }
            } else {
                if (rightOp instanceof FieldRef) {
                    this.addCodeForFieldRef((FieldRef)rightOp, body, st, taskLocal, this.markReadMethod);
                } else if (rightOp instanceof ArrayRef) {
                    this.addCodeForArrayRef((ArrayRef)rightOp, body, st, taskLocal, this.markReadArrayMethod);
                }
                if (leftOp instanceof FieldRef) {
                    this.addCodeForFieldRef((FieldRef)leftOp, body, st, taskLocal, this.markWriteMethod);
                } else if (leftOp instanceof ArrayRef) {
                    this.addCodeForArrayRef((ArrayRef)leftOp, body, st, taskLocal, this.markWriteArrayMethod);
                }
            }
        }
        if (st.containsInvokeExpr()) {
            InvokeExpr invExpr = st.getInvokeExpr();
            SootMethod calledMethod = invExpr.getMethod();
        }
    }

    protected void addCodeForFieldRef(FieldRef fRef, JimpleBody body, Stmt beforeSt, Value taskLocal, SootMethod callMethod) {
        int size;
        Value field;
        SootField sField = fRef.getField();
        if (!sField.getDeclaringClass().isApplicationClass()) {
            return;
        }
        if (this.doesExtendLibraryClass(sField.getDeclaringClass())) {
            this.extendsLibraryClass.add(sField.getDeclaringClass());
            return;
        }
        if (sField.isFinal()) {
            return;
        }
        if (debug2) {
            System.out.println("SootField = " + sField);
            System.out.println("  Declaring class = " + sField.getDeclaringClass());
        }
        if (fRef instanceof InstanceFieldRef) {
            InstanceFieldRef ifRef = (InstanceFieldRef)fRef;
            field = ifRef.getBase();
            size = this.instanceFieldsOfClasses.get(sField.getDeclaringClass());
        } else if (fRef instanceof StaticFieldRef) {
            StaticFieldRef sfRef = (StaticFieldRef)fRef;
            field = this.getStaticObjectField(sfRef, body, beforeSt);
            size = this.staticFieldsOfClasses.get(sField.getDeclaringClass());
        } else {
            throw new RuntimeException("DJC Error: Unhandled FieldRef type");
        }
        ArrayList<Value> params = new ArrayList<Value>();
        params.add(taskLocal);
        params.add(field);
        params.add(IntConstant.v(size));
        params.add(IntConstant.v(this.fieldNumbers.get(sField)));
        this.addSourcePositionInformation(body, beforeSt, params);
        body.getUnits().insertBefore(Jimple.v().newInvokeStmt(Jimple.v().newStaticInvokeExpr(callMethod.makeRef(), params)), (Unit)beforeSt);
    }

    private void addSourcePositionInformation(JimpleBody body, Stmt beforeSt, List<Value> params) {
        SourceLnPosTag t = (SourceLnPosTag)beforeSt.getTag("SourceLnPosTag");
        if (t != null) {
            LocalGenerator lg = new LocalGenerator(body);
            Local sourceTag = lg.generateLocal("_sourceTag_", Scene.v().getRefType("java.lang.String"));
            AssignStmt newSt = Jimple.v().newAssignStmt(sourceTag, StringConstant.v(beforeSt.getTag("SourceLnPosTag").toString()));
            body.getUnits().insertBefore(newSt, (Unit)beforeSt);
            if (t instanceof SourceLnNamePosTag) {
                params.add(StringConstant.v(((SourceLnNamePosTag)t).getFileName()));
            } else {
                params.add(NullConstant.v());
            }
            params.add(IntConstant.v(t.startLn()));
            params.add(IntConstant.v(t.endLn()));
            params.add(IntConstant.v(t.startPos()));
            params.add(IntConstant.v(t.endPos()));
        } else {
            params.add(NullConstant.v());
            params.add(IntConstant.v(0));
            params.add(IntConstant.v(0));
            params.add(IntConstant.v(0));
            params.add(IntConstant.v(0));
        }
    }

    protected void addCodeForArrayView(Value view, Value pos, JimpleBody body, Stmt beforeSt, Value taskLocal, SootMethod callMethod) {
        ArrayList<Value> params = new ArrayList<Value>();
        params.add(taskLocal);
        params.add(view);
        params.add(pos);
        this.addSourcePositionInformation(body, beforeSt, params);
        body.getUnits().insertBefore(Jimple.v().newInvokeStmt(Jimple.v().newStaticInvokeExpr(callMethod.makeRef(), params)), (Unit)beforeSt);
    }

    private void addCodeForArrayRef(ArrayRef aRef, JimpleBody body, Stmt beforeSt, Value taskLocal, SootMethod callMethod) {
        LocalGenerator lg = new LocalGenerator(body);
        Local lenLocal = lg.generateLocal("_int_", IntType.v());
        AssignStmt lenSt = Jimple.v().newAssignStmt(lenLocal, Jimple.v().newLengthExpr(aRef.getBase()));
        body.getUnits().insertBefore(lenSt, (Unit)beforeSt);
        ArrayList<Value> params = new ArrayList<Value>();
        params.add(taskLocal);
        params.add(aRef.getBase());
        params.add(lenLocal);
        params.add(aRef.getIndex());
        this.addSourcePositionInformation(body, beforeSt, params);
        body.getUnits().insertBefore(Jimple.v().newInvokeStmt(Jimple.v().newStaticInvokeExpr(callMethod.makeRef(), params)), (Unit)beforeSt);
    }

    protected Value getStaticObjectField(StaticFieldRef sfRef, JimpleBody body, Stmt beforeSt) {
        SootField sField = sfRef.getField();
        SootClass sClass = sField.getDeclaringClass();
        SootField staticObjectField = this.staticObjectFields.get(sClass);
        if (staticObjectField == null) {
            JimpleBody constructorBody;
            staticObjectField = new SootField("_static_object", this.BaseObjectClass.getType(), 9);
            if (this.staticObjectClass == null) {
                this.staticObjectClass = new SootClass("DJCStaticObjectClass");
                this.staticObjectClass.setSuperclass(this.BaseObjectClass);
                Scene.v().addClass(this.staticObjectClass);
                this.staticObjectClass.setApplicationClass();
                this.staticObjectConstructor = new SootMethod("<clinit>", new ArrayList(), VoidType.v(), 8);
                this.staticObjectClass.addMethod(this.staticObjectConstructor);
                constructorBody = Jimple.v().newBody(this.staticObjectConstructor);
                this.staticObjectConstructor.setActiveBody(constructorBody);
                constructorBody.getUnits().add(Jimple.v().newReturnVoidStmt());
            }
            this.staticObjectClass.addField(staticObjectField);
            constructorBody = (JimpleBody)this.staticObjectConstructor.getActiveBody();
            LocalGenerator lg = new LocalGenerator(constructorBody);
            Local objectLocal = lg.generateLocal(this.BaseObjectClass.getType());
            Stmt firstSt = constructorBody.getFirstNonIdentityStmt();
            constructorBody.getUnits().insertBefore(Jimple.v().newAssignStmt(objectLocal, Jimple.v().newNewExpr(this.BaseObjectClass.getType())), (Unit)firstSt);
            constructorBody.getUnits().insertBefore(Jimple.v().newInvokeStmt(Jimple.v().newSpecialInvokeExpr(objectLocal, this.objectConstructor.makeRef())), (Unit)firstSt);
            constructorBody.getUnits().insertBefore(Jimple.v().newInvokeStmt(Jimple.v().newVirtualInvokeExpr(objectLocal, this.objectAllocateMethod.makeRef(), IntConstant.v(this.staticFieldsOfClasses.get(sClass)))), (Unit)firstSt);
            constructorBody.getUnits().insertBefore(Jimple.v().newAssignStmt(Jimple.v().newStaticFieldRef(staticObjectField.makeRef()), objectLocal), (Unit)firstSt);
            this.staticObjectFields.put(sClass, staticObjectField);
        }
        LocalGenerator lg = new LocalGenerator(body);
        Local staticObject = lg.generateLocal(this.BaseObjectClass.getType());
        body.getUnits().insertBefore(Jimple.v().newAssignStmt(staticObject, Jimple.v().newStaticFieldRef(staticObjectField.makeRef())), (Unit)beforeSt);
        return staticObject;
    }

    protected void updateMethodCall(Stmt st, Value taskLocal) {
        SootMethod sMethod = st.getInvokeExpr().getMethod();
        SootMethod clone = this.cloneMethods.get(sMethod);
        if (this.applicationClones.contains(clone) || this.abstractMethods.contains(sMethod)) {
            ValueBox invExprBox = st.getInvokeExprBox();
            InvokeExpr invExpr = st.getInvokeExpr();
            List args = invExpr.getArgs();
            args.add(taskLocal);
            if (invExpr instanceof InterfaceInvokeExpr) {
                InterfaceInvokeExpr iie = (InterfaceInvokeExpr)invExpr;
                invExprBox.setValue(Jimple.v().newInterfaceInvokeExpr((Local)iie.getBase(), clone.makeRef(), args));
            } else if (invExpr instanceof SpecialInvokeExpr) {
                SpecialInvokeExpr sie = (SpecialInvokeExpr)invExpr;
                invExprBox.setValue(Jimple.v().newSpecialInvokeExpr((Local)sie.getBase(), clone.makeRef(), args));
            } else if (invExpr instanceof StaticInvokeExpr) {
                StaticInvokeExpr sie = (StaticInvokeExpr)invExpr;
                invExprBox.setValue(Jimple.v().newStaticInvokeExpr(clone.makeRef(), args));
            } else if (invExpr instanceof VirtualInvokeExpr) {
                VirtualInvokeExpr vie = (VirtualInvokeExpr)invExpr;
                invExprBox.setValue(Jimple.v().newVirtualInvokeExpr((Local)vie.getBase(), clone.makeRef(), args));
            }
        }
    }

    protected void addAllocateCall(SootMethod sMethod) {
        JimpleBody body = (JimpleBody)sMethod.getActiveBody();
        Iterator<Unit> unitsIt = body.getUnits().snapshotIterator();
        while (unitsIt.hasNext()) {
            Stmt beforeSt;
            Stmt spInvSt;
            Value rightOp;
            Stmt st = (Stmt)unitsIt.next();
            if (!(st instanceof AssignStmt) || !((rightOp = ((AssignStmt)st).getRightOp()) instanceof NewExpr)) continue;
            Local leftOp = (Local)((AssignStmt)st).getLeftOp();
            NewExpr ne = (NewExpr)rightOp;
            Type newType = ne.getType();
            if (this.isArrayViewType(newType)) {
                if (this.ArrayViewClass == null) {
                    this.ArrayViewClass = Scene.v().getSootClass(ArrayViewClassName);
                }
                spInvSt = this.getNextSpInvSt(body, st);
                while (((SpecialInvokeExpr)spInvSt.getInvokeExpr()).getBase() != leftOp) {
                    spInvSt = (Stmt)body.getUnits().getSuccOf(spInvSt);
                    spInvSt = this.getNextSpInvSt(body, spInvSt);
                }
                beforeSt = (Stmt)body.getUnits().getSuccOf(spInvSt);
                LocalGenerator lg = new LocalGenerator(body);
                Local lenLocal = lg.generateLocal(IntType.v());
                body.getUnits().insertBefore(Jimple.v().newAssignStmt(lenLocal, Jimple.v().newVirtualInvokeExpr(leftOp, this.ArrayViewClass.getMethodByName("getBaseArrayLength").makeRef())), (Unit)beforeSt);
                body.getUnits().insertBefore(Jimple.v().newInvokeStmt(Jimple.v().newVirtualInvokeExpr(leftOp, this.objectAllocateMethod.makeRef(), lenLocal)), (Unit)beforeSt);
                continue;
            }
            if (!this.isHjLangObjectType(newType)) continue;
            spInvSt = this.getNextSpInvSt(body, st);
            while (((SpecialInvokeExpr)spInvSt.getInvokeExpr()).getBase() != leftOp) {
                spInvSt = (Stmt)body.getUnits().getSuccOf(spInvSt);
                spInvSt = this.getNextSpInvSt(body, spInvSt);
            }
            beforeSt = (Stmt)body.getUnits().getSuccOf(spInvSt);
            int numFields = this.instanceFieldsOfClasses.get(((RefType)newType).getSootClass());
            body.getUnits().insertBefore(Jimple.v().newInvokeStmt(Jimple.v().newVirtualInvokeExpr(leftOp, this.objectAllocateMethod.makeRef(), IntConstant.v(numFields))), (Unit)beforeSt);
        }
    }

    protected boolean isArrayViewType(Type t) {
        return false;
    }

    protected boolean isHjLangObjectType(Type t) {
        if (t instanceof RefType) {
            for (SootClass typeClass = ((RefType)t).getSootClass(); typeClass != this.JavaLangObjectClass; typeClass = typeClass.getSuperclass()) {
                if (typeClass != this.BaseObjectClass) continue;
                return true;
            }
        }
        return false;
    }

    protected Stmt getNextSpInvSt(JimpleBody body, Stmt st) {
        Iterator<Unit> unitsIt = body.getUnits().iterator(st);
        while (unitsIt.hasNext()) {
            Stmt nextSt = (Stmt)unitsIt.next();
            if (!nextSt.containsInvokeExpr() || !(nextSt.getInvokeExpr() instanceof SpecialInvokeExpr)) continue;
            return nextSt;
        }
        assert (false);
        return null;
    }

    protected void addDefaultAllocateCallForConstructor(SootMethod sMethod) {
        if (!sMethod.getName().equals("<init>")) {
            return;
        }
        if (!this.isHjLangObjectType(sMethod.getDeclaringClass().getType())) {
            return;
        }
        JimpleBody body = (JimpleBody)sMethod.getActiveBody();
        Stmt spInvSt = this.getNextSpInvSt(body, body.getFirstNonIdentityStmt());
        int numFields = this.instanceFieldsOfClasses.get(sMethod.getDeclaringClass());
        body.getUnits().insertAfter(Jimple.v().newInvokeStmt(Jimple.v().newVirtualInvokeExpr(body.getThisLocal(), this.objectAllocateMethod.makeRef(), IntConstant.v(numFields))), (Unit)spInvSt);
    }

    static {
        RaceDetMainClassName = "ESPbags";
        TaskObjectClassName = "TaskObject";
        FinishObjectClassName = "FinishObject";
        AsyncObjectClassName = "AsyncObject";
        BaseObjectClassName = SPbagsPackage + "RaceDetObject";
        HJLangObjectClassName = "hj.lang.Object";
        ArrayViewClassName = "hj.lib.array.view.ArrayView";
        JavaLangObjectClassName = "java.lang.Object";
        MarkReadMethodName = "markRead";
        MarkReadViewMethodName = "markReadView";
        MarkReadArrayMethodName = "markReadArray";
        MarkWriteMethodName = "markWrite";
        MarkWriteViewMethodName = "markWriteView";
        MarkWriteArrayMethodName = "markWriteArray";
        MarkAtomicReadMethodName = "markAtomicRead";
        MarkAtomicReadViewMethodName = "markAtomicReadView";
        MarkAtomicReadArrayMethodName = "markAtomicReadArray";
        MarkAtomicWriteMethodName = "markAtomicWrite";
        MarkAtomicWriteViewMethodName = "markAtomicWriteView";
        MarkAtomicWriteArrayMethodName = "markAtomicWriteArray";
        InitMethodName = "init";
        StartFinishMethodName = "startFinish";
        EndFinishMethodName = "endFinish";
        StartAsyncMethodName = "startAsync";
        EndAsyncMethodName = "endAsync";
        AllocateMethodName = "void allocate(int)";
    }
}

