/*
 * Decompiled with CFR 0.152.
 */
package soot.javaToJimple;

import polyglot.ast.ClassDecl;
import polyglot.ast.ConstructorDecl;
import polyglot.ast.LocalClassDecl;
import polyglot.ast.MethodDecl;
import polyglot.ast.Node;
import polyglot.visit.NodeVisitor;

public class StrictFPPropagator
extends NodeVisitor {
    boolean strict = false;

    public StrictFPPropagator(boolean val) {
        this.strict = val;
    }

    public NodeVisitor enter(Node parent, Node n) {
        if (n instanceof ClassDecl && ((ClassDecl)n).flags().flags().isStrictFP()) {
            return new StrictFPPropagator(true);
        }
        if (n instanceof LocalClassDecl && ((LocalClassDecl)n).decl().flags().flags().isStrictFP()) {
            return new StrictFPPropagator(true);
        }
        if (n instanceof MethodDecl && ((MethodDecl)n).flags().flags().isStrictFP()) {
            return new StrictFPPropagator(true);
        }
        if (n instanceof ConstructorDecl && ((ConstructorDecl)n).flags().flags().isStrictFP()) {
            return new StrictFPPropagator(true);
        }
        return this;
    }

    public Node leave(Node old, Node n, NodeVisitor nodeVisitor) {
        MethodDecl decl;
        if (n instanceof MethodDecl) {
            decl = (MethodDecl)n;
            if (this.strict && !decl.flags().flags().isAbstract() && !decl.flags().flags().isStrictFP()) {
                decl = decl.flags(decl.flags().flags(decl.flags().flags().StrictFP()));
                return decl;
            }
        }
        if (n instanceof ConstructorDecl) {
            decl = (ConstructorDecl)n;
            if (this.strict && !decl.flags().flags().isAbstract() && !decl.flags().flags().isStrictFP()) {
                return decl.flags(decl.flags().flags(decl.flags().flags().StrictFP()));
            }
        }
        if (n instanceof LocalClassDecl && (decl = (LocalClassDecl)n).decl().flags().flags().isStrictFP()) {
            return decl.decl().flags(decl.decl().flags().flags(decl.decl().flags().flags().clearStrictFP()));
        }
        if (n instanceof ClassDecl && (decl = (ClassDecl)n).flags().flags().isStrictFP()) {
            return decl.flags(decl.flags().flags(decl.flags().flags().clearStrictFP()));
        }
        return n;
    }
}

