/*
 * Decompiled with CFR 0.152.
 */
package soot.jimple.internal;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import soot.Unit;
import soot.UnitBox;
import soot.UnitPrinter;
import soot.baf.Baf;
import soot.baf.GotoInst;
import soot.jimple.GotoStmt;
import soot.jimple.Jimple;
import soot.jimple.JimpleToBafContext;
import soot.jimple.StmtSwitch;
import soot.jimple.internal.AbstractStmt;
import soot.tagkit.Tag;
import soot.util.Switch;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JGotoStmt
extends AbstractStmt
implements GotoStmt {
    UnitBox targetBox;
    List targetBoxes;

    public JGotoStmt(Unit target) {
        this(Jimple.v().newStmtBox(target));
    }

    public JGotoStmt(UnitBox box) {
        this.targetBox = box;
        this.targetBoxes = new ArrayList();
        this.targetBoxes.add(this.targetBox);
        this.targetBoxes = Collections.unmodifiableList(this.targetBoxes);
    }

    @Override
    public Object clone() {
        return new JGotoStmt(this.getTarget());
    }

    public String toString() {
        Unit t = this.getTarget();
        String target = "(branch)";
        if (!t.branches()) {
            target = t.toString();
        }
        return "goto [?= " + target + "]";
    }

    @Override
    public void toString(UnitPrinter up) {
        up.literal("goto");
        up.literal(" ");
        this.targetBox.toString(up);
    }

    @Override
    public Unit getTarget() {
        return this.targetBox.getUnit();
    }

    @Override
    public void setTarget(Unit target) {
        this.targetBox.setUnit(target);
    }

    @Override
    public void setTargetBox(Unit target) {
        this.targetBox.setUnit(target);
        this.targetBoxes = new ArrayList();
        this.targetBoxes.add(this.targetBox);
        this.targetBoxes = Collections.unmodifiableList(this.targetBoxes);
    }

    @Override
    public UnitBox getTargetBox() {
        return this.targetBox;
    }

    @Override
    public List getUnitBoxes() {
        return this.targetBoxes;
    }

    @Override
    public void apply(Switch sw) {
        ((StmtSwitch)sw).caseGotoStmt(this);
    }

    @Override
    public void convertToBaf(JimpleToBafContext context, List<Unit> out) {
        GotoInst u = Baf.v().newGotoInst(Baf.v().newPlaceholderInst(this.getTarget()));
        out.add(u);
        Iterator<Tag> it = this.getTags().iterator();
        while (it.hasNext()) {
            u.addTag(it.next());
        }
    }

    @Override
    public boolean fallsThrough() {
        return false;
    }

    @Override
    public boolean branches() {
        return true;
    }
}

