/*
 * Decompiled with CFR 0.152.
 */
package soot.jimple.toolkits.callgraph;

import java.util.Iterator;
import soot.Scene;
import soot.jimple.Stmt;
import soot.jimple.toolkits.callgraph.CallGraph;
import soot.jimple.toolkits.callgraph.Edge;
import soot.toolkits.graph.UnitGraph;
import soot.toolkits.scalar.ArraySparseSet;
import soot.toolkits.scalar.FlowSet;
import soot.toolkits.scalar.ForwardFlowAnalysis;

public class ClinitElimAnalysis
extends ForwardFlowAnalysis {
    private UnitGraph g;

    public ClinitElimAnalysis(UnitGraph g) {
        super(g);
        this.g = g;
        this.doAnalysis();
    }

    public void merge(Object in1, Object in2, Object out) {
        FlowSet inSet1 = (FlowSet)in1;
        FlowSet inSet2 = (FlowSet)in2;
        FlowSet outSet = (FlowSet)out;
        inSet1.intersection(inSet2, outSet);
    }

    public void copy(Object src, Object dest) {
        FlowSet srcIn = (FlowSet)src;
        FlowSet destOut = (FlowSet)dest;
        srcIn.copy(destOut);
    }

    protected void flowThrough(Object inVal, Object stmt, Object outVal) {
        FlowSet in = (FlowSet)inVal;
        FlowSet out = (FlowSet)outVal;
        Stmt s = (Stmt)stmt;
        in.copy(out);
        CallGraph cg = Scene.v().getCallGraph();
        Iterator<Edge> edges = cg.edgesOutOf(s);
        while (edges.hasNext()) {
            Edge e = edges.next();
            if (!e.isClinit()) continue;
            out.add(e.tgt());
        }
    }

    protected Object entryInitialFlow() {
        return new ArraySparseSet();
    }

    protected Object newInitialFlow() {
        ArraySparseSet set = new ArraySparseSet();
        CallGraph cg = Scene.v().getCallGraph();
        Iterator<Edge> mIt = cg.edgesOutOf(this.g.getBody().getMethod());
        while (mIt.hasNext()) {
            Edge edge = mIt.next();
            if (!edge.isClinit()) continue;
            set.add(edge.tgt());
        }
        return set;
    }
}

