/*
 * Decompiled with CFR 0.152.
 */
package soot.jimple.toolkits.thread.mhp;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import soot.Kind;
import soot.SootMethod;
import soot.Unit;
import soot.jimple.toolkits.callgraph.CallGraph;
import soot.jimple.toolkits.callgraph.Edge;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TargetMethodsFinder {
    public List<SootMethod> find(Unit unit, CallGraph cg, boolean canBeNullList, boolean canBeNative) {
        HashSet<SootMethod> clinit = new HashSet<SootMethod>();
        ArrayList<SootMethod> target = new ArrayList<SootMethod>();
        ArrayList<SootMethod> t = new ArrayList<SootMethod>();
        Iterator<Edge> it = cg.edgesOutOf(unit);
        while (it.hasNext()) {
            Edge edge = it.next();
            SootMethod targetMethod = edge.tgt();
            t.add(targetMethod);
            if (targetMethod.isNative()) {
                if (!canBeNative) continue;
                target.add(targetMethod);
            }
            if (edge.kind() == Kind.CLINIT) {
                clinit.add(targetMethod);
            }
            target.add(targetMethod);
        }
        if (target.size() > 1) {
            Iterator targetIt = target.iterator();
            while (targetIt.hasNext()) {
                SootMethod sm = (SootMethod)targetIt.next();
                if (!clinit.contains(sm)) continue;
                targetIt.remove();
            }
        }
        if (target.size() < 1 && !canBeNullList) {
            throw new RuntimeException("No target method for: " + unit);
        }
        return target;
    }
}

