/*
 * Decompiled with CFR 0.152.
 */
package lpg.runtime;

import java.util.HashMap;
import lpg.runtime.IPrsStream;

public abstract class Differ {
    static final int I_CODE = 0;
    static final int D_CODE = 1;
    static final int R_CODE = 2;
    static final int M_CODE = 3;
    static final int MM_CODE = 4;
    static final int IMI_CODE = 5;
    static final int MI_CODE = 6;
    static final int IM_CODE = 7;
    static final int DMD_CODE = 8;
    static final int MD_CODE = 9;
    static final int DM_CODE = 10;
    IPrsStream newStream;
    IPrsStream oldStream;
    int insertCount = 0;
    int deleteCount = 0;
    int replaceDeleteCount = 0;
    int replaceInsertCount = 0;
    int moveCount = 0;
    Change deleteRoot = null;
    Change insertRoot = null;
    Change replaceRoot = null;
    Change changeRoot = null;
    int changeCount = 0;
    int extraCount = 0;
    int newStart;
    int oldStart;
    int newEnd;
    int oldEnd;
    ILine[] newBuffer;
    ILine[] oldBuffer;
    HashMap newMap = new HashMap();
    int[] newLink;

    public abstract ILine[] getBuffer(IPrsStream var1);

    protected Differ() {
    }

    public Differ(IPrsStream iPrsStream, IPrsStream iPrsStream2) {
        int n;
        int n2;
        this.newStream = iPrsStream;
        this.oldStream = iPrsStream2;
        this.newBuffer = this.getBuffer(iPrsStream);
        this.oldBuffer = this.getBuffer(iPrsStream2);
        for (n2 = 1; n2 < this.newBuffer.length && n2 < this.oldBuffer.length && ((Object)this.newBuffer[n2]).equals(this.oldBuffer[n2]); ++n2) {
        }
        if (n2 == this.newBuffer.length && n2 == this.oldBuffer.length) {
            return;
        }
        this.newStart = n2;
        this.oldStart = n2;
        n2 = this.newBuffer.length - 1;
        for (n = this.oldBuffer.length - 1; n2 > this.newStart && n > this.oldStart && ((Object)this.newBuffer[n2]).equals(this.oldBuffer[n]); --n2, --n) {
        }
        this.newEnd = n2;
        this.oldEnd = n;
        this.newLink = new int[this.newBuffer.length];
        int[] nArray = new int[this.newBuffer.length];
        n2 = 1;
        while (n2 < this.newBuffer.length) {
            ILine iLine = this.newBuffer[n2];
            Integer n3 = (Integer)this.newMap.get(iLine);
            if (n3 == null) {
                n3 = new Integer(n2);
                this.newMap.put(iLine, n3);
            } else {
                this.newLink[nArray[n3.intValue()]] = n2;
            }
            nArray[n3.intValue()] = n2++;
        }
    }

    final int min(int n, int n2) {
        return n < n2 ? n : n2;
    }

    public final int getChangeCount() {
        return this.changeCount;
    }

    public final int getInsertCount() {
        return this.insertCount;
    }

    public final int getDeleteCount() {
        return this.deleteCount;
    }

    public final int getReplaceDeleteCount() {
        return this.replaceDeleteCount;
    }

    public final int getReplaceInsertCount() {
        return this.replaceInsertCount;
    }

    public final int getMoveCount() {
        return this.moveCount;
    }

    public void compare() {
        if (this.newLink != null) {
            this.compare(this.oldStart, this.oldEnd, this.newStart, this.newEnd);
            this.findMoves();
            this.mergeChanges();
        }
    }

    public void outputChanges() {
        for (Change change = this.changeRoot; change != null; change = change.getNext()) {
            if (change.getCode() == 0) {
                this.outputInsert(change);
                continue;
            }
            if (change.getCode() == 1) {
                this.outputDelete(change);
                continue;
            }
            if (change.getCode() == 2) {
                this.outputReplace(change);
                continue;
            }
            if (change.getCode() == 3) {
                this.outputMove(change);
                continue;
            }
            if (change.getCode() == 9) {
                this.outputMoveDelete(change);
                continue;
            }
            if (change.getCode() == 6) {
                this.outputMoveInsert(change);
                continue;
            }
            System.out.println("Don't know what to do with code " + change.getCode());
        }
    }

    void detach(ILine[] iLineArray, HashMap hashMap, int[] nArray, int n, int n2) {
        for (int i = n; i <= n2; ++i) {
            ILine iLine = iLineArray[i];
            Integer n3 = (Integer)hashMap.get(iLine);
            if (n3 == null) continue;
            int n4 = 0;
            int n5 = n3;
            while (n5 != i && n5 != 0) {
                n4 = n5;
                n5 = nArray[n5];
            }
            if (n4 == 0) {
                n5 = nArray[n3];
                if (n5 == 0) {
                    hashMap.remove(iLine);
                    continue;
                }
                hashMap.put(iLine, new Integer(n5));
                continue;
            }
            nArray[n4] = nArray[i];
        }
    }

    boolean compareSections(int n, int n2, int n3) {
        for (int i = 0; i <= n3; ++i) {
            if (((Object)this.oldBuffer[n + i]).equals(this.newBuffer[n2 + i])) continue;
            return false;
        }
        return true;
    }

    void addReplace(int n, int n2, int n3, int n4) {
        Change change;
        ++this.changeCount;
        this.detach(this.newBuffer, this.newMap, this.newLink, n3, n4);
        Change change2 = null;
        for (change = this.replaceRoot; change != null; change = change.getNext()) {
            int n5 = change.getOlde() - change.getOlds();
            int n6 = change.getNewe() - change.getNews();
            if (n5 == n4 - n3 && n6 == n2 - n && this.compareSections(change.getOlds(), n3, n5) && this.compareSections(n, change.getNews(), n6)) {
                Change change3 = new Change(3, change.getOlds(), change.getOlde(), n3, n4, this.changeCount);
                change3.setNext(this.changeRoot);
                this.changeRoot = change3;
                change.setCode(3);
                change.setOlds(n);
                change.setOlde(n2);
                if (change == this.replaceRoot) {
                    this.replaceRoot = change.getNext();
                } else {
                    change2.setNext(change.getNext());
                }
                change.setNext(this.changeRoot);
                this.changeRoot = change;
                return;
            }
            change2 = change;
        }
        change = new Change(2, n, n2, n3, n4, this.changeCount);
        change.setNext(this.replaceRoot);
        this.replaceRoot = change;
    }

    void findMoves() {
        Change change;
        Change change2;
        int n;
        Change change3;
        Change change4 = null;
        for (change3 = this.insertRoot; change3 != null && this.deleteRoot != null; change3 = change3.getNext()) {
            n = change3.getNewe() - change3.getNews();
            change2 = null;
            for (change = this.deleteRoot; change != null; change = change.getNext()) {
                if (n == change.getOlde() - change.getOlds() && this.similarSections(change, change3)) {
                    if (change == this.deleteRoot) {
                        this.deleteRoot = change.getNext();
                        break;
                    }
                    change2.setNext(change.getNext());
                    break;
                }
                change2 = change;
            }
            if (change3.getCode() != 0) {
                if (change3 == this.insertRoot) {
                    this.insertRoot = change3.getNext();
                } else {
                    change4.setNext(change3.getNext());
                }
                change3.setNext(this.changeRoot);
                this.changeRoot = change3;
            }
            change4 = change3;
        }
        change2 = null;
        for (change = this.deleteRoot; change != null && this.insertRoot != null; change = change.getNext()) {
            n = change.getOlde() - change.getOlds();
            if (n >= 2) {
                for (change3 = this.insertRoot; change3 != null; change3 = change3.getNext()) {
                    if (n < change3.getNewe() - change3.getNews() && this.deleteOverlap(change, change3)) {
                        if (change3 == this.insertRoot) {
                            this.insertRoot = change3.getNext();
                            break;
                        }
                        change4.setNext(change3.getNext());
                        break;
                    }
                    change4 = change3;
                }
                if (change.getCode() != 1) {
                    if (change == this.deleteRoot) {
                        this.deleteRoot = change.getNext();
                    } else {
                        change2.setNext(change.getNext());
                    }
                    change.setNext(this.changeRoot);
                    this.changeRoot = change;
                }
            }
            change2 = change;
        }
        change4 = null;
        for (change3 = this.insertRoot; change3 != null && this.deleteRoot != null; change3 = change3.getNext()) {
            n = change3.getNewe() - change3.getNews();
            if (n >= 2) {
                change2 = null;
                for (change = this.deleteRoot; change != null; change = change.getNext()) {
                    if (n < change.getOlde() - change.getOlds() && this.insertOverlap(change, change3)) {
                        if (change == this.deleteRoot) {
                            this.deleteRoot = change.getNext();
                            break;
                        }
                        change2.setNext(change.getNext());
                        break;
                    }
                    change2 = change;
                }
            }
            if (change3.getCode() != 0) {
                if (change3 == this.insertRoot) {
                    this.insertRoot = change3.getNext();
                } else {
                    change4.setNext(change3.getNext());
                }
                change3.setNext(this.changeRoot);
                this.changeRoot = change3;
            }
            change4 = change3;
        }
    }

    void compare(int n, int n2, int n3, int n4) {
        if (n > n2 && n3 > n4) {
            return;
        }
        if (n > n2) {
            ++this.changeCount;
            Change change = new Change(0, n, n2, n3, n4, this.changeCount);
            change.setNext(this.insertRoot);
            this.insertRoot = change;
            this.detach(this.newBuffer, this.newMap, this.newLink, n3, n4);
        } else if (n3 > n4) {
            ++this.changeCount;
            Change change = new Change(1, n, n2, n3, n4, this.changeCount);
            change.setNext(this.deleteRoot);
            this.deleteRoot = change;
        } else {
            int n5 = 0;
            int n6 = 0;
            int n7 = 0;
            int n8 = n;
            while (n8 + n5 <= n2) {
                Integer n9 = (Integer)this.newMap.get(this.oldBuffer[n8]);
                if (n9 != null) {
                    int n10 = n9;
                    while (n10 != 0 && n8 + n5 <= n2) {
                        if (n10 >= n3 && n10 + n5 <= n4 && ((Object)this.oldBuffer[n8 + n5]).equals(this.newBuffer[n10 + n5])) {
                            int n11;
                            int n12 = this.min(n4 - n10, n2 - n8);
                            for (n11 = 1; n11 <= n12 && ((Object)this.oldBuffer[n8 + n11]).equals(this.newBuffer[n10 + n11]); ++n11) {
                            }
                            if (n11 > n5) {
                                n5 = n11;
                                n6 = n8;
                                n7 = n10;
                            }
                        }
                        n10 = this.newLink[n10];
                    }
                }
                ++n8;
            }
            if (n5 > 0) {
                this.detach(this.newBuffer, this.newMap, this.newLink, n7, n7 + n5 - 1);
                this.compare(n, n6 - 1, n3, n7 - 1);
                this.compare(n6 + n5, n2, n7 + n5, n4);
            } else {
                this.addReplace(n, n2, n3, n4);
            }
        }
    }

    boolean similarSections(Change change, Change change2) {
        int n;
        Integer n2;
        HashMap<ILine, Integer> hashMap = new HashMap<ILine, Integer>();
        int[] nArray = new int[this.newBuffer.length];
        int[] nArray2 = new int[this.newBuffer.length];
        int n3 = change.getOlde() - change.getOlds();
        if (this.compareSections(change.getOlds(), change2.getNews(), n3)) {
            for (int i = change.getOlds(); i <= change.getOlde(); ++i) {
                if (this.oldBuffer[i].size() == 0) continue;
                change2.setCode(3);
                change2.setOlds(change.getOlds());
                change2.setOlde(change.getOlde());
                ++this.extraCount;
                return true;
            }
            return false;
        }
        int n4 = change2.getNews();
        while (n4 <= change2.getNewe()) {
            ILine iLine = this.newBuffer[n4];
            n2 = (Integer)hashMap.get(iLine);
            if (n2 == null) {
                n2 = new Integer(n4);
                hashMap.put(iLine, n2);
            } else {
                nArray[nArray2[n2.intValue()]] = n4;
            }
            nArray2[n2.intValue()] = n4++;
        }
        n4 = -1;
        int n5 = 0;
        n3 = 0;
        n2 = (Integer)hashMap.get(this.oldBuffer[change.getOlds()]);
        if (n2 != null) {
            n = n2;
            while (n != 0) {
                n3 = change2.getNewe() - n;
                if (this.compareSections(change.getOlds(), n, n3) && n3 > n4) {
                    n4 = n3;
                    n5 = n;
                }
                n = nArray[n];
            }
        }
        this.detach(this.newBuffer, hashMap, nArray, change2.getNews(), change2.getNewe());
        if (n4 >= 0) {
            change2.setTemp(n3);
            n = change.getOlds() + n3 + 1;
            n3 = change.getOlde() - n;
            if (this.compareSections(n, change2.getNews(), n3)) {
                change2.setCode(4);
                change2.setOlds(change.getOlds());
                change2.setOlde(change.getOlde());
                change2.setTemp(n);
                change2.setTemp2(n5);
                return true;
            }
        }
        return false;
    }

    boolean insertOverlap(Change change, Change change2) {
        Integer n;
        HashMap<ILine, Integer> hashMap = new HashMap<ILine, Integer>();
        int[] nArray = new int[this.oldBuffer.length];
        int[] nArray2 = new int[this.oldBuffer.length];
        int n2 = change.getOlds();
        while (n2 <= change.getOlde()) {
            ILine iLine = this.oldBuffer[n2];
            n = (Integer)hashMap.get(iLine);
            if (n == null) {
                n = new Integer(n2);
                hashMap.put(iLine, n);
            } else {
                nArray[nArray2[n.intValue()]] = n2;
            }
            nArray2[n.intValue()] = n2++;
        }
        n2 = 0;
        int n3 = change2.getNewe() - change2.getNews();
        n = (Integer)hashMap.get(this.oldBuffer[change2.getNews()]);
        if (n != null) {
            n2 = n;
            while (!(n2 == 0 || change.getOlde() - n2 >= n3 && this.compareSections(n2, change2.getNews(), n3))) {
                n2 = nArray[n2];
            }
        }
        this.detach(this.oldBuffer, hashMap, nArray, change.getOlds(), change.getOlde());
        if (n2 != 0) {
            if (n2 == change.getOlds()) {
                ++this.extraCount;
                change2.setCode(9);
            } else if (change.getOlde() == n2 + n3) {
                change2.setCode(10);
            } else {
                change2.setCode(8);
            }
            change2.setTemp(n2);
            change2.setTemp2(change.getNewe());
            change2.setOlds(change.getOlds());
            change2.setOlde(change.getOlde());
            return true;
        }
        return false;
    }

    boolean deleteOverlap(Change change, Change change2) {
        Integer n;
        HashMap<ILine, Integer> hashMap = new HashMap<ILine, Integer>();
        int[] nArray = new int[this.newBuffer.length];
        int[] nArray2 = new int[this.newBuffer.length];
        int n2 = change2.getNews();
        while (n2 <= change2.getNewe()) {
            ILine iLine = this.newBuffer[n2];
            n = (Integer)hashMap.get(iLine);
            if (n == null) {
                n = new Integer(n2);
                hashMap.put(iLine, n);
            } else {
                nArray[nArray2[n.intValue()]] = n2;
            }
            nArray2[n.intValue()] = n2++;
        }
        n2 = change.getOlde() - change.getOlds();
        int n3 = 0;
        n = (Integer)hashMap.get(this.oldBuffer[change.getOlds()]);
        if (n != null) {
            n3 = n;
            while (!(n3 == 0 || change2.getNewe() - n3 >= n2 && this.compareSections(change.getOlds(), n3, n2))) {
                n3 = nArray[n3];
            }
        }
        this.detach(this.newBuffer, hashMap, nArray, change2.getNews(), change2.getNewe());
        if (n3 != 0) {
            if (n3 == change2.getNews()) {
                ++this.extraCount;
                change.setCode(6);
            } else if (change2.getNewe() == n3 + n2) {
                change.setCode(7);
            } else {
                change.setCode(5);
            }
            change.setTemp(n3);
            change.setTemp2(change2.getOlde());
            change.setNews(change2.getNews());
            change.setNewe(change2.getNewe());
            return true;
        }
        return false;
    }

    void mergeChanges() {
        Change change;
        Change[] changeArray = new Change[this.changeCount + 1];
        boolean[] blArray = new boolean[this.changeCount + 1];
        for (change = this.insertRoot; change != null; change = change.getNext()) {
            changeArray[change.getNumber()] = change;
            blArray[change.getNumber()] = true;
        }
        for (change = this.deleteRoot; change != null; change = change.getNext()) {
            changeArray[change.getNumber()] = change;
            blArray[change.getNumber()] = true;
        }
        for (change = this.replaceRoot; change != null; change = change.getNext()) {
            changeArray[change.getNumber()] = change;
            blArray[change.getNumber()] = true;
        }
        for (change = this.changeRoot; change != null; change = change.getNext()) {
            changeArray[change.getNumber()] = change;
            blArray[change.getNumber()] = true;
        }
        this.changeRoot = null;
        for (int i = this.changeCount; i >= 1; --i) {
            Change change2;
            if (!blArray[i]) continue;
            if (changeArray[i].getCode() == 4) {
                change2 = new Change(3, changeArray[i].getOlds(), changeArray[i].getTemp() - 1, changeArray[i].getTemp2(), changeArray[i].getNewe(), changeArray[i].getNumber());
                change2.setNext(this.changeRoot);
                this.changeRoot = change2;
                changeArray[i].setCode(3);
                changeArray[i].setOlds(changeArray[i].getTemp());
                changeArray[i].setNewe(changeArray[i].getTemp2() - 1);
            } else if (changeArray[i].getCode() == 10) {
                change2 = new Change(3, changeArray[i].getTemp(), changeArray[i].getOlde(), changeArray[i].getNews(), changeArray[i].getNewe(), changeArray[i].getNumber());
                change2.setNext(this.changeRoot);
                this.changeRoot = change2;
                changeArray[i].setCode(1);
                changeArray[i].setOlde(changeArray[i].getTemp() - 1);
                changeArray[i].setNewe(changeArray[i].getTemp2());
            } else if (changeArray[i].getCode() == 8) {
                change2 = new Change(9, changeArray[i].getTemp(), changeArray[i].getOlde(), changeArray[i].getNews(), changeArray[i].getNewe(), changeArray[i].getNumber());
                change2.setNext(this.changeRoot);
                this.changeRoot = change2;
                changeArray[i].setCode(1);
                changeArray[i].setOlde(changeArray[i].getTemp() - 1);
                changeArray[i].setNewe(changeArray[i].getTemp2());
            } else if (changeArray[i].getCode() == 7) {
                change2 = new Change(3, changeArray[i].getOlds(), changeArray[i].getOlde(), changeArray[i].getTemp(), changeArray[i].getNewe(), changeArray[i].getNumber());
                change2.setNext(this.changeRoot);
                this.changeRoot = change2;
                changeArray[i].setCode(0);
                changeArray[i].setNewe(changeArray[i].getTemp() - 1);
                changeArray[i].setOlde(changeArray[i].getTemp2());
            } else if (changeArray[i].getCode() == 5) {
                change2 = new Change(6, changeArray[i].getOlds(), changeArray[i].getOlde(), changeArray[i].getTemp(), changeArray[i].getNewe(), changeArray[i].getNumber());
                change2.setNext(this.changeRoot);
                this.changeRoot = change2;
                changeArray[i].setCode(0);
                changeArray[i].setNewe(changeArray[i].getTemp() - 1);
                changeArray[i].setOlde(changeArray[i].getTemp2());
            }
            changeArray[i].setNext(this.changeRoot);
            this.changeRoot = changeArray[i];
        }
        this.changeCount -= this.extraCount;
    }

    abstract void outputInsert(Change var1);

    abstract void outputDelete(Change var1);

    abstract void outputReplace(Change var1);

    abstract void outputMove(Change var1);

    abstract void outputMoveDelete(Change var1);

    abstract void outputMoveInsert(Change var1);

    class Change {
        private int number;
        private int olds;
        private int olde;
        private int news;
        private int newe;
        private int code;
        private int temp;
        private int temp2;
        private Change next;

        public Change(int n, int n2, int n3, int n4, int n5, int n6) {
            this.code = n;
            this.olds = n2;
            this.olde = n3;
            this.news = n4;
            this.newe = n5;
            this.number = n6;
        }

        public final int getCode() {
            return this.code;
        }

        public final int getOlds() {
            return this.olds;
        }

        public final int getOlde() {
            return this.olde;
        }

        public final int getNews() {
            return this.news;
        }

        public final int getNewe() {
            return this.newe;
        }

        public final int getNumber() {
            return this.number;
        }

        public final int getTemp() {
            return this.temp;
        }

        public final int getTemp2() {
            return this.temp2;
        }

        public final Change getNext() {
            return this.next;
        }

        public final void setCode(int n) {
            this.code = n;
        }

        public final void setOlds(int n) {
            this.olds = n;
        }

        public final void setOlde(int n) {
            this.olde = n;
        }

        public final void setNews(int n) {
            this.news = n;
        }

        public final void setNewe(int n) {
            this.newe = n;
        }

        public final void setNumber(int n) {
            this.number = n;
        }

        public final void setTemp(int n) {
            this.temp = n;
        }

        public final void setTemp2(int n) {
            this.temp2 = n;
        }

        public final void setNext(Change change) {
            this.next = change;
        }
    }

    public static interface ILine {
        public int hashCode();

        public boolean equals(Object var1);

        public int size();

        public int getStartLine();

        public int getStartColumn();

        public int getEndLine();

        public int getEndColumn();
    }
}

