/*
 * Decompiled with CFR 0.152.
 */
package lpg.runtime;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import lpg.runtime.ILexStream;
import lpg.runtime.IMessageHandler;
import lpg.runtime.IPrsStream;
import lpg.runtime.IntSegmentedTuple;
import lpg.runtime.ParseErrorCodes;

public class LexStream
implements ILexStream,
ParseErrorCodes {
    static final int DEFAULT_TAB = 1;
    private int index = -1;
    private int streamLength = 0;
    private char[] inputChars;
    private String fileName;
    private IntSegmentedTuple lineOffsets;
    private int tab = 1;
    protected IPrsStream prsStream;
    private IMessageHandler errMsg = null;

    public LexStream() {
        this.lineOffsets = new IntSegmentedTuple(12);
        this.setLineOffset(-1);
    }

    public LexStream(int n) {
        this();
        this.tab = n;
    }

    public LexStream(String string) throws IOException {
        this(string, 1);
    }

    public LexStream(String string, int n) throws IOException {
        this(n);
        this.initialize(string);
    }

    public LexStream(char[] cArray, String string) {
        this();
        this.initialize(cArray, string);
    }

    public LexStream(IntSegmentedTuple intSegmentedTuple, char[] cArray, String string) {
        this.initialize(intSegmentedTuple, cArray, string);
    }

    public LexStream(char[] cArray, String string, int n) {
        this(n);
        this.initialize(cArray, string);
    }

    public LexStream(IntSegmentedTuple intSegmentedTuple, char[] cArray, String string, int n) {
        this.tab = n;
        this.initialize(intSegmentedTuple, cArray, string);
    }

    public void initialize(String string) throws IOException {
        try {
            File file = new File(string);
            InputStreamReader inputStreamReader = new InputStreamReader(new FileInputStream(file));
            char[] cArray = new char[(int)file.length()];
            inputStreamReader.read(cArray, 0, cArray.length);
            this.initialize(cArray, string);
        }
        catch (Exception exception) {
            IOException iOException = new IOException();
            System.err.println(exception.getMessage());
            exception.printStackTrace();
            throw iOException;
        }
    }

    public void initialize(char[] cArray, String string) {
        this.setInputChars(cArray);
        this.setStreamLength(cArray.length);
        this.setFileName(string);
        this.computeLineOffsets();
    }

    public void initialize(IntSegmentedTuple intSegmentedTuple, char[] cArray, String string) {
        this.lineOffsets = intSegmentedTuple;
        this.setInputChars(cArray);
        this.setStreamLength(cArray.length);
        this.setFileName(string);
    }

    public void computeLineOffsets() {
        this.lineOffsets.reset();
        this.setLineOffset(-1);
        for (int i = 0; i < this.inputChars.length; ++i) {
            if (this.inputChars[i] != '\n') continue;
            this.setLineOffset(i);
        }
    }

    public void setInputChars(char[] cArray) {
        this.inputChars = cArray;
        this.index = -1;
    }

    public char[] getInputChars() {
        return this.inputChars;
    }

    public void setFileName(String string) {
        this.fileName = string;
    }

    public String getFileName() {
        return this.fileName;
    }

    public void setLineOffsets(IntSegmentedTuple intSegmentedTuple) {
        this.lineOffsets = intSegmentedTuple;
    }

    public IntSegmentedTuple getLineOffsets() {
        return this.lineOffsets;
    }

    public void setTab(int n) {
        this.tab = n;
    }

    public int getTab() {
        return this.tab;
    }

    public void setStreamIndex(int n) {
        this.index = n;
    }

    public int getStreamIndex() {
        return this.index;
    }

    public void setStreamLength(int n) {
        this.streamLength = n;
    }

    public int getStreamLength() {
        return this.streamLength;
    }

    public void setLineOffset(int n) {
        this.lineOffsets.add(n);
    }

    public int getLineOffset(int n) {
        return this.lineOffsets.get(n);
    }

    public void setPrsStream(IPrsStream iPrsStream) {
        iPrsStream.setLexStream(this);
        this.prsStream = iPrsStream;
    }

    public IPrsStream getIPrsStream() {
        return this.prsStream;
    }

    public IPrsStream getPrsStream() {
        return this.prsStream;
    }

    public String[] orderedExportedSymbols() {
        return null;
    }

    public char getCharValue(int n) {
        return this.inputChars[n];
    }

    public int getIntValue(int n) {
        return this.inputChars[n];
    }

    public int getLine() {
        return this.getLineCount();
    }

    public int getLineCount() {
        return this.lineOffsets.size() - 1;
    }

    public int getLineNumberOfCharAt(int n) {
        int n2 = this.lineOffsets.binarySearch(n);
        return n2 < 0 ? -n2 : (n2 == 0 ? 1 : n2);
    }

    public int getColumnOfCharAt(int n) {
        int n2 = this.getLineNumberOfCharAt(n);
        int n3 = this.lineOffsets.get(n2 - 1);
        if (n3 + 1 >= this.streamLength) {
            return 1;
        }
        for (int i = n3 + 1; i < n; ++i) {
            if (this.inputChars[i] != '\t') continue;
            int n4 = i - n3 - 1;
            n3 -= this.tab - 1 - n4 % this.tab;
        }
        return n - n3;
    }

    public int getToken() {
        this.index = this.getNext(this.index);
        return this.index;
    }

    public int getToken(int n) {
        this.index = this.index < n ? this.getNext(this.index) : this.streamLength;
        return this.index;
    }

    public int getKind(int n) {
        return 0;
    }

    int next(int n) {
        return this.getNext(n);
    }

    public int getNext(int n) {
        return ++n < this.streamLength ? n : this.streamLength;
    }

    int previous(int n) {
        return this.getPrevious(n);
    }

    public int getPrevious(int n) {
        return n <= 0 ? 0 : n - 1;
    }

    public String getName(int n) {
        return n >= this.getStreamLength() ? "" : "" + this.getCharValue(n);
    }

    public int peek() {
        return this.getNext(this.index);
    }

    public void reset(int n) {
        this.index = n - 1;
    }

    public void reset() {
        this.index = -1;
    }

    public int badToken() {
        return 0;
    }

    public int getLine(int n) {
        return this.getLineNumberOfCharAt(n);
    }

    public int getColumn(int n) {
        return this.getColumnOfCharAt(n);
    }

    public int getEndLine(int n) {
        return this.getLine(n);
    }

    public int getEndColumn(int n) {
        return this.getColumnOfCharAt(n);
    }

    public boolean afterEol(int n) {
        return n < 1 ? true : this.getLineNumberOfCharAt(n - 1) < this.getLineNumberOfCharAt(n);
    }

    public int getFirstErrorToken(int n) {
        return this.getFirstRealToken(n);
    }

    public int getFirstRealToken(int n) {
        return n;
    }

    public int getLastErrorToken(int n) {
        return this.getLastRealToken(n);
    }

    public int getLastRealToken(int n) {
        return n;
    }

    public void setMessageHandler(IMessageHandler iMessageHandler) {
        this.errMsg = iMessageHandler;
    }

    public IMessageHandler getMessageHandler() {
        return this.errMsg;
    }

    public void makeToken(int n, int n2, int n3) {
        if (this.prsStream != null) {
            this.prsStream.makeToken(n, n2, n3);
        } else {
            this.reportLexicalError(n, n2);
        }
    }

    public void reportLexicalError(int n, int n2) {
        int n3;
        int n4 = n2 >= this.streamLength ? 10 : (n3 = n == n2 ? 0 : 11);
        String string = n3 == 10 ? "End-of-file " : (n3 == 11 ? "\"" + new String(this.inputChars, n, n2 - n + 1) + "\" " : "\"" + this.getCharValue(n) + "\" ");
        this.reportLexicalError(n3, n, n2, 0, 0, new String[]{string});
    }

    public int[] getLocation(int n, int n2) {
        int n3 = (n2 < this.streamLength ? n2 : this.streamLength - 1) - n + 1;
        return new int[]{n, n3, this.getLineNumberOfCharAt(n), this.getColumnOfCharAt(n), this.getLineNumberOfCharAt(n2), this.getColumnOfCharAt(n2)};
    }

    public void reportLexicalError(int n, int n2, int n3, int n4, int n5, String[] stringArray) {
        if (this.errMsg == null) {
            String string = this.getFileName() + ':' + this.getLineNumberOfCharAt(n2) + ':' + this.getColumnOfCharAt(n2) + ':' + this.getLineNumberOfCharAt(n3) + ':' + this.getColumnOfCharAt(n3) + ':' + n4 + ':' + n5 + ':' + n + ": ";
            System.out.print("****Error: " + string);
            if (stringArray != null) {
                for (int i = 0; i < stringArray.length; ++i) {
                    System.out.print(stringArray[i] + " ");
                }
            }
            System.out.println(errorMsgText[n]);
        } else {
            this.errMsg.handleMessage(n, this.getLocation(n2, n3), this.getLocation(n4, n5), this.getFileName(), stringArray);
        }
    }

    public void reportError(int n, int n2, int n3, String string) {
        String[] stringArray;
        if (string == null) {
            stringArray = null;
        } else {
            String[] stringArray2 = new String[1];
            stringArray = stringArray2;
            stringArray2[0] = string;
        }
        this.reportError(n, n2, 0, n3, stringArray);
    }

    public void reportError(int n, int n2, int n3, String[] stringArray) {
        this.reportError(n, n2, 0, n3, stringArray);
    }

    public void reportError(int n, int n2, int n3, int n4, String string) {
        String[] stringArray;
        if (string == null) {
            stringArray = null;
        } else {
            String[] stringArray2 = new String[1];
            stringArray = stringArray2;
            stringArray2[0] = string;
        }
        this.reportError(n, n2, n3, n4, stringArray);
    }

    public void reportError(int n, int n2, int n3, int n4, String[] stringArray) {
        this.reportLexicalError(n, n2, n4, n3, n3, stringArray == null ? new String[]{} : stringArray);
    }

    public String toString(int n, int n2) {
        int n3 = n2 - n + 1;
        return n2 >= this.inputChars.length ? "$EOF" : (n3 <= 0 ? "" : new String(this.inputChars, n, n3));
    }
}

