/*
 * Decompiled with CFR 0.152.
 */
package polyglot.ext.hj.ast;

import java.util.List;
import polyglot.ast.Expr;
import polyglot.ast.Formal;
import polyglot.ast.Node;
import polyglot.ast.Stmt;
import polyglot.ext.hj.ast.ForEach;
import polyglot.ext.hj.ast.HjLoopRegion;
import polyglot.ext.hj.ast.HjPhasedLoop_c;
import polyglot.ext.hj.ast.Phased;
import polyglot.ext.hj.types.HjContext;
import polyglot.types.Context;
import polyglot.util.CodeWriter;
import polyglot.util.Position;
import polyglot.visit.PrettyPrinter;

public class ForEach_c
extends HjPhasedLoop_c
implements ForEach,
HjLoopRegion,
Phased {
    private final boolean isForAll;

    public ForEach_c(Position pos) {
        super(pos);
        this.isForAll = false;
    }

    public ForEach_c(Position pos, Formal formal, Expr domain, List phasers, Stmt body) {
        this(pos, formal, domain, phasers, body, false);
    }

    protected ForEach_c(Position pos, Formal formal, Expr domain, List phasers, Stmt body, boolean b) {
        super(pos, formal, domain, phasers, body);
        this.isForAll = b;
    }

    public String toString() {
        return "foreach (" + this.formal + ":" + this.domain + ")" + this.body;
    }

    public Context enterChildScope(Node child, Context c) {
        if (child == this.body) {
            return ((HjContext)c).pushForEach();
        }
        return c;
    }

    public void prettyPrint(CodeWriter w, PrettyPrinter tr) {
        w.write("foreach(");
        this.printBlock((Node)this.formal, w, tr);
        w.write(" : ");
        this.printBlock((Node)this.domain, w, tr);
        w.write(") ");
        this.printSubStmt(this.body, w, tr);
    }

    public boolean isForAll() {
        return this.isForAll;
    }
}

