/*
 * Decompiled with CFR 0.152.
 */
package polyglot.ext.hj.ast;

import polyglot.ast.ArrayAccess_c;
import polyglot.ast.Expr;
import polyglot.ast.Node;
import polyglot.ext.hj.ast.HjArrayAccess;
import polyglot.ext.hj.ast.HjCanonicalTypeNode_c;
import polyglot.ext.hj.ast.Point;
import polyglot.ext.hj.types.HjParsedClassType;
import polyglot.ext.hj.types.HjType;
import polyglot.ext.hj.types.HjTypeSystem;
import polyglot.types.Ref;
import polyglot.types.SemanticException;
import polyglot.types.Type;
import polyglot.types.Types;
import polyglot.util.CodeWriter;
import polyglot.util.Position;
import polyglot.visit.AscriptionVisitor;
import polyglot.visit.ContextVisitor;
import polyglot.visit.PrettyPrinter;

public class HjArrayAccess_c
extends ArrayAccess_c
implements HjArrayAccess {
    public HjArrayAccess_c(Position pos, Expr array, Point index) {
        super(pos, array, (Expr)index);
    }

    public HjArrayAccess array(Expr array) {
        HjArrayAccess_c n = (HjArrayAccess_c)this.copy();
        n.array = array;
        return n;
    }

    public Node typeCheck(ContextVisitor tc) throws SemanticException {
        Type nType;
        HjTypeSystem ts = (HjTypeSystem)tc.typeSystem();
        Type type = this.array.type();
        boolean isArray = type.isArray();
        boolean isIndexable = ts.isIndexable(type);
        if (!isArray && !isIndexable) {
            throw new SemanticException("Subscript can only follow an array type, and not " + type + ".", this.position());
        }
        HjArrayAccess_c node = this;
        Expr index = node.index();
        if (!ts.isImplicitCastValid(index.type(), (Type)ts.point(), tc.context()) && !index.type().isInt()) {
            throw new SemanticException("Array subscript |" + this.toString() + "| must be an integer or a point.", this.position());
        }
        Expr p = index;
        node = (HjArrayAccess_c)node.reconstruct(node.array, p);
        if (isIndexable) {
            nType = type;
            nType = ts.baseType(nType);
            assert (nType != null);
        } else {
            return this.type(node.array.type().toArray().base());
        }
        node = (HjArrayAccess_c)node.type(nType);
        return node;
    }

    public Type childExpectedType(Expr child, AscriptionVisitor av) {
        HjTypeSystem ts = (HjTypeSystem)av.typeSystem();
        if (child == this.array) {
            boolean isArray = this.type.isArray();
            boolean isIndexable = ts.isIndexable(this.type);
            if (!isArray && !isIndexable) {
                return ts.arrayViewOf(this.type);
            }
        }
        return super.childExpectedType(child, av);
    }

    public void prettyPrint(CodeWriter w, PrettyPrinter tr) {
        assert (false);
        HjType at = (HjType)this.array.type();
        if (at instanceof HjParsedClassType && ((HjParsedClassType)at).isParameterized()) {
            HjParsedClassType ct = (HjParsedClassType)at;
            Type result = ct.typeParameter();
            w.write("((");
            this.print((Node)new HjCanonicalTypeNode_c(Position.COMPILER_GENERATED, (Ref<? extends Type>)Types.ref((Object)result)), w, tr);
            w.write(")");
        }
        this.printSubExpr(this.array, w, tr);
        w.write(".get(");
        this.printBlock((Node)this.index, w, tr);
        w.write(")");
        if (at instanceof HjParsedClassType && ((HjParsedClassType)at).isParameterized()) {
            w.write(")");
        }
    }
}

