/*
 * Decompiled with CFR 0.152.
 */
package polyglot.ext.hj.ast;

import polyglot.ast.Expr;
import polyglot.ast.Node;
import polyglot.ast.NodeFactory;
import polyglot.ast.TypeNode;
import polyglot.ext.hj.ast.HjArrayViewTypeNode;
import polyglot.ext.hj.ast.HjTypeNode;
import polyglot.ext.hj.ast.HjTypeNode_c;
import polyglot.ext.hj.types.HjArrayViewType;
import polyglot.ext.hj.types.HjTypeSystem;
import polyglot.types.Context;
import polyglot.types.Ref;
import polyglot.types.SemanticException;
import polyglot.types.Type;
import polyglot.types.Types;
import polyglot.util.CodeWriter;
import polyglot.util.InternalCompilerError;
import polyglot.util.Position;
import polyglot.visit.ContextVisitor;
import polyglot.visit.ExceptionChecker;
import polyglot.visit.NodeVisitor;
import polyglot.visit.PrettyPrinter;
import polyglot.visit.Translator;
import polyglot.visit.TypeBuilder;

public class HjArrayViewTypeNode_c
extends HjTypeNode_c
implements HjArrayViewTypeNode {
    protected TypeNode base;
    protected boolean isValueType;
    protected Expr distribution;

    public HjArrayViewTypeNode_c(Position pos, TypeNode base) {
        this(pos, base, false);
    }

    public HjArrayViewTypeNode_c(Position pos, TypeNode base, boolean isValueType) {
        super(pos);
        this.base = base;
        this.isValueType = isValueType;
    }

    public boolean isValueType() {
        return this.isValueType;
    }

    public TypeNode base() {
        return this.base;
    }

    public HjArrayViewTypeNode base(TypeNode base) {
        HjArrayViewTypeNode_c n = (HjArrayViewTypeNode_c)this.copy();
        n.base = base;
        return n;
    }

    public Expr distribution() {
        return this.distribution;
    }

    public HjArrayViewTypeNode reconstruct(TypeNode base, Expr indexedSet) {
        if (base != this.base || indexedSet != this.distribution) {
            HjArrayViewTypeNode_c n = (HjArrayViewTypeNode_c)this.copy();
            n.base = base;
            this.distribution = indexedSet;
            return n;
        }
        return this;
    }

    protected HjArrayViewTypeNode_c reconstruct(TypeNode base) {
        if (base != this.base) {
            HjArrayViewTypeNode_c n = (HjArrayViewTypeNode_c)this.copy();
            n.base = base;
            return n;
        }
        return this;
    }

    public Context enterChildScope(Node child, Context c) {
        return super.enterChildScope(child, c);
    }

    public Node visitChildren(NodeVisitor v) {
        HjArrayViewTypeNode n = (HjArrayViewTypeNode)super.visitChildren(v);
        TypeNode base = (TypeNode)n.visitChild((Node)this.base, v);
        Expr indexedSet = (Expr)n.visitChild((Node)this.distribution, v);
        return n.reconstruct(base, indexedSet);
    }

    public Node buildTypes(TypeBuilder tb) throws SemanticException {
        return this.typeRef(Types.ref((Object)((HjTypeSystem)tb.typeSystem()).arrayViewOf((Ref<? extends Type>)this.base.typeRef(), this.isValueType, this.distribution)));
    }

    public Node disambiguate(ContextVisitor ar) throws SemanticException {
        HjTypeSystem ts = (HjTypeSystem)ar.typeSystem();
        NodeFactory nf = ar.nodeFactory();
        HjArrayViewType newType = ts.arrayViewOf((Ref<? extends Type>)this.base.typeRef(), this.isValueType, this.distribution);
        HjTypeNode n = (HjTypeNode)nf.CanonicalTypeNode(this.position(), (Type)newType);
        return n;
    }

    public Node typeCheck(ContextVisitor tc) throws SemanticException {
        throw new InternalCompilerError(this.position(), "Cannot type check HjArrayType Node " + this + " should have been converted to HjCanonicalTypeNode.");
    }

    public Node exceptionCheck(ExceptionChecker ec) throws SemanticException {
        throw new InternalCompilerError(this.position(), "Cannot type check HjArrayType Node " + this + " should have been converted to HjCanonicalTypeNode.");
    }

    public void prettyPrint(CodeWriter w, PrettyPrinter tr) {
        System.out.println("HjArrayTypeNode:  base=" + this.base);
        this.print((Node)this.base, w, tr);
        w.write((this.isValueType ? " value " : "") + "[." + (this.distribution == null ? "" : this.distribution.toString()) + "]");
    }

    public void translate(CodeWriter w, Translator tr) {
        throw new InternalCompilerError(this.position(), "Cannot translate ambiguous node " + this + ".");
    }

    public String toString() {
        return this.base.toString() + (this.isValueType ? " value " : "") + "[" + "." + (this.distribution == null ? "" : this.distribution.toString()) + "]";
    }
}

