/*
 * Decompiled with CFR 0.152.
 */
package polyglot.ext.hj.ast;

import polyglot.ast.CanonicalTypeNode;
import polyglot.ast.Expr;
import polyglot.ast.Id;
import polyglot.ast.Node;
import polyglot.ast.Receiver;
import polyglot.ast.TypeNode;
import polyglot.ext.hj.ast.HjCanonicalTypeNode;
import polyglot.ext.hj.ast.HjNodeFactory;
import polyglot.ext.hj.types.HjTypeSystem;
import polyglot.ext.jl5.ast.JL5Field_c;
import polyglot.types.ClassType;
import polyglot.types.Context;
import polyglot.types.FieldInstance;
import polyglot.types.Name;
import polyglot.types.NoMemberException;
import polyglot.types.SemanticException;
import polyglot.types.Type;
import polyglot.types.TypeSystem;
import polyglot.util.InternalCompilerError;
import polyglot.util.Position;
import polyglot.visit.AscriptionVisitor;
import polyglot.visit.ContextVisitor;

public class HjField_c
extends JL5Field_c {
    public HjField_c(Position pos, Receiver target, Id name) {
        super(pos, target, name);
    }

    public Node typeCheck(ContextVisitor tc) throws SemanticException {
        HjTypeSystem xts = (HjTypeSystem)tc.typeSystem();
        HjNodeFactory xnf = (HjNodeFactory)tc.nodeFactory();
        Type tType = this.target.type();
        try {
            Context c = tc.context();
            TypeSystem ts = tc.typeSystem();
            if (!tType.isReference()) {
                throw new NoMemberException(3, "Field \"" + this.name + "\" not found in type \"" + tType + "\".");
            }
            FieldInstance fi = ts.findField(this.target.type(), ts.FieldMatcher(this.target.type(), this.name.id(), c));
            if (fi == null) {
                throw new InternalCompilerError("Cannot access field " + this.name + " on node of type " + this.target.getClass().getName() + ".", this.position());
            }
            if (this.target instanceof HjCanonicalTypeNode && !fi.flags().isStatic()) {
                throw new SemanticException("Cannot statically access non-static field " + this.name + " of class " + this.target + ".", this.position());
            }
            HjField_c result = this;
            result = (HjField_c)this.fieldInstance(fi).type(fi.type());
            result.checkConsistency(c);
            return result;
        }
        catch (NoMemberException e) {
            if (e.getKind() != 3 || this.target == null) {
                throw e;
            }
            if (xts.isHjArrayView(tType)) {
                if (this.name().id().equals((Object)Name.make((String)"distribution")) || this.name().id().equals((Object)Name.make((String)"region"))) {
                    ClassType array = xts.array();
                    CanonicalTypeNode typenode = xnf.CanonicalTypeNode(this.position(), (Type)array);
                    return this.target((Receiver)xnf.Cast(this.position(), (TypeNode)typenode, (Expr)this.target).type((Type)array)).del().typeCheck(tc);
                }
            } else if (xts.isValueType(tType) && this.name().id().equals((Object)Name.make((String)"location"))) {
                return (Expr)xnf.NullLit(this.position()).typeCheck(tc);
            }
            throw e;
        }
    }

    public Type childExpectedType(Expr child, AscriptionVisitor av) {
        if (child == this.target) {
            return this.fi.container();
        }
        return child.type();
    }
}

