/*
 * Decompiled with CFR 0.152.
 */
package polyglot.ext.hj.ast;

import java.util.List;
import polyglot.ast.Block;
import polyglot.ast.Formal;
import polyglot.ast.Id;
import polyglot.ast.MethodDecl;
import polyglot.ast.Node;
import polyglot.ast.TypeNode;
import polyglot.ext.hj.ast.HjMethodDecl;
import polyglot.ext.hj.types.HjFlags;
import polyglot.ext.hj.types.HjTypeSystem;
import polyglot.ext.jl5.ast.JL5MethodDecl_c;
import polyglot.ext.jl5.types.FlagAnnotations;
import polyglot.types.Context;
import polyglot.types.Flags;
import polyglot.types.SemanticException;
import polyglot.types.Type;
import polyglot.util.CodeWriter;
import polyglot.util.Position;
import polyglot.visit.ContextVisitor;
import polyglot.visit.Translator;
import polyglot.visit.TypeBuilder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HjMethodDecl_c
extends JL5MethodDecl_c
implements HjMethodDecl {
    public HjMethodDecl_c(Position pos, FlagAnnotations flags, TypeNode returnType, Id name, List<Formal> formals, List<TypeNode> throwTypes, Block body) {
        super(pos, flags, returnType, name, formals, throwTypes, body);
    }

    public HjMethodDecl_c(Position pos, FlagAnnotations flags, TypeNode returnType, Id name, List<Formal> formals, List<TypeNode> throwTypes, Block body, List typeParams) {
        super(pos, flags, returnType, name, formals, throwTypes, body, typeParams);
    }

    public void translate(CodeWriter w, Translator tr) {
        Context c = tr.context();
        Flags flags = this.flags().flags();
        if (c.currentClass().flags().isInterface()) {
            flags = flags.clearPublic();
            flags = flags.clearAbstract();
        }
        this.flags = this.flags().flags((Flags)HjFlags.toHjFlags(flags));
        super.translate(w, tr);
    }

    public Node buildTypesOverride(TypeBuilder tb) throws SemanticException {
        Node n = super.buildTypesOverride(tb);
        return n;
    }

    public Node typeCheck(ContextVisitor tc) throws SemanticException {
        MethodDecl nn = (MethodDecl)super.typeCheck(tc);
        if (nn.flags().flags().isNative() && !nn.flags().flags().isStatic()) {
            throw new SemanticException("extern method must be declared static", this.position());
        }
        if (nn.flags().flags().isNative()) {
            HjTypeSystem ts = (HjTypeSystem)tc.typeSystem();
            if (!((Type)this.mi.returnType().get()).isPrimitive() && !ts.isString((Type)this.mi.returnType().get())) {
                throw new SemanticException("extern return type \"" + nn.returnType() + "\" is not a primitive type.", nn.position());
            }
            this.checkExternParameterTypes(ts, nn.formals());
        }
        return nn;
    }

    private void checkExternParameterTypes(HjTypeSystem ts, List<Formal> formalTypes) throws SemanticException {
        for (Formal f : formalTypes) {
            Type fType = f.type().type();
            if (fType.isPrimitive() || ts.isString(fType) || ts.isPrimitiveTypeArrayView(fType)) continue;
            throw new SemanticException("Extern method's argument '" + f.name() + "' must be either a primitive, String or an array-view");
        }
    }
}

