/*
 * Decompiled with CFR 0.152.
 */
package polyglot.ext.hj.ast;

import java.util.Iterator;
import java.util.List;
import polyglot.ast.Expr;
import polyglot.ast.Expr_c;
import polyglot.ast.Node;
import polyglot.ast.Term;
import polyglot.ext.hj.ast.Point;
import polyglot.ext.hj.types.HjTypeSystem;
import polyglot.types.SemanticException;
import polyglot.types.Type;
import polyglot.types.TypeSystem;
import polyglot.util.CollectionUtil;
import polyglot.util.Position;
import polyglot.util.TypedList;
import polyglot.visit.AscriptionVisitor;
import polyglot.visit.CFGBuilder;
import polyglot.visit.ContextVisitor;
import polyglot.visit.NodeVisitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Point_c
extends Expr_c
implements Point {
    List<Expr> exprs;

    public Point_c(Position pos) {
        super(pos);
    }

    public Point_c(Position pos, List<Expr> exprs) {
        super(pos);
        this.exprs = TypedList.copyAndCheck(exprs, Expr.class, (boolean)true);
    }

    public Node typeCheck(ContextVisitor tc) throws SemanticException {
        return this.type((Type)((HjTypeSystem)tc.typeSystem()).point());
    }

    public Term firstChild() {
        return (Term)this.exprs.get(0);
    }

    public Node visitChildren(NodeVisitor v) {
        List vExprs = this.visitList(this.exprs, v);
        return this.reconstruct(vExprs);
    }

    protected Node reconstruct(List<Expr> vExprs) {
        if (!CollectionUtil.allEqual(this.exprs, vExprs)) {
            Point_c p = (Point_c)this.copy();
            p.exprs = vExprs;
            return p;
        }
        return this;
    }

    public List acceptCFG(CFGBuilder v, List succs) {
        v.visitCFGList(this.exprs, (Term)this, 0);
        return succs;
    }

    @Override
    public int rank() {
        if (this.exprs == null) {
            return 0;
        }
        return this.exprs.size();
    }

    @Override
    public Expr valueAt(int i) {
        return this.exprs.get(i);
    }

    @Override
    public Point value(List l) {
        Point_c n = (Point_c)this.copy();
        n.exprs = TypedList.copyAndCheck((List)l, Expr.class, (boolean)true);
        return n;
    }

    @Override
    public List<Expr> indices() {
        return this.exprs;
    }

    public String toString() {
        StringBuffer buff = new StringBuffer();
        buff.append('[');
        if (this.exprs != null) {
            Iterator<Expr> iter = this.exprs.iterator();
            while (iter.hasNext()) {
                Expr coord = iter.next();
                buff.append(coord);
                if (!iter.hasNext()) continue;
                buff.append(", ");
            }
        }
        buff.append(']');
        return buff.toString();
    }

    public Type childExpectedType(Expr child, AscriptionVisitor av) {
        TypeSystem ts = av.typeSystem();
        if (child == this.exprs) {
            return ts.Int();
        }
        return child.type();
    }
}

