/*
 * Decompiled with CFR 0.152.
 */
package polyglot.ext.hj.extension.extern;

import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import polyglot.ast.Binary;
import polyglot.ast.Call;
import polyglot.ast.Call_c;
import polyglot.ast.CanonicalTypeNode;
import polyglot.ast.Cast;
import polyglot.ast.Conditional;
import polyglot.ast.Expr;
import polyglot.ast.Formal;
import polyglot.ast.Formal_c;
import polyglot.ast.Local;
import polyglot.ast.NodeFactory;
import polyglot.ast.NullLit;
import polyglot.ast.Receiver;
import polyglot.ast.TypeNode;
import polyglot.ext.hj.extension.extern.HjClassBodyExtHelperJNI;
import polyglot.ext.hj.types.HjTypeSystem;
import polyglot.types.MethodInstance;
import polyglot.types.Name;
import polyglot.types.Ref;
import polyglot.types.SemanticException;
import polyglot.types.Type;
import polyglot.util.Position;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HjClassBodyExtArrayViewHelper {
    public static final String KdescriptorNameSuffix = "_hjDeScRiPtOr";
    public static final String KPtrNameSuffix = "_hjPoInTeR";
    private static final String GET = "get";
    private static final String REGION = "Region";
    public static final String KgetDescriptorMethod = "getDescriptor";
    protected HjTypeSystem ts;
    protected NodeFactory nf;
    private TypeNode arrayOfIntType;
    public static final String KgetBackingArrayMethod = "getBackingArray";

    public HjClassBodyExtArrayViewHelper(HjTypeSystem typeSystem, NodeFactory nf) {
        this.ts = typeSystem;
        this.nf = nf;
    }

    public boolean isViewType(Type t) {
        return this.ts.isHjArrayView(t);
    }

    private TypeNode getArrayOfIntType(Position pos) {
        return this.nf.CanonicalTypeNode(pos, this.ts.arrayOf(pos, this.ts.Int()));
    }

    protected MethodInstance getMethodInstance(Type ct, Name methodName) {
        try {
            return this.ts.findMethod(ct, this.ts.MethodMatcher(ct, methodName, Collections.EMPTY_LIST, null));
        }
        catch (SemanticException e) {
            throw new Error("Could not find " + methodName + " in class " + ct);
        }
    }

    protected Call generateCallGetMetaData(Local view, TypeNode typeNode, String metaDataName) {
        Position pos = view.position();
        Call getRegion = this.generateCall(pos, (Receiver)view, view.type(), Name.make((String)"getRegion"));
        Cast cast = this.nf.Cast(pos, typeNode, (Expr)getRegion);
        cast = (Cast)cast.type(typeNode.type());
        Call getMetaData = this.generateCall(pos, (Receiver)cast, typeNode.type(), Name.make((String)(GET + metaDataName)));
        return getMetaData;
    }

    protected Call generateCall(Position pos, Receiver receiver, Type receiverType, Name methodName) {
        Call methodCall = this.nf.Call(pos, receiver, this.nf.Id(pos, methodName));
        MethodInstance methodCallMi = this.getMethodInstance(receiverType, methodName);
        methodCall = methodCall.methodInstance(methodCallMi);
        methodCall = (Call)methodCall.type(methodCallMi.returnType());
        return methodCall;
    }

    public String getViewDataPrimitiveTypes(Type viewType) {
        return HjClassBodyExtHelperJNI.typeToCString(this.ts.baseType(viewType));
    }

    public void generateViewSignature(Position pos, Formal parameter, List<Formal> newFormals, List<Ref<? extends Type>> newFormalsType) {
        if (this.arrayOfIntType == null) {
            this.arrayOfIntType = this.getArrayOfIntType(pos);
        }
        MethodInstance backingMethod = this.getBackingArrayMethod(parameter.type().type());
        CanonicalTypeNode theReturnType = this.nf.CanonicalTypeNode(pos, backingMethod.returnType());
        newFormals.add(parameter.type((TypeNode)theReturnType));
        newFormalsType.add((Ref<? extends Type>)theReturnType.typeRef());
        Formal_c paramDescriptor = (Formal_c)parameter.name(this.nf.Id(parameter.position(), Name.make((String)(parameter.name().id() + KdescriptorNameSuffix))));
        newFormals.add(paramDescriptor.type(this.arrayOfIntType));
        newFormalsType.add((Ref<? extends Type>)this.arrayOfIntType.typeRef());
    }

    public void generateViewJavaSignature(Formal parameter, StringBuffer signature) {
        Type ct = parameter.type().type();
        MethodInstance backingMethod = this.getBackingArrayMethod(ct);
        signature.append(HjClassBodyExtHelperJNI.typeToJavaSigString(backingMethod.returnType()));
        signature.append(HjClassBodyExtHelperJNI.typeToJavaSigString(this.ts.arrayOf(parameter.position(), this.ts.Int())));
    }

    public MethodInstance getBackingArrayMethod(Type ct) {
        try {
            return this.ts.findMethod(ct, this.ts.MethodMatcher(ct, Name.make((String)KgetBackingArrayMethod), Collections.EMPTY_LIST, null));
        }
        catch (SemanticException e) {
            throw new Error("Could not find getBackingArray in class " + ct);
        }
    }

    public MethodInstance getDescriptorMethod(Type ct) {
        try {
            return this.ts.findMethod(ct, this.ts.MethodMatcher(ct, Name.make((String)KgetDescriptorMethod), Collections.EMPTY_LIST, null));
        }
        catch (SemanticException e) {
            throw new Error("Could not find getDescriptor in class " + ct);
        }
    }

    public void createNativeWrapperViewArgument(Position pos, List args, Formal wrapperParameter) throws Error {
        Type ct = wrapperParameter.type().type();
        MethodInstance getDescriptorMI = this.getDescriptorMethod(ct);
        MethodInstance getBackingArrayMI = this.getBackingArrayMethod(ct);
        Local getAddrTarget = this.nf.Local(pos, this.nf.Id(pos, wrapperParameter.name().id()));
        getAddrTarget = (Local)getAddrTarget.type(wrapperParameter.type().type());
        getAddrTarget = getAddrTarget.localInstance(wrapperParameter.localDef().asInstance());
        NullLit nullLit = (NullLit)this.nf.NullLit(pos).type((Type)this.ts.Null());
        Binary bCond = this.nf.Binary(pos, (Expr)getAddrTarget, Binary.NE, (Expr)nullLit);
        bCond = (Binary)bCond.type(this.ts.Boolean());
        Call getAddr = this.nf.Call(pos, (Receiver)getAddrTarget, this.nf.Id(pos, KgetBackingArrayMethod));
        getAddr = (Call_c)getAddr.methodInstance(getBackingArrayMI);
        getAddr = (Call)getAddr.type(getBackingArrayMI.returnType());
        Conditional condAddr = (Conditional)this.nf.Conditional(pos, (Expr)bCond, (Expr)getAddr, (Expr)nullLit).type(getAddr.type());
        args.add(condAddr);
        Call getDescriptor = this.nf.Call(pos, (Receiver)getAddrTarget, this.nf.Id(pos, KgetDescriptorMethod));
        getDescriptor = (Call_c)getDescriptor.methodInstance(getDescriptorMI);
        getDescriptor = (Call)getDescriptor.type(getDescriptorMI.returnType());
        Conditional condDesc = (Conditional)this.nf.Conditional(pos, (Expr)bCond, (Expr)getDescriptor, (Expr)nullLit).type(getDescriptor.type());
        args.add(condDesc);
    }

    public Type[] getPrimitiveViewTypes(Type type) {
        assert (this.isViewType(type));
        LinkedList<Type> res = new LinkedList<Type>();
        res.add(type);
        return res.toArray(new Type[res.size()]);
    }

    public String[] getViewNames(Type type) {
        assert (this.isViewType(type));
        LinkedList<String> res = new LinkedList<String>();
        res.add("data");
        return res.toArray(new String[res.size()]);
    }
}

