/*
 * Decompiled with CFR 0.152.
 */
package polyglot.ext.hj.types;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import polyglot.ast.Expr;
import polyglot.ext.hj.types.AsyncDef;
import polyglot.ext.hj.types.AsyncDef_c;
import polyglot.ext.hj.types.AsyncInstance;
import polyglot.ext.hj.types.AsyncInstance_c;
import polyglot.ext.hj.types.FutureType;
import polyglot.ext.hj.types.FutureType_c;
import polyglot.ext.hj.types.HjArrayType_c;
import polyglot.ext.hj.types.HjArrayViewType;
import polyglot.ext.hj.types.HjArrayViewType_c;
import polyglot.ext.hj.types.HjComplexType_c;
import polyglot.ext.hj.types.HjConstructorInstance_c;
import polyglot.ext.hj.types.HjContext_c;
import polyglot.ext.hj.types.HjFieldInstance_c;
import polyglot.ext.hj.types.HjFlags;
import polyglot.ext.hj.types.HjLocalInstance_c;
import polyglot.ext.hj.types.HjMethodInstance_c;
import polyglot.ext.hj.types.HjNullType_c;
import polyglot.ext.hj.types.HjParameterizedType_c;
import polyglot.ext.hj.types.HjParsedClassType;
import polyglot.ext.hj.types.HjParsedClassType_c;
import polyglot.ext.hj.types.HjPrimitiveType;
import polyglot.ext.hj.types.HjPrimitiveType_c;
import polyglot.ext.hj.types.HjRawType_c;
import polyglot.ext.hj.types.HjType;
import polyglot.ext.hj.types.HjTypeEnv_c;
import polyglot.ext.hj.types.HjTypeSystem;
import polyglot.ext.hj.types.HjTypeVariable_c;
import polyglot.ext.hj.types.HjUnknownType_c;
import polyglot.ext.jl5.types.JL5ParsedClassType;
import polyglot.ext.jl5.types.JL5TypeSystem_c;
import polyglot.ext.jl5.types.ParameterizedType;
import polyglot.ext.jl5.types.RawType;
import polyglot.ext.jl5.types.TypeVariable;
import polyglot.main.Report;
import polyglot.types.ArrayType;
import polyglot.types.ClassDef;
import polyglot.types.ClassType;
import polyglot.types.ConstructorDef;
import polyglot.types.ConstructorInstance;
import polyglot.types.Context;
import polyglot.types.FieldDef;
import polyglot.types.FieldInstance;
import polyglot.types.Flags;
import polyglot.types.LocalDef;
import polyglot.types.LocalInstance;
import polyglot.types.MemberInstance;
import polyglot.types.MethodDef;
import polyglot.types.MethodInstance;
import polyglot.types.Name;
import polyglot.types.NoMemberException;
import polyglot.types.NullType;
import polyglot.types.ObjectType;
import polyglot.types.ParsedClassType;
import polyglot.types.PrimitiveType;
import polyglot.types.Ref;
import polyglot.types.SemanticException;
import polyglot.types.StructType;
import polyglot.types.Type;
import polyglot.types.TypeEnv;
import polyglot.types.TypeObject;
import polyglot.types.TypeSystem;
import polyglot.types.TypeSystem_c;
import polyglot.types.Types;
import polyglot.types.UnknownType;
import polyglot.util.Position;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HjTypeSystem_c
extends JL5TypeSystem_c
implements HjTypeSystem,
Serializable {
    private static final Set<Name> primitiveTypeNames = new HashSet<Name>();
    protected final PrimitiveType COMPLEX_64_ = this.createPrimitive(HjPrimitiveType.COMPLEX_64);
    protected final PrimitiveType COMPLEX_32_ = this.createPrimitive(HjPrimitiveType.COMPLEX_32);
    protected final HjFlags Hj_TOP_LEVEL_CLASS_FLAGS = (HjFlags)this.legalTopLevelClassFlags();
    protected final HjFlags Hj_INTERFACE_FLAGS = (HjFlags)this.legalInterfaceFlags();
    protected final Flags Hj_MEMBER_CLASS_FLAGS = (HjFlags)this.legalMemberClassFlags();
    protected final HjFlags Hj_LOCAL_CLASS_FLAGS = (HjFlags)this.legalLocalClassFlags();
    private static final String WRAPPER_PACKAGE = "hj.compilergenerated";
    protected ClassType hjObjectType_;
    protected ClassType parameter1Type_;
    protected ClassType placeType_;
    protected ClassType regionType_;
    protected ClassType pointType_;
    protected ClassType valueType_;
    protected ClassType distributionType_;
    protected ClassType activityType_;
    protected ClassType futureActivityType_;
    protected ClassType hjArrayType_;
    protected ClassType accumulatorType_;
    protected ClassType ddfType_;
    protected ClassType phaserType_;
    protected ClassType phaserMode_;
    protected ClassType runtimeType_;
    protected ClassType operatorPointwiseType_;
    protected ClassType operatorBinaryType_;
    protected ClassType operatorUnaryType_;
    protected ClassType arrayOperationsType_;
    Map<Ref<? extends Type>, Type> arrayViewTypeCache = new HashMap<Ref<? extends Type>, Type>();
    Map<String, ClassType> arrayViewRuntimeType = new HashMap<String, ClassType>();
    protected HjParsedClassType arrayViewBaseType_;
    protected ClassType indexableType_ = null;
    protected ClassType arrayType_ = null;
    protected final Flags Hj_METHOD_FLAGS = this.legalMethodFlags();

    public HjTypeSystem_c() {
        this.unknownType = new HjUnknownType_c((TypeSystem)this);
    }

    public TypeEnv env(Context context) {
        return new HjTypeEnv_c(context);
    }

    public Context emptyContext() {
        return new HjContext_c((TypeSystem)this);
    }

    @Override
    public boolean isPrimitiveTypeName(Name name) {
        return primitiveTypeNames.contains(name);
    }

    public Context createContext() {
        return new HjContext_c((TypeSystem)this);
    }

    public Flags legalMethodFlags() {
        HjFlags x = HjFlags.toHjFlags(this.legalAccessFlags().Abstract().Static().Final().Native().Synchronized().StrictFP());
        x = x.Safe().Local().NonBlocking().Sequential();
        return x;
    }

    public Flags legalTopLevelClassFlags() {
        return HjFlags.toHjFlags(super.legalTopLevelClassFlags()).Safe();
    }

    public Flags legalInterfaceFlags() {
        return HjFlags.toHjFlags(super.legalInterfaceFlags()).Safe();
    }

    public Flags legalMemberClassFlags() {
        return HjFlags.toHjFlags(super.legalMemberClassFlags()).Safe();
    }

    public Flags legalLocalClassFlags() {
        return HjFlags.toHjFlags(super.legalLocalClassFlags()).Safe();
    }

    public boolean isImplicitCastValid(Type fromType, Type toType, Context context) {
        this.assert_((TypeObject)fromType);
        this.assert_((TypeObject)toType);
        if (Report.should_report((String)"debug", (int)5)) {
            Report.report((int)5, (String)("[HjTypeSystem_c] isImplicitCastValid |" + fromType.getClass() + "| to |" + toType + "|?"));
        }
        boolean result = this.env(context).isImplicitCastValid(fromType, toType);
        if (Report.should_report((String)"debug", (int)5)) {
            Report.report((int)5, (String)("[HjTypeSystem_c] ... " + result));
        }
        return result;
    }

    @Override
    public FutureType createFutureType(Position pos, Ref<? extends Type> baseType) {
        return new FutureType_c((TypeSystem)this, pos, baseType);
    }

    protected UnknownType createUnknownType() {
        return this.unknownType;
    }

    public boolean descendsFrom(ClassDef child, ClassDef ancestor) {
        ClassType childT = child.asType();
        ClassType ancestorT = child.asType();
        if (childT.isNull()) {
            return this.typeEquals((Type)ancestorT, this.Object(), this.emptyContext());
        }
        if (childT.isClass()) {
            return super.descendsFrom(child, ancestor);
        }
        if (childT.isPrimitive()) {
            return this.typeEquals((Type)ancestorT, (Type)this.HjObject(), this.emptyContext()) || this.typeEquals((Type)ancestorT, (Type)this.value(), this.emptyContext());
        }
        return super.descendsFrom(child, ancestor);
    }

    @Override
    public boolean typeListEquals(List<Type> l1, List<Type> l2) {
        if (l1 == null) {
            return l2 == null;
        }
        if (l1.isEmpty()) {
            return l2 == null || l2.isEmpty();
        }
        if (l1.size() != l2.size()) {
            return false;
        }
        for (int i = 0; i < l1.size(); ++i) {
            if (this.typeEquals(l1.get(i), l2.get(i), this.emptyContext())) continue;
            return false;
        }
        return true;
    }

    @Override
    public AsyncDef createAsyncWithReturnDef(Ref<? extends Type> returnType) {
        return this.createAsyncDef_(returnType, true);
    }

    @Override
    public AsyncDef createAsyncDef(Ref<? extends Type> returnType) {
        return this.createAsyncDef_(returnType, false);
    }

    private AsyncDef createAsyncDef_(Ref<? extends Type> returnType, boolean isAsyncWithReturn) {
        return new AsyncDef_c((TypeSystem)this, Position.COMPILER_GENERATED, (Ref<? extends StructType>)Types.ref((Object)this.Runtime()), this.Public(), returnType, Name.make((String)"$dummyAsync$"), Collections.<Ref<Type>>emptyList(), Collections.<Ref<Type>>emptyList(), isAsyncWithReturn);
    }

    @Override
    public AsyncInstance createAsyncInstance(Position pos, Ref<? extends AsyncDef> def) {
        return new AsyncInstance_c((TypeSystem)this, pos, def);
    }

    protected NullType createNull() {
        return new HjNullType_c((TypeSystem)this);
    }

    protected PrimitiveType createPrimitive(Name name) {
        if (name == HjPrimitiveType.COMPLEX_32 || name == HjPrimitiveType.COMPLEX_64) {
            return new HjComplexType_c(this, name);
        }
        return new HjPrimitiveType_c((TypeSystem)this, name);
    }

    @Override
    public ClassType HjObject() {
        if (this.hjObjectType_ == null) {
            this.hjObjectType_ = this.load("hj.lang.Object");
        }
        return this.hjObjectType_;
    }

    @Override
    public ClassType parameter1() {
        if (this.parameter1Type_ == null) {
            this.parameter1Type_ = this.load("hj.compilergenerated.Parameter1");
        }
        return this.parameter1Type_;
    }

    @Override
    public ClassType place() {
        if (this.placeType_ == null) {
            this.placeType_ = this.load("hj.lang.place");
        }
        return this.placeType_;
    }

    @Override
    public ClassType region() {
        if (this.regionType_ == null) {
            this.regionType_ = this.load("hj.lang.region");
        }
        return this.regionType_;
    }

    @Override
    public ClassType point() {
        if (this.pointType_ == null) {
            this.pointType_ = this.load("hj.lang.point");
        }
        return this.pointType_;
    }

    @Override
    public ClassType value() {
        if (this.valueType_ == null) {
            this.valueType_ = this.load("hj.lang.ValueType");
        }
        return this.valueType_;
    }

    @Override
    public ClassType distribution() {
        if (this.distributionType_ == null) {
            this.distributionType_ = this.load("hj.lang.dist");
        }
        return this.distributionType_;
    }

    @Override
    public ClassType Activity() {
        if (this.activityType_ == null) {
            this.activityType_ = this.load("hj.lang.Activity");
        }
        return this.activityType_;
    }

    @Override
    public ClassType FutureActivity() {
        if (this.futureActivityType_ == null) {
            this.futureActivityType_ = this.load("hj.lang.Future");
        }
        return this.futureActivityType_;
    }

    @Override
    public ClassType array() {
        if (this.hjArrayType_ == null) {
            this.hjArrayType_ = this.load("hj.array.lang.hjArray");
        }
        return this.hjArrayType_;
    }

    @Override
    public ClassType accumulator() {
        if (this.accumulatorType_ == null) {
            this.accumulatorType_ = this.load("hj.lang.accumulator");
        }
        return this.accumulatorType_;
    }

    @Override
    public ClassType ddf() {
        if (this.ddfType_ == null) {
            this.ddfType_ = this.load("hj.lang.DataDrivenFuture");
        }
        return this.ddfType_;
    }

    @Override
    public ClassType phaser() {
        if (this.phaserType_ == null) {
            this.phaserType_ = this.load("hj.lang.phaser");
        }
        return this.phaserType_;
    }

    @Override
    public ClassType phaserMode() {
        if (this.phaserMode_ == null) {
            this.phaserMode_ = this.load("hj.lang.phaserMode");
        }
        return this.phaserMode_;
    }

    @Override
    public ClassType Runtime() {
        if (this.runtimeType_ == null) {
            this.runtimeType_ = this.load("hj.lang.Runtime");
        }
        return this.runtimeType_;
    }

    @Override
    public ClassType OperatorPointwise() {
        if (this.operatorPointwiseType_ == null) {
            this.operatorPointwiseType_ = this.load("hj.array.Operator.Pointwise");
        }
        return this.operatorPointwiseType_;
    }

    @Override
    public ClassType OperatorBinary() {
        if (this.operatorBinaryType_ == null) {
            this.operatorBinaryType_ = this.load("hj.array.Operator.Binary");
        }
        return this.operatorBinaryType_;
    }

    @Override
    public ClassType OperatorUnary() {
        if (this.operatorUnaryType_ == null) {
            this.operatorUnaryType_ = this.load("hj.array.Operator.Unary");
        }
        return this.operatorUnaryType_;
    }

    @Override
    public ClassType ArrayOperations() {
        if (this.arrayOperationsType_ == null) {
            this.arrayOperationsType_ = this.load("hj.array.lang.ArrayOperations");
        }
        return this.arrayOperationsType_;
    }

    protected ArrayType createArrayType(Position pos, Ref<? extends Type> type) {
        return new HjArrayType_c((TypeSystem)this, pos, type);
    }

    protected HjArrayViewType arrayViewOf(Position pos, Ref<? extends Type> type) {
        HjArrayViewType t = (HjArrayViewType)this.arrayViewTypeCache.get(type);
        if (t == null) {
            t = this.createArrayViewType(pos, type);
            this.arrayViewTypeCache.put(type, (Type)t);
        }
        if (type.known()) {
            this.loadArrayViewRuntimeType(t);
        }
        return t;
    }

    public HjArrayViewType arrayViewOf(Type type) {
        return this.arrayViewOf(null, (Ref<? extends Type>)Types.ref((Object)type));
    }

    @Override
    public HjArrayViewType arrayViewOf(Type type, boolean isValueType, Expr distribution) {
        return this.arrayViewOf(null, (Ref<? extends Type>)Types.ref((Object)type));
    }

    @Override
    public HjArrayViewType arrayViewOf(Ref<? extends Type> type, boolean isValueType, Expr distribution) {
        return this.arrayViewOf(null, type);
    }

    public HjArrayViewType createArrayViewType(Position pos, Ref<? extends Type> type) {
        return new HjArrayViewType_c((TypeSystem)this, pos, type);
    }

    public String arrayViewBaseName() {
        return "hj.lang.ArrayView";
    }

    private String getArrayViewRuntimeTypeName(Type baseType) {
        String pack;
        String typeName = pack = "hj.array.view.";
        if (baseType.isPrimitive()) {
            String pName = baseType.toString();
            char[] c = pName.toCharArray();
            c[0] = Character.toUpperCase(c[0]);
            pName = new String(c);
            typeName = typeName + pName + "ArrayView";
        } else {
            typeName = typeName + "ObjectArrayView";
        }
        return typeName;
    }

    protected ClassType loadArrayViewRuntimeType(HjArrayViewType t) {
        String name = this.getArrayViewRuntimeTypeName(t.base());
        ClassType ct = null;
        ct = this.arrayViewRuntimeType.get(name);
        if (ct == null) {
            ct = this.load(name);
            this.arrayViewRuntimeType.put(name, ct);
        }
        return ct;
    }

    public ClassType arrayViewBase() {
        if (this.arrayViewBaseType_ == null) {
            this.arrayViewBaseType_ = (HjParsedClassType)this.load(this.arrayViewBaseName());
        }
        return this.arrayViewBaseType_;
    }

    public Type booleanArray() {
        return this.arrayOf(Types.ref((Object)this.Boolean()));
    }

    public Type charArray() {
        return this.arrayOf(Types.ref((Object)this.Char()));
    }

    public Type byteArray() {
        return this.arrayOf(Types.ref((Object)this.Byte()));
    }

    public Type shortArray() {
        return this.arrayOf(Types.ref((Object)this.Short()));
    }

    public Type intArray() {
        return this.arrayOf(Types.ref((Object)this.Int()));
    }

    public Type longArray() {
        return this.arrayOf(Types.ref((Object)this.Long()));
    }

    public Type floatArray() {
        return this.arrayOf(Types.ref((Object)this.Float()));
    }

    public Type doubleArray() {
        return this.arrayOf(Types.ref((Object)this.Double()));
    }

    public Type complex32Array() {
        return this.arrayOf(Types.ref((Object)this.Complex32()));
    }

    public Type complex64Array() {
        return this.arrayOf(Types.ref((Object)this.Complex64()));
    }

    public Type genericArray(Ref<? extends Type> paramType) {
        return this.arrayOf(Types.ref((Object)this.Object()));
    }

    @Override
    public ClassType Indexable() {
        if (this.indexableType_ == null) {
            this.indexableType_ = this.load("hj.lang.Indexable");
        }
        return this.indexableType_;
    }

    @Override
    public ClassType ArrayView() {
        if (this.arrayType_ == null) {
            this.arrayType_ = this.load("hj.lang.ArrayView");
        }
        return this.arrayType_;
    }

    public ParameterizedType parameterizedType(JL5ParsedClassType ct) {
        return new HjParameterizedType_c(ct);
    }

    public RawType rawType(JL5ParsedClassType ct) {
        if (ct instanceof RawType) {
            return (RawType)ct;
        }
        return new HjRawType_c(ct);
    }

    public Flags flagsForBits(int bits) {
        Flags sf = super.flagsForBits(bits);
        if (sf.isInterface()) {
            return sf.Static();
        }
        return sf;
    }

    public ConstructorInstance createConstructorInstance(Position pos, Ref<? extends ConstructorDef> def) {
        return new HjConstructorInstance_c((TypeSystem)this, pos, def);
    }

    public MethodInstance createMethodInstance(Position pos, Ref<? extends MethodDef> def) {
        return new HjMethodInstance_c((TypeSystem)this, pos, def);
    }

    public FieldInstance createFieldInstance(Position pos, Ref<? extends FieldDef> def) {
        return new HjFieldInstance_c((TypeSystem)this, pos, def);
    }

    @Override
    public boolean isPrimitiveTypeArrayView(Type me1) {
        HjType me = (HjType)me1;
        return me.isArrayView() ? ((HjArrayViewType)me).base().isPrimitive() : false;
    }

    @Override
    public boolean isFuture(Type me) {
        return me instanceof FutureType;
    }

    @Override
    public boolean isFutureVoid(Type me) {
        return me instanceof FutureType && ((FutureType)me).base().isVoid();
    }

    protected boolean isHjSubtype(Type me, Type sup) {
        boolean result = this.isSubtype(me, sup, this.emptyContext());
        return result;
    }

    protected boolean isHjBaseSubtype(Type me, Type sup) {
        HjType xme = (HjType)me;
        HjType xsup = (HjType)sup;
        return this.isHjSubtype((Type)xme, (Type)xsup);
    }

    @Override
    public boolean isIndexable(Type me) {
        HjType mex = (HjType)me;
        return this.isHjSubtype((Type)mex, (Type)this.Indexable());
    }

    @Override
    public boolean isHjArrayView(Type me) {
        return ((HjType)me).isArrayView();
    }

    @Override
    public boolean isBooleanArray(Type me) {
        return this.isHjArrayView(me) ? this.typeEquals(this.Boolean(), ((HjArrayViewType)me).base(), this.emptyContext()) : false;
    }

    @Override
    public boolean isCharArray(Type me) {
        return this.isHjArrayView(me) ? this.typeEquals(this.Char(), ((HjArrayViewType)me).base(), this.emptyContext()) : false;
    }

    @Override
    public boolean isByteArray(Type me) {
        return this.isHjArrayView(me) ? this.typeEquals(this.Byte(), ((HjArrayViewType)me).base(), this.emptyContext()) : false;
    }

    @Override
    public boolean isShortArray(Type me) {
        return this.isHjArrayView(me) ? this.typeEquals(this.Short(), ((HjArrayViewType)me).base(), this.emptyContext()) : false;
    }

    @Override
    public boolean isIntArray(Type me) {
        return this.isHjArrayView(me) ? this.typeEquals(this.Int(), ((HjArrayViewType)me).base(), this.emptyContext()) : false;
    }

    @Override
    public boolean isLongArray(Type me) {
        return this.isHjArrayView(me) ? this.typeEquals(this.Long(), ((HjArrayViewType)me).base(), this.emptyContext()) : false;
    }

    @Override
    public boolean isFloatArray(Type me) {
        return this.isHjArrayView(me) ? this.typeEquals(this.Float(), ((HjArrayViewType)me).base(), this.emptyContext()) : false;
    }

    @Override
    public boolean isDoubleArray(Type me) {
        return this.isHjArrayView(me) ? this.typeEquals(this.Double(), ((HjArrayViewType)me).base(), this.emptyContext()) : false;
    }

    @Override
    public boolean isComplex32Array(Type me) {
        return this.isHjArrayView(me) ? this.typeEquals((Type)this.Complex32(), ((HjArrayViewType)me).base(), this.emptyContext()) : false;
    }

    @Override
    public boolean isComplex64Array(Type me) {
        return this.isHjArrayView(me) ? this.typeEquals((Type)this.Complex64(), ((HjArrayViewType)me).base(), this.emptyContext()) : false;
    }

    @Override
    public boolean isDDF(Type me) {
        return this.isHjSubtype(me, (Type)this.ddf());
    }

    @Override
    public boolean isPhaser(Type me) {
        return this.isHjSubtype(me, (Type)this.phaser());
    }

    @Override
    public boolean isPoint(Type me) {
        return this.isHjSubtype(me, (Type)this.point());
    }

    @Override
    public boolean isHjObject(Type me) {
        return this.isHjSubtype(me, (Type)this.HjObject());
    }

    @Override
    public boolean isPlace(Type me) {
        return this.isHjSubtype(me, (Type)this.place());
    }

    @Override
    public boolean isRegion(Type me) {
        return this.isHjSubtype(me, (Type)this.region());
    }

    @Override
    public boolean isDistribution(Type me) {
        return this.isHjSubtype(me, (Type)this.distribution());
    }

    @Override
    public boolean isDistributedArray(Type me) {
        return this.isHjArrayView(me);
    }

    @Override
    public boolean isValueType(Type me) {
        return this.isHjBaseSubtype((Type)((HjType)me), (Type)this.value());
    }

    public boolean isArrayViewType(Type t) {
        return ((HjType)t).isArrayView();
    }

    @Override
    public Type baseType(Type t) {
        if (this.isArrayViewType(t)) {
            return ((HjArrayViewType)t).base();
        }
        return t;
    }

    public Flags createNewFlag(String name, Flags after) {
        Flags f = HjFlags.createFlag(name, after);
        this.flagsForName.put(name, f);
        return f;
    }

    protected void initFlags() {
        super.initFlags();
        this.flagsForName.put("local", HjFlags.LOCAL);
        this.flagsForName.put("nonblocking", HjFlags.NON_BLOCKING);
        this.flagsForName.put("safe", HjFlags.SAFE);
        this.flagsForName.put("sequential", HjFlags.SEQUENTIAL);
    }

    public Flags Local() {
        return HjFlags.LOCAL;
    }

    public Flags Sequential() {
        return HjFlags.SEQUENTIAL;
    }

    public Flags Safe() {
        return HjFlags.SAFE;
    }

    public Flags NonBlocking() {
        return HjFlags.NON_BLOCKING;
    }

    public void checkMethodFlags(Flags f) throws SemanticException {
        if (!f.clear(this.Hj_METHOD_FLAGS).equals((Object)Flags.NONE)) {
            throw new SemanticException("Cannot declare method with flags " + f.clear(this.Hj_METHOD_FLAGS) + ".");
        }
        if (f.isAbstract() && !f.clear(this.ABSTRACT_METHOD_FLAGS).equals((Object)Flags.NONE)) {
            throw new SemanticException("Cannot declare abstract method with flags " + f.clear(this.ABSTRACT_METHOD_FLAGS) + ".");
        }
        this.checkAccessFlags(f);
    }

    public void checkTopLevelClassFlags(Flags f) throws SemanticException {
        if (!f.clear((Flags)this.Hj_TOP_LEVEL_CLASS_FLAGS).equals((Object)Flags.NONE)) {
            throw new SemanticException("Cannot declare a top-level class with flag(s) " + f.clear((Flags)this.Hj_TOP_LEVEL_CLASS_FLAGS) + ".");
        }
        if (f.isInterface() && !f.clear((Flags)this.Hj_INTERFACE_FLAGS).equals((Object)Flags.NONE)) {
            throw new SemanticException("Cannot declare interface with flags " + f.clear((Flags)this.Hj_INTERFACE_FLAGS) + ".");
        }
        this.checkAccessFlags(f);
    }

    public void checkMemberClassFlags(Flags f) throws SemanticException {
        if (!f.clear(this.Hj_MEMBER_CLASS_FLAGS).equals((Object)Flags.NONE)) {
            throw new SemanticException("Cannot declare a member class with flag(s) " + f.clear(this.Hj_MEMBER_CLASS_FLAGS) + ".");
        }
        this.checkAccessFlags(f);
    }

    public void checkLocalClassFlags(Flags f) throws SemanticException {
        if (f.isInterface()) {
            throw new SemanticException("Cannot declare a local interface.");
        }
        if (!f.clear((Flags)this.Hj_LOCAL_CLASS_FLAGS).equals((Object)Flags.NONE)) {
            throw new SemanticException("Cannot declare a local class with flag(s) " + f.clear((Flags)this.Hj_LOCAL_CLASS_FLAGS) + ".");
        }
        this.checkAccessFlags(f);
    }

    public boolean isNumeric(Type t) {
        HjType tt = (HjType)t;
        return super.isNumeric(t) || tt.isComplex32() || tt.isComplex64();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Type leastCommonAncestor(Type type1, Type type2) throws SemanticException {
        block25: {
            Type result;
            block32: {
                Context ctx;
                block31: {
                    block30: {
                        block29: {
                            block28: {
                                block27: {
                                    block26: {
                                        block24: {
                                            block23: {
                                                block22: {
                                                    block18: {
                                                        block21: {
                                                            block20: {
                                                                block19: {
                                                                    block17: {
                                                                        this.assert_((TypeObject)type1);
                                                                        this.assert_((TypeObject)type2);
                                                                        result = null;
                                                                        ctx = this.emptyContext();
                                                                        if (!this.typeEquals(type1, type2, ctx)) break block17;
                                                                        Type type = result = type1;
                                                                        return type;
                                                                    }
                                                                    if (!type1.isNumeric() || !type2.isNumeric()) break block18;
                                                                    if (!this.isImplicitCastValid(type1, type2, ctx)) break block19;
                                                                    Type type = result = type2;
                                                                    return type;
                                                                }
                                                                if (!this.isImplicitCastValid(type2, type1, ctx)) break block20;
                                                                Type type = result = type1;
                                                                return type;
                                                            }
                                                            if ((!type1.isChar() || !type2.isByte()) && (!type1.isByte() || !type2.isChar())) break block21;
                                                            Type type = result = this.Int();
                                                            return type;
                                                        }
                                                        if ((!type1.isChar() || !type2.isShort()) && (!type1.isShort() || !type2.isChar())) break block18;
                                                        Type type = result = this.Int();
                                                        return type;
                                                    }
                                                    if (!type1.isArray() || !type2.isArray()) break block22;
                                                    Type type = result = this.arrayOf(this.leastCommonAncestor(type1.toArray().base(), type2.toArray().base()));
                                                    return type;
                                                }
                                                if (!type1.isReference() || !type2.isNull()) break block23;
                                                Type type = result = type1;
                                                return type;
                                            }
                                            if (!type2.isReference() || !type1.isNull()) break block24;
                                            Type type = result = type2;
                                            return type;
                                        }
                                        if (!type1.isReference() || !type2.isReference()) break block25;
                                        if (!type1.isClass() || !type1.toClass().flags().isInterface()) break block26;
                                        Type type = result = this.Object();
                                        return type;
                                    }
                                    if (!type2.isClass() || !type2.toClass().flags().isInterface()) break block27;
                                    Type type = result = this.Object();
                                    return type;
                                }
                                if (!this.typeEquals(type1, this.Object(), ctx)) break block28;
                                Type type = result = type1;
                                return type;
                            }
                            if (!this.typeEquals(type2, this.Object(), ctx)) break block29;
                            Type type = result = type2;
                            return type;
                        }
                        if (!this.isSubtype(type1, type2, ctx)) break block30;
                        Type type = result = type2;
                        return type;
                    }
                    if (!this.isSubtype(type2, type1, ctx)) break block31;
                    Type type = result = type1;
                    return type;
                }
                Type t1 = this.leastCommonAncestor(type1.toClass().superClass(), type2);
                Type t2 = this.leastCommonAncestor(type1.toClass().superClass(), type1);
                if (!this.typeEquals(t1, t2, ctx)) break block32;
                Type type = result = t1;
                return type;
            }
            Type type = result = this.Object();
            return type;
        }
        throw new SemanticException("No least common ancestor found for types \"" + type1 + "\" and \"" + type2 + "\".");
    }

    public LocalInstance createLocalInstance(Position pos, Ref<? extends LocalDef> def) {
        return new HjLocalInstance_c((TypeSystem)this, pos, def);
    }

    public List<MethodInstance> findAcceptableMethods(Type container, TypeSystem_c.MethodMatcher matcher) throws SemanticException {
        this.assert_((TypeObject)container);
        Context context = matcher.context();
        NoMemberException error = null;
        ArrayList<MethodInstance> acceptable = new ArrayList<MethodInstance>();
        ArrayList<MethodInstance> unacceptable = new ArrayList<MethodInstance>();
        HashSet<StructType> visitedTypes = new HashSet<StructType>();
        LinkedList<Type> typeQueue = new LinkedList<Type>();
        typeQueue.addLast(container);
        block2: while (!typeQueue.isEmpty()) {
            Type t = (Type)typeQueue.removeFirst();
            if (t instanceof StructType) {
                StructType type = (StructType)t;
                for (Type type2 : visitedTypes) {
                    if (!this.typeEquals((Type)type, type2, context)) continue;
                    continue block2;
                }
                if (visitedTypes.contains(type)) continue;
                visitedTypes.add(type);
                if (Report.should_report((String)"types", (int)2)) {
                    Report.report((int)2, (String)("Searching type " + type + " for method " + matcher.signature()));
                }
                for (MethodInstance methodInstance : type.methodsNamed(matcher.name())) {
                    if (Report.should_report((String)"types", (int)3)) {
                        Report.report((int)3, (String)("Trying " + methodInstance));
                    }
                    try {
                        MethodInstance methodInstance2 = matcher.instantiate(methodInstance);
                        if (methodInstance2 == null) continue;
                        if (this.isAccessible((MemberInstance)methodInstance2, context)) {
                            if (Report.should_report((String)"types", (int)3)) {
                                Report.report((int)3, (String)("->acceptable: " + methodInstance2 + " in " + methodInstance2.container()));
                            }
                            acceptable.add(methodInstance2);
                            continue;
                        }
                        unacceptable.add(methodInstance2);
                        if (error != null) continue;
                        error = new NoMemberException(1, "Method " + methodInstance2.signature() + " in " + container + " is inaccessible.");
                    }
                    catch (SemanticException e) {
                        if (error == null) {
                            error = new NoMemberException(1, "Method " + methodInstance.signature() + " in " + container + " cannot be called with arguments " + matcher.argumentString() + "; " + e.getMessage());
                        }
                        if (error != null) continue;
                        error = new NoMemberException(1, "Method " + methodInstance.signature() + " in " + container + " cannot be called with arguments " + matcher.argumentString() + ".");
                    }
                }
            }
            if (!(t instanceof ObjectType)) continue;
            ObjectType ot = (ObjectType)t;
            if (ot.superClass() != null) {
                typeQueue.addLast(ot.superClass());
            }
            typeQueue.addAll(ot.interfaces());
        }
        if (acceptable.size() > 0) {
            for (MethodInstance mi : unacceptable) {
                acceptable.removeAll(mi.overrides(context));
            }
        }
        if (acceptable.size() == 0) {
            if (error == null) {
                error = new NoMemberException(1, "No valid method call found for " + matcher.signature() + " in " + container + ".");
            }
            throw error;
        }
        return acceptable;
    }

    @Override
    public boolean equalTypeParameters(List<Type> a, List<Type> b) {
        int j;
        if (a == null || a.isEmpty()) {
            return b == null || b.isEmpty();
        }
        if (b == null || b.isEmpty()) {
            return false;
        }
        int i = a.size();
        if (i != (j = b.size())) {
            return false;
        }
        boolean result = true;
        for (int k = 0; result && k < i; ++k) {
            result = this.typeEquals(a.get(k), b.get(k), this.emptyContext());
        }
        return result;
    }

    @Override
    public PrimitiveType Complex64() {
        return this.COMPLEX_64_;
    }

    @Override
    public PrimitiveType Complex32() {
        return this.COMPLEX_32_;
    }

    @Override
    public boolean isComplex64(Type type) {
        if (type.isPrimitive()) {
            return ((HjPrimitiveType)type).isComplex64();
        }
        return false;
    }

    @Override
    public boolean isComplex32(Type type) {
        if (type.isPrimitive()) {
            return ((HjPrimitiveType)type).isComplex32();
        }
        return false;
    }

    public Type promote(Type t1, Type t2) throws SemanticException {
        if (this.isComplex64(t1) || this.isComplex64(t2)) {
            return this.Complex64();
        }
        if (this.isComplex32(t1) || this.isComplex32(t2)) {
            return this.Complex32();
        }
        Type pt = super.promote(t1, t2);
        return pt;
    }

    @Override
    public boolean isString(Type toType) {
        return this.typeEquals(toType, this.String(), this.emptyContext());
    }

    public ParsedClassType createClassType(Position pos, Ref<? extends ClassDef> def) {
        return new HjParsedClassType_c((TypeSystem)this, pos, def);
    }

    public TypeVariable typeVariable(Position pos, Name name, Ref<? extends ClassDef> def, List bounds) {
        return new HjTypeVariable_c((TypeSystem)this, pos, name, def, bounds);
    }

    static {
        primitiveTypeNames.add(Name.make((String)"boolean"));
        primitiveTypeNames.add(Name.make((String)"byte"));
        primitiveTypeNames.add(Name.make((String)"char"));
        primitiveTypeNames.add(Name.make((String)"short"));
        primitiveTypeNames.add(Name.make((String)"int"));
        primitiveTypeNames.add(Name.make((String)"long"));
        primitiveTypeNames.add(Name.make((String)"float"));
        primitiveTypeNames.add(Name.make((String)"double"));
        primitiveTypeNames.add(Name.make((String)"complex32"));
        primitiveTypeNames.add(Name.make((String)"complex64"));
    }
}

