/*
 * Decompiled with CFR 0.152.
 */
package polyglot.ext.hj.visit;

import java.util.LinkedList;
import java.util.List;
import polyglot.ast.Call;
import polyglot.ast.CanonicalTypeNode;
import polyglot.ast.Expr;
import polyglot.ast.Field;
import polyglot.ast.FieldAssign;
import polyglot.ast.FieldDecl;
import polyglot.ast.Formal;
import polyglot.ast.Local;
import polyglot.ast.MethodDecl;
import polyglot.ast.New;
import polyglot.ast.Node;
import polyglot.ast.NodeFactory;
import polyglot.ast.TypeNode;
import polyglot.ast.VarDecl;
import polyglot.ext.hj.ast.HjCanonicalTypeNode_c;
import polyglot.ext.hj.ast.HjClassDecl;
import polyglot.ext.jl5.ast.JL5FieldDecl;
import polyglot.ext.jl5.types.JL5FieldInstance;
import polyglot.ext.jl5.types.JL5ParsedClassType;
import polyglot.ext.jl5.types.JL5ProcedureInstance;
import polyglot.ext.jl5.types.JL5Type;
import polyglot.ext.jl5.types.TypeVariable;
import polyglot.frontend.Job;
import polyglot.types.ClassType;
import polyglot.types.ConstructorInstance;
import polyglot.types.FieldDef;
import polyglot.types.FieldInstance;
import polyglot.types.LocalDef;
import polyglot.types.LocalInstance;
import polyglot.types.MethodInstance;
import polyglot.types.ProcedureInstance;
import polyglot.types.Ref;
import polyglot.types.Type;
import polyglot.types.TypeSystem;
import polyglot.types.Types;
import polyglot.types.VarInstance;
import polyglot.visit.ContextVisitor;
import polyglot.visit.NodeVisitor;

public class ErasureVisitor
extends ContextVisitor {
    public static boolean debug = false;

    public ErasureVisitor(Job job, TypeSystem ts, NodeFactory nf) {
        super(job, ts, nf);
        if (debug) {
            System.out.println("Creating ErasureVisitor");
        }
    }

    public boolean isErasable(Type t) {
        return this.isGeneric(t) || ((JL5Type)t).isTypeVariable();
    }

    public boolean isGeneric(Type t) {
        JL5ParsedClassType jlt;
        assert (t instanceof JL5Type);
        if (t.isClass() && !((JL5Type)t).isTypeVariable() && (jlt = (JL5ParsedClassType)t).isGeneric()) {
            if (debug) {
                System.out.println("isGeneric " + jlt.isGeneric());
            }
            ClassType erasedType = jlt.def().asType();
            if (debug) {
                System.out.println("rawType is " + erasedType);
            }
            return true;
        }
        return false;
    }

    public Type getErasedType(Type t) {
        assert (this.isErasable(t));
        if (t.isClass()) {
            if (((JL5Type)t).isTypeVariable()) {
                return ((TypeVariable)t).erasureType();
            }
            return t;
        }
        assert (false);
        return null;
    }

    private ProcedureInstance getErasedProcedureInstance(ProcedureInstance pi) {
        assert (pi instanceof JL5ProcedureInstance);
        return ((JL5ProcedureInstance)pi).erasure();
    }

    private VarInstance getErasedFieldInstance(FieldInstance fi) {
        assert (fi instanceof JL5FieldInstance);
        return ((JL5FieldInstance)fi).erasure();
    }

    private VarInstance getErasedVariableInstance(VarInstance pi) {
        assert (false);
        return null;
    }

    private Expr generateCast(Expr expr, Type castType) {
        if (debug) {
            System.out.println("Erasure: Generating " + castType + " cast for expr: " + expr);
        }
        CanonicalTypeNode tn = this.nf.CanonicalTypeNode(expr.position(), castType);
        expr = this.nf.Cast(expr.position(), (TypeNode)tn, expr);
        expr = expr.type(castType);
        return expr;
    }

    public Node leaveCall(Node parent, Node old, Node n, NodeVisitor v) {
        FieldDef def;
        Node ret = n;
        if (debug) {
            System.out.println("Erasure: called on node " + ret);
        }
        if (ret instanceof TypeNode) {
            Type t;
            TypeNode tn = (TypeNode)ret;
            if (debug) {
                System.out.println("TypeNode " + tn);
            }
            if (this.isErasable(t = tn.type())) {
                if (debug) {
                    System.out.println("TypeNode Generic" + tn);
                }
                tn.typeRef().update((Object)this.getErasedType(tn.type()));
            }
            if (t.isClass() && ((JL5Type)t).isTypeVariable()) {
                if (parent instanceof HjClassDecl) {
                    return null;
                }
                TypeVariable tv = (TypeVariable)t;
                Type erasedType = tv.erasureType();
                HjCanonicalTypeNode_c newTn = new HjCanonicalTypeNode_c(tn.position(), (Ref<? extends Type>)Types.ref((Object)erasedType));
                return newTn;
            }
        }
        if (n instanceof VarDecl) {
            VarDecl varDecl = (VarDecl)n;
            if (debug) {
                System.out.println("VarDecl: " + varDecl);
            }
            Type erasedType = varDecl.type().type();
            LocalDef localDef = varDecl.localDef();
            localDef.setType(Types.ref((Object)erasedType));
        }
        if (n instanceof FieldDecl) {
            JL5FieldDecl field = (JL5FieldDecl)n;
            def = field.fieldDef();
            def.setType(Types.ref((Object)field.type().type()));
        }
        if (n instanceof MethodDecl) {
            MethodDecl method = (MethodDecl)n;
            def = method.methodDef();
            List formals = method.formals();
            LinkedList<Ref> formalsRefs = new LinkedList<Ref>();
            for (Formal formal : formals) {
                formalsRefs.add(Types.ref((Object)formal.type().type()));
            }
            def.setFormalTypes(formalsRefs);
            def.setReturnType(Types.ref((Object)method.returnType().type()));
            formals.size();
        }
        if (ret instanceof Expr) {
            Expr expr = (Expr)ret;
            JL5Type type = (JL5Type)expr.type();
            if (expr instanceof Call) {
                Call call = (Call)ret;
                MethodInstance mi = call.methodInstance();
                if (this.isGeneric((Type)mi.container())) {
                    Type newType;
                    MethodInstance erasedMi = (MethodInstance)this.getErasedProcedureInstance((ProcedureInstance)mi);
                    expr = call.methodInstance(erasedMi);
                    if (erasedMi.returnType() != mi.returnType()) {
                        if (debug) {
                            System.out.println("Erasure: Updating call's return type from: " + mi.returnType() + " to: " + erasedMi.returnType());
                        }
                        expr = expr.type(erasedMi.returnType());
                    }
                    if (this.ts.isSubtype((Type)type, newType = expr.type(), this.context)) {
                        expr = this.generateCast(expr, (Type)type);
                    }
                }
                return expr;
            }
            if (expr instanceof FieldAssign || expr instanceof Field) {
                return this.handleFieldAccess(expr);
            }
            if (this.isErasable((Type)type)) {
                Field field;
                FieldInstance fi;
                Local local;
                LocalInstance li;
                if (expr instanceof Local && (li = (local = (Local)expr).localInstance()) != ((LocalDef)li.def()).asInstance()) {
                    expr = local.localInstance((LocalInstance)this.getErasedVariableInstance((VarInstance)li));
                }
                if (expr instanceof Field && (fi = (field = (Field)expr).fieldInstance()) != ((FieldDef)fi.def()).asInstance()) {
                    expr = field.fieldInstance((FieldInstance)this.getErasedVariableInstance((VarInstance)fi));
                    System.out.println("Field process");
                }
                if (expr instanceof New) {
                    New ccall = (New)expr;
                    ConstructorInstance ci = ccall.constructorInstance();
                    expr = ccall.constructorInstance((ConstructorInstance)this.getErasedProcedureInstance((ProcedureInstance)ci));
                }
                expr = expr.type(this.getErasedType((Type)type));
                return expr;
            }
        }
        return ret;
    }

    private Expr handleFieldAccess(Expr expr) {
        FieldDef def;
        FieldAssign field;
        FieldInstance fi;
        if (expr instanceof FieldAssign && this.isGeneric((Type)(fi = (field = (FieldAssign)expr).fieldInstance()).container()) && (def = (FieldDef)fi.def()).type().get() instanceof TypeVariable) {
            FieldInstance erasedFi = (FieldInstance)this.getErasedFieldInstance(fi);
            expr = field.fieldInstance(erasedFi);
            expr = expr.type(erasedFi.type());
        }
        if (expr instanceof Field && this.isGeneric((Type)(fi = (field = (Field)expr).fieldInstance()).container()) && (def = (FieldDef)fi.def()).type().get() instanceof TypeVariable) {
            Type targetType = field.type();
            FieldInstance erasedFi = (FieldInstance)this.getErasedFieldInstance(fi);
            expr = field.fieldInstance(erasedFi);
            expr = expr.type(erasedFi.type());
            expr = this.generateCast(expr, targetType);
        }
        return expr;
    }
}

