/*
 * Decompiled with CFR 0.152.
 */
package polyglot.ext.jl5;

import java.util.ArrayList;
import java.util.List;
import polyglot.ast.NodeFactory;
import polyglot.ext.jl5.types.JL5ClassDef;
import polyglot.ext.jl5.types.TypeVariable;
import polyglot.ext.jl5.visit.ApplicationChecker;
import polyglot.frontend.ExtensionInfo;
import polyglot.frontend.Goal;
import polyglot.frontend.JLScheduler;
import polyglot.frontend.Job;
import polyglot.frontend.Scheduler;
import polyglot.frontend.VisitorGoal;
import polyglot.types.ClassDef;
import polyglot.types.LazyRef;
import polyglot.types.QName;
import polyglot.types.Ref;
import polyglot.types.TypeSystem;
import polyglot.visit.NodeVisitor;

public class JL5Scheduler
extends JLScheduler {
    public JL5Scheduler(ExtensionInfo extInfo) {
        super(extInfo);
    }

    public List<Goal> goals(Job job) {
        ArrayList<Goal> goals = new ArrayList<Goal>();
        goals.add(this.Parsed(job));
        goals.add(this.TypesInitialized(job));
        goals.add(this.ImportTableInitialized(job));
        goals.add(this.PreTypeCheck(job));
        goals.add(this.TypesInitializedForCommandLineBarrier());
        goals.add(this.TypeChecked(job));
        goals.add(this.ReassembleAST(job));
        goals.add(this.ConformanceChecked(job));
        goals.add(this.ReachabilityChecked(job));
        goals.add(this.ExceptionsChecked(job));
        goals.add(this.ExitPathsChecked(job));
        goals.add(this.InitializationsChecked(job));
        goals.add(this.ConstructorCallsChecked(job));
        goals.add(this.ForwardReferencesChecked(job));
        goals.add(this.ApplicationChecked(job));
        goals.add(this.Serialized(job));
        goals.add(this.CodeGenerated(job));
        goals.add(this.End(job));
        return goals;
    }

    public Goal ApplicationChecked(Job job) {
        TypeSystem ts = job.extensionInfo().typeSystem();
        NodeFactory nf = job.extensionInfo().nodeFactory();
        return new VisitorGoal("ApplicationChecked", job, (NodeVisitor)new ApplicationChecker(job, ts, nf)).intern((Scheduler)this);
    }

    public Runnable LookupGlobalTypeDef(LazyRef<ClassDef> sym2, QName className, List<Ref<TypeVariable>> tvList) {
        return new LookupGlobalTypeDefAndSetTypeVariable((Ref)sym2, className, tvList).intern((Scheduler)this);
    }

    protected static class LookupGlobalTypeDefAndSetTypeVariable
    extends JLScheduler.LookupGlobalTypeDefAndSetFlags {
        List<Ref<TypeVariable>> tvList = null;

        private LookupGlobalTypeDefAndSetTypeVariable(Ref<ClassDef> v, QName className, List<Ref<TypeVariable>> tvList) {
            super(v, className, null);
            assert (tvList != null && !tvList.isEmpty());
            this.tvList = tvList;
        }

        public String toString() {
            return super.toString() + "<tv>";
        }

        protected void defResolved(ClassDef def) {
            ((JL5ClassDef)def).setTypeVariables(this.tvList);
        }
    }
}

