/*
 * Decompiled with CFR 0.152.
 */
package polyglot.ext.jl5.ast;

import java.util.List;
import polyglot.ast.ArrayInit;
import polyglot.ast.Expr;
import polyglot.ast.FlagsNode;
import polyglot.ast.Id;
import polyglot.ast.Node;
import polyglot.ast.Term;
import polyglot.ast.Term_c;
import polyglot.ast.TypeNode;
import polyglot.ext.jl5.ast.AnnotationElemDecl;
import polyglot.ext.jl5.types.AnnotationElemInstance;
import polyglot.ext.jl5.types.FlagAnnotations;
import polyglot.ext.jl5.types.JL5Flags;
import polyglot.ext.jl5.types.JL5TypeSystem;
import polyglot.types.ClassType;
import polyglot.types.Context;
import polyglot.types.Flags;
import polyglot.types.MemberDef;
import polyglot.types.SemanticException;
import polyglot.types.Type;
import polyglot.util.CodeWriter;
import polyglot.util.Position;
import polyglot.visit.CFGBuilder;
import polyglot.visit.ContextVisitor;
import polyglot.visit.NodeVisitor;
import polyglot.visit.PrettyPrinter;
import polyglot.visit.TypeBuilder;

public class AnnotationElemDecl_c
extends Term_c
implements AnnotationElemDecl {
    protected TypeNode type;
    protected FlagsNode flags;
    protected Expr defaultVal;
    protected Id name;
    protected AnnotationElemInstance ai;

    public AnnotationElemDecl_c(Position pos, FlagAnnotations flags, TypeNode type, Id name, Expr defaultVal) {
        super(pos);
        this.type = type;
        this.flags = flags.classicFlags();
        this.defaultVal = defaultVal;
        this.name = name;
        throw new RuntimeException("Annotation elements declaration are not yet supported");
    }

    @Override
    public AnnotationElemDecl type(TypeNode type) {
        if (!type.equals(this.type)) {
            AnnotationElemDecl_c n = (AnnotationElemDecl_c)this.copy();
            n.type = type;
            return n;
        }
        return this;
    }

    @Override
    public TypeNode type() {
        return this.type;
    }

    @Override
    public AnnotationElemDecl flags(FlagsNode flags) {
        if (!flags.equals(this.flags)) {
            AnnotationElemDecl_c n = (AnnotationElemDecl_c)this.copy();
            n.flags = flags;
            return n;
        }
        return this;
    }

    @Override
    public FlagsNode flags() {
        return this.flags;
    }

    @Override
    public AnnotationElemDecl defaultVal(Expr def) {
        if (!def.equals(this.defaultVal)) {
            AnnotationElemDecl_c n = (AnnotationElemDecl_c)this.copy();
            n.defaultVal = def;
            return n;
        }
        return this;
    }

    @Override
    public Expr defaultVal() {
        return this.defaultVal;
    }

    @Override
    public AnnotationElemDecl name(Id name) {
        if (!name.equals(this.name)) {
            AnnotationElemDecl_c n = (AnnotationElemDecl_c)this.copy();
            n.name = name;
            return n;
        }
        return this;
    }

    @Override
    public Id name() {
        return this.name;
    }

    @Override
    public AnnotationElemDecl annotationElemInstance(AnnotationElemInstance ai) {
        AnnotationElemDecl_c n = (AnnotationElemDecl_c)this.copy();
        n.ai = ai;
        return n;
    }

    @Override
    public AnnotationElemInstance annotationElemInstance() {
        return this.ai;
    }

    protected AnnotationElemDecl_c reconstruct(TypeNode type, Expr defaultVal) {
        if (!type.equals(this.type) || this.defaultVal != defaultVal) {
            AnnotationElemDecl_c n = (AnnotationElemDecl_c)this.copy();
            n.type = type;
            n.defaultVal = defaultVal;
            return n;
        }
        return this;
    }

    public Node visitChildren(NodeVisitor v) {
        TypeNode type = (TypeNode)this.visitChild((Node)this.type, v);
        Expr defVal = (Expr)this.visitChild((Node)this.defaultVal, v);
        return this.reconstruct(type, defVal);
    }

    public Node buildTypes(TypeBuilder tb) throws SemanticException {
        JL5TypeSystem ts = (JL5TypeSystem)tb.typeSystem();
        AnnotationElemDecl_c n = this;
        AnnotationElemInstance ai = ts.annotationElemInstance(n.position(), (ClassType)ts.Object(), JL5Flags.NONE, (Type)ts.unknownType(this.position()), n.name(), this.defaultVal != null);
        return n.annotationElemInstance(ai);
    }

    public Node typeCheck(ContextVisitor tc) throws SemanticException {
        JL5TypeSystem ts = (JL5TypeSystem)tc.typeSystem();
        Context ctx = tc.context();
        if (!ts.isValidAnnotationValueType(this.type().type())) {
            throw new SemanticException("The type: " + this.type() + " for the annotation element declaration " + this.name() + " must be a primitive, String, Class, enum type, annotation type or an array of one of these.", this.type().position());
        }
        if (ts.typeEquals(this.type().type(), (Type)tc.context().currentClass(), ctx)) {
            throw new SemanticException("Cyclic annotation element type: " + this.type(), this.type().position());
        }
        if (this.defaultVal != null) {
            if (this.defaultVal instanceof ArrayInit) {
                ((ArrayInit)this.defaultVal).typeCheckElements(tc, this.type.type());
            } else if (!(ts.isImplicitCastValid(this.defaultVal.type(), this.type.type(), ctx) || ts.typeEquals(this.defaultVal.type(), this.type.type(), ctx) || ts.numericConversionValid(this.type.type(), this.defaultVal.constantValue(), ctx) || ts.isBaseCastValid(this.defaultVal.type(), this.type.type(), ctx) || ts.numericConversionBaseValid(this.type.type(), this.defaultVal.constantValue(), ctx))) {
                throw new SemanticException("The type of the default value: " + this.defaultVal + " does not match the annotation element type: " + this.type.type() + " .", this.defaultVal.position());
            }
        }
        if (this.flags.flags().isNative()) {
            throw new SemanticException("Modifier native is not allowed here", this.position());
        }
        if (this.flags.flags().isPrivate()) {
            throw new SemanticException("Modifier private is not allowed here", this.position());
        }
        if (this.defaultVal != null) {
            ts.checkValueConstant(this.defaultVal);
        }
        return this;
    }

    public List acceptCFG(CFGBuilder v, List<Term> succs) {
        if (this.defaultVal != null) {
            v.visitCFG((Term)this.defaultVal, (Term)this, 0);
        }
        return succs;
    }

    public Term firstChild() {
        return this.defaultVal != null ? this.defaultVal.firstChild() : this;
    }

    public void prettyPrint(CodeWriter w, PrettyPrinter tr) {
        w.begin(0);
        Flags f = this.flags().flags();
        f = f.clearPublic();
        f = f.clearAbstract();
        w.write(f.translate());
        this.print((Node)this.type, w, tr);
        w.write(" " + this.name + "( )");
        if (this.defaultVal != null) {
            w.write(" default ");
            this.print((Node)this.defaultVal, w, tr);
        }
        w.write(";");
        w.end();
    }

    public MemberDef memberDef() {
        return null;
    }
}

