/*
 * Decompiled with CFR 0.152.
 */
package polyglot.ext.jl5.ast;

import polyglot.ast.Node;
import polyglot.ast.TypeNode;
import polyglot.ast.TypeNode_c;
import polyglot.ext.jl5.ast.BoundedTypeNode;
import polyglot.ext.jl5.types.JL5TypeSystem;
import polyglot.types.ClassDef;
import polyglot.types.ClassType;
import polyglot.types.Ref;
import polyglot.types.Types;
import polyglot.util.CodeWriter;
import polyglot.util.Position;
import polyglot.visit.ContextVisitor;
import polyglot.visit.NodeVisitor;
import polyglot.visit.PrettyPrinter;

public class BoundedTypeNode_c
extends TypeNode_c
implements BoundedTypeNode {
    protected ClassDef.Kind kind;
    protected TypeNode bound;

    public BoundedTypeNode_c(Position pos, ClassDef.Kind kind, TypeNode bound) {
        super(pos);
        this.kind = kind;
        this.bound = bound;
    }

    @Override
    public ClassDef.Kind kind() {
        return this.kind;
    }

    @Override
    public BoundedTypeNode kind(ClassDef.Kind kind) {
        BoundedTypeNode_c n = (BoundedTypeNode_c)this.copy();
        n.kind = kind;
        return n;
    }

    @Override
    public TypeNode bound() {
        return this.bound;
    }

    @Override
    public BoundedTypeNode bound(TypeNode bound) {
        BoundedTypeNode_c n = (BoundedTypeNode_c)this.copy();
        n.bound = bound;
        return n;
    }

    public BoundedTypeNode reconstruct(TypeNode bound) {
        if (bound != this.bound) {
            BoundedTypeNode_c n = (BoundedTypeNode_c)this.copy();
            n.bound = bound;
            return n;
        }
        return this;
    }

    public Node visitChildren(NodeVisitor v) {
        if (this.bound != null) {
            TypeNode bound = (TypeNode)this.visitChild((Node)this.bound, v);
            return this.reconstruct(bound);
        }
        return this;
    }

    public Node disambiguate(ContextVisitor v) {
        if (this.type != null) {
            JL5TypeSystem ts = (JL5TypeSystem)v.typeSystem();
            if (this.bound == null) {
                return this.typeRef((Ref)Types.lazyRef((Object)ts.anyType()));
            }
            if (this.kind == BoundedTypeNode.SUPER) {
                return this.typeRef((Ref)Types.lazyRef((Object)ts.anySuperType((Ref<ClassType>)Types.ref((Object)((ClassType)this.bound.type())))));
            }
            if (this.kind == BoundedTypeNode.EXTENDS) {
                return this.typeRef((Ref)Types.lazyRef((Object)ts.anySubType((Ref<ClassType>)Types.ref((Object)((ClassType)this.bound.type())))));
            }
        }
        return this;
    }

    public void prettyPrint(CodeWriter w, PrettyPrinter tr) {
        w.write("?");
        if (this.bound != null) {
            w.write(this.kind.toString());
            w.write(" ");
            this.print((Node)this.bound, w, tr);
        }
    }
}

