/*
 * Decompiled with CFR 0.152.
 */
package polyglot.ext.jl5.ast;

import java.util.Collections;
import java.util.List;
import polyglot.ast.Block;
import polyglot.ast.CanonicalTypeNode;
import polyglot.ast.ClassBody;
import polyglot.ast.ClassDecl_c;
import polyglot.ast.ClassMember;
import polyglot.ast.ConstructorDecl;
import polyglot.ast.Expr;
import polyglot.ast.FlagsNode;
import polyglot.ast.Formal;
import polyglot.ast.Id;
import polyglot.ast.MethodDecl;
import polyglot.ast.Node;
import polyglot.ast.NodeFactory;
import polyglot.ast.Stmt;
import polyglot.ast.TypeNode;
import polyglot.ext.jl5.ast.EnumDecl;
import polyglot.ext.jl5.ast.JL5ClassBody;
import polyglot.ext.jl5.ast.JL5ClassDecl_c;
import polyglot.ext.jl5.ast.JL5MethodDecl;
import polyglot.ext.jl5.ast.JL5NodeFactory;
import polyglot.ext.jl5.types.FlagAnnotations;
import polyglot.ext.jl5.types.JL5Flags;
import polyglot.ext.jl5.types.JL5ParsedClassType;
import polyglot.ext.jl5.types.JL5TypeSystem;
import polyglot.types.ClassDef;
import polyglot.types.ClassType;
import polyglot.types.ConstructorInstance;
import polyglot.types.Flags;
import polyglot.types.LocalDef;
import polyglot.types.MethodDef;
import polyglot.types.Name;
import polyglot.types.Ref;
import polyglot.types.SemanticException;
import polyglot.types.StructType;
import polyglot.types.Type;
import polyglot.types.TypeSystem;
import polyglot.types.Types;
import polyglot.util.Position;
import polyglot.visit.ContextVisitor;
import polyglot.visit.TypeBuilder;

public class EnumDecl_c
extends JL5ClassDecl_c
implements EnumDecl {
    public EnumDecl_c(Position pos, FlagAnnotations flags, Id name, TypeNode superClass, List interfaces, ClassBody body) {
        super(pos, flags, name, superClass, interfaces, body);
    }

    public EnumDecl_c(Position pos, FlagAnnotations flags, Id name, TypeNode superClass, List interfaces, ClassBody body, List paramTypes) {
        super(pos, flags, name, superClass, interfaces, body, paramTypes);
    }

    @Override
    public Node conformanceCheck(ContextVisitor tc) throws SemanticException {
        JL5ParsedClassType type = (JL5ParsedClassType)this.type.asType();
        ClassType superType = (ClassType)type.superClass();
        Flags flags = this.flags().flags();
        if (flags.isAbstract()) {
            throw new SemanticException("Enum types cannot have abstract modifier", this.position());
        }
        if (flags.isPrivate() && !type.isInnerClass()) {
            throw new SemanticException("Enum types cannot have explicit private modifier", this.position());
        }
        if (flags.isFinal()) {
            throw new SemanticException("Enum types cannot have explicit final modifier", this.position());
        }
        if (superType != null && JL5Flags.isEnumModifier(superType.flags())) {
            throw new SemanticException("Cannot extend enum type", this.position());
        }
        for (ConstructorInstance ci : type.constructors()) {
            if (ci.flags().clear(Flags.PRIVATE).equals((Object)Flags.NONE)) continue;
            throw new SemanticException("Modifier " + ci.flags().clear(Flags.PRIVATE) + " not allowed here", ci.position());
        }
        return super.conformanceCheck(tc);
    }

    @Override
    public ClassDecl_c postBuildTypes(TypeBuilder tb) throws SemanticException {
        JL5ClassDecl_c cd = (JL5ClassDecl_c)super.postBuildTypes(tb);
        cd = (JL5ClassDecl_c)cd.addGenEnumMethods(tb);
        return cd.postBuildTypes(tb);
    }

    @Override
    protected Node addGenEnumMethods(TypeBuilder tb) {
        JL5ClassBody newBody = (JL5ClassBody)this.body();
        JL5MethodDecl valuesMeth = this.addEnumMethodValues(tb);
        JL5MethodDecl valueOfMeth = this.addEnumMethodValueOf(tb);
        newBody = (JL5ClassBody)newBody.addMember((ClassMember)valuesMeth);
        newBody = (JL5ClassBody)newBody.addMember((ClassMember)valueOfMeth);
        this.type.addMethod(valuesMeth.methodDef());
        this.type.addMethod(valueOfMeth.methodDef());
        return this.body(newBody);
    }

    @Override
    protected JL5MethodDecl addEnumMethodValues(TypeBuilder tb) {
        JL5TypeSystem ts = (JL5TypeSystem)tb.typeSystem();
        NodeFactory nf = tb.nodeFactory();
        Position pos = this.position();
        assert (false);
        Block valuesBlock = nf.Block(pos);
        valuesBlock = valuesBlock.append((Stmt)nf.Return(pos, (Expr)nf.NullLit(pos)));
        FlagAnnotations vmFlags = new FlagAnnotations();
        FlagsNode vmFlagsNode = nf.FlagsNode(pos, Flags.PUBLIC.Static().Final());
        vmFlags.classicFlags(vmFlagsNode);
        CanonicalTypeNode returnType = nf.CanonicalTypeNode(pos, ts.arrayOf((Type)this.type.asType()));
        Id name = nf.Id(pos, "values");
        MethodDecl valuesMeth = ((JL5NodeFactory)nf).MethodDecl(pos, vmFlags, (TypeNode)returnType, name, Collections.EMPTY_LIST, Collections.EMPTY_LIST, valuesBlock, null);
        MethodDef md = ts.methodDef(pos, (Ref<? extends StructType>)Types.ref((Object)this.classDef().asType()), vmFlagsNode.flags(), (Ref<? extends Type>)Types.ref((Object)returnType.type()), Name.make((String)"values"), Collections.EMPTY_LIST, Collections.EMPTY_LIST, Collections.EMPTY_LIST, true);
        return (JL5MethodDecl)valuesMeth.methodDef(md);
    }

    @Override
    protected JL5MethodDecl addEnumMethodValueOf(TypeBuilder tb) {
        JL5TypeSystem ts = (JL5TypeSystem)tb.typeSystem();
        JL5NodeFactory nf = (JL5NodeFactory)tb.nodeFactory();
        Position pos = this.position();
        FlagsNode flags = nf.FlagsNode(pos, Flags.NONE);
        FlagAnnotations fl = new FlagAnnotations(flags);
        LocalDef ld = ts.localDef(pos, flags.flags(), Types.ref((Object)ts.String()), Name.make((String)"arg1"));
        Formal formal = nf.Formal(pos, fl, (TypeNode)nf.CanonicalTypeNode(pos, ts.String()), nf.Id(pos, "arg1"));
        formal = formal.localDef(ld);
        List<Formal> formals = Collections.singletonList(formal);
        assert (false);
        Block valueOfBody = nf.Block(pos);
        valueOfBody = valueOfBody.append((Stmt)nf.Return(pos, (Expr)nf.NullLit(pos)));
        FlagAnnotations voFlags = new FlagAnnotations();
        voFlags.classicFlags(nf.FlagsNode(pos, Flags.PUBLIC.Static()));
        CanonicalTypeNode returnType = nf.CanonicalTypeNode(pos, (Type)this.type.asType());
        MethodDecl valueOfMeth = nf.MethodDecl(pos, voFlags, (TypeNode)returnType, nf.Id(pos, "valueOf"), formals, Collections.EMPTY_LIST, valueOfBody, null);
        Flags mthFlags = JL5Flags.PUBLIC.set(JL5Flags.STATIC);
        List<Ref<? extends Type>> formalTypes = Collections.singletonList(Types.ref((Object)ts.String()));
        MethodDef md = ts.methodDef(pos, (Ref<? extends StructType>)Types.ref((Object)this.classDef().asType()), mthFlags, (Ref<? extends Type>)Types.ref((Object)returnType.type()), Name.make((String)"valueOf"), formalTypes, Collections.EMPTY_LIST, Collections.EMPTY_LIST, true);
        return (JL5MethodDecl)valueOfMeth.methodDef(md);
    }

    @Override
    protected ConstructorDecl createDefaultConstructor(ClassDef thisType, TypeSystem ts, NodeFactory nf) throws SemanticException {
        ConstructorDecl cd = super.createDefaultConstructor(thisType, ts, nf);
        Position pos = this.body().position().startOf();
        return cd.flags(nf.FlagsNode(pos, Flags.PRIVATE));
    }
}

