/*
 * Decompiled with CFR 0.152.
 */
package polyglot.ext.jl5.ast;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import polyglot.ast.Block;
import polyglot.ast.ClassBody_c;
import polyglot.ast.ClassMember;
import polyglot.ast.ConstructorCall;
import polyglot.ast.ConstructorDecl;
import polyglot.ast.Node;
import polyglot.ext.jl5.ast.EnumConstantDecl;
import polyglot.ext.jl5.ast.JL5ClassBody;
import polyglot.ext.jl5.types.AnnotationElemInstance;
import polyglot.ext.jl5.types.EnumInstance;
import polyglot.ext.jl5.types.JL5Flags;
import polyglot.ext.jl5.types.JL5MethodDef;
import polyglot.ext.jl5.types.JL5MethodInstance;
import polyglot.ext.jl5.types.JL5ParsedClassType;
import polyglot.ext.jl5.types.JL5TypeSystem;
import polyglot.types.ClassType;
import polyglot.types.FieldInstance;
import polyglot.types.MethodInstance;
import polyglot.types.Name;
import polyglot.types.QName;
import polyglot.types.SemanticException;
import polyglot.util.CodeWriter;
import polyglot.util.Position;
import polyglot.visit.ContextVisitor;
import polyglot.visit.PrettyPrinter;

public class JL5ClassBody_c
extends ClassBody_c
implements JL5ClassBody {
    public JL5ClassBody_c(Position pos, List members) {
        super(pos, members);
    }

    public Node conformanceCheck(ContextVisitor tc) throws SemanticException {
        JL5ClassBody_c n = (JL5ClassBody_c)super.conformanceCheck(tc);
        n.duplicateEnumConstantDeclCheck(tc);
        n.duplicateEnumConstantDeclFieldCheck(tc);
        n.checkCCallEnumConstructors(tc);
        n.checkAbsMembers(tc);
        n.checkGenMethConflicts(tc);
        n.duplicateAnnotationElemDeclCheck(tc);
        n.duplicateErasureMethodCheck(tc);
        return n;
    }

    protected void duplicateErasureMethodCheck(ContextVisitor tc) throws SemanticException {
        JL5TypeSystem ts = (JL5TypeSystem)tc.typeSystem();
        ArrayList l = new ArrayList(tc.context().currentClass().methods());
        for (int i = 0; i < l.size(); ++i) {
            MethodInstance mi = (MethodInstance)l.get(i);
            MethodInstance emi = ts.erasureMethodInstance(mi);
            for (int j = i + 1; j < l.size(); ++j) {
                MethodInstance mj = (MethodInstance)l.get(j);
                MethodInstance emj = ts.erasureMethodInstance(mj);
                if (!emi.isSameMethod(emj, tc.context())) continue;
                throw new SemanticException("Method " + mi + " and " + mj + " have the same erasure.", mj.position());
            }
        }
    }

    protected void checkGenMethConflicts(ContextVisitor tc) throws SemanticException {
        JL5ParsedClassType type = (JL5ParsedClassType)tc.context().currentClass();
        ArrayList list = new ArrayList(type.methods());
        for (JL5MethodInstance mi : list) {
            JL5MethodDef def = (JL5MethodDef)mi.def();
            if (!def.isCompilerGenerated() && mi.name().equals((Object)Name.make((String)"values")) && mi.formalTypes().isEmpty()) {
                throw new SemanticException("method " + mi.name() + " is already defined in type: " + type, mi.position());
            }
            if (def.isCompilerGenerated() || !mi.name().equals((Object)Name.make((String)"valueOf")) || mi.formalTypes().size() != 1 || !mi.formalTypes().get(0).isClass() || !((ClassType)mi.formalTypes().get(0)).fullName().equals((Object)QName.make((String)"java.lang.String"))) continue;
            throw new SemanticException("method " + mi.name() + " is already defined in type: " + type, mi.position());
        }
    }

    protected void checkAbsMembers(ContextVisitor tc) throws SemanticException {
    }

    protected void checkCCallEnumConstructors(ContextVisitor tc) throws SemanticException {
        JL5ParsedClassType type = (JL5ParsedClassType)tc.context().currentClass();
        for (Object next : this.members()) {
            Block body;
            if (!(next instanceof ConstructorDecl) || (body = ((ConstructorDecl)next).body()).statements().isEmpty() || !JL5Flags.isEnumModifier(type.flags()) || !(body.statements().get(0) instanceof ConstructorCall) || ((ConstructorCall)body.statements().get(0)).kind() != ConstructorCall.SUPER) continue;
            throw new SemanticException("Cannot have: " + body.statements().get(0) + " in enum constructor", ((Node)body.statements().get(0)).position());
        }
    }

    protected void duplicateEnumConstantDeclFieldCheck(ContextVisitor tc) throws SemanticException {
        JL5ParsedClassType type = (JL5ParsedClassType)tc.context().currentClass();
        ArrayList<EnumInstance> l = new ArrayList<EnumInstance>(type.enumConstants());
        ArrayList lf = new ArrayList(type.fields());
        for (int i = 0; i < l.size(); ++i) {
            EnumInstance ei = (EnumInstance)l.get(i);
            for (int j = 0; j < lf.size(); ++j) {
                FieldInstance fi = (FieldInstance)lf.get(j);
                if (!ei.name().equals((Object)fi.name())) continue;
                throw new SemanticException("Duplicate enum constant / field \"" + fi + "\" at: ", fi.position());
            }
        }
    }

    protected void duplicateEnumConstantDeclCheck(ContextVisitor tc) throws SemanticException {
        JL5ParsedClassType type = (JL5ParsedClassType)tc.context().currentClass();
        ArrayList<EnumInstance> l = new ArrayList<EnumInstance>(type.enumConstants());
        for (int i = 0; i < l.size(); ++i) {
            EnumInstance ei = (EnumInstance)l.get(i);
            for (int j = i + 1; j < l.size(); ++j) {
                EnumInstance ej = (EnumInstance)l.get(j);
                if (!ei.name().equals((Object)ej.name())) continue;
                throw new SemanticException("Duplicate enum constant \"" + ej + "\" at ", ej.position());
            }
        }
    }

    public void duplicateAnnotationElemDeclCheck(ContextVisitor tc) throws SemanticException {
        JL5ParsedClassType type = (JL5ParsedClassType)tc.context().currentClass();
        ArrayList<AnnotationElemInstance> l = new ArrayList<AnnotationElemInstance>(type.annotationElems());
        for (int i = 0; i < l.size(); ++i) {
            AnnotationElemInstance ai = (AnnotationElemInstance)l.get(i);
            for (int j = i + 1; j < l.size(); ++j) {
                AnnotationElemInstance aj = (AnnotationElemInstance)l.get(j);
                if (!ai.name().equals((Object)aj.name())) continue;
                throw new SemanticException("Duplicate annotation element \"" + aj + "\" at ", aj.position());
            }
        }
    }

    public void prettyPrint(CodeWriter w, PrettyPrinter tr) {
        if (!this.members.isEmpty()) {
            w.newline(4);
            w.begin(0);
            boolean lastWasEnum = false;
            Iterator i = this.members.iterator();
            while (i.hasNext()) {
                ClassMember member = (ClassMember)i.next();
                if (!(member instanceof EnumConstantDecl) && lastWasEnum) {
                    w.write(";");
                    w.newline(0);
                    lastWasEnum = false;
                }
                this.printBlock((Node)member, w, tr);
                if (member instanceof EnumConstantDecl) {
                    w.write(",");
                    lastWasEnum = true;
                }
                if (!i.hasNext()) continue;
                w.newline(0);
                w.newline(0);
            }
            w.end();
            w.newline(0);
        }
    }
}

