/*
 * Decompiled with CFR 0.152.
 */
package polyglot.ext.jl5.ast;

import java.util.ArrayList;
import java.util.List;
import polyglot.ast.ConstructorCall;
import polyglot.ast.ConstructorCall_c;
import polyglot.ast.Expr;
import polyglot.ast.Node;
import polyglot.ast.NodeFactory;
import polyglot.ast.TypeNode;
import polyglot.ext.jl5.ast.JL5ConstructorCall;
import polyglot.ext.jl5.types.JL5Context;
import polyglot.ext.jl5.types.JL5TypeSystem;
import polyglot.ext.jl5.types.JL5TypeSystem_c;
import polyglot.types.ClassType;
import polyglot.types.ConstructorInstance;
import polyglot.types.Context;
import polyglot.types.SemanticException;
import polyglot.types.Type;
import polyglot.types.TypeSystem;
import polyglot.util.Position;
import polyglot.visit.ContextVisitor;

public class JL5ConstructorCall_c
extends ConstructorCall_c
implements JL5ConstructorCall {
    protected List<TypeNode> typeArguments;

    public JL5ConstructorCall_c(Position pos, ConstructorCall.Kind kind, Expr qualifier, List arguments, List typeArguments) {
        super(pos, kind, qualifier, arguments);
        this.typeArguments = typeArguments;
    }

    @Override
    public List typeArguments() {
        return this.typeArguments;
    }

    @Override
    public JL5ConstructorCall typeArguments(List args) {
        JL5ConstructorCall_c n = (JL5ConstructorCall_c)this.copy();
        n.typeArguments = args;
        return n;
    }

    public Node typeCheck(ContextVisitor tc) throws SemanticException {
        JL5ConstructorCall_c n = this;
        TypeSystem ts = tc.typeSystem();
        Context c = tc.context();
        ClassType ct = c.currentClass();
        Type superType = ct.superClass();
        if (this.qualifier != null) {
            if (this.kind != SUPER) {
                throw new SemanticException("Can only qualify a \"super\"constructor invocation.", this.position());
            }
            if (!superType.isClass() || !superType.toClass().isInnerClass() || superType.toClass().inStaticContext()) {
                throw new SemanticException("The class \"" + superType + "\"" + " is not an inner class, or was declared in a static " + "context; a qualified constructor invocation cannot " + "be used.", this.position());
            }
            Type qt = this.qualifier.type();
            if (!qt.isClass() || !qt.isSubtype((Type)superType.toClass().outer(), c)) {
                throw new SemanticException("The type of the qualifier \"" + qt + "\" does not match the immediately enclosing " + "class  of the super class \"" + superType.toClass().outer() + "\".", this.qualifier.position());
            }
        }
        if (this.kind == SUPER) {
            if (!superType.isClass()) {
                throw new SemanticException("Super type of " + ct + " is not a class.", this.position());
            }
            Expr q = this.qualifier;
            if (q == null && superType.isClass() && superType.toClass().isInnerClass()) {
                ClassType e;
                ClassType superContainer = superType.toClass().outer();
                for (e = ct; e != null; e = e.outer()) {
                    if (!e.isSubtype((Type)superContainer, c) || !ct.hasEnclosingInstance(e)) continue;
                    NodeFactory nf = tc.nodeFactory();
                    q = nf.This(this.position(), (TypeNode)nf.CanonicalTypeNode(this.position(), (Type)e)).type((Type)e);
                    break;
                }
                if (e == null) {
                    throw new SemanticException(ct + " must have an enclosing instance" + " that is a subtype of " + superContainer, this.position());
                }
                if (e == ct) {
                    throw new SemanticException(ct + " is a subtype of " + superContainer + "; an enclosing instance that is a subtype of " + superContainer + " must be specified in the super constructor call.", this.position());
                }
            }
            if (this.qualifier != q) {
                n = (JL5ConstructorCall_c)n.qualifier(q);
            }
        }
        ArrayList<Type> explicitTypeArgs = null;
        ArrayList<Type> paramTypes = new ArrayList<Type>();
        if (n.typeArguments != null && !n.typeArguments.isEmpty()) {
            explicitTypeArgs = new ArrayList<Type>();
            for (TypeNode tn : n.typeArguments) {
                explicitTypeArgs.add(tn.type());
            }
        }
        for (Expr expr : n.arguments) {
            paramTypes.add(expr.type());
        }
        if (this.kind == SUPER) {
            ct = ct.superClass().toClass();
        }
        JL5TypeSystem jl5ts = (JL5TypeSystem)ts;
        ConstructorInstance ci = jl5ts.findJL5Constructor((Type)ct, (JL5TypeSystem_c.JL5ConstructorMatcher)jl5ts.JL5ConstructorMatcher((Type)ct, paramTypes, explicitTypeArgs, (JL5Context)c));
        return n.constructorInstance(ci);
    }
}

