/*
 * Decompiled with CFR 0.152.
 */
package polyglot.ext.jl5.ast;

import java.util.LinkedList;
import java.util.List;
import polyglot.ast.Formal;
import polyglot.ast.Formal_c;
import polyglot.ast.Id;
import polyglot.ast.Node;
import polyglot.ast.TypeNode;
import polyglot.ext.jl5.ast.AnnotationElem;
import polyglot.ext.jl5.ast.JL5ArrayTypeNode;
import polyglot.ext.jl5.ast.JL5Formal;
import polyglot.ext.jl5.types.FlagAnnotations;
import polyglot.ext.jl5.types.JL5TypeSystem;
import polyglot.ext.jl5.visit.ApplicationCheck;
import polyglot.ext.jl5.visit.ApplicationChecker;
import polyglot.types.ArrayType;
import polyglot.types.Context;
import polyglot.types.SemanticException;
import polyglot.util.CodeWriter;
import polyglot.util.CollectionUtil;
import polyglot.util.Position;
import polyglot.util.TypedList;
import polyglot.visit.ContextVisitor;
import polyglot.visit.NodeVisitor;
import polyglot.visit.PrettyPrinter;

public class JL5Formal_c
extends Formal_c
implements JL5Formal,
ApplicationCheck {
    protected List<AnnotationElem> annotations;
    protected List runtimeAnnotations;
    protected List classAnnotations;
    protected List sourceAnnotations;

    public JL5Formal_c(Position pos, FlagAnnotations flags, TypeNode type, Id name) {
        super(pos, flags.classicFlags(), type, name);
        this.annotations = flags.annotations() != null ? flags.annotations() : new TypedList(new LinkedList(), AnnotationElem.class, true);
    }

    @Override
    public List<AnnotationElem> annotations() {
        return this.annotations;
    }

    public JL5Formal annotations(List annotations) {
        JL5Formal_c n = (JL5Formal_c)this.copy();
        n.annotations = annotations;
        return n;
    }

    @Override
    public boolean isVarargs() {
        return this.type instanceof JL5ArrayTypeNode && ((JL5ArrayTypeNode)this.type).isVarargs();
    }

    protected Formal reconstruct(List<AnnotationElem> annotations) {
        if (!CollectionUtil.allEqual(annotations, this.annotations)) {
            JL5Formal_c n = (JL5Formal_c)this.copy();
            n.annotations = annotations;
            return n;
        }
        return this;
    }

    public Node visitChildren(NodeVisitor v) {
        List annots = this.visitList(this.annotations, v);
        JL5Formal_c n = (JL5Formal_c)super.visitChildren(v);
        return n.reconstruct(annots);
    }

    public Node typeCheck(ContextVisitor tc) throws SemanticException {
        JL5TypeSystem ts = (JL5TypeSystem)tc.typeSystem();
        ts.checkDuplicateAnnotations(this.annotations);
        return super.typeCheck(tc);
    }

    @Override
    public Node applicationCheck(ApplicationChecker appCheck, Context ctx) throws SemanticException {
        JL5TypeSystem ts = (JL5TypeSystem)appCheck.typeSystem();
        for (AnnotationElem a : this.annotations) {
            ts.checkAnnotationApplicability(a, (Node)this);
        }
        return this;
    }

    public void prettyPrint(CodeWriter w, PrettyPrinter tr) {
        if (this.annotations != null) {
            for (AnnotationElem a : this.annotations) {
                this.print((Node)a, w, tr);
            }
        }
        this.print((Node)this.flags, w, tr);
        if (this.isVarargs()) {
            w.write(((ArrayType)this.type.type()).base().toString());
            w.write(" ...");
        } else {
            this.print((Node)this.type, w, tr);
        }
        w.write(" ");
        tr.print((Node)this, (Node)this.name, w);
    }

    @Override
    public List runtimeAnnotations() {
        return this.runtimeAnnotations;
    }

    @Override
    public List classAnnotations() {
        return this.classAnnotations;
    }

    @Override
    public List sourceAnnotations() {
        return this.sourceAnnotations;
    }
}

