/*
 * Decompiled with CFR 0.152.
 */
package polyglot.ext.jl5.ast;

import java.util.ArrayList;
import java.util.List;
import polyglot.ast.AmbExpr;
import polyglot.ast.Case;
import polyglot.ast.Expr;
import polyglot.ast.Field;
import polyglot.ast.Node;
import polyglot.ast.Receiver;
import polyglot.ast.Switch_c;
import polyglot.ext.jl5.ast.JL5NodeFactory;
import polyglot.ext.jl5.ast.JL5Switch;
import polyglot.ext.jl5.types.EnumInstance;
import polyglot.ext.jl5.types.JL5Context;
import polyglot.ext.jl5.types.JL5Flags;
import polyglot.ext.jl5.types.JL5ParsedClassType;
import polyglot.ext.jl5.types.JL5TypeSystem;
import polyglot.types.FieldInstance;
import polyglot.types.SemanticException;
import polyglot.util.Position;
import polyglot.visit.ContextVisitor;

public class JL5Switch_c
extends Switch_c
implements JL5Switch {
    public JL5Switch_c(Position pos, Expr expr, List elements) {
        super(pos, expr, elements);
    }

    public Node typeCheck(ContextVisitor tc) throws SemanticException {
        JL5TypeSystem ts = (JL5TypeSystem)tc.typeSystem();
        JL5Context context = (JL5Context)tc.context();
        JL5NodeFactory nf = (JL5NodeFactory)tc.nodeFactory();
        JL5Switch_c sw = this;
        if (sw.expr().type() instanceof JL5ParsedClassType && JL5Flags.isEnumModifier(((JL5ParsedClassType)sw.expr().type()).flags())) {
            ArrayList<Node> elems = new ArrayList<Node>(sw.elements.size());
            for (Node swElem : sw.elements()) {
                if (swElem instanceof Case && ((Case)swElem).expr() instanceof AmbExpr) {
                    AmbExpr amb = (AmbExpr)((Case)swElem).expr();
                    FieldInstance fi = ts.findFieldOrEnum(sw.expr().type(), ts.FieldMatcher(sw.expr().type(), amb.name().id(), context));
                    if (fi instanceof EnumInstance) {
                        Field caseField = nf.Field(swElem.position(), (Receiver)nf.CanonicalTypeNode(sw.expr().type().position(), sw.expr().type()), amb.name());
                        caseField = caseField.fieldInstance(fi);
                        caseField = caseField.targetImplicit(true);
                        swElem = ((Case)swElem).expr((Expr)caseField);
                        elems.add(swElem);
                        continue;
                    }
                    throw new SemanticException("Case label: " + swElem + " not allowed here, only enum constants are allowed as case labels in a switch statement with an expression of an enum type", swElem.position());
                }
                if (swElem instanceof Case && ((Case)swElem).expr() == null) {
                    elems.add(swElem);
                    continue;
                }
                if (swElem instanceof Case) {
                    throw new SemanticException("Unexpected case label: " + swElem + ", only unqualified enum constants case labels are allowed in a switch statement with an expression of an enum type", swElem.position());
                }
                throw new SemanticException("JL5Switch_c: Internal error");
            }
            sw = (JL5Switch_c)sw.elements(elems);
            throw new SemanticException("JL5Switch_c: Internal error");
        }
        return super.typeCheck(tc);
    }
}

