/*
 * Decompiled with CFR 0.152.
 */
package polyglot.ext.jl5.ast;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import polyglot.ast.Node;
import polyglot.ast.TypeNode;
import polyglot.ext.jl5.ast.AnnotationElem_c;
import polyglot.ext.jl5.ast.ElementValuePair;
import polyglot.ext.jl5.ast.NormalAnnotationElem;
import polyglot.ext.jl5.types.AnnotationElemInstance;
import polyglot.ext.jl5.types.JL5ParsedClassType;
import polyglot.ext.jl5.types.JL5TypeSystem;
import polyglot.types.Context;
import polyglot.types.SemanticException;
import polyglot.util.CodeWriter;
import polyglot.util.CollectionUtil;
import polyglot.util.Position;
import polyglot.util.TypedList;
import polyglot.visit.ContextVisitor;
import polyglot.visit.NodeVisitor;
import polyglot.visit.PrettyPrinter;
import polyglot.visit.Translator;

public class NormalAnnotationElem_c
extends AnnotationElem_c
implements NormalAnnotationElem {
    protected List elements;

    public NormalAnnotationElem_c(Position pos, TypeNode typeName, List elements) {
        super(pos, typeName);
        this.elements = TypedList.copyAndCheck((List)elements, ElementValuePair.class, (boolean)true);
    }

    @Override
    public List elements() {
        return Collections.unmodifiableList(this.elements);
    }

    @Override
    public NormalAnnotationElem elements(List elements) {
        NormalAnnotationElem_c n = (NormalAnnotationElem_c)this.copy();
        n.elements = TypedList.copyAndCheck((List)elements, ElementValuePair.class, (boolean)true);
        return n;
    }

    protected Node reconstruct(TypeNode tn, List elements) {
        if (tn != this.typeName || !CollectionUtil.allEqual((Collection)elements, (Collection)this.elements)) {
            NormalAnnotationElem_c n = (NormalAnnotationElem_c)this.copy();
            n.typeName = tn;
            n.elements = TypedList.copyAndCheck((List)elements, ElementValuePair.class, (boolean)true);
            return n;
        }
        return this;
    }

    @Override
    public Node visitChildren(NodeVisitor v) {
        TypeNode tn = (TypeNode)this.visitChild((Node)this.typeName, v);
        List elements = this.visitList(this.elements, v);
        return this.reconstruct(tn, elements);
    }

    @Override
    public Node typeCheck(ContextVisitor tc) throws SemanticException {
        JL5TypeSystem ts = (JL5TypeSystem)tc.typeSystem();
        Context c = tc.context();
        for (ElementValuePair next : this.elements()) {
            AnnotationElemInstance ai = ts.findAnnotation(this.typeName().type(), ts.AnnotationMatcher(this.typeName().type(), next.name().id(), c));
            if (ts.isImplicitCastValid(next.value().type(), ai.type(), c) || ts.typeEquals(next.value().type(), ai.type(), c) || ts.numericConversionValid(ai.type(), next.value().constantValue(), c) || ts.isBaseCastValid(next.value().type(), ai.type(), c) || ts.numericConversionBaseValid(ai.type(), next.value().constantValue(), c)) continue;
            throw new SemanticException("The type of the value: " + next.value().type() + " for element: " + next.name() + " does not match the declared annotation type: " + ai.type(), next.value().position());
        }
        List<AnnotationElemInstance> requiredAnnots = ((JL5ParsedClassType)this.typeName().type()).annotationElems();
        for (AnnotationElemInstance next : requiredAnnots) {
            if (next.hasDefault() || this.elementForNoDefault(next)) continue;
            throw new SemanticException("Must have value for element: " + next.name(), this.typeName().position());
        }
        ArrayList list = new ArrayList(this.elements);
        for (int i = 0; i < list.size(); ++i) {
            ElementValuePair ei = (ElementValuePair)list.get(i);
            for (int j = i + 1; j < list.size(); ++j) {
                ElementValuePair ej = (ElementValuePair)list.get(j);
                if (!ei.name().equals(ej.name())) continue;
                throw new SemanticException("Duplicate annotation member value name in " + this.typeName(), ej.position());
            }
        }
        return super.typeCheck(tc);
    }

    protected boolean elementForNoDefault(AnnotationElemInstance ai) {
        Iterator it = this.elements.iterator();
        while (it.hasNext()) {
            if (!((ElementValuePair)it.next()).name().id().equals((Object)ai.name())) continue;
            return true;
        }
        return false;
    }

    @Override
    public void translate(CodeWriter w, Translator tr) {
        super.translate(w, tr);
        w.write("(");
        Iterator it = this.elements().iterator();
        while (it.hasNext()) {
            this.print((Node)((ElementValuePair)it.next()), w, (PrettyPrinter)tr);
            if (!it.hasNext()) continue;
            w.write(",");
        }
        w.write(") ");
    }
}

