/*
 * Decompiled with CFR 0.152.
 */
package polyglot.ext.jl5.types;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import polyglot.ext.jl5.types.JL5ArrayType;
import polyglot.ext.jl5.types.JL5ProcedureDef;
import polyglot.ext.jl5.types.JL5ProcedureInstance;
import polyglot.ext.jl5.types.JL5TypeSystem;
import polyglot.ext.jl5.types.JL5TypeSystem_c;
import polyglot.ext.jl5.types.TypeVariable;
import polyglot.types.Context;
import polyglot.types.DerefTransform;
import polyglot.types.Name;
import polyglot.types.ProcedureDef;
import polyglot.types.ProcedureInstance_c;
import polyglot.types.Ref;
import polyglot.types.Type;
import polyglot.types.TypeSystem;
import polyglot.types.TypeSystem_c;
import polyglot.types.UnknownType;
import polyglot.util.CollectionUtil;
import polyglot.util.Position;
import polyglot.util.Predicate2;
import polyglot.util.Transformation;
import polyglot.util.TransformingList;

public abstract class JL5ProcedureInstance_c<T extends ProcedureDef>
extends ProcedureInstance_c<T>
implements JL5ProcedureInstance<T> {
    protected List<TypeVariable> typeVariables;
    protected List<TypeVariable> substTypeVariables;
    protected List<Type> typeArguments;
    protected List<Type> substFormals = null;

    public JL5ProcedureInstance_c(TypeSystem ts, Position pos, Ref<? extends T> def) {
        super(ts, pos, def);
    }

    public JL5ProcedureInstance<T> formalTypes(List<Type> formalTypes) {
        return (JL5ProcedureInstance)super.formalTypes(formalTypes);
    }

    public JL5ProcedureInstance<T> throwTypes(List<Type> throwTypes) {
        return (JL5ProcedureInstance)super.throwTypes(throwTypes);
    }

    public List<TypeVariable> typeVariablesDefs() {
        if (this.typeVariables == null) {
            List<Ref<? extends Type>> tv = ((JL5ProcedureDef)this.def.get()).typeVariableTypes();
            this.typeVariables = new TransformingList(tv, (Transformation)new DerefTransform());
        }
        return this.typeVariables;
    }

    @Override
    public List<TypeVariable> typeVariables() {
        if (this.typeArguments == null || this.typeArguments.size() == 0) {
            return this.typeVariablesDefs();
        }
        if (this.substTypeVariables != null) {
            return this.substTypeVariables;
        }
        ArrayList<TypeVariable> r = new ArrayList<TypeVariable>();
        JL5TypeSystem ts = (JL5TypeSystem)this.typeSystem();
        for (TypeVariable tv : this.typeVariablesDefs()) {
            TypeVariable n = (TypeVariable)tv.copy();
            n.bounds(ts.applySubstitution(tv.bounds(), this.typeVariablesDefs(), this.typeArguments));
            r.add(n);
        }
        this.substTypeVariables = r;
        return this.substTypeVariables;
    }

    @Override
    @Deprecated
    public void addTypeVariable(TypeVariable type) {
        if (this.typeVariables == null) {
            this.typeVariables = new ArrayList<TypeVariable>();
        }
        this.typeVariables.add(type);
        type.declaringProcedure(this);
    }

    @Override
    @Deprecated
    public boolean hasTypeVariable(Name name) {
        return this.getTypeVariable(name) != null;
    }

    @Override
    @Deprecated
    public TypeVariable getTypeVariable(Name name) {
        for (TypeVariable iType : this.typeVariables) {
            if (!iType.name().equals((Object)name)) continue;
            return iType;
        }
        return null;
    }

    @Override
    @Deprecated
    public void typeVariables(List<TypeVariable> vars) {
        this.typeVariables = vars;
        for (TypeVariable tv : this.typeVariables) {
            tv.declaringProcedure(this);
        }
    }

    @Override
    public boolean isGeneric() {
        return !this.typeVariablesDefs().isEmpty();
    }

    public boolean isGeneric(List<TypeVariable> l) {
        return l != null && !l.isEmpty();
    }

    @Override
    public boolean isVariableArrity() {
        JL5ArrayType lastAsArr;
        Type last;
        int numFormals = this.formalTypes().size();
        return numFormals > 0 && (last = this.formalTypes().get(numFormals - 1)) instanceof JL5ArrayType && (lastAsArr = (JL5ArrayType)last).isVarargs();
    }

    public boolean callValid(Type thisType, List<Type> argTypes, Context context) {
        JL5TypeSystem ts = (JL5TypeSystem)this.typeSystem();
        List<Type> l1 = this.formalTypes();
        List<Type> l2 = argTypes;
        if (l1.size() == 0 && l2.size() != 0) {
            return false;
        }
        Iterator<Type> itCallee = l1.iterator();
        Iterator<Type> itCaller = l2.iterator();
        while (itCallee.hasNext() && itCaller.hasNext()) {
            Type t1 = itCallee.next();
            Type t2 = itCaller.next();
            if (!itCallee.hasNext() && t1.isArray() && ((JL5ArrayType)t1).isVarargs()) {
                JL5ArrayType vartype = (JL5ArrayType)t1;
                if (!itCaller.hasNext()) {
                    return ts.isImplicitCastValid(t2, vartype, context) || ts.isImplicitCastValid(t2, vartype.base(), context);
                }
                while (itCaller.hasNext()) {
                    if (!ts.isImplicitCastValid(t2, vartype.base(), context)) {
                        return false;
                    }
                    t2 = itCaller.next();
                }
                continue;
            }
            if (ts.isImplicitCastValid(t2, t1, context)) continue;
            return false;
        }
        if (itCallee.hasNext() && this.isVariableArrity()) {
            itCallee.next();
        }
        return !itCallee.hasNext() && !itCaller.hasNext();
    }

    @Override
    public List<Type> typeArguments() {
        return this.typeArguments;
    }

    @Override
    public JL5ProcedureInstance typeArguments(List<? extends Type> typeArgs) {
        JL5ProcedureInstance_c n = (JL5ProcedureInstance_c)this.copy();
        n.typeArguments = new ArrayList<Type>();
        n.typeArguments.addAll(typeArgs);
        return n;
    }

    protected List<Type> knownTypeArguments() {
        ArrayList<Type> typeArgsForSub = new ArrayList<Type>(this.typeArguments);
        for (int i = 0; i < typeArgsForSub.size(); ++i) {
            if (typeArgsForSub.get(i) != null && !(typeArgsForSub.get(i) instanceof UnknownType)) continue;
            typeArgsForSub.set(i, this.typeVariables().get(i));
        }
        return typeArgsForSub;
    }

    @Override
    public List<Type> formalTypes() {
        List declaredFormals = super.formalTypes();
        if (!this.isGeneric() || this.typeArguments == null) {
            return declaredFormals;
        }
        if (this.substFormals != null) {
            return this.substFormals;
        }
        JL5TypeSystem ts = (JL5TypeSystem)this.typeSystem();
        ArrayList<Type> r = new ArrayList<Type>();
        for (Type t : declaredFormals) {
            r.add(ts.applySubstitution(t, this.typeVariablesDefs(), this.knownTypeArguments()));
        }
        this.substFormals = r;
        return this.substFormals;
    }

    @Override
    public JL5ProcedureInstance<T> erasure() {
        JL5TypeSystem ts = (JL5TypeSystem)this.typeSystem();
        JL5ProcedureInstance_c n = (JL5ProcedureInstance_c)this.copy();
        ArrayList<Type> erasedFormals = new ArrayList<Type>();
        TransformingList declaredFormals = new TransformingList(((ProcedureDef)this.def()).formalTypes(), (Transformation)new DerefTransform());
        for (Type formal : declaredFormals) {
            erasedFormals.add(ts.erasure(formal));
        }
        n.formalTypes = erasedFormals;
        n.typeArguments = null;
        n.substTypeVariables = null;
        return n;
    }

    @Override
    public boolean hasFormals(List<Type> otherFormalTypes, List<TypeVariable> otherTypeVariables, List<Type> typeArguments, Context context) {
        if (this.isGeneric() != this.isGeneric(otherTypeVariables)) {
            return false;
        }
        if (this.formalTypes().size() != otherFormalTypes.size()) {
            return false;
        }
        if (this.isGeneric() && this.typeVariables().size() != otherTypeVariables.size()) {
            return false;
        }
        if (!CollectionUtil.allElementwise(this.typeVariables(), otherTypeVariables, (Predicate2)new JL5TypeSystem_c.TypeVariableEquals(context))) {
            return false;
        }
        return CollectionUtil.allElementwise(this.formalTypes(), otherFormalTypes, (Predicate2)new TypeSystem_c.TypeEquals(context));
    }
}

