/*
 * Decompiled with CFR 0.152.
 */
package polyglot.ext.jl5.types;

import polyglot.ast.TypeNode;
import polyglot.ext.jl5.types.GenericTypeRef;
import polyglot.ext.jl5.types.IntersectionType;
import polyglot.ext.jl5.types.JL5MethodInstance;
import polyglot.ext.jl5.types.JL5ParsedClassType;
import polyglot.ext.jl5.types.JL5PrimitiveType;
import polyglot.ext.jl5.types.JL5TypeSystem;
import polyglot.ext.jl5.types.ParameterizedType;
import polyglot.ext.jl5.types.RawType;
import polyglot.ext.jl5.types.TypeVariable;
import polyglot.ext.jl5.types.Wildcard;
import polyglot.ext.jl5.types.inference.LubType;
import polyglot.main.Report;
import polyglot.types.Context;
import polyglot.types.MethodDef;
import polyglot.types.MethodInstance;
import polyglot.types.PrimitiveType;
import polyglot.types.ProcedureInstance;
import polyglot.types.ReferenceType;
import polyglot.types.SemanticException;
import polyglot.types.Type;
import polyglot.types.TypeEnv_c;
import polyglot.types.TypeObject;

public class JL5TypeEnv_c
extends TypeEnv_c {
    protected JL5TypeSystem jts;

    public JL5TypeEnv_c(Context context) {
        super(context);
        this.jts = (JL5TypeSystem)this.ts;
    }

    public boolean isImplicitCastValid(Type fromType, Type toType) {
        if (fromType instanceof IntersectionType) {
            IntersectionType it = (IntersectionType)fromType;
            for (Type b : it.boundsTypes()) {
                if (!this.isImplicitCastValid(b, toType)) continue;
                return true;
            }
            return false;
        }
        if (fromType instanceof LubType) {
            for (Type elem : ((LubType)fromType).lubElements()) {
                if (this.isImplicitCastValid(elem, toType)) continue;
                return false;
            }
            return true;
        }
        if (toType instanceof TypeVariable) {
            TypeVariable tv = (TypeVariable)toType;
            return super.isImplicitCastValid(fromType, (Type)tv.upperBound()) || super.isImplicitCastValid(fromType, toType);
        }
        if (toType instanceof ReferenceType && this.isPrimitiveNonVoid(fromType)) {
            return this.isImplicitCastValid((Type)this.jts.classOf(fromType), toType);
        }
        if (fromType instanceof ReferenceType && this.isPrimitiveNonVoid(toType)) {
            return this.isImplicitCastValid(fromType, (Type)this.jts.classOf(toType));
        }
        return super.isImplicitCastValid(fromType, toType);
    }

    private boolean isPrimitiveNonVoid(Type t) {
        return t.isPrimitive() && !t.isVoid();
    }

    private boolean isClassToIntersectionValid(Type fromType, Type toType) {
        TypeVariable it = (TypeVariable)toType;
        if (it.bounds() == null || it.bounds().isEmpty()) {
            return true;
        }
        return this.isImplicitCastValid(fromType, ((TypeNode)it.bounds().get(0)).type());
    }

    public boolean numericConversionValid(Type t, Object value) {
        long v;
        if (t instanceof PrimitiveType) {
            return super.numericConversionValid(t, value);
        }
        if (value == null) {
            return false;
        }
        if (value instanceof Float || value instanceof Double) {
            return false;
        }
        if (value instanceof Number) {
            v = ((Number)value).longValue();
        } else if (value instanceof Character) {
            v = ((Character)value).charValue();
        } else {
            return false;
        }
        if (this.typeEquals(t, (Type)this.jts.LongWrapper()) && value instanceof Long) {
            return true;
        }
        if (this.typeEquals(t, (Type)this.jts.IntegerWrapper()) && value instanceof Integer) {
            return Integer.MIN_VALUE <= v && v <= Integer.MAX_VALUE;
        }
        if (this.typeEquals(t, (Type)this.jts.CharacterWrapper()) && value instanceof Character) {
            return 0L <= v && v <= 65535L;
        }
        if (this.typeEquals(t, (Type)this.jts.ShortWrapper()) && value instanceof Short) {
            return -32768L <= v && v <= 32767L;
        }
        if (this.typeEquals(t, (Type)this.jts.ByteWrapper()) && value instanceof Byte) {
            return -128L <= v && v <= 127L;
        }
        return false;
    }

    public boolean isSubtype(Type t1, Type t2) {
        if (t1 instanceof Wildcard) {
            return false;
        }
        if (t1 instanceof LubType) {
            LubType lubType = (LubType)t1;
            Type ancestor = t2;
            for (Type elem : lubType.lubElements()) {
                if (this.isSubtype(elem, ancestor)) continue;
                return false;
            }
            return true;
        }
        if (t1 instanceof IntersectionType) {
            IntersectionType it = (IntersectionType)t1;
            Type ancestor = t2;
            for (Type b : it.boundsTypes()) {
                if (!this.isSubtype(b, ancestor)) continue;
                return true;
            }
            return false;
        }
        if (t1 instanceof ParameterizedType) {
            if (super.isSubtype(t1, t2)) {
                return true;
            }
            if (t2 instanceof RawType) {
                if (this.isSubtype(this.jts.rawify(t1), t2)) {
                    return true;
                }
            } else {
                if (t2 instanceof ParameterizedType && !this.typeEquals(t1, t2)) {
                    return this.jts.checkContains((ParameterizedType)((ParameterizedType)t1).capture(), (ParameterizedType)t2);
                }
                if (t2 instanceof JL5ParsedClassType && this.isSubtype((Type)((ParameterizedType)t1).baseType(), t2)) {
                    return true;
                }
            }
            return false;
        }
        if (t1 instanceof RawType) {
            if (super.isSubtype(t1, t2)) {
                return true;
            }
            if (t2 instanceof ParameterizedType || t2 instanceof JL5ParsedClassType && !(t2 instanceof RawType) && ((JL5ParsedClassType)t2).isGeneric()) {
                return this.isSubtype(t1, this.jts.rawify(t2));
            }
            return false;
        }
        if (t2 instanceof TypeVariable) {
            TypeVariable tv = (TypeVariable)t2;
            return super.isSubtype(t1, t2) || super.isSubtype(t1, tv.lowerBound());
        }
        if (t2 instanceof LubType) {
            LubType lt = (LubType)t2;
            for (Type e : lt.lubElements()) {
                if (!this.isSubtype(t1, e)) continue;
                return true;
            }
            return this.isSubtype(t1, lt.calculateLub());
        }
        if (t2 instanceof IntersectionType) {
            IntersectionType it = (IntersectionType)t2;
            for (Type b : it.boundsTypes()) {
                if (this.isSubtype(t1, b)) continue;
                return false;
            }
            return true;
        }
        return super.isSubtype(t1, t2);
    }

    public boolean isCastValid(Type fromType, Type toType) {
        PrimitiveType pt;
        if (fromType instanceof IntersectionType) {
            IntersectionType it = (IntersectionType)fromType;
            for (Type b : it.boundsTypes()) {
                if (!this.isCastValid(b, toType)) continue;
                return true;
            }
            return false;
        }
        if (fromType instanceof LubType) {
            for (Type elem : ((LubType)fromType).lubElements()) {
                if (this.isCastValid(elem, toType)) continue;
                return false;
            }
            return true;
        }
        if (fromType instanceof TypeVariable) {
            return this.isCastValid(((TypeVariable)fromType).upperBound(), toType);
        }
        if (fromType.isPrimitive() && toType.isReference()) {
            return this.equivalent(fromType, toType);
        }
        if (fromType.isReference() && toType.isPrimitive() && (pt = fromType.toPrimitive()) != null) {
            return super.isCastValid((Type)pt, toType);
        }
        return super.isCastValid(fromType, toType);
    }

    public boolean equivalent(Type fromType, Type toType) {
        if (fromType instanceof GenericTypeRef) {
            return ((GenericTypeRef)fromType).equivalentImpl((TypeObject)toType);
        }
        if (fromType instanceof TypeVariable) {
            return ((TypeVariable)fromType).equivalentImpl((TypeObject)toType);
        }
        if (fromType instanceof JL5PrimitiveType || fromType instanceof JL5ParsedClassType) {
            if (fromType.isBoolean() && toType.isBoolean()) {
                return true;
            }
            if (fromType.isInt() && toType.isInt()) {
                return true;
            }
            if (fromType.isByte() && toType.isByte()) {
                return true;
            }
            if (fromType.isShort() && toType.isShort()) {
                return true;
            }
            if (fromType.isChar() && toType.isChar()) {
                return true;
            }
            if (fromType.isLong() && toType.isLong()) {
                return true;
            }
            if (fromType.isFloat() && toType.isFloat()) {
                return true;
            }
            if (fromType.isDouble() && toType.isDouble()) {
                return true;
            }
        }
        return false;
    }

    public boolean canOverride(MethodInstance mi, MethodInstance mj) {
        return super.canOverride(mi, mj) || super.canOverride(mi, (MethodInstance)((JL5MethodInstance)mj).erasure());
    }

    public void checkOverride(MethodInstance mi, MethodInstance mj) throws SemanticException {
        try {
            this.checkOverride(mi, mj, true);
        }
        catch (SemanticException e) {
            this.checkOverride(mi, ((JL5MethodInstance)mj).erasure(), true);
        }
    }

    public void checkOverride(MethodInstance mii, MethodInstance mjj, boolean allowCovariantReturn) throws SemanticException {
        JL5MethodInstance mi = (JL5MethodInstance)mii;
        JL5MethodInstance mj = (JL5MethodInstance)mjj;
        if (mi == mj) {
            return;
        }
        if (!mi.name().equals((Object)mj.name()) || !mi.hasFormals(mj.formalTypes(), mj.typeVariables(), mj.typeArguments(), this.context)) {
            throw new SemanticException(mi.signature() + " in " + mi.container() + " cannot override " + mj.signature() + " in " + mj.container() + "; incompatible " + "parameter types", mi.position());
        }
        mj = (JL5MethodInstance)mj.typeArguments(mi.typeVariables());
        if (allowCovariantReturn ? !this.isSubtype(mi.returnType(), mj.returnType()) : !this.typeEquals(mi.returnType(), mj.returnType())) {
            if (Report.should_report((String)"types", (int)3)) {
                Report.report((int)3, (String)("return type " + mi.returnType() + " != " + mj.returnType()));
            }
            throw new SemanticException(mi.signature() + " in " + mi.container() + " cannot override " + mj.signature() + " in " + mj.container() + "; attempting to use incompatible " + "return type\n" + "found: " + mi.returnType() + "\n" + "required: " + mj.returnType(), mi.position());
        }
        if (!this.ts.throwsSubset((ProcedureInstance)mi, (ProcedureInstance)mj)) {
            if (Report.should_report((String)"types", (int)3)) {
                Report.report((int)3, (String)(mi.throwTypes() + " not subset of " + mj.throwTypes()));
            }
            throw new SemanticException(mi.signature() + " in " + mi.container() + " cannot override " + mj.signature() + " in " + mj.container() + "; the throw set " + mi.throwTypes() + " is not a subset of the " + "overridden method's throw set " + mj.throwTypes() + ".", mi.position());
        }
        if (mi.flags().moreRestrictiveThan(mj.flags())) {
            if (Report.should_report((String)"types", (int)3)) {
                Report.report((int)3, (String)(mi.flags() + " more restrictive than " + mj.flags()));
            }
            throw new SemanticException(mi.signature() + " in " + mi.container() + " cannot override " + mj.signature() + " in " + mj.container() + "; attempting to assign weaker " + "access privileges", mi.position());
        }
        if (mi.flags().isStatic() != mj.flags().isStatic()) {
            if (Report.should_report((String)"types", (int)3)) {
                Report.report((int)3, (String)(mi.signature() + " is " + (mi.flags().isStatic() ? "" : "not") + " static but " + mj.signature() + " is " + (mj.flags().isStatic() ? "" : "not") + " static"));
            }
            throw new SemanticException(mi.signature() + " in " + mi.container() + " cannot override " + mj.signature() + " in " + mj.container() + "; overridden method is " + (mj.flags().isStatic() ? "" : "not") + "static", mi.position());
        }
        if (!((MethodDef)mi.def()).equals(mj.def()) && mj.flags().isFinal()) {
            if (Report.should_report((String)"types", (int)3)) {
                Report.report((int)3, (String)(mj.flags() + " final"));
            }
            throw new SemanticException(mi.signature() + " in " + mi.container() + " cannot override " + mj.signature() + " in " + mj.container() + "; overridden method is final", mi.position());
        }
    }
}

