/*
 * Decompiled with CFR 0.152.
 */
package polyglot.ext.jl5.ast;

import java.util.List;
import polyglot.ast.Expr_c;
import polyglot.ast.Node;
import polyglot.ast.Term;
import polyglot.ast.TypeNode;
import polyglot.ext.jl5.ast.AnnotationElem;
import polyglot.ext.jl5.types.JL5Flags;
import polyglot.ext.jl5.types.JL5ParsedClassType;
import polyglot.ext.jl5.types.JL5TypeSystem;
import polyglot.types.SemanticException;
import polyglot.util.CodeWriter;
import polyglot.util.Position;
import polyglot.visit.CFGBuilder;
import polyglot.visit.ContextVisitor;
import polyglot.visit.NodeVisitor;
import polyglot.visit.PrettyPrinter;
import polyglot.visit.Translator;

public class AnnotationElem_c
extends Expr_c
implements AnnotationElem {
    protected TypeNode typeName;

    public AnnotationElem_c(Position pos, TypeNode typeName) {
        super(pos);
        this.typeName = typeName;
    }

    @Override
    public TypeNode typeName() {
        return this.typeName;
    }

    @Override
    public AnnotationElem typeName(TypeNode typeName) {
        if (!typeName.equals(this.typeName)) {
            AnnotationElem_c n = (AnnotationElem_c)this.copy();
            n.typeName = typeName;
            return n;
        }
        return this;
    }

    protected AnnotationElem_c reconstruct(TypeNode typeName) {
        if (!typeName.equals(this.typeName)) {
            AnnotationElem_c n = (AnnotationElem_c)this.copy();
            n.typeName = typeName;
            return n;
        }
        return this;
    }

    public Node visitChildren(NodeVisitor v) {
        TypeNode tn = (TypeNode)this.visitChild((Node)this.typeName, v);
        return this.reconstruct(tn);
    }

    public Node typeCheck(ContextVisitor tc) throws SemanticException {
        JL5TypeSystem ts = (JL5TypeSystem)tc.typeSystem();
        if (!this.typeName.type().isClass() || !JL5Flags.isAnnotationModifier(((JL5ParsedClassType)this.typeName.type()).flags())) {
            throw new SemanticException("Annotation: " + this.typeName + " must be an annotation type, ", this.position());
        }
        return this.type(this.typeName.type());
    }

    public void translate(CodeWriter w, Translator tr) {
        w.write("@");
        this.print((Node)this.typeName, w, (PrettyPrinter)tr);
    }

    public Term firstChild() {
        return this;
    }

    public List acceptCFG(CFGBuilder v, List<Term> succs) {
        return succs;
    }

    public boolean isConstant() {
        return true;
    }

    public String toString() {
        return "Annotation Type: " + this.typeName();
    }
}

