/*
 * Decompiled with CFR 0.152.
 */
package polyglot.ext.jl5.ast;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import polyglot.ast.Call_c;
import polyglot.ast.CanonicalTypeNode;
import polyglot.ast.Expr;
import polyglot.ast.Id;
import polyglot.ast.Node;
import polyglot.ast.Receiver;
import polyglot.ast.Special;
import polyglot.ast.TypeNode;
import polyglot.ext.jl5.ast.JL5Call;
import polyglot.ext.jl5.ast.JL5NodeFactory;
import polyglot.ext.jl5.types.JL5Context;
import polyglot.ext.jl5.types.JL5MethodInstance;
import polyglot.ext.jl5.types.JL5TypeSystem;
import polyglot.ext.jl5.types.TypeVariable;
import polyglot.types.ClassDef;
import polyglot.types.ClassType;
import polyglot.types.Context;
import polyglot.types.MemberInstance;
import polyglot.types.MethodInstance;
import polyglot.types.NoMemberException;
import polyglot.types.SemanticException;
import polyglot.types.Type;
import polyglot.types.TypeSystem_c;
import polyglot.types.Types;
import polyglot.util.CodeWriter;
import polyglot.util.CollectionUtil;
import polyglot.util.Position;
import polyglot.util.TypedList;
import polyglot.visit.ContextVisitor;
import polyglot.visit.NodeVisitor;
import polyglot.visit.PrettyPrinter;

public class JL5Call_c
extends Call_c
implements JL5Call {
    protected List<TypeNode> typeArguments;

    public JL5Call_c(Position pos, Receiver target, Id name, List<Expr> arguments, List<TypeNode> typeArguments) {
        super(pos, target, name, arguments);
        this.typeArguments = typeArguments;
    }

    @Override
    public List<TypeNode> typeArguments() {
        return this.typeArguments;
    }

    @Override
    public JL5Call typeArguments(List<TypeNode> args) {
        JL5Call_c n = (JL5Call_c)this.copy();
        n.typeArguments = TypedList.copyAndCheck(args, TypeNode.class, (boolean)true);
        return n;
    }

    protected Call_c reconstruct(Receiver target, Id name, List<Expr> arguments, List<TypeNode> typeArguments) {
        if (target != this.target || name != this.name || !CollectionUtil.allEqual(arguments, (Collection)this.arguments) || !CollectionUtil.allEqual(typeArguments, this.typeArguments)) {
            JL5Call_c n = (JL5Call_c)super.reconstruct(target, name, arguments);
            n.typeArguments = TypedList.copyAndCheck(typeArguments, TypeNode.class, (boolean)true);
        }
        return this;
    }

    public Node visitChildren(NodeVisitor v) {
        JL5Call_c visited = (JL5Call_c)super.visitChildren(v);
        List newTypeArguments = visited.visitList(visited.typeArguments, v);
        return visited.reconstruct(visited.target(), visited.name(), visited.arguments(), newTypeArguments);
    }

    public Node typeCheck(ContextVisitor tc) throws SemanticException {
        boolean staticContext;
        JL5Call_c n = null;
        JL5TypeSystem ts = (JL5TypeSystem)tc.typeSystem();
        JL5Context c = (JL5Context)tc.context();
        ArrayList<Type> explicitTypeArgs = null;
        ArrayList<Type> argsTypes = new ArrayList<Type>();
        if (this.typeArguments != null && !this.typeArguments.isEmpty()) {
            explicitTypeArgs = new ArrayList<Type>();
            if (this.target() == null) {
                throw new SemanticException("Explicit target required when using explicit type arguments", this.position());
            }
            Iterator<TypeNode> it = this.typeArguments().iterator();
            while (it.hasNext()) {
                explicitTypeArgs.add(it.next().type());
            }
        }
        Iterator i = this.arguments().iterator();
        while (i.hasNext()) {
            argsTypes.add(((Expr)i.next()).type());
        }
        if (this.target == null) {
            return this.typeCheckNullTarget(tc, argsTypes, explicitTypeArgs);
        }
        Type targetType = this.target.type();
        JL5MethodInstance mi = null;
        if (targetType instanceof ClassType && !(targetType instanceof TypeVariable)) {
            Context ctx = tc.context();
            ClassType ct = (ClassType)targetType;
            ctx = ctx.pushClass((ClassDef)ct.def(), ct);
            TypeSystem_c.MethodMatcher matcher = ts.JL5MethodMatcher(targetType, this.name().id(), argsTypes, explicitTypeArgs, ctx);
            mi = (JL5MethodInstance)ts.findMethod(targetType, matcher);
            if (!ts.isAccessibleTarget((MemberInstance)mi, targetType, ctx = ctx.pop())) {
                throw new NoMemberException(1, "Method " + mi.signature() + " in " + targetType + " is inaccessible.");
            }
        } else {
            TypeSystem_c.MethodMatcher matcher = ts.JL5MethodMatcher(targetType, this.name().id(), argsTypes, explicitTypeArgs, tc.context());
            mi = (JL5MethodInstance)ts.findMethod(targetType, matcher);
        }
        if ((staticContext = this.target instanceof TypeNode) && !mi.flags().isStatic()) {
            throw new SemanticException("Cannot call non-static method " + this.name.id() + " of " + this.target.type() + " in static " + "context.", this.position());
        }
        if (this.target instanceof Special && ((Special)this.target).kind() == Special.SUPER && mi.flags().isAbstract()) {
            throw new SemanticException("Cannot call an abstract method of the super class", this.position());
        }
        n = (JL5Call_c)this.methodInstance(mi).type(mi.returnType());
        return n;
    }

    protected Node typeCheckNullTarget(ContextVisitor tc, List<Type> paramTypes, List<Type> explicitTypeArgs) throws SemanticException {
        CanonicalTypeNode r;
        JL5TypeSystem ts = (JL5TypeSystem)tc.typeSystem();
        JL5NodeFactory nf = (JL5NodeFactory)tc.nodeFactory();
        JL5Context c = (JL5Context)tc.context();
        JL5MethodInstance mi = (JL5MethodInstance)c.findMethod(ts.JL5MethodMatcher(null, this.name.id(), paramTypes, explicitTypeArgs, c));
        if (mi.flags().isStatic()) {
            Type container = this.findContainer(ts, mi);
            r = nf.CanonicalTypeNode(this.position().startOf(), container).typeRef(Types.ref((Object)container));
        } else {
            ClassType scope = c.findMethodScope(this.name.id());
            r = !ts.typeEquals((Type)scope, (Type)c.currentClass(), c) ? (Special)nf.This(this.position().startOf(), (TypeNode)nf.CanonicalTypeNode(this.position().startOf(), (Type)scope)).del().typeCheck(tc) : (Special)nf.This(this.position().startOf()).del().typeCheck(tc);
        }
        Call_c call = (Call_c)this.targetImplicit(true).target((Receiver)r);
        call = (Call_c)call.methodInstance((MethodInstance)mi).type(mi.returnType());
        return call;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        if (!this.targetImplicit) {
            sb.append(this.target.toString());
        }
        if (this.typeArguments != null && this.typeArguments.size() != 0) {
            sb.append("<");
            Iterator<TypeNode> it = this.typeArguments.iterator();
            while (it.hasNext()) {
                sb.append(it.next().toString());
                if (!it.hasNext()) continue;
                sb.append(", ");
            }
            sb.append(">");
        }
        if (!this.targetImplicit) {
            sb.append(".");
        }
        sb.append(this.name);
        sb.append("(");
        int count = 0;
        Iterator i = this.arguments.iterator();
        while (i.hasNext()) {
            if (count++ > 2) {
                sb.append("...");
                break;
            }
            Expr n = (Expr)i.next();
            sb.append(n.toString());
            if (!i.hasNext()) continue;
            sb.append(", ");
        }
        sb.append(")");
        return sb.toString();
    }

    public void prettyPrint(CodeWriter w, PrettyPrinter tr) {
        if (!this.targetImplicit) {
            if (this.target instanceof Expr) {
                this.printSubExpr((Expr)this.target, w, tr);
                w.write(".");
            } else if (this.target != null) {
                this.print((Node)this.target, w, tr);
                w.write(".");
            }
        }
        if (this.typeArguments.size() != 0) {
            w.write("<");
            Iterator<TypeNode> it = this.typeArguments.iterator();
            while (it.hasNext()) {
                this.print((Node)it.next(), w, tr);
                if (!it.hasNext()) continue;
                w.write(", ");
            }
            w.write(">");
        }
        w.write(this.name + "(");
        w.begin(0);
        Iterator i = this.arguments.iterator();
        while (i.hasNext()) {
            Expr e = (Expr)i.next();
            this.print((Node)e, w, tr);
            if (!i.hasNext()) continue;
            w.write(",");
            w.allowBreak(0, " ");
        }
        w.end();
        w.write(")");
    }
}

