/*
 * Decompiled with CFR 0.152.
 */
package polyglot.ext.jl5.ast;

import polyglot.ast.CanonicalTypeNode_c;
import polyglot.ast.Node;
import polyglot.ext.jl5.ast.JL5CanonicalTypeNode;
import polyglot.ext.jl5.types.JL5TypeSystem;
import polyglot.ext.jl5.types.ParameterizedType;
import polyglot.ext.jl5.types.RawType;
import polyglot.ext.jl5.types.TypeVariable;
import polyglot.types.Ref;
import polyglot.types.SemanticException;
import polyglot.types.Type;
import polyglot.types.Types;
import polyglot.util.ErrorQueue;
import polyglot.util.Position;
import polyglot.visit.ContextVisitor;

public class JL5CanonicalTypeNode_c
extends CanonicalTypeNode_c
implements JL5CanonicalTypeNode {
    public JL5CanonicalTypeNode_c(Position pos, Ref<? extends Type> type) {
        super(pos, type);
    }

    public Type type() {
        return (Type)Types.get((Ref)this.type);
    }

    public Node typeCheck(ContextVisitor tc) throws SemanticException {
        Type t = this.type();
        if (t instanceof RawType) {
            ErrorQueue eq = tc.errorQueue();
            eq.enqueue(0, "Use of a raw type could lead to unchecked  operations.", this.position());
        } else if (t instanceof ParameterizedType) {
            ParameterizedType pt = (ParameterizedType)this.type();
            if (pt.baseType() instanceof TypeVariable) {
                throw new SemanticException("Unexpected type: only class types can have type arguments.", this.position());
            }
            if (!pt.baseType().isGeneric()) {
                throw new SemanticException("Class " + pt.baseType() + " is not generic.", this.position());
            }
            if (!pt.typeArguments().isEmpty() && pt.typeArguments().size() != pt.typeVariables().size()) {
                throw new SemanticException("Must give exactly " + pt.typeVariables().size() + " type argument(s).", this.position());
            }
            JL5TypeSystem ts = (JL5TypeSystem)tc.typeSystem();
            pt = (ParameterizedType)pt.capture();
            for (int i = 0; i < pt.typeVariables().size(); ++i) {
                Type b;
                Type arg = pt.typeArguments().get(i);
                if (arg instanceof TypeVariable) {
                    TypeVariable tvarg = (TypeVariable)arg;
                    ts.checkIntersectionBounds(tvarg.bounds(), false);
                }
                if (ts.isSubtype(arg, b = ts.getSubstitution(pt, pt.typeVariables().get(i).upperBound()), tc.context())) continue;
                throw new SemanticException("Type argument " + arg + " is not a subtype of its declared bound " + b, this.position());
            }
            this.type.update((Object)pt);
        }
        return super.typeCheck(tc);
    }
}

