/*
 * Decompiled with CFR 0.152.
 */
package polyglot.ext.jl5.ast;

import polyglot.ast.Case_c;
import polyglot.ast.Expr;
import polyglot.ast.Field;
import polyglot.ast.Local;
import polyglot.ast.Node;
import polyglot.ext.jl5.ast.JL5Case;
import polyglot.ext.jl5.types.JL5Flags;
import polyglot.types.FieldInstance;
import polyglot.types.LocalInstance;
import polyglot.types.SemanticException;
import polyglot.types.Type;
import polyglot.types.TypeSystem;
import polyglot.util.InternalCompilerError;
import polyglot.util.Position;
import polyglot.visit.ContextVisitor;

public class JL5Case_c
extends Case_c
implements JL5Case {
    public JL5Case_c(Position pos, Expr expr) {
        super(pos, expr);
    }

    public Node typeCheck(ContextVisitor tc) throws SemanticException {
        if (this.expr == null) {
            return this;
        }
        TypeSystem ts = tc.typeSystem();
        Type et = this.expr.type();
        if (et.isClass() && JL5Flags.isEnumModifier(et.toClass().flags())) {
            return this;
        }
        if (!ts.isImplicitCastValid(this.expr.type(), ts.Int(), tc.context())) {
            throw new SemanticException("Case label must be an enum, byte, char, short, or int.", this.position());
        }
        Object o = null;
        if (this.expr instanceof Field) {
            FieldInstance fi = ((Field)this.expr).fieldInstance();
            if (fi == null) {
                throw new InternalCompilerError("Undefined FieldInstance after type-checking.");
            }
            if (!fi.isConstant()) {
                throw new SemanticException("Case label must be an integral constant.", this.position());
            }
            o = fi.constantValue();
        } else if (this.expr instanceof Local) {
            LocalInstance li = ((Local)this.expr).localInstance();
            if (li == null) {
                throw new InternalCompilerError("Undefined LocalInstance after type-checking.");
            }
            if (!li.isConstant()) {
                return this;
            }
            o = li.constantValue();
        } else {
            o = this.expr.constantValue();
        }
        if (o instanceof Number && !(o instanceof Long) && !(o instanceof Float) && !(o instanceof Double)) {
            return this.value(((Number)o).longValue());
        }
        if (o instanceof Character) {
            return this.value(((Character)o).charValue());
        }
        throw new SemanticException("Case label must be an integral constant.", this.position());
    }
}

